/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.utils;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.Vector;

public class FigureEventSilencer {
    private static List<FigureMouseEventSilencingListener> sIgnoringMouseEventsListenerList = new Vector<FigureMouseEventSilencingListener>();

    private FigureEventSilencer() {
    }

    public static void enable() {
        for (FigureMouseEventSilencingListener figureMouseEventSilencingListener : sIgnoringMouseEventsListenerList) {
            figureMouseEventSilencingListener.enable();
        }
    }

    public static void disable() {
        for (FigureMouseEventSilencingListener figureMouseEventSilencingListener : sIgnoringMouseEventsListenerList) {
            figureMouseEventSilencingListener.disable();
        }
    }

    public static Object installMouseSilencerFor(String string) {
        FigureMouseEventSilencingListener figureMouseEventSilencingListener = new FigureMouseEventSilencingListener(string);
        sIgnoringMouseEventsListenerList.add(figureMouseEventSilencingListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(figureMouseEventSilencingListener, 131120L);
        return figureMouseEventSilencingListener;
    }

    public static void removeMouseSilencer(Object object) {
        assert (object instanceof FigureMouseEventSilencingListener);
        FigureMouseEventSilencingListener figureMouseEventSilencingListener = (FigureMouseEventSilencingListener)object;
        Toolkit.getDefaultToolkit().removeAWTEventListener(figureMouseEventSilencingListener);
        sIgnoringMouseEventsListenerList.remove(figureMouseEventSilencingListener);
    }

    private static class FigureMouseEventSilencingListener
    implements AWTEventListener {
        private boolean fEnabled;
        private String fPackageName;

        FigureMouseEventSilencingListener(String string) {
            assert (string != null);
            this.fPackageName = string;
            this.enable();
        }

        void enable() {
            this.fEnabled = true;
        }

        void disable() {
            this.fEnabled = false;
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (!this.fEnabled) {
                return;
            }
            assert (aWTEvent instanceof InputEvent);
            InputEvent inputEvent = (InputEvent)aWTEvent;
            String string = aWTEvent.getSource().getClass().getPackage().getName();
            if (this.fPackageName.length() > 0 && string.startsWith(this.fPackageName)) {
                inputEvent.consume();
            }
        }
    }
}

