/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.utils;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class DialogUtilities {
    private static Rectangle getParentFrameBounds() {
        assert (EventQueue.isDispatchThread());
        Component component = DialogUtilities.getFocusedWindow();
        if (component == null) {
            return null;
        }
        return component.getBounds();
    }

    private static Component getFocusedWindow() {
        assert (EventQueue.isDispatchThread());
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = keyboardFocusManager.getFocusedWindow();
        if (window != null && window.isShowing()) {
            return window;
        }
        return null;
    }

    public static Frame createParentWindow() {
        AWTUtilities.InvocationRunnable invocationRunnable = new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                Rectangle rectangle = DialogUtilities.getParentFrameBounds();
                MJFrame mJFrame = new MJFrame();
                mJFrame.setVisible(false);
                mJFrame.pack();
                if (rectangle == null) {
                    WindowUtils.centerWindowOnScreen((Window)mJFrame);
                } else {
                    mJFrame.setBounds(rectangle);
                }
                if (PlatformInfo.isWindows()) assert (NativeJava.hWndFromWindow((Window)mJFrame) != 0L);
                return mJFrame;
            }
        };
        Frame frame = null;
        if (SwingUtilities.isEventDispatchThread()) {
            frame = (Frame)invocationRunnable.runWithOutput();
        } else {
            try {
                frame = (Frame)AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)invocationRunnable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        assert (frame != null);
        return frame;
    }

    public static void destroyParentWindow(Frame frame) {
        assert (SwingUtilities.isEventDispatchThread());
        frame.dispose();
    }
}

