/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.table;

import java.util.Vector;

public class TableHeaderNames {
    public static final String NUMBERED = "numbered";
    private Vector<Object> fHeaderNames = null;
    private boolean fIsNumbered = false;

    public TableHeaderNames() {
    }

    public TableHeaderNames(Object[] objectArray) {
        this();
        this.setNames(objectArray);
    }

    public void setNames(Object[] objectArray) {
        if (TableHeaderNames.isNumbered(objectArray)) {
            if (this.fHeaderNames != null) {
                this.fHeaderNames.removeAllElements();
                this.fHeaderNames = null;
            }
            this.fIsNumbered = true;
            return;
        }
        this.fIsNumbered = false;
        this.fHeaderNames = null;
        if (objectArray != null && objectArray.length > 0) {
            this.fHeaderNames = new Vector();
            for (Object object : objectArray) {
                this.fHeaderNames.add(object);
            }
            if ("".equals(objectArray[0])) {
                this.fHeaderNames.removeElementAt(0);
                this.fHeaderNames.add(0, " ");
            }
        }
    }

    public int getNameCount() {
        return this.fHeaderNames != null ? this.fHeaderNames.size() : 0;
    }

    public String getHeaderName(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Cannot get the name of a negative header index.");
        }
        if (this.fIsNumbered) {
            return this.getNumberedHeaderName(n);
        }
        if (n >= this.getNameCount()) {
            return "";
        }
        return this.fHeaderNames.elementAt(n).toString();
    }

    public int getMaxCharLength() {
        int n = 0;
        for (int i = 0; i < this.getNameCount(); ++i) {
            int n2 = this.getHeaderName(i).length();
            n = n < n2 ? n2 : n;
        }
        return n;
    }

    public static boolean isNumbered(Object[] objectArray) {
        if (objectArray == null) {
            return false;
        }
        return objectArray.length == 1 && NUMBERED.equalsIgnoreCase((String)objectArray[0]);
    }

    private String getNumberedHeaderName(int n) {
        Integer n2 = n + 1;
        return n2.toString();
    }
}

