/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.borders;

import com.mathworks.hg.peer.ui.borders.BorderWithThickness;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class BevelBorderWithThickness
implements Border,
BorderWithThickness {
    private final int fBevelType;
    private int fBorderThickness;
    private final Color fShadowColor;
    private final Color fHighlightColor;

    public BevelBorderWithThickness(int n, Color color, Color color2, int n2) {
        this.fBevelType = n;
        this.fBorderThickness = n2;
        this.fShadowColor = color2;
        this.fHighlightColor = color;
        this.fBorderThickness = n2;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets();
    }

    Insets getBorderInsets() {
        return new Insets(this.fBorderThickness, this.fBorderThickness, this.fBorderThickness, this.fBorderThickness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics.create();
        if (graphics2 != null) {
            try {
                graphics2.translate(n, n2);
                this.paintBeveling(graphics2, n3, n4, this.fBevelType);
                graphics2.translate(-n, -n2);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    private void paintBeveling(Graphics graphics, int n, int n2, int n3) {
        Color color = n3 == 1 ? this.fShadowColor : this.fHighlightColor;
        graphics.setColor(color);
        int[] nArray = new int[]{0, this.fBorderThickness, this.fBorderThickness, 0, 0};
        int[] nArray2 = new int[]{0, 0, n2 - this.fBorderThickness, n2, 0};
        graphics.fillPolygon(nArray, nArray2, 5);
        int[] nArray3 = new int[]{0, n, n - this.fBorderThickness, 0, 0};
        int[] nArray4 = new int[]{0, 0, this.fBorderThickness, this.fBorderThickness, 0};
        graphics.fillPolygon(nArray3, nArray4, 5);
        Color color2 = n3 == 1 ? this.fHighlightColor : this.fShadowColor;
        graphics.setColor(color2);
        int[] nArray5 = new int[]{n, n - this.fBorderThickness, n - this.fBorderThickness, n, n};
        int[] nArray6 = new int[]{0, this.fBorderThickness, n2, n2, 0};
        graphics.fillPolygon(nArray5, nArray6, 5);
        int[] nArray7 = new int[]{0, n - this.fBorderThickness, n, this.fBorderThickness, 0};
        int[] nArray8 = new int[]{n2, n2, n2 - this.fBorderThickness, n2 - this.fBorderThickness, n2};
        graphics.fillPolygon(nArray7, nArray8, 5);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public int getThickness() {
        return this.fBorderThickness;
    }

    public int getfBevelType() {
        return this.fBevelType;
    }
}

