/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui;

import com.mathworks.hg.peer.ComponentPositionListener;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureMouseListener;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigurePanelProxyNotification;
import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.PositionDataInDevice;
import com.mathworks.hg.peer.ui.UIContainerPeer;
import com.mathworks.hg.peer.ui.borders.BorderStateObject;
import com.mathworks.hg.peer.ui.borders.DefaultTitledBorderOwner;
import com.mathworks.hg.peer.ui.borders.TitledBorderOwner;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class UIPanelPeer
extends UIContainerPeer
implements TitledBorderOwner {
    private Container fParentContainer = null;
    private MJPanel fDecorPanel = null;
    private TitledBorderOwner fBorderTitle;
    private BorderStateObject fStateCache;
    private static final int sFirstMethodIndex;
    private static final int sSetTitle;
    private static final int sSetTitlePosition;
    private static final int sSetBorderType;
    private static final int sSetBorderWidth;
    private static final int sSetHighlightColor;
    private static final int sSetShadowColor;
    private static final int sLastBaseMethodIndex;
    private static final String[] sLogMessagesBase;
    private Container fFigurePanel = null;

    @Override
    protected JComponent getUIComponent() {
        return this.fDecorPanel;
    }

    @Override
    protected Component getTopLevelComponent() {
        super.getTopLevelComponent();
        assert (this.fParentContainer != null);
        return this.fParentContainer;
    }

    @Override
    protected boolean doPreSetForegroundColor(Color color) {
        return true;
    }

    @Override
    public void doSetForegroundColor(Color color) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        super.doSetForegroundColor(color);
        this.setForegroundColorOnBorder(color);
    }

    @Override
    protected boolean doPreSetFont(Font font) {
        return true;
    }

    @Override
    protected void doSetFont(Font font) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        super.doSetFont(font);
        this.setFontOnBorder(font);
    }

    @Override
    protected void doSetBackgroundColor(Color color) {
        if (!this.isDisposed()) {
            this.fFigurePanel.setBackground(color);
            this.fDecorPanel.setBackground(color);
        }
    }

    void setBorderType(int n) {
        DebugUtilities.logMessage(32, "UIPanelPeer.setBorderType " + n, this);
        assert (this.fStateCache != null);
        this.fStateCache.fBorderType = n;
        final BorderStateObject borderStateObject = this.getCacheCopy();
        if (UIPanelPeer.doPreSetBorderType(borderStateObject)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetBorderType, 7){

                @Override
                public void run() {
                    UIPanelPeer.this.doSetBorderType(borderStateObject);
                }
            });
        }
    }

    protected static boolean doPreSetBorderType(BorderStateObject borderStateObject) {
        return true;
    }

    protected void doSetBorderType(BorderStateObject borderStateObject) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        this.doApplyBorderOnComponent(borderStateObject);
    }

    private void doApplyBorderOnComponent(BorderStateObject borderStateObject) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        this.getUIComponent().setBorder(this.createBorder(borderStateObject));
        this.getUIComponent().revalidate();
    }

    void setBorderWidth(int n) {
        DebugUtilities.logMessage(32, "UIPanelPeer.setBorderWidth " + n, this);
        assert (this.fStateCache != null);
        this.fStateCache.fBorderWidth = n;
        final BorderStateObject borderStateObject = this.getCacheCopy();
        if (UIPanelPeer.doPreSetBorderWidth(borderStateObject)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetBorderWidth, 7){

                @Override
                public void run() {
                    UIPanelPeer.this.doSetBorderWidth(borderStateObject);
                }
            });
        }
    }

    protected static boolean doPreSetBorderWidth(BorderStateObject borderStateObject) {
        return true;
    }

    protected void doSetBorderWidth(BorderStateObject borderStateObject) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        this.doApplyBorderOnComponent(borderStateObject);
        this.updateComponent(false);
    }

    void setHighlightColor(Color color) {
        DebugUtilities.logMessage(32, "UIPanelPeer.setHighlightColor " + color, this);
        assert (this.fStateCache != null);
        this.fStateCache.fHighlightColor = color;
        final BorderStateObject borderStateObject = this.getCacheCopy();
        if (UIPanelPeer.doPreSetHighlightColor(borderStateObject)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetHighlightColor, 7){

                @Override
                public void run() {
                    UIPanelPeer.this.doSetHighlightColor(borderStateObject);
                }
            });
        }
    }

    protected static boolean doPreSetHighlightColor(BorderStateObject borderStateObject) {
        return true;
    }

    protected void doSetHighlightColor(BorderStateObject borderStateObject) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        this.doApplyBorderOnComponent(borderStateObject);
        this.updateComponent(false);
    }

    void setShadowColor(Color color) {
        DebugUtilities.logMessage(32, "UIPanelPeer.setShadowColor " + color, this);
        assert (this.fStateCache != null);
        this.fStateCache.fShadowColor = color;
        final BorderStateObject borderStateObject = this.getCacheCopy();
        if (UIPanelPeer.doPreSetShadowColor(borderStateObject)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetShadowColor, 7){

                @Override
                public void run() {
                    UIPanelPeer.this.doSetShadowColor(borderStateObject);
                }
            });
        }
    }

    protected static boolean doPreSetShadowColor(BorderStateObject borderStateObject) {
        return true;
    }

    protected void doSetShadowColor(BorderStateObject borderStateObject) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        this.doApplyBorderOnComponent(borderStateObject);
        this.updateComponent(false);
    }

    void setTitle(String[] stringArray) {
        DebugUtilities.logMessage(32, "UIPanelPeer.setTitle " + stringArray, this);
        final String string = UIPanelPeer.getTitleForBorder(stringArray);
        if (UIPanelPeer.doPreSetTitle(string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetTitle, 7){

                @Override
                public void run() {
                    UIPanelPeer.this.doSetTitle(string);
                }
            });
        }
    }

    protected static boolean doPreSetTitle(String string) {
        return true;
    }

    protected void doSetTitle(String string) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        this.setTitleOnBorder(string);
    }

    private static String getTitleForBorder(String[] stringArray) {
        String string = null;
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        return string;
    }

    void setTitlePosition(final int n) {
        DebugUtilities.logMessage(32, "UIPanelPeer.setTitlePosition " + n, this);
        if (UIPanelPeer.doPreSetTitlePosition(n)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetTitlePosition, 7){

                @Override
                public void run() {
                    UIPanelPeer.this.doSetTitlePosition(n);
                }
            });
        }
    }

    protected static boolean doPreSetTitlePosition(int n) {
        return true;
    }

    protected void doSetTitlePosition(int n) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this from event dispatch thread";
        this.setTitlePositionOnBorder(n);
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = super.getUserMethodDescription(n);
        if (string == null && n >= sFirstMethodIndex && n <= this.getUserLastMethodID()) {
            string = sLogMessagesBase[n - sFirstMethodIndex];
        }
        return string;
    }

    protected static int getLastMethodIndex() {
        return sLastBaseMethodIndex;
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        if (figureNotification instanceof FigurePanelProxyNotification) {
            if (figureNotification.getType() == 1) {
                this.fFigurePanel = ((FigurePanelProxyNotification)figureNotification).getContainer();
                assert (this.fFigurePanel != null);
                if (this.fDecorPanel == null) {
                    this.doInitializeContainer(this.fLightweight);
                    this.fDecorPanel.add((Component)this.fFigurePanel, (Object)"Center");
                    this.fParentContainer.add((Component)this.fDecorPanel, "Center");
                }
            }
        } else {
            super.handleNotification(figureNotification);
        }
    }

    private void doInitializeContainer(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fParentContainer = HeavyweightLightweightContainerFactory.getUIPanelContainer();
        this.fDecorPanel = new UIPanelJPanel();
        this.setTitledBorderOwner(new DefaultTitledBorderOwner());
        this.setInitialCache();
        this.fParentContainer.setLayout(new BorderLayout());
    }

    private BorderStateObject getCacheCopy() {
        assert (!SwingUtilities.isEventDispatchThread());
        return BorderStateObject.clone(this.fStateCache);
    }

    private void setInitialCache() {
        assert (this.fStateCache == null);
        this.fStateCache = new BorderStateObject();
    }

    private void setTitledBorderOwner(TitledBorderOwner titledBorderOwner) {
        this.fBorderTitle = titledBorderOwner;
    }

    @Override
    public Border createBorder(BorderStateObject borderStateObject) {
        if (!this.isDisposed()) {
            return this.fBorderTitle.createBorder(borderStateObject);
        }
        return null;
    }

    @Override
    public void setForegroundColorOnBorder(Color color) {
        if (!this.isDisposed()) {
            this.fBorderTitle.setForegroundColorOnBorder(color);
            this.updateComponent(false);
        }
    }

    @Override
    public boolean isTitledBorderNull() {
        return this.isDisposed() || this.fBorderTitle.isTitledBorderNull();
    }

    @Override
    public void setTitleOnBorder(String string) {
        if (!this.isDisposed()) {
            this.fBorderTitle.setTitleOnBorder(string);
            this.updateComponent(true);
        }
    }

    @Override
    public void setTitlePositionOnBorder(int n) {
        if (!this.isDisposed()) {
            this.fBorderTitle.setTitlePositionOnBorder(n);
            this.updateComponent(true);
        }
    }

    @Override
    public void setFontOnBorder(Font font) {
        if (!this.isDisposed()) {
            this.fBorderTitle.setFontOnBorder(font);
            this.updateComponent(false);
        }
    }

    private void updateComponent(boolean bl) {
        if (!this.isDisposed()) {
            this.getUIComponent().revalidate();
            if (bl) {
                this.getUIComponent().repaint();
            }
        }
    }

    @Override
    public void addPeerPositionListener(ComponentPositionListener componentPositionListener) {
        super.addPeerPositionListener(componentPositionListener);
        this.fContainerProxy.addContainerPositionListener(componentPositionListener);
    }

    @Override
    public void removePeerPositionListener(ComponentPositionListener componentPositionListener) {
        this.fContainerProxy.removeContainerPositionListener(componentPositionListener);
        super.removePeerPositionListener(componentPositionListener);
    }

    @Override
    public PositionDataInDevice getPositionInDevice() {
        Cloneable cloneable;
        assert (SwingUtilities.isEventDispatchThread()) : "Must query position in device coordinates on the EDT";
        Rectangle rectangle = this.getOuterBoundsComponent().getBounds();
        Container container = this.fContainerProxy.getContainer();
        if (!container.isDisplayable()) {
            return new PositionDataInDevice(rectangle);
        }
        Rectangle rectangle2 = container.getBounds();
        Container container2 = container;
        do {
            if ((container2 = container2.getParent()) != null) {
                cloneable = container2.getLocation();
                rectangle2.translate(cloneable.x, cloneable.y);
                continue;
            }
            assert (container2 != null);
        } while (container2 != null && !container2.equals(this.getOuterBoundsComponent()));
        cloneable = new Insets(rectangle2.y - rectangle.y, rectangle2.x - rectangle.x, rectangle.height - rectangle2.height - (rectangle2.y - rectangle.y), rectangle.width - rectangle2.width - (rectangle2.x - rectangle.x));
        return new PositionDataInDevice(rectangle, (Insets)cloneable);
    }

    @Override
    protected void doSetName(String string) {
        if (!this.isDisposed()) {
            this.fCompContainerProxy.getJComponent().setName(string);
        }
    }

    static {
        sSetTitle = sFirstMethodIndex = UIContainerPeer.getLastMethodIndex() + 1;
        sSetTitlePosition = sFirstMethodIndex + 1;
        sSetShadowColor = sSetHighlightColor = (sSetBorderWidth = (sSetBorderType = sFirstMethodIndex + 2));
        sLastBaseMethodIndex = sSetShadowColor + 1;
        sLogMessagesBase = new String[]{"setTitle", "setTitlePosition", "setBorderType", "setBorderWidth", "setHighlightColor", "setShadowColor"};
    }

    private class UIPanelJPanel
    extends HeavyweightLightweightContainerFactory.UIPanelLightweightContainer {
        UIPanelJPanel() {
            this.setLayout(new BorderLayout());
            FigureMouseListener figureMouseListener = new FigureMouseListener();
            figureMouseListener.setNotificationSuccessor(UIPanelPeer.this);
            this.addMouseListener(figureMouseListener);
            this.addMouseMotionListener(figureMouseListener);
        }
    }
}

