/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui;

import com.mathworks.hg.peer.AbstractUicomponentButtondownListener;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.UIComponentMouseEvent;
import com.mathworks.hg.peer.UIComponentParentWithLayout;
import com.mathworks.hg.peer.event.UicomponentButtonListener;
import com.mathworks.hg.peer.event.UicontrolKeyListener;
import com.mathworks.hg.peer.ui.AbstractUIBasePeer;
import com.mathworks.hg.peer.ui.DefaultUIComponentImpl;
import com.mathworks.hg.peer.ui.FigureUIChild;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.util.StringUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractUIGroupPeer
extends AbstractUIBasePeer {
    public static final int ENABLE_OFF = 0;
    public static final int ENABLE_ON = 1;
    public static final int ENABLE_INACTIVE = 2;
    protected int fEnable = 1;
    protected AbstractUicomponentButtondownListener fButtondownListener = null;
    protected InnerUicontrolKeyListener fKeyListener = null;
    private static final int sFirstMethodIndex;
    protected static final int sSetEnable;
    protected static final int sSetTooltip;
    private static final int sLastBaseMethodIndex;
    private static final String[] sLogMessagesBase;
    private boolean fUsingDirectButtonListeners = false;

    @Override
    protected FigureUIChild createFigureChild() {
        DefaultUIComponentImpl defaultUIComponentImpl = new DefaultUIComponentImpl(this.getTopLevelComponent());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractUIGroupPeer.this.addUicontrolKeyListeners();
            }
        });
        return defaultUIComponentImpl;
    }

    @Override
    public void addComponent(UIComponentParentWithLayout uIComponentParentWithLayout, int n) {
        super.addComponent(uIComponentParentWithLayout, n);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractUIGroupPeer.this.addUicomponentButtondownListener();
            }
        });
    }

    @Override
    public void removeComponent(UIComponentParentWithLayout uIComponentParentWithLayout) {
        super.removeComponent(uIComponentParentWithLayout);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractUIGroupPeer.this.cleanup();
            }
        });
    }

    public final void setEnable(final int n) {
        if (this.doPreSetEnable(n)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetEnable, 7){

                @Override
                public void run() {
                    AbstractUIGroupPeer.this.doSetEnable(n);
                }
            });
        }
    }

    protected boolean doPreSetEnable(int n) {
        this.getFigureChild().addLogMessage(sSetEnable);
        this.fEnable = n;
        return true;
    }

    protected void doSetEnable(int n) {
        if (n == 0) {
            this.getUIComponent().setEnabled(false);
        } else {
            this.getUIComponent().setEnabled(true);
        }
    }

    protected void doProcessEvent(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof MouseEvent)) {
            return;
        }
        switch (aWTEvent.getID()) {
            case 501: 
            case 502: 
            case 503: 
            case 506: {
                if (this.fUsingDirectButtonListeners) {
                    this.fireUicomponentButton((MouseEvent)aWTEvent);
                    break;
                }
                this.handleMouseEvent((MouseEvent)aWTEvent, this.shouldButtonDownFcnFired((MouseEvent)aWTEvent));
            }
        }
    }

    public final void setTooltip(final String string) {
        if (this.doPreSetTooltip(string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetTooltip, 7){

                @Override
                public void run() {
                    AbstractUIGroupPeer.this.doSetTooltip(string);
                }
            });
        }
    }

    protected boolean doPreSetTooltip(String string) {
        this.getFigureChild().addLogMessage(sSetTooltip);
        return true;
    }

    protected void doSetTooltip(String string) {
        String string2 = null;
        if (null != string && string.length() > 0) {
            string2 = StringUtils.convertToHTML((String)string, (boolean)true, (boolean)false);
        }
        this.getUIComponent().setToolTipText(string2);
    }

    public Font getFont() {
        return this.getUIComponent().getFont();
    }

    public String getTooltip() {
        return this.getUIComponent().getToolTipText();
    }

    public synchronized void removeUicontrolKeyListener(UicontrolKeyListener uicontrolKeyListener) {
        this.fListenerList.remove(UicontrolKeyListener.class, uicontrolKeyListener);
    }

    public synchronized void addUicontrolKeyListener(UicontrolKeyListener uicontrolKeyListener) {
        this.fListenerList.add(UicontrolKeyListener.class, uicontrolKeyListener);
    }

    protected void fireUicontrolKey(KeyEvent keyEvent) {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.fListenerList.getListeners(UicontrolKeyListener.class)) {
            ((UicontrolKeyListener)eventListener).UicontrolKey(keyEvent);
        }
    }

    public synchronized void removeUicomponentButtonListener(UicomponentButtonListener uicomponentButtonListener) {
        this.fListenerList.remove(UicomponentButtonListener.class, uicomponentButtonListener);
    }

    public synchronized void addUicomponentButtonListener(UicomponentButtonListener uicomponentButtonListener) {
        this.fListenerList.add(UicomponentButtonListener.class, uicomponentButtonListener);
        this.fUsingDirectButtonListeners = true;
        if (this.fButtondownListener != null) {
            this.fButtondownListener.setUsingDirectButtonListeners(this.fUsingDirectButtonListeners);
        }
    }

    private void TranslateEventToScreenCoordinates(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        while (component != null) {
            mouseEvent.translatePoint(component.getX(), component.getY());
            if (component == this.getTopLevelComponent()) {
                if ((component = component.getParent()) != null) {
                    mouseEvent.translatePoint(component.getX(), component.getY());
                }
                component = null;
                continue;
            }
            component = component.getParent();
        }
    }

    protected void fireUicomponentButton(MouseEvent mouseEvent) {
        EventListener[] eventListenerArray;
        UIComponentMouseEvent uIComponentMouseEvent = new UIComponentMouseEvent(mouseEvent);
        this.TranslateEventToScreenCoordinates(uIComponentMouseEvent);
        for (EventListener eventListener : eventListenerArray = this.fListenerList.getListeners(UicomponentButtonListener.class)) {
            ((UicomponentButtonListener)eventListener).UicomponentButton(uIComponentMouseEvent);
        }
    }

    @Override
    public void addLogMessage(int n, String string) {
        if (DebugUtilities.isDebugOptions()) {
            DebugUtilities.logMessage(n, string, this);
        }
    }

    @Override
    public int getUserLastMethodID() {
        return AbstractUIGroupPeer.getLastMethodIndex();
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        string = super.getUserMethodDescription(n);
        if (string == null && n >= sFirstMethodIndex && n <= this.getUserLastMethodID()) {
            string = sLogMessagesBase[n - sFirstMethodIndex];
        }
        return string;
    }

    protected static int getLastMethodIndex() {
        return sLastBaseMethodIndex;
    }

    @Override
    protected abstract JComponent getUIComponent();

    @Override
    protected abstract JComponent getTopLevelComponent();

    @Override
    public JComponent getPrintableComponent() {
        return this.getTopLevelComponent();
    }

    @Override
    public JComponent getGUIDEView() {
        return this.getTopLevelComponent();
    }

    private boolean shouldButtonDownFcnFired(MouseEvent mouseEvent) {
        return this.fEnable != 1 || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isPopupTrigger();
    }

    protected void addUicomponentButtondownListener() {
        if (null == this.fButtondownListener) {
            this.fButtondownListener = new AbstractUicomponentButtondownListener(){

                @Override
                protected boolean shouldButtonDownFcnFired(MouseEvent mouseEvent) {
                    return AbstractUIGroupPeer.this.shouldButtonDownFcnFired(mouseEvent);
                }

                @Override
                protected void fireUicomponentButtonEvent(MouseEvent mouseEvent) {
                    AbstractUIGroupPeer.this.fireUicomponentButton(mouseEvent);
                }
            };
            this.fButtondownListener.setParentFigure(this.getFigureChild());
            this.fButtondownListener.setUsingDirectButtonListeners(this.fUsingDirectButtonListeners);
            this.getUIComponent().addMouseListener(this.fButtondownListener);
            this.getUIComponent().addMouseMotionListener(this.fButtondownListener);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.removeUicomponentButtondownListener();
    }

    protected void removeUicomponentButtondownListener() {
        if (null != this.fButtondownListener) {
            this.getUIComponent().removeMouseListener(this.fButtondownListener);
            this.getUIComponent().removeMouseMotionListener(this.fButtondownListener);
            this.fButtondownListener.setParentFigure(null);
            this.fButtondownListener = null;
        }
    }

    protected void addUicontrolKeyListeners() {
        if (null == this.fKeyListener) {
            this.fKeyListener = new InnerUicontrolKeyListener();
            this.getUIComponent().addKeyListener(this.fKeyListener);
        }
    }

    protected void removeUicontrolKeyListeners() {
        if (null != this.fKeyListener) {
            this.getUIComponent().removeKeyListener(this.fKeyListener);
        }
    }

    static {
        sSetEnable = sFirstMethodIndex = AbstractUIBasePeer.getLastMethodIndex() + 1;
        sLastBaseMethodIndex = sSetTooltip = sFirstMethodIndex + 1;
        sLogMessagesBase = new String[]{"setEnable", "setTooltip"};
    }

    protected class InnerUicontrolKeyListener
    extends KeyAdapter {
        protected InnerUicontrolKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            AbstractUIGroupPeer.this.fireUicontrolKey(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            AbstractUIGroupPeer.this.fireUicontrolKey(keyEvent);
        }
    }
}

