/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureFrameProxyBase;
import com.mathworks.hg.peer.FigureFrameProxyBaseAdapter;
import com.mathworks.hg.peer.FigureInsetsUtilities;
import com.mathworks.hg.peer.FigureMoveResizeNotification;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.PositionEventType;
import com.mathworks.hg.peer.PositionableFigureClient;
import com.mathworks.hg.peer.WindowRectHandler;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class WindowRectHandlerImpl
implements WindowRectHandler {
    private static FigureAttributesChanging sInsetsChanging = null;
    private boolean fHonorClientRect = true;
    private boolean fResizable = true;
    private boolean fResizableChanged = false;
    private int fMenuBarHeight = 0;
    private int fToolBarHeight = 0;
    private Insets fOldInsets = null;
    private int fJavaCompNorth;
    private int fJavaCompSouth;
    private int fJavaCompWest;
    private int fJavaCompEast;
    private boolean fDocked = false;
    private boolean fDockPending = false;
    private FigureFrameProxyBase fFrameProxy = new FigureFrameProxyBaseAdapter();
    private boolean fFigureClientSet = false;
    private boolean fFrameProxySet = false;
    protected PositionableFigureClient fFigureClient = null;
    private LocationSizeSetHandler fLocationSizeSetHandler = new LocationSizeSetHandler();

    @Override
    public boolean setResizable(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = this.fResizable;
        if (bl != bl3) {
            this.fResizableChanged = true;
        }
        if (this.fResizableChanged && SwingUtilities.isEventDispatchThread()) {
            this.fResizableChanged = false;
            this.update(new ResizableChanging(bl));
        }
        return bl2;
    }

    @Override
    public void setFigureClient(PositionableFigureClient positionableFigureClient) {
        if (null == positionableFigureClient) {
            return;
        }
        assert (!this.fFigureClientSet);
        this.fFigureClient = positionableFigureClient;
        this.fFigureClientSet = true;
    }

    @Override
    public void setActivePositionMode(boolean bl) {
        this.fHonorClientRect = bl;
    }

    private boolean isUsingDockedMargins() {
        return this.fDocked;
    }

    @Override
    public void setDocked(boolean bl) {
        this.fDocked = bl;
        this.fDockPending = false;
    }

    @Override
    public void setDockedPending() {
        this.fDockPending = true;
    }

    @Override
    public void windowOpened() {
        this.updateInsets();
        this.update(sInsetsChanging);
    }

    private void update(FigureAttributesChanging figureAttributesChanging) {
        assert (figureAttributesChanging != null);
        if (this.fFigureClient.isClientDocked()) {
            return;
        }
        if (this.fHonorClientRect && !this.fFigureClient.isClientMaximized()) {
            Rectangle rectangle = this.fFigureClient.getCachedClientRectangle();
            Rectangle rectangle2 = this.getClientRectFromOuterRect(rectangle);
            figureAttributesChanging.attributeChanged();
            boolean bl = this.updateCachedInsets();
            this.setBounds(rectangle2);
            if (bl && figureAttributesChanging instanceof ResizableChanging) {
                this.fireMoveResizeEvent(PositionEventType.RESIZED);
            }
        } else {
            figureAttributesChanging.attributeChanged();
            this.updateCachedInsets();
            this.fireMoveResizeEvent(PositionEventType.MOVED);
        }
    }

    private boolean isShowing() {
        boolean bl = this.fFrameProxySet && this.fFrameProxy.isShowing();
        return bl;
    }

    @Override
    public void moveContainerPointToClientPoint(Point point, Point point2) {
        this._movePoint(point, point2, true);
    }

    @Override
    public void presetBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getOuterRectFromClientRect(rectangle);
        this.presetOuterBounds(rectangle2);
    }

    @Override
    public boolean setBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getOuterRectFromClientRect(rectangle);
        return this.setOuterBounds(rectangle2);
    }

    private Rectangle adjustOuterBoundsForScreenLimits(Rectangle rectangle) {
        if (!this.fDocked) {
            rectangle = WindowRectHandlerImpl.adjustWindowOuterBoundsForScreenLimits(rectangle);
        }
        return rectangle;
    }

    static Rectangle adjustWindowOuterBoundsForScreenLimits(Rectangle rectangle) {
        if (PlatformInfo.isWindows()) {
            if (rectangle.width > FigurePeer.sCXMaxTrack) {
                rectangle.width = FigurePeer.sCXMaxTrack;
            } else if (rectangle.width < FigurePeer.sCXMin) {
                rectangle.width = FigurePeer.sCXMin;
            }
            if (rectangle.height > FigurePeer.sCYMaxTrack) {
                rectangle.y += rectangle.height - FigurePeer.sCYMaxTrack;
                rectangle.height = FigurePeer.sCYMaxTrack;
            } else if (rectangle.height < FigurePeer.sCYMin) {
                rectangle.height = FigurePeer.sCYMin;
            }
        }
        return rectangle;
    }

    @Override
    public void presetOuterBounds(Rectangle rectangle) {
        rectangle = this.adjustOuterBoundsForScreenLimits(rectangle);
        this.fLocationSizeSetHandler.setAllPending();
        this.fFigureClient.setCachedClientRectangle(rectangle);
        this.recheckPendingLocationOrSizeOnEDT();
    }

    @Override
    public boolean setOuterBounds(Rectangle rectangle) {
        rectangle = this.adjustOuterBoundsForScreenLimits(rectangle);
        this.fLocationSizeSetHandler.setAllPending();
        this.fFigureClient.setClientRectangle(rectangle);
        this.recheckPendingLocationOrSizeOnEDT();
        return rectangle.equals(this.fFigureClient.getClientRectangle());
    }

    @Override
    public PositionEventType isWaitingForResize() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.fFigureClient.getCachedClientRectangle();
        if (rectangle2.equals(rectangle = this.fFigureClient.getClientRectangle())) {
            return PositionEventType.NONE;
        }
        if (rectangle2.width == rectangle.width && rectangle2.height == rectangle.height) {
            return PositionEventType.MOVED;
        }
        return PositionEventType.RESIZED;
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds(false);
    }

    @Override
    public Rectangle getBounds(boolean bl) {
        Rectangle rectangle = this.getOuterBounds(bl);
        Rectangle rectangle2 = this.getClientRectFromOuterRect(rectangle);
        return rectangle2;
    }

    @Override
    public Rectangle getOuterBounds() {
        return this.getOuterBounds(false);
    }

    @Override
    public Rectangle getOuterBounds(boolean bl) {
        Rectangle rectangle = this.fDocked || bl ? this.fFigureClient.getClientRectangle() : this.fFigureClient.getCachedClientRectangle();
        assert (rectangle != null);
        return rectangle;
    }

    Dimension getSize() {
        Rectangle rectangle = this.getBounds();
        return rectangle.getSize();
    }

    protected Rectangle adjustSizeToBeValid(Rectangle rectangle) {
        return rectangle;
    }

    private Rectangle getClientRectFromOuterRect(Rectangle rectangle) {
        MarginHelper marginHelper = new MarginHelper();
        Rectangle rectangle2 = new Rectangle(rectangle.x + marginHelper.xCorrection, rectangle.y + marginHelper.yCorrection, rectangle.width - marginHelper.widthCorrection, rectangle.height - marginHelper.heightCorrection);
        return this.adjustSizeToBeValid(rectangle2);
    }

    public Rectangle getOuterRectFromClientRect(Rectangle rectangle) {
        this.updateCachedInsets();
        MarginHelper marginHelper = new MarginHelper();
        Rectangle rectangle2 = new Rectangle(rectangle.x - marginHelper.xCorrection, rectangle.y - marginHelper.yCorrection, rectangle.width + marginHelper.widthCorrection, rectangle.height + marginHelper.heightCorrection);
        return rectangle2;
    }

    public Rectangle getMargins() {
        MarginHelper marginHelper = new MarginHelper();
        return new Rectangle(marginHelper.xCorrection, marginHelper.yCorrection, marginHelper.widthCorrection, marginHelper.heightCorrection);
    }

    public String toString() {
        return new String("Insets  " + this.getInsets() + "\n" + "Toolbar " + this.fToolBarHeight + "\n" + "Menubar " + this.fMenuBarHeight);
    }

    @Override
    public void setFrameProxy(FigureFrameProxyBase figureFrameProxyBase) {
        this.fFrameProxy = figureFrameProxyBase;
        assert (!this.fFrameProxySet);
        this.fFrameProxySet = true;
    }

    @Override
    public void componentChanged(boolean bl, int n, int n2) {
        int n3;
        int n4 = n3 = bl ? n2 : 0;
        if (!this.fDockPending || n3 == 0 && this.fDockPending) {
            this.update(new JavaComponentChanging(n3, n));
        }
    }

    @Override
    public void setCachedMenuBarHeight(int n) {
        if (n != this.fMenuBarHeight) {
            this.update(new MenuBarHeightChanging(n));
        }
    }

    @Override
    public void setToolbarContainerHeight(int n) {
        if (this.fToolBarHeight != n) {
            this.update(new ToolBarHeightChanging(n));
        }
    }

    private void qeSetRealInsets(Insets insets) {
        FigureInsetsUtilities.updateCachedResizableFrameInsets(insets);
    }

    private void _movePoint(Point point, Point point2, boolean bl) {
        MarginHelper marginHelper = new MarginHelper();
        int n = marginHelper.xCorrection;
        int n2 = marginHelper.yCorrection;
        int n3 = 1;
        if (bl) {
            n3 = -1;
        }
        point2.translate(n3 * point.x, n3 * point.y);
        point2.translate(n3 * n, n3 * n2);
    }

    private Insets getCachedInsets() {
        if (this.fResizable) {
            return FigureInsetsUtilities.getCachedResizableFrameInsets();
        }
        return FigureInsetsUtilities.getCachedNonResizableFrameInsets();
    }

    private Insets getFrameInsets() {
        if (this.fFrameProxy.isShowing()) {
            return this.fFrameProxy.getInsets();
        }
        return null;
    }

    @Override
    public void updateInsets() {
        Insets insets = this.getFrameInsets();
        if (insets != null) {
            if (this.fResizable) {
                FigureInsetsUtilities.updateCachedResizableFrameInsets(insets);
            } else {
                FigureInsetsUtilities.updateCachedNonResizableFrameInsets(insets);
            }
        }
    }

    private Insets getInsets() {
        Insets insets = this.getFrameInsets();
        if (insets == null) {
            insets = this.getCachedInsets();
        }
        Insets insets2 = FigureInsetsUtilities.validateInsets(insets, this.fResizable);
        if (this.fOldInsets == null) {
            this.fOldInsets = (Insets)insets2.clone();
        }
        return insets2;
    }

    private boolean updateCachedInsets() {
        boolean bl = false;
        Insets insets = this.getInsets();
        if (!this.fOldInsets.equals(insets)) {
            this.fOldInsets = (Insets)insets.clone();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isSizeLocationPending() {
        return this.fLocationSizeSetHandler.isSizeSetPending() || this.fLocationSizeSetHandler.isLocationSetPending();
    }

    @Override
    public void releaseSizeLocationPending() {
        this.fLocationSizeSetHandler.releaseAllPending();
    }

    @Override
    public void recheckPendingLocationOrSizeOnEDT() {
        if (this.fFigureClient.isShowing()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WindowRectHandlerImpl.this.recheckPendingLocationOrSize();
                }
            };
            FigurePeer.runOnEDT(runnable);
        }
    }

    private void recheckPendingLocationOrSize() {
        if (this.fLocationSizeSetHandler.isSizeSetPending() || this.fLocationSizeSetHandler.isLocationSetPending()) {
            if (this.fDocked || !this.isShowing()) {
                this.fLocationSizeSetHandler.releaseAllPending();
                return;
            }
            Rectangle rectangle = this.fFrameProxy.getBounds();
            Rectangle rectangle2 = this.getOuterBounds();
            if (rectangle.width == rectangle2.width && rectangle.height == rectangle2.height) {
                this.fLocationSizeSetHandler.setSizeSetPending(false);
            }
            if (rectangle.x == rectangle2.x && rectangle.y == rectangle2.y) {
                this.fLocationSizeSetHandler.setLocationSetPending(false);
            }
        }
    }

    private void fireMoveResizeEvent(PositionEventType positionEventType) {
        FigureMoveResizeNotification figureMoveResizeNotification = new FigureMoveResizeNotification(positionEventType == PositionEventType.MOVED);
        this.fFigureClient.handleNotification(figureMoveResizeNotification);
    }

    static {
        sInsetsChanging = new FigureAttributesChanging();
    }

    private class LocationSizeSetHandler {
        private boolean fLocationSetPending = false;
        private boolean fSizeSetPending = false;

        private LocationSizeSetHandler() {
        }

        void setLocationSetPending(boolean bl) {
            this.fLocationSetPending = bl;
        }

        public boolean isLocationSetPending() {
            return this.fLocationSetPending;
        }

        public void setSizeSetPending(boolean bl) {
            this.fSizeSetPending = bl;
        }

        public boolean isSizeSetPending() {
            return this.fSizeSetPending;
        }

        void setAllPending() {
            this.setLocationSetPending(true);
            this.setSizeSetPending(true);
        }

        public void releaseAllPending() {
            this.setLocationSetPending(false);
            this.setSizeSetPending(false);
        }
    }

    private static class FigureAttributesChanging {
        private FigureAttributesChanging() {
        }

        void attributeChanged() {
        }
    }

    private class ToolBarHeightChanging
    extends FigureAttributesChanging {
        int fToolBarHeight = 0;

        ToolBarHeightChanging(int n) {
            assert (n >= 0);
            this.fToolBarHeight = n;
        }

        @Override
        public void attributeChanged() {
            WindowRectHandlerImpl.this.fToolBarHeight = this.fToolBarHeight;
        }
    }

    private class MenuBarHeightChanging
    extends FigureAttributesChanging {
        int fMenuBarHeight = 0;

        MenuBarHeightChanging(int n) {
            assert (n >= 0);
            this.fMenuBarHeight = n;
        }

        @Override
        public void attributeChanged() {
            WindowRectHandlerImpl.this.fMenuBarHeight = this.fMenuBarHeight;
        }
    }

    private class JavaComponentChanging
    extends FigureAttributesChanging {
        int fMargin = 0;
        int fType = 0;

        JavaComponentChanging(int n, int n2) {
            this.fMargin = n;
            this.fType = n2;
        }

        @Override
        public void attributeChanged() {
            switch (this.fType) {
                case 0: {
                    WindowRectHandlerImpl.this.fJavaCompNorth = this.fMargin;
                    break;
                }
                case 1: {
                    WindowRectHandlerImpl.this.fJavaCompSouth = this.fMargin;
                    break;
                }
                case 3: {
                    WindowRectHandlerImpl.this.fJavaCompWest = this.fMargin;
                    break;
                }
                case 2: {
                    WindowRectHandlerImpl.this.fJavaCompEast = this.fMargin;
                    break;
                }
                default: {
                    throw new AssertionError(this.fType);
                }
            }
        }
    }

    private class MarginHelper {
        public int xCorrection;
        public int yCorrection;
        public int widthCorrection;
        public int heightCorrection;
        private boolean fShowing;

        private MarginHelper() {
            this.calculateMargins();
        }

        public void calculateMargins() {
            boolean bl = WindowRectHandlerImpl.this.isUsingDockedMargins();
            Insets insets = this.determineInsets(bl);
            this.xCorrection = insets.left + WindowRectHandlerImpl.this.fJavaCompWest;
            this.yCorrection = insets.top + WindowRectHandlerImpl.this.fJavaCompNorth + this.toolbarMenubarCorrection(bl);
            this.widthCorrection = this.xCorrection + insets.right + WindowRectHandlerImpl.this.fJavaCompEast;
            this.heightCorrection = this.yCorrection + insets.bottom + WindowRectHandlerImpl.this.fJavaCompSouth;
        }

        private Insets determineInsets(boolean bl) {
            Insets insets = new Insets(0, 0, 0, 0);
            insets = bl ? WindowRectHandlerImpl.this.fFigureClient.getDockedClientInsets() : (WindowRectHandlerImpl.this.fOldInsets == null ? WindowRectHandlerImpl.this.getInsets() : WindowRectHandlerImpl.this.fOldInsets);
            return insets;
        }

        private int toolbarMenubarCorrection(boolean bl) {
            int n = 0;
            if (!bl) {
                n = WindowRectHandlerImpl.this.fToolBarHeight + WindowRectHandlerImpl.this.fMenuBarHeight;
            }
            return n;
        }
    }

    private class ResizableChanging
    extends FigureAttributesChanging {
        boolean fResizable = true;

        ResizableChanging(boolean bl) {
            this.fResizable = bl;
        }

        @Override
        public void attributeChanged() {
            WindowRectHandlerImpl.this.fResizable = this.fResizable;
        }
    }
}

