/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.common.icons.ControlIcon;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.util.CategoricalVariable;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Introspector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class UITreeNode
extends DefaultMutableTreeNode {
    private static final int UIC_PUSHB = 0;
    private static final int UIC_SLIDER = 1;
    private static final int UIC_RADIOB = 2;
    private static final int UIC_CHECKB = 3;
    private static final int UIC_EDIT = 4;
    private static final int UIC_STATIC = 5;
    private static final int UIC_FRAME = 6;
    private static final int UIC_POPUP = 7;
    private static final int UIC_LISTB = 8;
    private static final int UIC_TOGGLEB = 9;
    private static final int UIC_AXES = 10;
    private static final int NUM_ICONS = 11;
    private static Image[] sUIControlIcons;
    private static Image sUnknownIcon;
    private static boolean sIconsInitialized;
    private Object fValue = null;
    private String fName = null;
    private boolean fLoaded = false;
    private Image fIcon = null;

    public UITreeNode(Object object, String string, String string2, boolean bl) {
        this.setValue(object);
        this.setName(string);
        if (null != string2) {
            Image image = new ImageIcon(string2).getImage();
            this.setIcon(image);
        } else {
            this.setIcon(null);
        }
        this.setLeafNode(bl);
    }

    public UITreeNode(Object object, String string) {
        this.setValue(object);
        this.setName(string);
        this.setIcon(UITreeNode.getMatlabIcon(object));
        this.setAllowsChildren(true);
    }

    public void setValue(Object object) {
        this.fValue = object;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setIcon(Image image) {
        this.fIcon = null == image ? UITreeNode.getMatlabIcon(this.fValue) : image;
    }

    public Image getIcon() {
        return this.fIcon;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public String getName() {
        return this.fName;
    }

    public void setLeafNode(boolean bl) {
        this.setAllowsChildren(!bl);
    }

    public boolean isLeafNode() {
        return !this.getAllowsChildren();
    }

    void setLoaded(boolean bl) {
        this.fLoaded = bl;
    }

    boolean isLoaded() {
        return this.fLoaded;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ':' + this.getName();
    }

    private static Image getMatlabIcon(Object object) {
        BeanInfo beanInfo;
        UITreeNode.initIcons();
        Image image = sUnknownIcon;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {
            beanInfo = null;
        }
        if (beanInfo != null && object instanceof UDDObject) {
            UDDObject uDDObject = (UDDObject)object;
            String string = beanInfo.getBeanDescriptor().getDisplayName();
            if (string.equals("uicontrol")) {
                int n = (Integer)uDDObject.getPropertyValue("Style");
                image = sUIControlIcons[n];
            }
            if (string.equals("matlab.ui.control.UIControl")) {
                CategoricalVariable categoricalVariable = (CategoricalVariable)uDDObject.getPropertyValue("Style");
                image = sUIControlIcons[(Integer)categoricalVariable.getValue()];
            }
            if (string.equals("axes") || string.equals("matlab.graphics.axis.Axes")) {
                image = sUIControlIcons[10];
            }
        }
        return image;
    }

    private static void initIcons() {
        if (!sIconsInitialized) {
            sUnknownIcon = ControlIcon.UNKNOWN.getIcon().getImage();
            sUIControlIcons = new Image[11];
            UITreeNode.sUIControlIcons[0] = ControlIcon.PUSHBUTTON.getIcon().getImage();
            UITreeNode.sUIControlIcons[1] = ControlIcon.SCROLLBAR.getIcon().getImage();
            UITreeNode.sUIControlIcons[2] = ControlIcon.RADIOBUTTON.getIcon().getImage();
            UITreeNode.sUIControlIcons[3] = ControlIcon.CHECKBOX.getIcon().getImage();
            UITreeNode.sUIControlIcons[4] = ControlIcon.TEXTEDIT.getIcon().getImage();
            UITreeNode.sUIControlIcons[5] = ControlIcon.LABEL.getIcon().getImage();
            UITreeNode.sUIControlIcons[6] = ControlIcon.FRAME.getIcon().getImage();
            UITreeNode.sUIControlIcons[7] = ControlIcon.COMBOBOX.getIcon().getImage();
            UITreeNode.sUIControlIcons[8] = ControlIcon.LISTBOX.getIcon().getImage();
            UITreeNode.sUIControlIcons[9] = ControlIcon.TOGGLEBUTTON.getIcon().getImage();
            UITreeNode.sUIControlIcons[10] = ControlIcon.AXES.getIcon().getImage();
            sIconsInitialized = true;
        }
    }

    static {
        sIconsInitialized = false;
    }
}

