/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.action.AbstractNewAction;
import com.mathworks.widgets.action.AbstractOpenAction;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTClientPropertyProvider;
import com.mathworks.widgets.desk.DTGroupAdapter;
import com.mathworks.widgets.desk.DTGroupBase;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;

public class FiguresGroup
extends DTGroupBase {
    MatlabMCR fMatlab = new MatlabMCR();
    Action fHidePlotToolsAction;
    Action fShowPlotToolsAction;
    private ResourceBundle fBundle;
    private static final String NAME = "Figures";
    private static FiguresGroup sInstance;

    protected FiguresGroup() {
        this.setGroupName(NAME);
        this.setAllowForcedClose(false);
        this.setPermitUserFloat(true);
        this.setAllowToolBarRearrangement(false);
        this.setHeavyweight(!FigurePeer.defaultUseLightWeightContainer());
        this.fBundle = ResourceBundle.getBundle("com.mathworks.hg.peer.resources.RES_FiguresGroup");
        this.fHidePlotToolsAction = new HidePlotToolsAction();
        this.fShowPlotToolsAction = new ShowPlotToolsAction();
        this.setToolBar(this.createToolBar());
        this.putGroupProperty((DTProperty)DTGroupProperty.LEGACY_TOOLSTRIP_TAB_TITLE, this.fBundle.getString("tabTitle.Figures"));
        this.fBundle = null;
    }

    public static synchronized FiguresGroup getInstance() {
        if (sInstance == null) {
            sInstance = new FiguresGroup();
        }
        return sInstance;
    }

    protected void setParentDesktop(Desktop desktop) {
        super.setParentDesktop(desktop);
        if (desktop != null) {
            desktop.addClientListener(NAME, (DTClientListener)new ClientListener());
            desktop.addGroupListener(NAME, (DTGroupListener)new GroupListener());
        }
        this.updatePlotToolsActions();
    }

    private JToolBar createToolBar() {
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.add((Action)((Object)new NewFigureAction()));
        mJToolBar.add((Action)((Object)new OpenFileAction()));
        mJToolBar.addSeparator();
        mJToolBar.add(this.fHidePlotToolsAction);
        mJToolBar.add(this.fShowPlotToolsAction);
        return mJToolBar;
    }

    private void updatePlotToolsActions() {
        boolean bl = false;
        Desktop desktop = this.getParentDesktop();
        if (desktop != null) {
            Component[] componentArray = desktop.getGroupMembers(NAME);
            for (int i = 0; i < componentArray.length && !bl; ++i) {
                if (!desktop.isClientShowing(componentArray[i]) || !(componentArray[i] instanceof DTClientPropertyProvider)) continue;
                Object object = ((DTClientPropertyProvider)componentArray[i]).getClientProperty((Object)DTClientProperty.MULTIPLE_INSTANCES);
                bl = object == null || Boolean.FALSE.equals(object);
            }
        }
        this.fHidePlotToolsAction.setEnabled(bl);
        this.fShowPlotToolsAction.setEnabled(!bl);
    }

    private class GroupListener
    extends DTGroupAdapter {
        private GroupListener() {
        }

        public void groupClosing(DTGroupEvent dTGroupEvent) {
            Desktop desktop = FiguresGroup.this.getParentDesktop();
            if (desktop != null) {
                desktop.closeGroupSingletons(FiguresGroup.NAME);
            }
        }
    }

    private class ClientListener
    extends DTClientAdapter {
        private ClientListener() {
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            FiguresGroup.this.updatePlotToolsActions();
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            FiguresGroup.this.updatePlotToolsActions();
        }
    }

    private class HidePlotToolsAction
    extends MJAbstractAction {
        HidePlotToolsAction() {
            super(FiguresGroup.this.fBundle.getString("HidePlotTools"), (Icon)new ImageIcon(FiguresGroup.class.getResource("resources/plottoolsoff.gif")));
            this.setComponentName("HidePlotTools");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Desktop desktop = FiguresGroup.this.getParentDesktop();
            if (desktop != null) {
                desktop.closeGroupSingletons(FiguresGroup.NAME);
            }
        }
    }

    private class ShowPlotToolsAction
    extends MJAbstractAction {
        ShowPlotToolsAction() {
            super(FiguresGroup.this.fBundle.getString("ShowPlotTools"), (Icon)new ImageIcon(FiguresGroup.class.getResource("resources/plottoolson.gif")));
            this.setComponentName("ShowPlotTools");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Desktop desktop = FiguresGroup.this.getParentDesktop();
            if (desktop != null) {
                desktop.restoreGroupSingletons(FiguresGroup.NAME);
            }
        }
    }

    private class OpenFileAction
    extends AbstractOpenAction {
        OpenFileAction() {
            this.setTip(FiguresGroup.this.fBundle.getString("OpenFile"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiguresGroup.this.fMatlab.evalConsoleOutput("uiopen('figure')");
        }
    }

    private class NewFigureAction
    extends AbstractNewAction {
        NewFigureAction() {
            this.setTip(FiguresGroup.this.fBundle.getString("NewFigure"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiguresGroup.this.fMatlab.evalConsoleOutput("figure('WindowStyle','docked');");
        }
    }
}

