/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.EchoEvent;
import com.mathworks.hg.peer.EchoListener;
import com.mathworks.hg.peer.FigureRenderLocker;
import com.mathworks.hg.util.HGUtils;
import java.awt.EventQueue;
import java.util.Enumeration;
import java.util.Vector;

public class Echo {
    private transient Vector<EchoListener> fEchoListeners;
    private final Object fEchoListenersLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Echo() {
        Object object = this.fEchoListenersLock = new Object();
        synchronized (object) {
            this.fEchoListeners = new Vector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEchoListener(EchoListener echoListener) {
        Object object = this.fEchoListenersLock;
        synchronized (object) {
            this.fEchoListeners.addElement(echoListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEchoListener(EchoListener echoListener) {
        Object object = this.fEchoListenersLock;
        synchronized (object) {
            this.fEchoListeners.removeElement(echoListener);
        }
    }

    public int fireEchoEvent(int n, boolean bl) {
        if (FigureRenderLocker.isBlocked()) {
            return 0;
        }
        if (bl || HGUtils.isEchoNeeded()) {
            EventQueue.invokeLater(new FireRunnable(new EchoEvent(n)));
            HGUtils.clearEchoNeeded();
            return n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFireEchoEvent(EchoEvent echoEvent) {
        boolean bl;
        Object object = this.fEchoListenersLock;
        synchronized (object) {
            bl = this.fEchoListeners == null;
        }
        if (bl) {
            System.out.println("EVENTQUEUE: com.mathworks.hg.peer.Echo: NULL listener list.");
            return;
        }
        Enumeration enumeration = this.fEchoListenersLock;
        synchronized (enumeration) {
            object = (Vector)this.fEchoListeners.clone();
        }
        if (object == null) {
            System.out.println("EVENTQUEUE: com.mathworks.hg.peer.Echo: Unable to clone listener list.");
            return;
        }
        enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            EchoListener echoListener = (EchoListener)enumeration.nextElement();
            if (echoListener != null) {
                echoListener.echoEvent(echoEvent);
                continue;
            }
            System.out.println("EVENTQUEUE: com.mathworks.hg.peer.Echo: NULL listener in list.");
        }
    }

    private class FireRunnable
    implements Runnable {
        private EchoEvent fEvent;

        public FireRunnable(EchoEvent echoEvent) {
            this.fEvent = echoEvent;
        }

        @Override
        public void run() {
            Echo.this.doFireEchoEvent(this.fEvent);
        }
    }
}

