/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.event.UicontrolEvent;
import com.mathworks.hg.peer.types.HGWindowsComboBoxUI;
import com.mathworks.hg.peer.utils.UIControlComboBoxRenderer;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.hg.util.UISettings;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class ComboboxPeer
extends AbstractUicontrolPeer {
    MJComboBox fCombobox;
    boolean fIsArrowButtonConfigured = true;
    HGRectangle fPosition = new HGRectangle();
    ComboboxUicontrolActionListener fListener;
    private boolean fListenersEnabled = false;
    boolean fFontSetInProgress;
    double[] fValue;
    double fMax;
    double fMin;
    private static int sMarginCorrection = 2;
    private static Color sViewPopUpUIControlBackgroundColor = null;

    public ComboboxPeer() {
        this.fType = 7;
    }

    @Override
    protected void createComponent() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fCombobox = new MLComboBox();
        this.fComponent = this.fCombobox;
        this.fCombobox.setEditable(false);
        this.fCombobox.setMaximumRowCount(20);
        this.fCombobox.setFocusable(true);
        if (PlatformInfo.isMacintosh()) {
            this.fCombobox.putClientProperty((Object)"JComboBox.isSquare", (Object)Boolean.TRUE);
        }
    }

    @Override
    protected boolean doPreSetString(String[] stringArray) {
        super.doPreSetString(stringArray);
        return true;
    }

    @Override
    protected void doSetString(String[] stringArray) {
        this.removeUicontrolActionListeners();
        if (null != stringArray) {
            DefaultComboBoxModel defaultComboBoxModel;
            stringArray = this.deriveUnicodeFromFont(stringArray);
            boolean bl = false;
            if (stringArray.length > 99) {
                defaultComboBoxModel = new DefaultComboBoxModel();
                bl = true;
            } else {
                defaultComboBoxModel = (DefaultComboBoxModel)this.fCombobox.getModel();
                this.fCombobox.setSelectedIndex(-1);
                defaultComboBoxModel.removeAllElements();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                defaultComboBoxModel.addElement(new ComboBoxElement(stringArray[i]));
            }
            if (bl) {
                this.fCombobox.setModel((ComboBoxModel)defaultComboBoxModel);
            }
            this.doSetValue(this.fValue, this.fMax, this.fMin);
        }
        if (null != this.fListener) {
            this.addUicontrolActionListeners();
        }
    }

    private void doSetPosition(double d, double d2, double d3, double d4, boolean bl) {
        if (this.fParentPanel != null) {
            double d5 = bl ? d4 : ((Component)((Object)this.fCombobox.getRenderer())).getPreferredSize().getHeight();
            double d6 = 4.0;
            double d7 = 1.0;
            if (PlatformInfo.isMacintosh()) {
                d7 = 4.0;
            }
            double d8 = this.fX;
            double d9 = this.fY - this.fH;
            this.fParentPanel.setBounds((int)d8, (int)d9, (int)this.fW, (int)(d5 += d6 + d7));
            this.fParentPanel.validate();
        }
    }

    @Override
    protected void doSetPosition(double d, double d2, double d3, double d4) {
        this.doSetPosition(d, d2, d3, d4, false);
    }

    @Override
    protected void doSetFont(Font font) {
        super.doSetFont(font);
        FontMetrics fontMetrics = this.fCombobox.getFontMetrics(font);
        final double d = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading() + 2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboboxPeer.this.doSetPosition(ComboboxPeer.this.fX, ComboboxPeer.this.fY, ComboboxPeer.this.fW, d, true);
            }
        });
    }

    @Override
    protected boolean doPreSetValue(double[] dArray, double d, double d2) {
        this.addLogMessage(11);
        return true;
    }

    @Override
    protected void doSetValue(double[] dArray, double d, double d2) {
        this.removeUicontrolActionListeners();
        this.fValue = dArray;
        this.fMax = d;
        this.fMin = d2;
        if (dArray != null && dArray.length > 0) {
            int n = (int)dArray[0] - 1;
            if (this.fCombobox != null && n >= 0 && n < this.fCombobox.getItemCount()) {
                this.fCombobox.setSelectedIndex(n);
            }
        }
        if (null != this.fListener) {
            this.addUicontrolActionListeners();
        }
    }

    @Override
    protected double[] doGetValue() {
        double[] dArray = new double[1];
        if (this.fCombobox != null) {
            dArray[0] = this.fCombobox.getSelectedIndex() + 1;
        }
        this.fValue = dArray;
        return dArray;
    }

    @Override
    protected void doSetInactive() {
        super.doSetInactive();
        if (this.fEnable == 1 && !this.fIsArrowButtonConfigured) {
            ((BasicComboBoxUI)this.fCombobox.getUI()).configureArrowButton();
            this.fIsArrowButtonConfigured = true;
        } else if (this.fEnable != 1 && this.fIsArrowButtonConfigured) {
            ((BasicComboBoxUI)this.fCombobox.getUI()).unconfigureArrowButton();
            this.fIsArrowButtonConfigured = false;
        }
    }

    @Override
    protected void addUicontrolActionListeners() {
        if (this.fListenersEnabled) {
            return;
        }
        if (this.fListener == null) {
            this.fListener = new ComboboxUicontrolActionListener();
        }
        this.fCombobox.addActionListener((ActionListener)this.fListener);
        this.fCombobox.addKeyListener((KeyListener)this.fListener);
        this.fListenersEnabled = true;
    }

    @Override
    protected void removeUicontrolActionListeners() {
        if (this.fListener == null || !this.fListenersEnabled) {
            return;
        }
        this.fCombobox.removeKeyListener((KeyListener)this.fListener);
        this.fCombobox.removeActionListener((ActionListener)this.fListener);
        this.fListenersEnabled = false;
    }

    private static class ComboBoxElement {
        private String fDisplayName;

        public ComboBoxElement(String string) {
            this.fDisplayName = string;
        }

        public String toString() {
            return this.fDisplayName;
        }
    }

    private class MLComboBox
    extends MJComboBox {
        public MLComboBox() {
            Component component;
            super(new DefaultComboBoxModel());
            if (PlatformInfo.isMacintosh() && (component = this.getComponent(0)) instanceof JButton) {
                MacArrowButtonMouseListener macArrowButtonMouseListener = new MacArrowButtonMouseListener();
                component.addMouseListener(macArrowButtonMouseListener);
                component.addMouseMotionListener(macArrowButtonMouseListener);
            }
            if (PlafUtils.isWindowsLookAndFeel()) {
                this.setRenderer(new UIControlComboBoxRenderer());
            }
        }

        public Insets getInsets() {
            Insets insets = super.getInsets();
            return new Insets(insets.top, -1, insets.bottom, 0);
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (ComboboxPeer.this.fEnable == 1) {
                super.processEvent(aWTEvent);
            } else {
                ComboboxPeer.this.doProcessEvent(aWTEvent);
            }
        }

        public void updateUI() {
            String string = UIManager.getLookAndFeel().getClass().getName();
            if (string.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                super.updateUI();
                this.setUI((ComboBoxUI)((Object)new HGWindowsComboBoxUI()));
            } else {
                super.updateUI();
            }
        }

        public void setBackground(Color color) {
            if (UISettings.isGraphicsVersion1ColorSettingsEnvironment()) {
                super.setBackground(color);
            } else {
                if (sViewPopUpUIControlBackgroundColor == null) {
                    sViewPopUpUIControlBackgroundColor = UISettings.getGraphics2ColorSetting("view", "popup_uicontrol", "BackgroundColor");
                }
                if (UISettings.isColorSameAsUIControlFactoryValue(color)) {
                    color = sViewPopUpUIControlBackgroundColor;
                }
                super.setBackground(color);
            }
        }

        private class MacArrowButtonMouseListener
        extends MouseAdapter
        implements MouseMotionListener {
            private MacArrowButtonMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.dispatchToComboBox(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.dispatchToComboBox(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.dispatchToComboBox(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.dispatchToComboBox(mouseEvent);
            }

            public void dispatchToComboBox(AWTEvent aWTEvent) {
                if (ComboboxPeer.this.fEnable != 1) {
                    MLComboBox.this.dispatchEvent(aWTEvent);
                }
            }
        }
    }

    private class ComboboxUicontrolActionListener
    extends KeyAdapter
    implements ActionListener {
        private ComboboxUicontrolActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UicontrolEvent uicontrolEvent = new UicontrolEvent(ComboboxPeer.this, actionEvent.getSource());
            ComboboxPeer.this.fireUicontrolAction(uicontrolEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                UicontrolEvent uicontrolEvent = new UicontrolEvent(ComboboxPeer.this, keyEvent.getSource());
                ComboboxPeer.this.fireUicontrolAction(uicontrolEvent);
                ComboboxPeer.this.refreshUicontrol();
            }
        }
    }
}

