/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.BaseControl;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.hg.util.FontConverter;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerReplaceRunnable;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.JComponent;

public abstract class AbstractComponentPeer
implements BaseControl,
HGPeerQueueUser {
    protected JComponent fComponent = null;
    protected Container fParentPanel = null;
    protected static final int sFirstMethodIndex = 0;
    protected static final int sAddControlView = 0;
    protected static final int sRemoveControlView = 1;
    protected static final int sSetControlBackgroundColor = 2;
    protected static final int sSetControlForegroundColor = 3;
    protected static final int sSetControlEnable = 4;
    protected static final int sSetControlVisible = 5;
    protected static final int sSetControlPosition = 6;
    protected static final int sSetControlFont = 7;
    protected static final int sSetControlTooltip = 8;
    protected static final int sInitializePeer = 9;
    protected static final int sLastBaseMethodIndex = 9;
    private static final String[] sLogMessagesBase = new String[]{"addControl", "removeControl", "setControlBackgroundColor", "setControlForegroundColor", "setControlEnable", "setControlVisible", "setControlPosition", "setControlFont", "setControlTooltip", "initializeControlPeer"};

    @Override
    public final void addControl(final UIComponentParent uIComponentParent, final int n) {
        HGPeerReplaceRunnable hGPeerReplaceRunnable = new HGPeerReplaceRunnable(this, this, 0, 0){

            @Override
            public void run() {
                AbstractComponentPeer.this.doAddControl(uIComponentParent, n);
            }
        };
        if (this.doPreAddControl(uIComponentParent, n)) {
            HGUtils.invokeLater(hGPeerReplaceRunnable);
        }
    }

    @Override
    public final void removeControl() {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 1, 1){

            @Override
            public void run() {
                AbstractComponentPeer.this.doRemoveControl();
            }
        };
        if (this.doPreRemoveControl()) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    @Override
    public final void setControlEnable(final int n) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 4, 7){

            @Override
            public void run() {
                AbstractComponentPeer.this.doSetEnable(n);
            }
        };
        if (this.doPreSetEnable(n)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    @Override
    public final void setControlVisible(final boolean bl) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 5, 7){

            @Override
            public void run() {
                AbstractComponentPeer.this.doSetVisible(bl);
            }
        };
        if (this.doPreSetVisible(bl)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    @Override
    public final void setControlBackgroundColor(final Color color) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 2, 7){

            @Override
            public void run() {
                AbstractComponentPeer.this.doSetBackgroundColor(color);
            }
        };
        if (this.doPreSetBackgroundColor(color)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    @Override
    public final void setControlForegroundColor(final Color color) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 3, 7){

            @Override
            public void run() {
                AbstractComponentPeer.this.doSetForegroundColor(color);
            }
        };
        if (this.doPreSetForegroundColor(color)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    @Override
    public final void setControlPosition(final double d, final double d2, final double d3, final double d4) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 6, 7){

            @Override
            public void run() {
                AbstractComponentPeer.this.doSetPosition(d, d2, d3, d4);
            }
        };
        if (this.doPreSetPosition(d, d2, d3, d4)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    public final void setControlFont(String string, double d, int n, int n2) {
        final Font font = FontConverter.convertToJavaFont(string, d, n, n2);
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 7, 7, true){

            @Override
            public void run() {
                AbstractComponentPeer.this.doSetFont(font);
            }
        };
        if (this.doPreSetFont(font)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    @Override
    public final void setControlTooltip(final String string) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 8, 7){

            @Override
            public void run() {
                AbstractComponentPeer.this.doSetTooltip(string);
            }
        };
        if (this.doPreSetTooltip(string)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    private boolean doPreAddControl(UIComponentParent uIComponentParent, int n) {
        return true;
    }

    private boolean doPreRemoveControl() {
        return true;
    }

    private boolean doPreSetEnable(int n) {
        return true;
    }

    private boolean doPreSetVisible(boolean bl) {
        return true;
    }

    protected boolean doPreSetBackgroundColor(Color color) {
        return true;
    }

    protected boolean doPreSetForegroundColor(Color color) {
        return true;
    }

    protected boolean doPreSetPosition(double d, double d2, double d3, double d4) {
        return true;
    }

    protected boolean doPreSetFont(Font font) {
        return true;
    }

    protected boolean doPreSetTooltip(String string) {
        return true;
    }

    protected void doAddControl(UIComponentParent uIComponentParent, int n) {
    }

    protected void doRemoveControl() {
    }

    protected void doSetEnable(int n) {
        if (this.fComponent != null) {
            if (n == 0) {
                this.fComponent.setEnabled(false);
            } else {
                this.fComponent.setEnabled(true);
            }
        }
    }

    protected void doSetVisible(boolean bl) {
        if (this.fComponent != null) {
            this.fComponent.setVisible(bl);
        }
    }

    protected void doSetBackgroundColor(Color color) {
        if (this.fComponent != null) {
            this.fComponent.setBackground(color);
        }
    }

    protected void doSetForegroundColor(Color color) {
        if (this.fComponent != null) {
            this.fComponent.setForeground(color);
        }
    }

    protected void doSetPosition(double d, double d2, double d3, double d4) {
        Container container;
        if (this.fParentPanel != null && (container = this.fParentPanel.getParent()) != null) {
            double d5 = container.getBounds().getHeight();
            double d6 = d;
            double d7 = d5 - (d5 - d2) - d4;
            this.fParentPanel.setBounds((int)d6, (int)d7, (int)d3, (int)d4);
        }
    }

    protected void doSetFont(Font font) {
        if (this.fComponent != null) {
            this.fComponent.setFont(font);
        }
    }

    protected void doSetTooltip(String string) {
        if (this.fComponent != null) {
            this.fComponent.setToolTipText(string);
        }
    }

    @Override
    public int getUserLastMethodID() {
        return 9;
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 9) {
            string = sLogMessagesBase[n - 0];
        }
        return string;
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return null;
    }

    public Component getComponent() {
        return this.fComponent;
    }
}

