/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor.widget.rtc;

import com.mathworks.html.HtmlCallbackProvider;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.mde.embeddedoutputs.EmbeddedOutputs;
import com.mathworks.mde.richeditor.widget.rtc.ConnectorFactory;
import com.mathworks.mde.richeditor.widget.rtc.DocumentEvent;
import com.mathworks.mde.richeditor.widget.rtc.DocumentEventSupport;
import com.mathworks.mde.richeditor.widget.rtc.DocumentListener;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.util.Log;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;

public class RichDocument {
    private final String fUniqueKey;
    private EmbeddedOutputs fEmbeddedOutputs;
    private final HtmlCallbackProvider fHtmlCommunication;
    private final DocumentEventSupport fDocumentEventSupport;
    private Subscriber fGetContentSubscriber;
    private Subscriber fSetContentSubscriber;
    private AtomicBoolean fSetContentResponse;
    private AtomicReference<Map<String, Object>> fGetContentResponse;
    private static final Map<String, Object> NO_CONTENT_RESULT = null;
    private static final String GET_CONTENT_REQUEST_CHANNEL_PREFIX = "/richeditor/events/getContentRequest/";
    private static final String GET_CONTENT_RESPONSE_CHANNEL_PREFIX = "/richeditor/events/getContentResponse/";
    private static final String SET_CONTENT_REQUEST_CHANNEL_PREFIX = "/richeditor/events/setContentRequest/";
    private static final String SET_CONTENT_RESPONSE_CHANNEL_PREFIX = "/richeditor/events/setContentResponse/";
    private static final String NO_DATA = "nodata";

    RichDocument(HtmlCallbackProvider htmlCallbackProvider, String string) {
        this.fUniqueKey = string;
        this.fHtmlCommunication = htmlCallbackProvider;
        this.fDocumentEventSupport = new DocumentEventSupport(string);
        this.initializeEmbeddedOutputs(string);
        this.installListeners(string);
    }

    private void installListeners(final String string) {
        this.fSetContentResponse = new AtomicBoolean(false);
        this.fGetContentResponse = new AtomicReference();
        this.fGetContentSubscriber = new Subscriber(){

            public void handle(Message message) {
                try {
                    RichDocument.this.fGetContentResponse.set((Map)message.getData());
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        };
        this.fSetContentSubscriber = new Subscriber(){

            public void handle(Message message) {
                try {
                    RichDocument.this.fSetContentResponse.set(true);
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        };
        ConnectorFactory.runWhenReady(new Runnable(){

            @Override
            public void run() {
                RichDocument.subscribe(RichDocument.GET_CONTENT_RESPONSE_CHANNEL_PREFIX + string, RichDocument.this.fGetContentSubscriber);
                RichDocument.subscribe(RichDocument.SET_CONTENT_RESPONSE_CHANNEL_PREFIX + string, RichDocument.this.fSetContentSubscriber);
            }
        });
    }

    private void initializeEmbeddedOutputs(final String string) {
        ConnectorFactory.runWhenReady(new Runnable(){

            @Override
            public void run() {
                RichDocument.this.fEmbeddedOutputs = new EmbeddedOutputs(string);
            }
        });
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.fDocumentEventSupport.addDocumentListener(documentListener);
    }

    public void addDocumentListener(DocumentEvent.EventType eventType, DocumentListener documentListener) {
        this.fDocumentEventSupport.addDocumentListener(eventType, documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.fDocumentEventSupport.removeDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentEvent.EventType eventType, DocumentListener documentListener) {
        this.fDocumentEventSupport.removeDocumentListener(eventType, documentListener);
    }

    public synchronized Map<String, Object> getContent() {
        this.fGetContentResponse.set(NO_CONTENT_RESULT);
        RichDocument.publish(GET_CONTENT_REQUEST_CHANNEL_PREFIX + this.fUniqueKey, NO_DATA);
        try {
            while (this.fGetContentResponse.get() == NO_CONTENT_RESULT) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            Log.logException((Exception)interruptedException);
        }
        return this.fGetContentResponse.get();
    }

    public String getMContent() {
        return this.executeScriptAndReturn("MDocumentWriter.write(rtcInstance._internalDocument)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeScriptAndReturn(String string) {
        assert (!SwingUtilities.isEventDispatchThread()) : "This should not be on swing thread";
        ReentrantLock reentrantLock = new ReentrantLock();
        reentrantLock.lock();
        final Condition condition = reentrantLock.newCondition();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        final AtomicReference atomicReference = new AtomicReference();
        this.fHtmlCommunication.executeScript(string, (HtmlDataListener)new HtmlDataListener<String>(){

            public void dataRetrieved(String string) {
                atomicBoolean.set(true);
                atomicReference.set(string);
                condition.signal();
            }
        });
        try {
            while (!atomicBoolean.get()) {
                condition.await(1L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            Log.logException((Exception)interruptedException);
        }
        finally {
            reentrantLock.unlock();
        }
        return (String)atomicReference.get();
    }

    public synchronized void setContent(Map<String, Object> map) {
        this.fSetContentResponse.set(false);
        RichDocument.publish(SET_CONTENT_REQUEST_CHANNEL_PREFIX + this.fUniqueKey, map);
        try {
            while (!this.fSetContentResponse.get()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            Log.logException((Exception)interruptedException);
        }
    }

    void dispose() {
        RichDocument.unsubscribe(GET_CONTENT_RESPONSE_CHANNEL_PREFIX + this.fUniqueKey, this.fGetContentSubscriber);
        RichDocument.unsubscribe(SET_CONTENT_RESPONSE_CHANNEL_PREFIX + this.fUniqueKey, this.fSetContentSubscriber);
        this.fDocumentEventSupport.dispose();
        this.fEmbeddedOutputs.dispose();
    }

    public void focus() {
        this.fHtmlCommunication.executeScript("rtcInstance.focus()");
    }

    public void blur() {
        this.fHtmlCommunication.executeScript("rtcInstance.blur()");
    }

    public void undo() {
        this.executeAction("rtc_undo");
    }

    public void redo() {
        this.executeAction("rtc_redo");
    }

    public void indent() {
        this.executeAction("rtc_indent_or_insert_blanks");
    }

    public void unIndent() {
        this.executeAction("rtc_unindent");
    }

    public void smartIndent() {
        this.executeAction("rtc_smart_indent");
    }

    public void comment() {
        this.executeAction("rtc_comment");
    }

    public void uncomment() {
        this.executeAction("rtc_uncomment");
    }

    public void find() {
        this.executeAction("rtc_find_dialog");
    }

    public void findNext() {
        this.executeAction("rtc_find_dialog_find_next_key");
    }

    public void findPrevious() {
        this.executeAction("rtc_find_dialog_find_previous_key");
    }

    public void findSelection() {
        this.executeAction("rtc_find_dialog_find_selection_key");
    }

    public void setBold(boolean bl) {
        if (bl) {
            this.executeAction("rtc_bold_on");
        } else {
            this.executeAction("rtc_bold_off");
        }
    }

    public void setItalics(boolean bl) {
        if (bl) {
            this.executeAction("rtc_italic_on");
        } else {
            this.executeAction("rtc_italic_off");
        }
    }

    public void setUnderline(boolean bl) {
        if (bl) {
            this.executeAction("rtc_underline_on");
        } else {
            this.executeAction("rtc_underline_off");
        }
    }

    public void setMonospace(boolean bl) {
        if (bl) {
            this.executeAction("rtc_monospace_on");
        } else {
            this.executeAction("rtc_monospace_off");
        }
    }

    public void hyperlink() {
        this.executeAction("rtc_hyperlink");
    }

    public void formatParagraphAsCode() {
        this.executeAction("rtc_paraformat_code");
    }

    public void formatParagraphAsText() {
        this.executeAction("rtc_paraformat_text");
    }

    public void formatParagraphAsHeading() {
        this.executeAction("rtc_paraformat_heading");
    }

    public void formatParagraphAsTitle() {
        this.executeAction("rtc_paraformat_title");
    }

    public void formatParagraphAsBulletedList() {
        this.executeAction("rtc_unordered_list");
    }

    public void formatParagraphAsNumberedList() {
        this.executeAction("rtc_ordered_list");
    }

    public void setLive(boolean bl) {
        if (bl) {
            this.fHtmlCommunication.executeScript("rtcInstance._embeddedOutputsPlugin._liveEvalTrigger.enableLive();");
        } else {
            this.fHtmlCommunication.executeScript("rtcInstance._embeddedOutputsPlugin._liveEvalTrigger.disableLive()");
        }
    }

    public void refreshOutputs() {
        this.fHtmlCommunication.executeScript("rtcInstance._embeddedOutputsPlugin._updateOutputs(true)");
    }

    private void executeAction(String string) {
        this.fHtmlCommunication.executeScript("rtcInstance.localActionService.executeAction('" + string + "', {temp: ''})");
    }

    public String getUniqueKey() {
        return this.fUniqueKey;
    }

    public HtmlCallbackProvider getHtmlCommunication() {
        return this.fHtmlCommunication;
    }

    private static void publish(String string, Object object) {
        MessageServiceFactory.getMessageService().publish(string, object);
    }

    private static void subscribe(String string, Subscriber subscriber) {
        MessageServiceFactory.getMessageService().subscribe(string, subscriber);
    }

    private static void unsubscribe(String string, Subscriber subscriber) {
        MessageServiceFactory.getMessageService().unsubscribe(string, subscriber);
    }
}

