/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.editor.codepad.CodepadActionManager;
import com.mathworks.mde.richeditor.RichEditorClient;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTGroupAdapter;
import com.mathworks.widgets.desk.DTGroupBase;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.Desktop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class RichEditorGroup
extends DTGroupBase {
    private static final String GROUP_NAME = "Editor";
    private List<RichEditorClient> fRichEditorClients = new ArrayList<RichEditorClient>();
    private boolean fRegisteredDesktopListener;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mde.richeditor.resources.RES_RichEditor");
    private static final Icon RICH_EDITOR_ICON = PlatformInfo.isWindows() ? ApplicationIcon.EDITOR_32x32.getIcon() : ApplicationIcon.EDITOR_48x48.getIcon();
    private static final Icon SMALL_RICH_EDITOR_ICON = ApplicationIcon.EDITOR.getIcon();
    private static RichEditorGroup sInstance = new RichEditorGroup();

    public static String getGroupName() {
        return GROUP_NAME;
    }

    static String getGroupTitle() {
        return BUNDLE.getString("Group.Title");
    }

    static RichEditorGroup getInstance() {
        return sInstance;
    }

    public RichEditorGroup() {
        this.setIcon(RICH_EDITOR_ICON);
        this.setSmallIcon(SMALL_RICH_EDITOR_ICON);
        this.setGroupName(GROUP_NAME);
        this.setTitle(BUNDLE.getString("Group.Title"));
        this.setNewAction(((MLDesktop)MatlabDesktopServices.getDesktop()).getDefaultNewAction());
    }

    protected void setParentDesktop(Desktop desktop) {
        super.setParentDesktop(desktop);
        if (desktop != null && !this.fRegisteredDesktopListener) {
            this.fRegisteredDesktopListener = true;
            desktop.addGroupListener(GROUP_NAME, RichEditorGroup.createDTGroupListener());
        }
    }

    List<RichEditorClient> getOpenRichEditorClients() {
        return Collections.unmodifiableList(this.fRichEditorClients);
    }

    void doRichEditorClientOpened(RichEditorClient richEditorClient) {
        this.fRichEditorClients.add(richEditorClient);
    }

    void doRichEditorClientClosed(RichEditorClient richEditorClient) {
        this.fRichEditorClients.remove((Object)richEditorClient);
    }

    private static DTGroupListener createDTGroupListener() {
        return new DTGroupAdapter(){

            public void groupActivated(DTGroupEvent dTGroupEvent) {
                CodepadActionManager.groupClosed(MatlabDesktopServices.getDesktop());
            }

            public void groupDeactivated(DTGroupEvent dTGroupEvent) {
                CodepadActionManager.groupOpened(MatlabDesktopServices.getDesktop());
            }
        };
    }
}

