/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.datamodel.BackingStore;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.mde.find.FindFiles;
import com.mathworks.mde.richeditor.ActionID;
import com.mathworks.mde.richeditor.ActionManager;
import com.mathworks.mde.richeditor.DirtyStateSupport;
import com.mathworks.mde.richeditor.RichCodeFileExtensionFilterContributor;
import com.mathworks.mde.richeditor.RichDocumentBackingStore;
import com.mathworks.mde.richeditor.RichEditor;
import com.mathworks.mde.richeditor.RichEditorApplication;
import com.mathworks.mde.richeditor.RichEditorGroup;
import com.mathworks.mde.richeditor.RichEditorToolstripTabFactory;
import com.mathworks.mde.richeditor.widget.rtc.DocumentEvent;
import com.mathworks.mde.richeditor.widget.rtc.DocumentListener;
import com.mathworks.mde.richeditor.widget.rtc.RichDocument;
import com.mathworks.mde.richeditor.widget.rtc.RichTextComponent;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.dialog.filters.MatlabProductFileExtensionFilter;
import com.mathworks.mlwidgets.help.HelpPopup;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.TextComponentUtils;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ThreadUtils;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTRecoverable;
import com.mathworks.widgets.desk.DTUnableToOpenException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Element;

public final class RichEditorClient
extends DTClientBase
implements DTRecoverable {
    private DirtyStateSupport fDirtyStateSupport;
    private ActionManager fActionManager;
    private RichTextComponent fRichTextComponent;
    private RichEditor fRichEditor;
    private RichEditorToolstripTabFactory fToolstripTabFactory;
    private DirtyStateSupport.DirtyStateListener fDirtyListener;
    private DocumentListener fDocumentListener;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mde.richeditor.resources.RES_RichEditor");
    private static final String DT_RESTORE_FILE_NAME = "RichRditorFileName";
    private boolean fCloseNoPrompt;

    public RichEditorClient(SimpleElement simpleElement) throws Exception {
        File file;
        if (!MlxFileUtils.isRichScriptEnabled()) {
            throw new DTUnableToOpenException();
        }
        File file2 = file = simpleElement.getAttribute(DT_RESTORE_FILE_NAME) != null ? new File(simpleElement.getAttribute(DT_RESTORE_FILE_NAME)) : null;
        if (file == null || !file.exists()) {
            String string = file == null ? "" : file.getAbsolutePath();
            String string2 = MessageFormat.format(BUNDLE.getString("FileDoesNotExist.Label"), string);
            throw new DTUnableToOpenException(string2);
        }
        RichDocumentBackingStore richDocumentBackingStore = RichDocumentBackingStore.createWithExistentBackingFile(file);
        this.init((BackingStore<RichDocument>)richDocumentBackingStore);
    }

    RichEditorClient(BackingStore<RichDocument> backingStore) {
        this.init(backingStore);
    }

    public RichEditor getRichEditor() {
        return this.fRichEditor;
    }

    public RichTextComponent getRichTextComponent() {
        return this.fRichTextComponent;
    }

    private void init(BackingStore<RichDocument> backingStore) {
        this.fDirtyStateSupport = new DirtyStateSupport();
        this.fRichTextComponent = new RichTextComponent();
        this.fRichEditor = new RichEditor(backingStore, this.fRichTextComponent.getDocument());
        this.fActionManager = new ActionManager(this.fRichTextComponent.getDocument());
        this.createToolstripTabs();
        this.installKeyBindings();
        this.installListeners(backingStore);
        this.installObservers();
        this.installClientListener();
        this.setAppendsAsteriskWhenDirty(true);
        this.updateShortAndLongTitle();
        this.setMultipleInstances(true);
        this.setGroup((DTGroupPropertyProvider)RichEditorGroup.getInstance());
        this.setLayout(new BorderLayout());
        this.add(this.fRichTextComponent, "Center");
    }

    private void installKeyBindings() {
        this.addKeyBindings("help-on-selection", KeyStroke.getKeyStroke(112, 0), (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        int n = PlatformInfo.isMacintosh() ? 256 : 128;
        this.addKeyBindings("save", KeyStroke.getKeyStroke(83, n), (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.addKeyBindings("open-new", KeyStroke.getKeyStroke(79, n), (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                RichEditorApplication.doOpen((Component)((Object)RichEditorClient.this));
            }
        });
        this.addKeyBindings("print", KeyStroke.getKeyStroke(80, n), (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }

    private void addKeyBindings(Object object, KeyStroke keyStroke, Action action) {
        InputMap inputMap = this.fRichTextComponent.getInputMap(1);
        ActionMap actionMap = this.fRichTextComponent.getActionMap();
        actionMap.put(object, action);
        inputMap.put(keyStroke, object);
    }

    public void closeNoPrompt() {
        this.fCloseNoPrompt = true;
        MatlabDesktopServices.getDesktop().closeClient((Component)((Object)this));
    }

    private void installObservers() {
        this.fActionManager.setObserver(ActionID.OPEN, new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                ActionEvent actionEvent = (ActionEvent)object;
                Frame frame = MJAbstractAction.getFrame((ActionEvent)actionEvent);
                RichEditorApplication.doOpen(frame);
            }
        });
        this.fActionManager.setObserver(ActionID.OPEN_AS_RICH_CODE, new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                ActionEvent actionEvent = (ActionEvent)object;
                Frame frame = MJAbstractAction.getFrame((ActionEvent)actionEvent);
                RichEditorApplication.doImportMATLABCode(frame);
            }
        });
        this.fActionManager.setObserver(ActionID.SAVE, new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                RichEditorClient.this.doSave();
            }
        });
        this.fActionManager.setObserver(ActionID.SAVE_AS, new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                RichEditorClient.this.doSaveAs();
            }
        });
        Observer observer = new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                RichEditorApplication.getInstance().newRichEditor();
            }
        };
        this.fActionManager.setObserver(ActionID.NEW, observer);
        this.fActionManager.setObserver(ActionID.NEW_RICH_SCRIPT, observer);
        this.fActionManager.setObserver(ActionID.FIND_FILES, new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                FindFiles.invoke();
            }
        });
    }

    private static String getMCodeForF1Help(String string, String string2, int n) {
        if (string.length() > 0) {
            return HelpPopup.stripSelection((String)string).trim();
        }
        PlainDocument plainDocument = new PlainDocument();
        try {
            plainDocument.insertString(0, string2, null);
            String string3 = TextComponentUtils.getFunctionAt((Document)plainDocument, (int)n, (boolean)true);
            return string3 == null ? null : string3.trim();
        }
        catch (BadLocationException badLocationException) {
            assert (false) : "Unable to determine the selected text due to: " + badLocationException;
            return null;
        }
    }

    private void installClientListener() {
        MatlabDesktopServices.getDesktop().addClientListener((Component)((Object)this), (DTClientListener)new DTClientAdapter(){

            public void clientOpened(DTClientEvent dTClientEvent) {
                RichEditorGroup.getInstance().doRichEditorClientOpened(RichEditorClient.this);
            }

            public void clientActivated(DTClientEvent dTClientEvent) {
                RichEditorClient.this.fRichTextComponent.requestFocus();
                RichEditorClient.this.fRichTextComponent.getDocument().focus();
            }

            public void clientDeactivated(DTClientEvent dTClientEvent) {
                RichEditorClient.this.fRichTextComponent.getDocument().blur();
            }

            public void clientClosing(DTClientEvent dTClientEvent) {
                if (RichEditorClient.this.fCloseNoPrompt) {
                    RichEditorClient.this.approveClose(dTClientEvent.getData());
                    return;
                }
                if (RichEditorClient.this.fDirtyStateSupport.isDirty()) {
                    int n = Dialogs.showSaveDirtyFile((Component)((Object)RichEditorClient.this), (String)RichEditorClient.this.fRichEditor.getShortName(), (String)BUNDLE.getString("Dialog.Title"));
                    if (n == 0) {
                        RichEditorClient.this.doSave();
                        RichEditorClient.this.approveClose(dTClientEvent.getData());
                    } else if (n == 1) {
                        RichEditorClient.this.approveClose(dTClientEvent.getData());
                    } else {
                        RichEditorClient.this.vetoClose(dTClientEvent.getData());
                    }
                }
            }

            public void clientClosed(DTClientEvent dTClientEvent) {
                RichEditorGroup.getInstance().doRichEditorClientClosed(RichEditorClient.this);
                RichEditorClient.this.dispose();
            }
        });
    }

    StorageLocation getStorageLocation() {
        return this.fRichEditor.getStorageLocation();
    }

    private void installListeners(final BackingStore<RichDocument> backingStore) {
        this.fDocumentListener = new DocumentListener(){

            @Override
            public void eventFired(DocumentEvent documentEvent) {
                if (documentEvent.getType().equals((Object)DocumentEvent.EventType.INITIALIZED)) {
                    RichEditorClient.this.doDocumentInitialized((BackingStore<RichDocument>)backingStore);
                } else if (documentEvent.getType().equals((Object)DocumentEvent.EventType.UPDATED)) {
                    RichEditorClient.this.doDocumentUpdated();
                } else if (documentEvent.getType().equals((Object)DocumentEvent.EventType.SAVE)) {
                    RichEditorClient.this.doSave();
                } else if (documentEvent.getType().equals((Object)DocumentEvent.EventType.HELP_ON_SELECTION)) {
                    RichEditorClient.this.doHelpCalled((HashMap)documentEvent.getData());
                }
            }
        };
        this.fRichTextComponent.getDocument().addDocumentListener(this.fDocumentListener);
        this.fDirtyListener = new DirtyStateSupport.DirtyStateListener(){

            @Override
            public void handleDirtyStateChanged(boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RichEditorClient.this.updateShortAndLongTitle();
                    }
                });
            }
        };
        this.fDirtyStateSupport.addDirtyListener(this.fDirtyListener);
    }

    private void doDocumentUpdated() {
        this.fDirtyStateSupport.setDirty(true);
    }

    private void doDocumentInitialized(BackingStore<RichDocument> backingStore) {
        if (backingStore.getStorageLocation() instanceof FileStorageLocation && ((FileStorageLocation)backingStore.getStorageLocation()).getFile().exists()) {
            ThreadUtils.newSingleDaemonThreadExecutor((String)"richeditor").submit(new Runnable(){

                @Override
                public void run() {
                    RichEditorClient.this.load();
                }
            });
        }
    }

    private void doHelpCalled(Map<String, Object> map) {
        Dimension dimension = new Dimension(520, 380);
        int n = ((Double)map.get("caretX")).intValue();
        int n2 = ((Double)map.get("caretY")).intValue();
        int n3 = n + (int)this.fRichTextComponent.getLocationOnScreen().getX();
        int n4 = n2 + (int)this.fRichTextComponent.getLocationOnScreen().getY();
        Point point = new Point(n3, n4);
        int n5 = ((Double)map.get("lineHeight")).intValue();
        final Rectangle rectangle = WindowUtils.computeTextPopupBounds((Dimension)dimension, (Dimension)dimension, (Point)point, (int)n5, (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED);
        final KeyStrokeList keyStrokeList = new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(112, 0)});
        String string = (String)map.get("currentLineCode");
        String string2 = (String)map.get("selectedText");
        int n6 = ((Double)map.get("endCaretPosition")).intValue();
        final String string3 = RichEditorClient.getMCodeForF1Help(string2, string, n6);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpPopup.showHelp((JComponent)((Object)RichEditorClient.this), (KeyStrokeList)keyStrokeList, (Rectangle)rectangle, (String)string3);
            }
        });
    }

    private void dispose() {
        this.fToolstripTabFactory.disposeTabs();
        this.fRichTextComponent.getDocument().removeDocumentListener(this.fDocumentListener);
        this.fDirtyStateSupport.removeDirtyListener(this.fDirtyListener);
        this.fActionManager.dispose();
        ExecutorService executorService = ThreadUtils.newSingleDaemonThreadExecutor((String)"richeditor");
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                RichEditorClient.this.fRichTextComponent.dispose();
            }
        });
    }

    private void doSaveAs() {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = this.createSaveAsDialog(this.fRichEditor);
        if (mJFileChooserPerPlatform.getState() == 0) {
            File file = mJFileChooserPerPlatform.getSelectedFile();
            if (MlxFileUtils.isMlxExtensionFile((String)file.getAbsolutePath())) {
                this.fRichEditor.setFile(file);
                this.save();
                try {
                    MatlabDesktopServices.getDesktop().getRecentFiles().addFile(RichEditorGroup.getGroupName(), file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    assert (false) : "Unable to update the recent file due to: " + iOException;
                }
            } else if (MLFileUtils.isMFile((String)file.getAbsolutePath())) {
                RichEditorApplication.exportToM(this.fRichTextComponent.getDocument(), file);
            } else {
                MJOptionPane.showMessageDialog((Component)((Object)this), (Object)BUNDLE.getString("SaveAs.InvalidFileExtension"), (String)BUNDLE.getString("Dialog.Title"), (int)0);
            }
        }
    }

    private void doSave() {
        File file = this.fRichEditor.getFile();
        if (file == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doSaveAs();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            RichEditorClient.this.doSaveAs();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    assert (false) : "Save As failed due to :" + exception;
                }
            }
        } else {
            this.save();
        }
    }

    private MJFileChooserPerPlatform createSaveAsDialog(RichEditor richEditor) {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
        mJFileChooserPerPlatform.setCurrentDirectory(RichEditorClient.getActiveDirectory(richEditor));
        mJFileChooserPerPlatform.setSelectedFile(new File(richEditor.getShortName()));
        ArrayList<FileExtensionFilter> arrayList = new ArrayList<FileExtensionFilter>(new RichCodeFileExtensionFilterContributor().getDialogFilters());
        arrayList.add(MatlabProductFileExtensionFilter.getMFileFilter());
        mJFileChooserPerPlatform.setMultiSelectionEnabled(false);
        mJFileChooserPerPlatform.addChoosableFileFilters(arrayList);
        mJFileChooserPerPlatform.setAcceptAllFileFilterUsed(false);
        mJFileChooserPerPlatform.setDialogTitle(BUNDLE.getString("SaveAs.DialogTitle"));
        mJFileChooserPerPlatform.showSaveDialog((Component)((Object)this));
        return mJFileChooserPerPlatform;
    }

    private void createToolstripTabs() {
        this.fToolstripTabFactory = new RichEditorToolstripTabFactory();
        List<ToolstripTab> list = this.fToolstripTabFactory.createTabs(this.fActionManager, this.fDirtyStateSupport);
        this.setToolstripTabs(list.toArray(new ToolstripTab[list.size()]));
    }

    String getClientTitle() {
        return this.fRichEditor.getShortName();
    }

    private void save() {
        try {
            this.fRichEditor.save();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return;
        }
        this.fDirtyStateSupport.setDirty(false);
        this.updateShortAndLongTitle();
    }

    private void load() {
        try {
            this.fRichEditor.load();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return;
        }
    }

    void setDirty(boolean bl) {
        this.fDirtyStateSupport.setDirty(bl);
    }

    private void updateShortAndLongTitle() {
        this.updateLongTitle();
        this.updateShortTitle();
    }

    String getShortTitle() {
        String string = this.fRichEditor.getShortName();
        return this.fDirtyStateSupport.isDirty() ? RichEditorClient.createDirtyTitle(string) : string;
    }

    String getLongTitle() {
        String string = this.fRichEditor.getBackingStore().isPersistenceLocationSet() && this.fRichEditor.getBackingStore().isReadOnly() ? RichEditorClient.createReadOnlyTitle(this.fRichEditor.getLongName()) : this.fRichEditor.getLongName();
        return this.fDirtyStateSupport.isDirty() ? RichEditorClient.createDirtyTitle(string) : string;
    }

    private void updateLongTitle() {
        this.setTitle(this.getLongTitle());
    }

    private void updateShortTitle() {
        this.setShortTitle(this.getShortTitle());
    }

    private static String createDirtyTitle(String string) {
        return MessageFormat.format(BUNDLE.getString("Title.Dirty"), string);
    }

    private static String createReadOnlyTitle(String string) {
        return MessageFormat.format(BUNDLE.getString("Title.ReadOnly"), string);
    }

    public void saveState(org.w3c.dom.Document document, Element element) {
        if (this.fRichEditor.getStorageLocation() instanceof FileStorageLocation) {
            element.setAttribute(DT_RESTORE_FILE_NAME, ((FileStorageLocation)this.fRichEditor.getStorageLocation()).getFile().getPath());
        }
    }

    public void restoreState(SimpleElement simpleElement) {
    }

    private static File getActiveDirectory(RichEditor richEditor) {
        File file;
        StorageLocation storageLocation = richEditor.getStorageLocation();
        if (storageLocation != null && storageLocation instanceof FileStorageLocation && (file = ((FileStorageLocation)storageLocation).getFile().getParentFile()) != null) {
            return file;
        }
        return new File(FactoryUtils.getDirectorySeed());
    }
}

