/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.profiler;

import com.mathworks.html.HtmlComponent;
import com.mathworks.mde.profiler.HTMLRendererBrowser;
import com.mathworks.mde.profiler.MJHtmlPanelBrowser;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mwswing.MJToolBar;

abstract class ProfilerBrowser<T extends HtmlComponent> {
    private final T fHtmlComponent;
    private final MJToolBar fToolBar;

    ProfilerBrowser(T t, MJToolBar mJToolBar) {
        this.fHtmlComponent = t;
        this.fToolBar = mJToolBar;
    }

    static ProfilerBrowser<? extends HtmlComponent> buildBrowser() {
        ProfilerBrowserBuilder profilerBrowserBuilder = new ProfilerBrowserBuilder();
        HtmlComponent htmlComponent = HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.HTMLRENDERER});
        HtmlConversionUtils.visitBrowser((HtmlComponent)htmlComponent, (HtmlConversionUtils.BrowserVisitor)profilerBrowserBuilder);
        return profilerBrowserBuilder.getBrowserWrapper();
    }

    protected T getHtmlComponent() {
        return this.fHtmlComponent;
    }

    protected MJToolBar getToolBar() {
        return this.fToolBar;
    }

    protected abstract void setHomeUrl(String var1);

    protected abstract void setWaitCursor(boolean var1);

    protected abstract void clearHistory();

    private static class ProfilerBrowserBuilder
    implements HtmlConversionUtils.BrowserVisitor {
        private ProfilerBrowser<? extends HtmlComponent> iWrapper;

        private ProfilerBrowserBuilder() {
        }

        public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            this.iWrapper = new MJHtmlPanelBrowser(mJHtmlPanel);
        }

        public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
            this.iWrapper = HTMLRendererBrowser.build();
        }

        private ProfilerBrowser<? extends HtmlComponent> getBrowserWrapper() {
            return this.iWrapper;
        }
    }
}

