/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.view;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.mathworks.mde.licensing.borrowing.comparator.MatlabeticalComparator;
import com.mathworks.mde.licensing.borrowing.controller.BorrowController;
import com.mathworks.mde.licensing.borrowing.model.Feature;
import com.mathworks.mde.licensing.borrowing.view.CenterRenderer;
import com.mathworks.mde.licensing.borrowing.view.FeatureColViewUtil;
import com.mathworks.mde.licensing.borrowing.view.ScrollPaneComponentAdapter;
import com.mathworks.mde.licensing.borrowing.view.StatusTableFormat;
import com.mathworks.mde.licensing.borrowing.view.StatusView;
import com.mathworks.mde.licensing.borrowing.view.SubPanelView;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.table.ListColorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class StatusViewImpl
implements StatusView,
SubPanelView {
    public static final String REFRESH_BUTTON_NAME = "RefreshButton";
    public static final String FEATURESTATUS_PANEL_NAME = "FeatureStatusPanel";
    public static final String STATUS_TABLE_NAME = "RefreshTable";
    public static final String TABLE_SCROLLPANE_NAME = "TableScrollPane";
    private EventList<Feature> featureEventList;
    private BorrowController fController;
    JPanel statusPanel;
    private MJTable statusTable;
    private StatusTableFormat statusFormat;
    private EventTableModel fFeatureTableModelSorted;
    private final ResourceBundle fResBundle;
    private MatlabeticalComparator featureComparator;
    private SortedList<Feature> sortedFeatures;
    private TableComparatorChooser tableSorter;
    private static final int NUM_ROWS_TO_DISPLAY = 15;
    private final ActionListener fButtonListener;

    public StatusViewImpl(BorrowController borrowController, ResourceBundle resourceBundle) {
        this.fController = borrowController;
        this.fResBundle = resourceBundle;
        this.fButtonListener = new ButtonActionListener();
        this.createComponents();
    }

    private void createComponents() {
        this.featureEventList = new BasicEventList();
        this.statusTable = new MJTable();
        this.statusTable.setName(STATUS_TABLE_NAME);
        this.statusFormat = new StatusTableFormat(this.fResBundle);
        this.featureComparator = new MatlabeticalComparator();
    }

    @Override
    public JPanel createSubPanelView() {
        return this.buildSubPanel();
    }

    @Override
    public void refreshData() {
        if (this.tableSorter != null) {
            this.tableSorter.clearComparator();
            this.tableSorter.dispose();
        }
        this.sortedFeatures.clear();
        this.sortedFeatures.setComparator((Comparator)this.featureComparator);
        Collection<Feature> collection = this.fController.getFlexFeatures();
        this.sortedFeatures.addAll(collection);
        this.statusTable.setModel((TableModel)this.fFeatureTableModelSorted);
        this.statusTable.getTableHeader().resizeAndRepaint();
        this.tableSorter = TableComparatorChooser.install((JTable)this.statusTable, this.sortedFeatures, (Object)AbstractTableComparatorChooser.SINGLE_COLUMN);
    }

    private JPanel buildSubPanel() {
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0), new ColumnSpec((Size)Sizes.dluX((int)4)), new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 0.0)};
        RowSpec[] rowSpecArray = new RowSpec[]{new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)10)), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)5)), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0)};
        FormLayout formLayout = new FormLayout(columnSpecArray, rowSpecArray);
        this.statusPanel = new JPanel((LayoutManager)formLayout);
        this.statusPanel.setName(FEATURESTATUS_PANEL_NAME);
        CellConstraints cellConstraints = new CellConstraints();
        this.statusPanel.add((Component)new JSeparator(), cellConstraints.xyw(1, 1, 3));
        this.statusPanel.add((Component)this.getTableScrollPane(), cellConstraints.xyw(1, 3, 3));
        this.statusPanel.add((Component)this.createButtonPanel(), cellConstraints.xy(3, 5));
        return this.statusPanel;
    }

    private void createFeatureTableList() {
        Collection<Feature> collection = this.fController.getFlexFeatures();
        this.featureEventList.clear();
        this.featureEventList.addAll(collection);
        if (this.sortedFeatures == null) {
            this.sortedFeatures = new SortedList(this.featureEventList, (Comparator)this.featureComparator);
        }
        if (this.fFeatureTableModelSorted == null) {
            this.fFeatureTableModelSorted = new EventTableModel(this.sortedFeatures, (TableFormat)this.statusFormat);
        }
        this.statusTable.setModel((TableModel)this.fFeatureTableModelSorted);
        this.statusTable.getTableHeader().resizeAndRepaint();
        this.tableSorter = TableComparatorChooser.install((JTable)this.statusTable, this.sortedFeatures, (Object)AbstractTableComparatorChooser.SINGLE_COLUMN);
    }

    private JComponent getTableScrollPane() {
        this.createFeatureTableList();
        this.statusTable.getTableHeader().setReorderingAllowed(false);
        FeatureColViewUtil.sizeTableColumnsToContents((JTable)this.statusTable);
        TableColumnModel tableColumnModel = this.statusTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setMaxWidth(tableColumn.getMinWidth());
        tableColumn.setCellRenderer(new CenterRenderer());
        ListColorUtils.setupForList((JTable)this.statusTable);
        JScrollPane jScrollPane = new JScrollPane((Component)this.statusTable);
        jScrollPane.setName(TABLE_SCROLLPANE_NAME);
        int n = 15 * this.statusTable.getRowHeight();
        this.statusTable.setPreferredScrollableViewportSize(new Dimension(0, n));
        jScrollPane.setWheelScrollingEnabled(true);
        this.statusTable.getParent().setBackground(this.statusTable.getBackground());
        jScrollPane.addComponentListener(new ScrollPaneComponentAdapter(this.statusTable));
        return jScrollPane;
    }

    private JPanel createButtonPanel() {
        MJButton mJButton = new MJButton(this.fResBundle.getString("button.refresh"));
        mJButton.setName(REFRESH_BUTTON_NAME);
        mJButton.setMnemonic(70);
        mJButton.addActionListener(this.fButtonListener);
        JPanel jPanel = ButtonBarFactory.buildRightAlignedBar((JButton)mJButton);
        return jPanel;
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatusViewImpl.this.fController.refreshStatus();
        }
    }
}

