/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.HelpBrowserSearchResult;
import com.mathworks.mde.help.search.HelpPageDisplayHandler;
import com.mathworks.mde.help.search.ResultsGroup;
import com.mathworks.mde.help.search.SearchResultsGroupDisplay;
import com.mathworks.mde.help.search.SearchResultsList;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.border.DashedBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SingleGroupDisplay {
    private MJPanel fPanel = new MJPanel((LayoutManager)new BorderLayout());
    private SearchResultsList fList;
    private boolean fExpanded = true;
    private GroupHeader fHeader;
    private JViewport fViewport;
    private SearchResultsGroupDisplay fGroupDisplay;

    SingleGroupDisplay(SearchCriteria searchCriteria, ResultsGroup resultsGroup, HelpPageDisplayHandler helpPageDisplayHandler, SearchResultsGroupDisplay searchResultsGroupDisplay) {
        this.fGroupDisplay = searchResultsGroupDisplay;
        this.fHeader = new GroupHeader(resultsGroup);
        this.fList = new SearchResultsList(searchCriteria, resultsGroup, helpPageDisplayHandler);
        this.fList.setName("SearchResultsGroupList_" + resultsGroup.getName());
        this.fList.setFocusable(false);
        this.fList.setFocusComponent(searchResultsGroupDisplay.getComponent());
        this.fViewport = new JViewport();
        this.fViewport.add((Component)((Object)this.fList));
        this.fViewport.setViewSize(this.fList.getPreferredSize());
        this.fPanel.add((Component)((Object)this.fHeader), (Object)"North");
        this.fPanel.add((Component)this.fViewport, (Object)"Center");
        this.fList.setVisibleRowCount(resultsGroup.getSize());
        int n = this.fHeader.getPreferredSize().height + this.fList.getPreferredSize().height;
        this.fPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, n));
        this.addListeners();
    }

    private void addListeners() {
        this.addKeyListeners();
        this.fList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getFirstIndex() > -1) {
                    SingleGroupDisplay.this.fHeader.setSelected(false);
                    SingleGroupDisplay.this.fGroupDisplay.setSelectedGroup(SingleGroupDisplay.this);
                    SingleGroupDisplay.this.fGroupDisplay.scrollToSelectedResult();
                }
            }
        });
    }

    private void addKeyListeners() {
        this.fList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                assert (SingleGroupDisplay.this.fList.getSelectedResult() != null && SingleGroupDisplay.this.isExpanded()) : "We should only dispatch key events to group lists when they are selected and expanded";
                if (keyEvent.getKeyCode() == 40 && SingleGroupDisplay.this.fList.getSelectedIndex() == SingleGroupDisplay.this.getNumResults() - 1) {
                    SingleGroupDisplay.this.fGroupDisplay.jumpToNextGroup();
                } else if (keyEvent.getKeyCode() == 38 && SingleGroupDisplay.this.fList.getSelectedIndex() == 0) {
                    SingleGroupDisplay.this.fList.clearSelection();
                    SingleGroupDisplay.this.selectHeader();
                } else if (keyEvent.getKeyCode() == 37) {
                    SingleGroupDisplay.this.collapse();
                    SingleGroupDisplay.this.selectHeader();
                }
            }
        });
        this.fHeader.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                assert (SingleGroupDisplay.this.fHeader.isSelected()) : "We should only dispatch key events to group headers when they are selected";
                if (keyEvent.getKeyCode() == 37) {
                    SingleGroupDisplay.this.collapse();
                } else if (keyEvent.getKeyCode() == 39) {
                    SingleGroupDisplay.this.expand(true);
                } else if (keyEvent.getKeyCode() == 40) {
                    if (SingleGroupDisplay.this.isExpanded()) {
                        SingleGroupDisplay.this.selectResult(0);
                    } else {
                        SingleGroupDisplay.this.fGroupDisplay.jumpToNextGroup();
                    }
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 38) {
                    SingleGroupDisplay.this.fGroupDisplay.jumpToPreviousGroup();
                    keyEvent.consume();
                }
            }
        });
    }

    void handleKeyEvent(KeyEvent keyEvent) {
        if (this.fList.getSelectedResult() != null && this.isExpanded()) {
            keyEvent.setSource((Object)this.fList);
            this.fList.dispatchEvent(keyEvent);
        } else if (this.fHeader.isSelected()) {
            keyEvent.setSource((Object)this.fHeader);
            this.fHeader.dispatchEvent(keyEvent);
        }
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    public HelpBrowserSearchResult getSelectedResult() {
        return this.fList.getSelectedResult();
    }

    void selectHeader() {
        this.fHeader.setSelected(true);
        this.fGroupDisplay.setSelectedGroup(this);
    }

    public void selectResult(int n) {
        this.fList.selectResult(n);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.fList.addListSelectionListener(listSelectionListener);
    }

    public void clearSelection() {
        this.fHeader.setSelected(false);
        this.fList.clearSelection();
    }

    public HelpBrowserSearchResult getSelectedValue() {
        return (HelpBrowserSearchResult)this.fList.getSelectedValue();
    }

    public int getNumResults() {
        return this.fList.getModel().getSize();
    }

    public void setSelectedIndex(int n) {
        this.fList.setSelectedIndex(n);
    }

    void setForeground(Color color) {
        this.fPanel.setForeground(color);
        this.fList.setForeground(color);
    }

    void setBackground(Color color) {
        this.fPanel.setBackground(color);
        this.fList.setBackground(color);
    }

    void setFont(Font font) {
        this.fPanel.setFont(font);
        this.fList.setFont(font);
    }

    void collapse() {
        if (this.fExpanded) {
            this.fHeader.setExpansionIcon(UIManager.getIcon("Tree.collapsedIcon"));
            this.fPanel.remove((Component)this.fViewport);
            this.fPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.fHeader.getPreferredSize().height));
            this.fPanel.revalidate();
            this.fPanel.repaint();
            this.fExpanded = false;
        }
    }

    void expand(boolean bl) {
        if (!this.fExpanded) {
            this.fHeader.setExpansionIcon(UIManager.getIcon("Tree.expandedIcon"));
            this.fPanel.add((Component)this.fViewport);
            this.fPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.fHeader.getPreferredSize().height + this.fList.getPreferredSize().height));
            if (bl) {
                this.fHeader.setSelected(this.fList.getSelectedResult() == null);
                this.fGroupDisplay.setSelectedGroup(this);
            }
            this.fPanel.revalidate();
            this.fPanel.repaint();
            if (this.fList.getSelectedResult() == null) {
                this.fGroupDisplay.scrollToGroup(this);
            } else {
                this.fGroupDisplay.scrollToSelectedResult();
            }
            this.fExpanded = true;
        }
    }

    boolean isExpanded() {
        return this.fExpanded;
    }

    void addGlobalMouseListener(MouseListener mouseListener) {
        this.fHeader.addMouseListener(mouseListener);
        this.fList.addMouseListener(mouseListener);
    }

    int getPreferredHeight() {
        return this.fPanel.getPreferredSize().height;
    }

    Rectangle getSelectedResultRectangle() {
        int n = this.fList.getSelectedIndex();
        if (this.fList.getSelectedIndex() > -1) {
            int n2 = this.fHeader.getPreferredSize().height;
            Rectangle rectangle = this.fList.getCellBounds(n, n);
            rectangle.y += n2;
            return rectangle;
        }
        return null;
    }

    Rectangle getHeaderRectangle() {
        return this.fHeader.getBounds();
    }

    private void toggleExpansion() {
        if (this.fExpanded) {
            this.collapse();
        } else {
            this.expand(true);
        }
    }

    void handleFocusGained() {
        this.fHeader.handleBorder();
    }

    void handleFocusLost() {
        this.fHeader.handleBorder();
    }

    public String toString() {
        return "Search result group: " + this.fHeader.getName();
    }

    private class GroupHeaderMouseListener
    extends MouseAdapter {
        private boolean iPopupTrigger;

        private GroupHeaderMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.iPopupTrigger = mouseEvent.isPopupTrigger();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.iPopupTrigger && !mouseEvent.isPopupTrigger()) {
                SingleGroupDisplay.this.toggleExpansion();
                if (!SingleGroupDisplay.this.isExpanded() && SingleGroupDisplay.this.equals(SingleGroupDisplay.this.fGroupDisplay.getSelectedGroup())) {
                    SingleGroupDisplay.this.fHeader.setSelected(true);
                }
            }
            this.iPopupTrigger = false;
        }
    }

    private class GroupHeader
    extends MJPanel {
        private MJLabel iExpansionIcon;
        private MJLabel iGroupLabel;
        private boolean iSelected = false;

        private GroupHeader(ResultsGroup resultsGroup) {
            this.setName("SearchResultsGroupHeader_" + resultsGroup.getName());
            this.doLayout(resultsGroup);
            this.addMouseListener(new GroupHeaderMouseListener());
            this.setFocusable(false);
        }

        private void doLayout(ResultsGroup resultsGroup) {
            this.setLayout(new BoxLayout((Container)((Object)this), 0));
            this.iGroupLabel = new MJLabel(resultsGroup.getName(), resultsGroup.getIcon(), 2);
            this.iGroupLabel.setFont(this.getFont().deriveFont(1));
            this.add(Box.createHorizontalStrut(3));
            this.iExpansionIcon = new MJLabel(UIManager.getIcon("Tree.expandedIcon"));
            this.iExpansionIcon.setOpaque(false);
            this.add((Component)this.iExpansionIcon);
            this.add(Box.createHorizontalStrut(3));
            this.add((Component)this.iGroupLabel);
            this.add(Box.createHorizontalGlue());
            this.setBorder(BorderFactory.createEmptyBorder(5, 1, 5, 1));
            int n = Math.max(16, this.getFontMetrics(this.getFont()).getHeight());
            Dimension dimension = new Dimension(Integer.MAX_VALUE, n + 10);
            this.setMaximumSize(dimension);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(this.getGroupHeaderGradient(rectangle));
            graphics2D.fill(rectangle);
        }

        private void setExpansionIcon(Icon icon) {
            this.iExpansionIcon.setIcon(icon);
        }

        private void setSelected(boolean bl) {
            this.iSelected = bl;
            this.handleBorder();
            if (bl) {
                SingleGroupDisplay.this.fGroupDisplay.scrollToGroupHeader(SingleGroupDisplay.this);
            }
        }

        private void handleBorder() {
            if (this.isSelected() && SingleGroupDisplay.this.fGroupDisplay.getComponent().hasFocus()) {
                SingleGroupDisplay.this.fHeader.setBorder(new CompoundBorder((Border)new DashedBorder(Color.BLACK, Color.WHITE), BorderFactory.createEmptyBorder(4, 0, 4, 0)));
            } else {
                SingleGroupDisplay.this.fHeader.setBorder(BorderFactory.createEmptyBorder(5, 1, 5, 1));
            }
        }

        private boolean isSelected() {
            return this.iSelected;
        }

        public void setFont(Font font) {
            super.setFont(font);
            if (this.iGroupLabel != null) {
                this.iGroupLabel.setFont(font.deriveFont(1));
            }
        }

        private GradientPaint getGroupHeaderGradient(Rectangle rectangle) {
            Color color;
            Color color2 = color = UIManager.getColor("control");
            Color color3 = color;
            if (!MJUtilities.isHighContrast()) {
                color2 = Color.WHITE;
                color3 = ColorUtils.convertToCurrentColorScheme((Color)new Color(242, 241, 246), (Color)color);
            }
            return new GradientPaint(new Point2D.Double(rectangle.getX(), rectangle.getY()), color2, new Point2D.Double(rectangle.getX(), rectangle.getY() + rectangle.getHeight()), color3);
        }
    }
}

