/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.HelpBrowserSearchResult;
import com.mathworks.mde.help.search.HelpPageDisplayHandler;
import com.mathworks.mde.help.search.SearchResultCell;
import com.mathworks.mde.help.search.SearchResultCellColors;
import com.mathworks.mde.help.search.SearchResultListCellRenderer;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mwswing.MJList;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchKeywordsVisitor;
import com.mathworks.search.SearchVisitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.ListModel;

class SearchResultsList
extends MJList {
    private HelpPageDisplayHandler fDisplayHandler;
    private String[] fKeywords;
    private Component fFocusComponent;

    SearchResultsList(SearchCriteria searchCriteria, ListModel listModel, HelpPageDisplayHandler helpPageDisplayHandler) {
        super(listModel);
        SearchResultListCellRenderer searchResultListCellRenderer = new SearchResultListCellRenderer(searchCriteria);
        this.setCellRenderer(searchResultListCellRenderer);
        this.setFixedCellWidth(1);
        this.setFixedCellHeight(this.getCellHeight());
        this.fKeywords = SearchResultsList.getSearchKeywords(searchCriteria);
        this.fDisplayHandler = helpPageDisplayHandler;
        this.addMouseListener(new ResultsListMouseListener());
        this.addKeyListener(new ResultsListKeyListener());
    }

    void setFocusComponent(Component component) {
        this.fFocusComponent = component;
    }

    boolean listHasFocus() {
        return this.hasFocus() || this.fFocusComponent != null && this.fFocusComponent.hasFocus();
    }

    private void sendSelectedResultToBrowser() {
        HelpBrowserSearchResult helpBrowserSearchResult = this.getSelectedResult();
        if (helpBrowserSearchResult != null) {
            helpBrowserSearchResult.displayResult(this.fKeywords, this.fDisplayHandler);
        }
    }

    public int getCellHeight() {
        int n = this.getFontMetrics(this.getFont()).getHeight();
        return SearchResultCell.getCellHeight(n);
    }

    private static String[] getSearchKeywords(SearchCriteria searchCriteria) {
        SearchKeywordsVisitor searchKeywordsVisitor = new SearchKeywordsVisitor();
        try {
            searchCriteria.getExpression().accept((SearchVisitor)searchKeywordsVisitor);
            Collection collection = searchKeywordsVisitor.getSearchKeywords();
            return searchKeywordsVisitor.getSearchKeywords().toArray(new String[collection.size()]);
        }
        catch (SearchException searchException) {
            return null;
        }
    }

    public HelpBrowserSearchResult getSelectedResult() {
        return (HelpBrowserSearchResult)this.getSelectedValue();
    }

    public void selectResult(int n) {
        this.setSelectedIndex(n);
        this.sendSelectedResultToBrowser();
    }

    public int getNumResults() {
        return this.getModel().getSize();
    }

    public void setForeground(Color color) {
        SearchResultCellColors.calculateColors(color, this.getBackground());
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        SearchResultCellColors.calculateColors(this.getForeground(), color);
        super.setBackground(color);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFixedCellHeight(this.getCellHeight());
    }

    protected void paintComponent(Graphics graphics) {
        this.setFixedCellHeight(this.getCellHeight());
        super.paintComponent(graphics);
    }

    private class ResultsListKeyListener
    extends KeyAdapter {
        private int fWaitingForKeyRelease;

        private ResultsListKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.fWaitingForKeyRelease = keyEvent.getKeyCode();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == this.fWaitingForKeyRelease && (n == 38 || n == 40 || n == 37 || n == 39 || n == 34 || n == 33 || n == 10 || n == 36 || n == 35)) {
                SearchResultsList.this.sendSelectedResultToBrowser();
            }
        }
    }

    private class ResultsListMouseListener
    extends MouseAdapter {
        private ResultsListMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                SearchResultsList.this.sendSelectedResultToBrowser();
            }
        }
    }
}

