/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.HelpBrowserSearchResult;
import com.mathworks.mde.help.search.HelpPageDisplayHandler;
import com.mathworks.mde.help.search.ResultsGroup;
import com.mathworks.mde.help.search.ResultsGrouper;
import com.mathworks.mde.help.search.SearchIconUtils;
import com.mathworks.mde.help.search.SearchResultsContainer;
import com.mathworks.mde.help.search.SearchResultsDisplay;
import com.mathworks.mde.help.search.SearchResultsGroupDisplay;
import com.mathworks.mde.help.search.SearchResultsListDisplay;
import com.mathworks.mlwidgets.help.ClassicHelpDataAccessor;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.ResultType;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public enum SearchPanelHeaderColumn {
    TYPE(HelpUtils.getLocalizedString((String)"searchfilelist.type"), (ResultsGrouper)new TypeGrouper(), false),
    RELEVANCE(HelpUtils.getLocalizedString((String)"searchfilelist.relevance"), null, true),
    PRODUCT(HelpUtils.getLocalizedString((String)"searchfilelist.product"), (ResultsGrouper)new ProductGrouper(), false);

    private String fText;
    private Icon fIcon;
    private ResultsGrouper fGrouper;
    private boolean fDescendingByDefault;

    private SearchPanelHeaderColumn(String string2, ResultsGrouper resultsGrouper, boolean bl) {
        this.fText = string2;
        this.fGrouper = resultsGrouper;
        this.fDescendingByDefault = bl;
    }

    private SearchPanelHeaderColumn(Icon icon, ResultsGrouper resultsGrouper, boolean bl) {
        this.fIcon = icon;
        this.fGrouper = resultsGrouper;
        this.fDescendingByDefault = bl;
    }

    String getText() {
        return this.fText;
    }

    Icon getIcon() {
        return this.fIcon;
    }

    SearchResultsDisplay getDisplayForColumn(SearchCriteria searchCriteria, SearchResultsContainer searchResultsContainer, HelpPageDisplayHandler helpPageDisplayHandler) {
        if (this.fGrouper == null) {
            searchResultsContainer.sort(this.getComparator(), false);
            return new SearchResultsListDisplay(searchCriteria, searchResultsContainer, helpPageDisplayHandler);
        }
        searchResultsContainer.sortAndGroup(this.getComparator(), false, this.fGrouper);
        return new SearchResultsGroupDisplay(searchCriteria, searchResultsContainer, helpPageDisplayHandler);
    }

    boolean isDescendingByDefault() {
        return this.fDescendingByDefault;
    }

    boolean isReversed(boolean bl) {
        return bl != this.fDescendingByDefault;
    }

    public ResultsGrouper getGrouper() {
        return this.fGrouper;
    }

    public Comparator<HelpBrowserSearchResult> getComparator() {
        switch (this) {
            case PRODUCT: {
                return new MatlabeticalProductComparator();
            }
            case TYPE: {
                return new Comparator<HelpBrowserSearchResult>(){

                    @Override
                    public int compare(HelpBrowserSearchResult helpBrowserSearchResult, HelpBrowserSearchResult helpBrowserSearchResult2) {
                        return helpBrowserSearchResult.getType().compareTo((Enum)helpBrowserSearchResult2.getType());
                    }
                };
            }
            case RELEVANCE: {
                return null;
            }
        }
        return null;
    }

    private static class ProductGrouper
    implements ResultsGrouper {
        private ProductGrouper() {
        }

        @Override
        public ResultsGroup createNewGroup(SearchResultsContainer searchResultsContainer, HelpBrowserSearchResult helpBrowserSearchResult) {
            return new ResultsGroup(searchResultsContainer, helpBrowserSearchResult.getProductName(), null);
        }

        @Override
        public boolean isInGroup(ResultsGroup resultsGroup, HelpBrowserSearchResult helpBrowserSearchResult) {
            return resultsGroup.getName().equals(helpBrowserSearchResult.getProductName());
        }
    }

    private static class TypeGrouper
    implements ResultsGrouper {
        private TypeGrouper() {
        }

        @Override
        public ResultsGroup createNewGroup(SearchResultsContainer searchResultsContainer, HelpBrowserSearchResult helpBrowserSearchResult) {
            ResultType resultType = helpBrowserSearchResult.getType();
            return new ResultsGroup(searchResultsContainer, resultType.getDisplayName(), SearchIconUtils.getIconForResultType(resultType));
        }

        @Override
        public boolean isInGroup(ResultsGroup resultsGroup, HelpBrowserSearchResult helpBrowserSearchResult) {
            return resultsGroup.getName().equals(helpBrowserSearchResult.getType().getDisplayName());
        }
    }

    private static class MatlabeticalProductComparator
    implements Comparator<HelpBrowserSearchResult> {
        private Map<String, Integer> iProductsInMatlabeticalOrder = new HashMap<String, Integer>();

        private MatlabeticalProductComparator() {
            HelpInfoItem[] helpInfoItemArray = ClassicHelpDataAccessor.getInstalledProductHelpInfo();
            for (int i = 0; i < helpInfoItemArray.length; ++i) {
                this.iProductsInMatlabeticalOrder.put(helpInfoItemArray[i].getProductName(), i);
            }
        }

        @Override
        public int compare(HelpBrowserSearchResult helpBrowserSearchResult, HelpBrowserSearchResult helpBrowserSearchResult2) {
            String string = helpBrowserSearchResult.getProductName();
            String string2 = helpBrowserSearchResult2.getProductName();
            Integer n = this.iProductsInMatlabeticalOrder.get(string);
            Integer n2 = this.iProductsInMatlabeticalOrder.get(string2);
            if (n != null && n2 != null) {
                return n.compareTo(n2);
            }
            if (n != null) {
                return -1;
            }
            if (n2 != null) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }
}

