/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.ProductTablePanel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ProductFilterPanel
extends MJPanel {
    private final ProductTablePanel fProductTablePanel;
    private MJButton fSelectAllButton;
    private MJButton fClearAllButton;
    private MJRadioButton fSelectedButton;
    private MJPanel fEnablePanel;
    private int fNumTableRows;

    ProductFilterPanel() {
        this(10);
    }

    ProductFilterPanel(int n) {
        this.fNumTableRows = n;
        this.setLayout(new BorderLayout(5, 0));
        this.fProductTablePanel = new ProductTablePanel();
        this.add(this.fProductTablePanel.getComponent(), "Center");
        boolean bl = false;
        MJRadioButton mJRadioButton = new MJRadioButton(HelpUtils.getLocalizedString((String)"filter.show_all"), !bl);
        mJRadioButton.setName("All Products");
        this.fSelectedButton = new MJRadioButton(HelpUtils.getLocalizedString((String)"filter.select_text"), bl);
        this.fSelectedButton.setName("Selected Products");
        this.fSelectAllButton = new MJButton(HelpUtils.getLocalizedString((String)"filter.select_all"));
        this.fSelectAllButton.setName("filter.select_all");
        this.fSelectAllButton.setEnabled(bl);
        this.fSelectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProductFilterPanel.this.fProductTablePanel.selectAll();
            }
        });
        this.fClearAllButton = new MJButton(HelpUtils.getLocalizedString((String)"filter.clear_all"));
        this.fClearAllButton.setName("filter.clear_all");
        this.fClearAllButton.setEnabled(bl);
        this.fClearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProductFilterPanel.this.fProductTablePanel.clearAll();
            }
        });
        MJPanel mJPanel = new MJPanel();
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mJPanel.add((Component)this.fSelectAllButton);
        mJPanel.add((Component)this.fClearAllButton);
        FormLayout formLayout = new FormLayout("left:pref, right:pref:grow", "pref, pref");
        this.fEnablePanel = new MJPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.fEnablePanel.add((Component)mJRadioButton, (Object)cellConstraints.xy(1, 1));
        this.fEnablePanel.add((Component)this.fSelectedButton, (Object)cellConstraints.xy(1, 2));
        this.fEnablePanel.add((Component)mJPanel, (Object)cellConstraints.xywh(2, 1, 1, 2, "r, b"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fSelectedButton);
        buttonGroup.add((AbstractButton)mJRadioButton);
        ButtonChangeListener buttonChangeListener = new ButtonChangeListener();
        mJRadioButton.addChangeListener((ChangeListener)buttonChangeListener);
        this.fSelectedButton.addChangeListener((ChangeListener)buttonChangeListener);
        this.add((Component)this.fEnablePanel, "North");
        this.fSelectedButton.setSelected(bl);
        this.enableProductTable(bl);
    }

    private void enableProductTable(boolean bl) {
        this.fProductTablePanel.enableProductTable(bl);
        this.fSelectAllButton.setEnabled(this.fProductTablePanel.isProductFilterEnabled());
        this.fClearAllButton.setEnabled(this.fProductTablePanel.isProductFilterEnabled());
    }

    public Dimension getPreferredSize() {
        int n = this.fProductTablePanel.getTableRowHeight() * this.fNumTableRows + (int)this.fEnablePanel.getPreferredSize().getHeight() + 5;
        return new Dimension(250, n);
    }

    void saveSelectedProducts() {
    }

    void resetSelectedProducts() {
        this.fProductTablePanel.resetProducts();
    }

    void setEnableNonRefPages(boolean bl) {
        this.fProductTablePanel.setEnableNonRefPages(bl);
    }

    private class ButtonChangeListener
    implements ChangeListener {
        private ButtonChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = ProductFilterPanel.this.fSelectedButton.isSelected();
            if (bl != ProductFilterPanel.this.fProductTablePanel.isProductFilterEnabled()) {
                ProductFilterPanel.this.enableProductTable(bl);
                ProductFilterPanel.this.repaint();
            }
        }
    }
}

