/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.html.Url;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.ReferenceDataUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MLHelpBrowserActiveTab {
    private static MLHelpBrowser sActiveHelpBrowserTab;
    private static Set<MLHelpBrowser> sHelpBrowserTabs;
    private static Set<ChangeListener> sListeners;

    private MLHelpBrowserActiveTab() {
    }

    static synchronized void addHelpBrowserTab(MLHelpBrowser mLHelpBrowser) {
        sHelpBrowserTabs.add(mLHelpBrowser);
    }

    static synchronized void removeHelpBrowserTab(MLHelpBrowser mLHelpBrowser) {
        sHelpBrowserTabs.remove((Object)mLHelpBrowser);
        if (sHelpBrowserTabs.isEmpty()) {
            MLHelpBrowserActiveTab.setActiveHelpBrowserTab(null);
        }
    }

    static synchronized void setActiveHelpBrowserTab(MLHelpBrowser mLHelpBrowser) {
        if (sActiveHelpBrowserTab == null || mLHelpBrowser == null || !sActiveHelpBrowserTab.getName().equalsIgnoreCase(mLHelpBrowser.getName())) {
            sActiveHelpBrowserTab = mLHelpBrowser;
            MLHelpBrowserActiveTab.notifyListeners();
        }
    }

    static synchronized MLHelpBrowser getActiveHelpBrowserTab() {
        return sActiveHelpBrowserTab;
    }

    static synchronized int getNumberHelpBrowserTabs() {
        return sHelpBrowserTabs.size();
    }

    static synchronized MLHelpBrowser getHelpBrowserTabShowingUrl(String string) {
        Object object;
        Object object2;
        Url url;
        if (string == null) {
            return null;
        }
        if (HelpBrowserUtils.isWebAddress((String)string)) {
            string = ReferenceDataUtils.removeReleaseFromPath(string);
        }
        try {
            url = Url.parse((String)string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (MLHelpBrowserActiveTab.getActiveHelpBrowserTab() != null && (object2 = Url.parseSilently((String)(object = MLHelpBrowserActiveTab.getActiveHelpBrowserTab().getCurrentLocation()))) != null && object2.equals((Object)url)) {
            return MLHelpBrowserActiveTab.getActiveHelpBrowserTab();
        }
        object = new ArrayList<MLHelpBrowser>(sHelpBrowserTabs);
        object2 = object.iterator();
        while (object2.hasNext()) {
            MLHelpBrowser mLHelpBrowser = (MLHelpBrowser)((Object)object2.next());
            String string2 = mLHelpBrowser.getCurrentLocation();
            Url url2 = Url.parseSilently((String)string2);
            if (url2 == null || !url2.equals((Object)url)) continue;
            return mLHelpBrowser;
        }
        return null;
    }

    static void addListener(ChangeListener changeListener) {
        sListeners.add(changeListener);
    }

    static void removeListener(ChangeListener changeListener) {
        sListeners.remove(changeListener);
    }

    private static void notifyListeners() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = new ArrayList(sListeners);
                for (ChangeListener changeListener : arrayList) {
                    changeListener.stateChanged(new ChangeEvent(this));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static {
        sHelpBrowserTabs = Collections.synchronizedSet(new LinkedHashSet());
        sListeners = Collections.synchronizedSet(new HashSet());
    }
}

