/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.help.helpui.ComponentHelper;
import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.Url;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.help.AddressLocator;
import com.mathworks.mde.help.HelpBrowserBridge;
import com.mathworks.mde.help.HelpBrowserLinkClickedHandler;
import com.mathworks.mde.help.HelpInfoBarComponent;
import com.mathworks.mde.help.HelpLocator;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.InstalledLinkClickedHandler;
import com.mathworks.mde.help.MLHelpBrowserActiveTab;
import com.mathworks.mde.help.MLHelpBrowserGroup;
import com.mathworks.mde.help.NewFavoriteAction;
import com.mathworks.mde.help.OrganizeFavoritesAction;
import com.mathworks.mde.help.UserFavoriteAction;
import com.mathworks.mde.help.WebLinkClickedHandler;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.HelpComponentHelper;
import com.mathworks.mlwidgets.help.HelpPanel;
import com.mathworks.mlwidgets.help.HelpPanelLinkClickedHandler;
import com.mathworks.mlwidgets.help.HelpToolBar;
import com.mathworks.mlwidgets.html.MatlabContextMenuCustomAction;
import com.mathworks.mlwidgets.html.OpenBrowserStrategies;
import com.mathworks.mlwidgets.html.OpenBrowserStrategy;
import com.mathworks.mlwidgets.html.OpenBrowserStrategyId;
import com.mathworks.mlwidgets.shortcuts.Shortcut;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.CloseableMessageBar;
import com.mathworks.widgets.DropdownButton;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class MLHelpBrowser
extends DTClientBase {
    private static final ResourceBundle PREF_RES = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private static final ResourceBundle HTML_RES = ResourceBundle.getBundle("com.mathworks.mlwidgets.html.resources.RES_HTMLRenderer");
    private static final ResourceBundle DOC_CTR_NO_TRANS_RES = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_DocCenterInfo_notranslation");
    private final HelpPanel fHelpPanel;
    private final MJPanel fInfoBarArea;
    private final MJStatusBar fStatusBar;
    private final Map<HelpInfoBarComponent, HelpBrowserMessageBar> fInfoBars = new HashMap<HelpInfoBarComponent, HelpBrowserMessageBar>();
    private final JPopupMenu fPopupMenu;
    private final MJAbstractAction fNewFavoriteAction;
    private final MJAbstractAction fOrganizeFavoritesAction;
    private final ActionListener fShortCutsListener;
    private String fClientTitle;
    private PageChangedListener fHelpPageChangedListener = null;
    private StatusTextListener fHelpStatusTextListener = null;
    private HtmlDataListener<String> fHelpTitleListener = null;

    public MLHelpBrowser() {
        assert (SwingUtilities.isEventDispatchThread()) : "MLHelpBrowser must be created on the EDT.";
        this.setLayout(new BorderLayout());
        this.setName(MLHelpBrowser.getUniqueClientName());
        this.setClientName(this.getName());
        this.getAccessibleContext().setAccessibleName(this.getName());
        this.fHelpPanel = this.createHelpPanel();
        this.add((Component)this.fHelpPanel);
        this.setDontMergeMenu(true);
        this.setDontReopen(true);
        this.setGroup((DTGroupPropertyProvider)MLHelpBrowserGroup.getInstance());
        this.setMultipleInstances(true);
        this.setPermitUserUndock(false);
        DropdownButton dropdownButton = this.getFavoritesButton();
        this.fPopupMenu = dropdownButton.getPopupMenu();
        HtmlComponent htmlComponent = this.fHelpPanel.getHtmlComponent();
        HelpToolBar helpToolBar = new HelpToolBar(MLHelpBrowser.getActions(htmlComponent), (ComponentHelper)new HelpComponentHelper(), MLHelpBrowser.getDocCenterToolBarButtons((MJButton)dropdownButton));
        this.setToolBar((JToolBar)helpToolBar.getComponent());
        this.setContextActions(MLHelpBrowser.getContextActions(htmlComponent));
        this.fStatusBar = new MJStatusBar();
        this.fStatusBar.setName("Doc Center Status Bar");
        this.fStatusBar.getAccessibleContext().setAccessibleName("Doc Center Status Bar");
        this.setStatusBar(this.fStatusBar);
        this.fInfoBarArea = new MJPanel();
        this.fInfoBarArea.setLayout((LayoutManager)new BoxLayout((Container)this.fInfoBarArea, 1));
        this.addToActiveTab();
        this.addClientToDesktop();
        this.fNewFavoriteAction = new NewFavoriteAction(this);
        this.fOrganizeFavoritesAction = new OrganizeFavoritesAction(this);
        this.addActionsToFavoritesMenu();
        this.fShortCutsListener = new HelpShortcutsListener();
        ShortcutUtils.addFavoritesListener((ActionListener)this.fShortCutsListener);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MLHelpBrowser.this.requestFocusInBrowser();
            }
        });
        this.requestFocusInBrowser();
    }

    private HelpPanel createHelpPanel() {
        DocCenterDocConfig docCenterDocConfig = DocCenterDocConfig.getInstance();
        HelpPanel helpPanel = new HelpPanel((DocConfig)docCenterDocConfig, MLHelpBrowser.getOpenBrowserStrategies(), (MatlabContextMenuCustomAction)new InvokeHelpLocatorAction());
        HelpBrowserLinkClickedHandler helpBrowserLinkClickedHandler = docCenterDocConfig.getUrlType() == Url.UrlType.FILE ? new InstalledLinkClickedHandler(this, (DocCenterDocConfig<FileUrl>)DocCenterDocConfig.getLocalConfig()) : new WebLinkClickedHandler(this);
        helpPanel.addLinkClickedHandler((HelpPanelLinkClickedHandler)helpBrowserLinkClickedHandler);
        helpPanel.getHtmlComponent().getComponent().setName("MJHtmlPanel");
        this.fHelpPageChangedListener = new HelpPageChangedListener();
        helpPanel.getHtmlComponent().addPageChangedListener(this.fHelpPageChangedListener);
        this.fHelpTitleListener = new HelpBrowserTitleListener();
        helpPanel.getHtmlComponent().addTitleChangedListener(this.fHelpTitleListener);
        this.fHelpStatusTextListener = new HelpBrowserStatusTextListener();
        helpPanel.getHtmlComponent().addStatusTextListener(this.fHelpStatusTextListener);
        return helpPanel;
    }

    private static Action[] getContextActions(HtmlComponent htmlComponent) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Map map = htmlComponent.getActions().getBasicActions();
        Action action = (Action)map.get(StandardHtmlActionId.COPY);
        ContextTargetingManager.setToolName((Action)action, (String)DTMenuMergeTag.COPY.toString());
        arrayList.add(action);
        Action action2 = (Action)map.get(StandardHtmlActionId.PRINT);
        if (action2 != null) {
            ContextTargetingManager.setToolName((Action)action2, (String)DTMenuMergeTag.PRINT.toString());
            arrayList.add(action2);
        }
        Action action3 = (Action)map.get(StandardHtmlActionId.FIND);
        ContextTargetingManager.setToolName((Action)action3, (String)DTMenuMergeTag.FIND.toString());
        arrayList.add(action3);
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static Map<StandardHtmlActionId, ? extends Action> getActions(HtmlComponent htmlComponent) {
        Map map = htmlComponent.getActions().getBasicActions();
        EnumMap enumMap = new EnumMap(StandardHtmlActionId.class);
        enumMap.put(StandardHtmlActionId.GO_BACK, map.get(StandardHtmlActionId.GO_BACK));
        enumMap.put(StandardHtmlActionId.GO_FORWARD, map.get(StandardHtmlActionId.GO_FORWARD));
        enumMap.put(StandardHtmlActionId.PRINT, map.get(StandardHtmlActionId.PRINT));
        return enumMap;
    }

    private static Collection<MJButton> getDocCenterToolBarButtons(MJButton mJButton) {
        LinkedHashSet<MJButton> linkedHashSet = new LinkedHashSet<MJButton>();
        MJButton mJButton2 = new MJButton();
        mJButton2.setName("SettingsButton");
        mJButton2.getAccessibleContext().setAccessibleName("SettingsButton");
        mJButton2.setToolTipText(HelpUtils.getLocalizedString((String)"doccenter.toolbar.settings"));
        mJButton2.setIcon((Icon)DocumentIcon.ACTIONS.getIcon());
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLPrefsDialogServices.showPrefsDialog((String)PREF_RES.getString("area.help"));
            }
        });
        linkedHashSet.add(mJButton);
        linkedHashSet.add(mJButton2);
        return linkedHashSet;
    }

    private DropdownButton getFavoritesButton() {
        ImageIcon imageIcon;
        DropdownButton dropdownButton = new DropdownButton();
        if (PlatformInfo.isMacintosh()) {
            dropdownButton.setMargin(new Insets(5, 6, 6, 6));
        }
        dropdownButton.setName("FavoritesButton");
        dropdownButton.getAccessibleContext().setAccessibleName("FavoritesButton");
        dropdownButton.setToolTipText(HelpUtils.getLocalizedString((String)"doccenter.toolbar.favorites"));
        String string = HelpUtils.getLocalizedString((String)"doccenter.toolbar.button.favorites.alttext");
        URL uRL = HelpBrowserUtils.getImageURL((String)DOC_CTR_NO_TRANS_RES.getString("toolbar.resource.directory.path"), (String)DOC_CTR_NO_TRANS_RES.getString("toolbar.image.favorites"));
        ImageIcon imageIcon2 = imageIcon = uRL != null ? new ImageIcon(uRL, string) : null;
        if (imageIcon != null) {
            dropdownButton.setIcon((Icon)imageIcon);
        } else {
            dropdownButton.setText(string);
        }
        dropdownButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MLHelpBrowser.this.fPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        return dropdownButton;
    }

    private static List<MJAbstractAction> getUserFavoriteActions() {
        Vector<MJAbstractAction> vector = new Vector<MJAbstractAction>();
        Vector vector2 = ShortcutUtils.getShortcutsByCategory((String)ShortcutUtils.getDefaultHelpCategoryName());
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                Shortcut shortcut = (Shortcut)vector2.elementAt(i);
                vector.add(new UserFavoriteAction(shortcut.getLabel(), shortcut.getCallback(), shortcut.getIcon()));
            }
        }
        return vector;
    }

    private static String getUniqueClientName() {
        int n = MLHelpBrowserGroup.getNextClientNum();
        return "New Help Browser " + String.valueOf(n);
    }

    private void addToActiveTab() {
        MLHelpBrowserActiveTab.addHelpBrowserTab(this);
    }

    private void addClientToDesktop() {
        MLDesktop.getInstance().addClient((Component)((Object)this), "Doc Center", false, null, true, null);
    }

    public void dispose() {
        ShortcutUtils.removeFavoritesListener((ActionListener)this.fShortCutsListener);
        if (this.fHelpPageChangedListener != null) {
            this.fHelpPanel.getHtmlComponent().removePageChangedListener(this.fHelpPageChangedListener);
            this.fHelpPageChangedListener = null;
        }
        if (this.fHelpTitleListener != null) {
            this.fHelpPanel.getHtmlComponent().removeTitleChangedListener(this.fHelpTitleListener);
        }
        if (this.fHelpStatusTextListener != null) {
            this.fHelpPanel.getHtmlComponent().removeStatusTextListener(this.fHelpStatusTextListener);
            this.fHelpStatusTextListener = null;
        }
        this.fHelpPanel.dispose();
    }

    private synchronized void setClientTitle(String string) {
        this.fClientTitle = string;
        this.setDTClientTitle(string);
    }

    private synchronized void setDTClientTitle(String string) {
        this.setTitle(string);
    }

    synchronized String getClientTitle() {
        return this.fClientTitle;
    }

    private static OpenBrowserStrategies getOpenBrowserStrategies() {
        OpenBrowserStrategies openBrowserStrategies = new OpenBrowserStrategies();
        openBrowserStrategies.addOpenBrowserStrategy(OpenBrowserStrategyId.CURRENT_BROWSER, (OpenBrowserStrategy)new OpenCurrentBrowserStrategy());
        openBrowserStrategies.addOpenBrowserStrategy(OpenBrowserStrategyId.NEW_TAB, (OpenBrowserStrategy)new OpenNewTabStrategy());
        return openBrowserStrategies;
    }

    void showClient(String string, boolean bl) {
        MLDesktop.getInstance().showClient((Component)((Object)this), null, bl);
        this.setCurrentLocation(string, bl);
    }

    void setCurrentLocation(String string) {
        this.setCurrentLocation(string, true);
    }

    private void setCurrentLocation(String string, boolean bl) {
        this.fHelpPanel.setCurrentLocation(string);
        if (bl) {
            this.requestFocusInBrowser();
        }
    }

    void showClient(Url url, boolean bl) {
        MLDesktop.getInstance().showClient((Component)((Object)this), null, bl);
        this.setCurrentLocation(url, bl);
    }

    void setCurrentLocation(Url url) {
        this.setCurrentLocation(url, true);
    }

    private void setCurrentLocation(Url url, boolean bl) {
        this.fHelpPanel.setCurrentLocation(url);
        if (bl) {
            this.requestFocusInBrowser();
        }
    }

    String getCurrentLocation() {
        return this.fHelpPanel.getCurrentLocation();
    }

    void showClientText(String string) {
        MLDesktop.getInstance().showClient((Component)((Object)this), null, true);
        this.setHtmlText(string);
    }

    void setHtmlText(String string) {
        this.fHelpPanel.setHtmlText(string);
        this.requestFocusInBrowser();
    }

    String getHtmlText() {
        return this.fHelpPanel.getHtmlText();
    }

    void addInfoMessageBar(HelpInfoBarComponent helpInfoBarComponent) {
        for (HelpInfoBarComponent helpInfoBarComponent2 : this.fInfoBars.keySet()) {
            if (!helpInfoBarComponent2.getClass().equals(helpInfoBarComponent.getClass())) continue;
            this.removeInfoMessageBar(helpInfoBarComponent2);
        }
        Object object = new HelpBrowserMessageBar(helpInfoBarComponent);
        object.getComponent().setName(helpInfoBarComponent.getMessageBarName());
        this.fInfoBars.put(helpInfoBarComponent, (HelpBrowserMessageBar)((Object)object));
        this.fInfoBarArea.add((Component)object.getComponent());
        if (this.fInfoBars.size() == 1) {
            this.add((Component)this.fInfoBarArea, "North");
        }
        this.revalidate();
        this.repaint();
    }

    void removeInfoMessageBar(HelpInfoBarComponent helpInfoBarComponent) {
        HelpBrowserMessageBar helpBrowserMessageBar = this.fInfoBars.get(helpInfoBarComponent);
        if (helpBrowserMessageBar != null) {
            this.fInfoBarArea.remove((Component)helpBrowserMessageBar.getComponent());
            helpInfoBarComponent.infoBarRemoved();
            if (this.fInfoBars.isEmpty()) {
                this.remove((Component)this.fInfoBarArea);
            }
            this.revalidate();
            this.repaint();
        }
    }

    void requestFocusInBrowser() {
        MLDesktop.getInstance().setClientSelected((Component)((Object)this), true);
        this.fHelpPanel.getHtmlComponent().getComponent().requestFocusInWindow();
    }

    JComponent getComponent() {
        return this.fHelpPanel;
    }

    void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fHelpPanel.getHtmlComponent().addPageChangedListener(pageChangedListener);
    }

    void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.fHelpPanel.getHtmlComponent().removePageChangedListener(pageChangedListener);
    }

    private void addActionsToFavoritesMenu() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MLHelpBrowser.this.fPopupMenu.removeAll();
                MLHelpBrowser.this.fPopupMenu.add((Action)MLHelpBrowser.this.fNewFavoriteAction);
                MLHelpBrowser.this.fPopupMenu.add((Action)MLHelpBrowser.this.fOrganizeFavoritesAction);
                List list = MLHelpBrowser.getUserFavoriteActions();
                if (list != null && !list.isEmpty()) {
                    MLHelpBrowser.this.fPopupMenu.addSeparator();
                    for (MJAbstractAction mJAbstractAction : list) {
                        MLHelpBrowser.this.fPopupMenu.add((Action)mJAbstractAction);
                    }
                }
            }
        });
    }

    private class HelpShortcutsListener
    implements ActionListener {
        private HelpShortcutsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MLHelpBrowser.this.addActionsToFavoritesMenu();
        }
    }

    private class HelpBrowserMessageBar
    extends CloseableMessageBar {
        private HelpBrowserMessageBar(final HelpInfoBarComponent helpInfoBarComponent) {
            super(helpInfoBarComponent.getComponent(), (Icon)CommonIcon.INFO.getIcon(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MLHelpBrowser.this.removeInfoMessageBar(helpInfoBarComponent);
                }
            });
        }
    }

    private class InvokeHelpLocatorAction
    implements MatlabContextMenuCustomAction {
        private InvokeHelpLocatorAction() {
        }

        public String getLabel() {
            return HTML_RES.getString("Action.get-page-address");
        }

        public void doAction(String string) {
            HelpLocator.invoke((MJFrame)SwingUtilities.windowForComponent((Component)((Object)MLHelpBrowser.this)));
        }

        public boolean enableAction(String string) {
            AddressLocator addressLocator = new AddressLocator();
            return addressLocator.isValidLocation(string);
        }
    }

    private static class OpenNewTabStrategy
    implements OpenBrowserStrategy {
        private OpenNewTabStrategy() {
        }

        public void openUrl(Url url) {
            HelpBrowserBridge.getInstance().openInNewBrowser(url, false);
        }
    }

    private static class OpenCurrentBrowserStrategy
    implements OpenBrowserStrategy {
        private OpenCurrentBrowserStrategy() {
        }

        public void openUrl(Url url) {
            HelpBrowserBridge.getInstance().openInCurrentBrowser(url);
        }
    }

    private class HelpBrowserStatusTextListener
    implements StatusTextListener {
        private HelpBrowserStatusTextListener() {
        }

        public void statusChanged(final StatusTextChangedEvent statusTextChangedEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MLHelpBrowser.this.fStatusBar.setText(statusTextChangedEvent.getStatusText());
                }
            });
        }
    }

    private class HelpBrowserTitleListener
    implements HtmlDataListener<String> {
        private HelpBrowserTitleListener() {
        }

        public void dataRetrieved(String string) {
            MLHelpBrowser.this.setClientTitle(string);
        }
    }

    private class HelpPageChangedListener
    implements PageChangedListener {
        private HelpPageChangedListener() {
        }

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            String string;
            if (pageChangedEvent.getChangedUrlParts().contains(Url.UrlPart.BASE)) {
                string = pageChangedEvent.getTitle();
                MLHelpBrowser.this.setClientTitle(string);
            }
            string = pageChangedEvent.getNewUrl();
            MLHelpBrowser.this.fNewFavoriteAction.setEnabled(string != null && !string.getProtocol().equals("text"));
        }
    }
}

