/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.mathworks.mde.functionbrowser.FunctionBrowserCloser;
import com.mathworks.mde.functionbrowser.FunctionBrowserFontPrefs;
import com.mathworks.mde.functionbrowser.FunctionBrowserPanel;
import com.mathworks.mde.functionbrowser.FunctionCellRenderer;
import com.mathworks.mde.functionbrowser.FunctionTable;
import com.mathworks.mde.functionbrowser.FunctionTableModel;
import com.mathworks.mde.functionbrowser.ProductScopePanel;
import com.mathworks.mde.functionbrowser.TargetDialog;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.actionbrowser.HelpPopupLauncher;
import com.mathworks.mlwidgets.actionbrowser.TearOffDialog;
import com.mathworks.mlwidgets.actionbrowser.TransparentDialog;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class FunctionBrowser
extends TearOffDialog
implements HelpPopupLauncher {
    private static volatile FunctionBrowser sInstance = null;
    private static String sDocRoot = null;
    private static LanguageLocale sLanguageLocale = null;
    private static volatile FontListener sFontListener;
    private static volatile ColorListener sColorListener;
    private static boolean sProductFilterDirty;
    private FunctionBrowserPanel fPanel = null;
    private JTextComponent fHostTextComponent;
    private WindowFocusListener fTooltipListener;
    private WindowListener fAntiClosingWindowListener;
    private ProductScopePanel fProductScopePanel;
    private TargetDialog fTargetDialog = null;
    private FunctionBrowserCloser fFunctionBrowserCloser;
    static Color DEFAULT_BACKGROUND_COLOR;

    private FunctionBrowser(String string, JTextComponent jTextComponent) {
        super((Frame)jTextComponent.getTopLevelAncestor());
        this.setName("FunctionBrowser:FunctionBrowser");
        this.fHostTextComponent = jTextComponent;
        this.fPanel = new FunctionBrowserPanel(string);
        this.fProductScopePanel = new ProductScopePanel();
        this.setContentPanel((JComponent)((Object)this.fPanel));
        this.setScopePanel((JComponent)((Object)this.fProductScopePanel));
        this.initCloser();
        this.initKeyBindings();
    }

    public FunctionBrowser(FunctionBrowserPanel functionBrowserPanel, JTextComponent jTextComponent) {
        super((Frame)jTextComponent.getTopLevelAncestor());
        this.setName("FunctionBrowser:FunctionBrowser");
        this.fHostTextComponent = jTextComponent;
        this.fPanel = functionBrowserPanel;
        this.fProductScopePanel = new ProductScopePanel();
        this.setContentPanel((JComponent)((Object)this.fPanel));
        this.setScopePanel((JComponent)((Object)this.fProductScopePanel));
        this.initCloser();
        this.initKeyBindings();
    }

    public FunctionBrowser(FunctionBrowserPanel functionBrowserPanel) {
        super((Frame)FunctionBrowser.getDefaultHostFrame(), (JComponent)((Object)functionBrowserPanel), (JComponent)((Object)new ProductScopePanel()));
        this.setName("FunctionBrowser:FunctionBrowser");
        this.fHostTextComponent = null;
        this.fPanel = functionBrowserPanel;
        this.fProductScopePanel = new ProductScopePanel();
        this.setContentPanel((JComponent)((Object)this.fPanel));
        this.setScopePanel((JComponent)((Object)this.fProductScopePanel));
        this.initCloser();
        this.initKeyBindings();
        this.makeFloating();
    }

    private FunctionBrowser(String string) {
        super((Frame)FunctionBrowser.getDefaultHostFrame(), (JComponent)((Object)new FunctionBrowserPanel(string)), (JComponent)((Object)new ProductScopePanel()));
        this.setName("FunctionBrowser:FunctionBrowser");
        this.fHostTextComponent = null;
        this.fPanel = new FunctionBrowserPanel(string);
        this.fProductScopePanel = new ProductScopePanel();
        this.setContentPanel((JComponent)((Object)this.fPanel));
        this.setScopePanel((JComponent)((Object)this.fProductScopePanel));
        this.initCloser();
        this.initKeyBindings();
        this.makeFloating();
    }

    public static void open(final JTextComponent jTextComponent, final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FunctionBrowser.utOpen(null, jTextComponent, string);
            }
        });
    }

    public static void closeUnfloating() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (sInstance != null && !sInstance.isFloating() && sInstance.isVisible()) {
                    sInstance.setVisible(false);
                }
            }
        });
    }

    public static void open(final Rectangle rectangle, final JTextComponent jTextComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            FunctionBrowser.utOpen(rectangle, jTextComponent, null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FunctionBrowser.utOpen(rectangle, jTextComponent, null);
                }
            });
        }
    }

    public static void open(final Rectangle rectangle, final JTextComponent jTextComponent, final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            FunctionBrowser.utOpen(rectangle, jTextComponent, string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FunctionBrowser.utOpen(rectangle, jTextComponent, string);
                }
            });
        }
    }

    public static void open(final JTextComponent jTextComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            FunctionBrowser.utOpen(null, jTextComponent, null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FunctionBrowser.utOpen(null, jTextComponent, null);
                }
            });
        }
    }

    public static void open(final Rectangle rectangle) {
        if (SwingUtilities.isEventDispatchThread()) {
            FunctionBrowser.utOpen(rectangle, null, null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FunctionBrowser.utOpen(rectangle, null, null);
                }
            });
        }
    }

    public static FunctionBrowser getInstance() {
        return sInstance;
    }

    public boolean isSearchComplete() {
        return this.fPanel != null && this.fPanel.isSearchComplete();
    }

    public String getSearchDiagnostic() {
        if (this.fPanel != null) {
            return this.fPanel.getDiagnostic();
        }
        return "null panel";
    }

    static void update() {
        if (sInstance == null) {
            return;
        }
        FunctionBrowser.sInstance.fPanel.resetTableModel();
        FunctionBrowser.sInstance.fPanel.update();
    }

    JTextComponent getHostTextComponent() {
        return this.fHostTextComponent;
    }

    public JComponent getParentComponent() {
        return this.fHostTextComponent;
    }

    public void setLocation(int n, int n2) {
        if (PlatformInfo.isIntelMac() && this.isFloating() && n2 < WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)new Point((int)n, (int)n2)).y) {
            n2 = WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)new Point((int)n, (int)n2)).y;
        }
        super.setLocation(n, n2);
    }

    static void utOpen(Rectangle rectangle, JTextComponent jTextComponent, String object) {
        Object object2;
        Object object3;
        FunctionBrowser.addDesktopListeners();
        if (object != null && ((String)object).length() < 2) {
            object = null;
        }
        if (jTextComponent != null && (object3 = jTextComponent.getSelectedText()) != null && ((String)object3).length() >= 2) {
            object = object3;
        }
        if (HelpUtils.isDocInstalled() && !FunctionBrowser.isDocCategoriesCurrent()) {
            sDocRoot = MLHelpServices.getDocRoot();
            sLanguageLocale = HelpUtils.getLanguageLocale();
            sProductFilterDirty = false;
            FunctionTableModel.resetCategories();
            sInstance = null;
        }
        object3 = null;
        if (jTextComponent != null) {
            object3 = jTextComponent.getCursor();
            jTextComponent.setCursor(new Cursor(3));
        }
        if (sInstance == null && jTextComponent == null) {
            sInstance = new FunctionBrowser((String)object);
            sInstance.makeFloating();
        } else if (sInstance == null) {
            sInstance = new FunctionBrowser((String)object, jTextComponent);
        } else if (sInstance.isFloating() && sInstance.isVisible()) {
            if (jTextComponent != null && jTextComponent.getTopLevelAncestor() != sInstance.getOwner()) {
                Rectangle rectangle2 = sInstance.getBounds();
                FunctionBrowserPanel functionBrowserPanel = FunctionBrowser.sInstance.fPanel;
                if (object == null) {
                    functionBrowserPanel.selectAllSearchText();
                } else {
                    functionBrowserPanel.clear((String)object);
                }
                sInstance.dispose();
                sInstance.cleanup();
                sInstance = new FunctionBrowser(functionBrowserPanel, jTextComponent);
                sInstance.makeFloating();
                sInstance.setBounds(rectangle2);
                FunctionBrowser.sInstance.fPanel.setInitialFocus();
                sInstance.open();
                jTextComponent.setCursor((Cursor)object3);
                return;
            }
            if (FunctionBrowser.sInstance.fPanel != null) {
                if (object == null) {
                    FunctionBrowser.sInstance.fPanel.selectAllSearchText();
                } else {
                    FunctionBrowser.sInstance.fPanel.clear((String)object);
                }
            }
        } else if (sInstance != null && jTextComponent != null && FunctionBrowser.sInstance.fHostTextComponent != jTextComponent) {
            object2 = FunctionBrowser.sInstance.fPanel;
            if (object == null) {
                ((FunctionBrowserPanel)object2).selectAllSearchText();
            } else {
                ((FunctionBrowserPanel)object2).clear((String)object);
            }
            sInstance.dispose();
            sInstance.cleanup();
            sInstance = new FunctionBrowser((FunctionBrowserPanel)object2, jTextComponent);
        } else if (sInstance != null && jTextComponent != null && FunctionBrowser.sInstance.fHostTextComponent == jTextComponent) {
            if (object == null) {
                FunctionBrowser.sInstance.fPanel.selectAllSearchText();
            } else {
                FunctionBrowser.sInstance.fPanel.clear((String)object);
            }
        } else if (sInstance != null && jTextComponent == null) {
            object2 = FunctionBrowser.sInstance.fPanel;
            ((FunctionBrowserPanel)object2).clear("");
            sInstance.dispose();
            sInstance.cleanup();
            sInstance = new FunctionBrowser((FunctionBrowserPanel)object2);
            sInstance.makeFloating();
        }
        if (sInstance != null && !sInstance.isVisible()) {
            object2 = rectangle == null ? (PlatformInfo.isIntelMac() && jTextComponent != null && jTextComponent.getLocationOnScreen() != null ? FunctionBrowser.computeBounds(jTextComponent.getLocationOnScreen().x, jTextComponent.getLocationOnScreen().y, jTextComponent.getHeight()) : FunctionBrowser.computeBounds(jTextComponent)) : FunctionBrowser.computeBounds(rectangle.x, rectangle.y, rectangle.height);
            object2 = FunctionBrowser.setBoundsInYlimits((Rectangle)object2);
            sInstance.setBounds((Rectangle)object2);
        }
        if (sInstance == null) {
            return;
        }
        FunctionBrowser.sInstance.fHostTextComponent = jTextComponent;
        FunctionBrowser.sInstance.fPanel.setInitialFocus();
        sInstance.open();
        if (jTextComponent != null) {
            jTextComponent.setCursor((Cursor)object3);
        }
    }

    private static Rectangle computeBounds(JTextComponent jTextComponent) {
        Rectangle rectangle = WindowUtils.computeTextPopupBounds((Dimension)sInstance.getSize(), (Dimension)sInstance.getSize(), (JTextComponent)jTextComponent, (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED);
        return rectangle;
    }

    private static Rectangle computeBounds(int n, int n2, int n3) {
        Rectangle rectangle = WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)new Point(n, n2));
        Point point = new Point(n, n2 - n3);
        Rectangle rectangle2 = WindowUtils.computeTextPopupBounds((Rectangle)rectangle, (Dimension)sInstance.getSize(), (Dimension)sInstance.getSize(), (Point)point, (int)n3, (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED);
        return rectangle2;
    }

    static void setProductFilterDirty(boolean bl) {
        sProductFilterDirty = bl;
    }

    private static boolean isDocCategoriesCurrent() {
        boolean bl = sDocRoot == null || !sDocRoot.equals(MLHelpServices.getDocRoot());
        boolean bl2 = sLanguageLocale == null || sLanguageLocale != HelpUtils.getLanguageLocale();
        return !bl && !bl2 && !sProductFilterDirty;
    }

    static boolean isInstanceShowing() {
        return sInstance != null && sInstance.isVisible();
    }

    private static void addDesktopListeners() {
        if (sFontListener == null) {
            sFontListener = new FontPrefListener();
            FontPrefs.addFontListener((String)FunctionBrowserFontPrefs.DISPLAY_NAME, (FontListener)sFontListener);
        }
        if (sColorListener == null) {
            sColorListener = new ColorListener();
            ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)sColorListener);
        }
    }

    private static Rectangle setBoundsInYlimits(Rectangle rectangle) {
        assert (rectangle != null);
        Rectangle rectangle2 = WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)new Point(rectangle.x, rectangle.y));
        if (rectangle.y + rectangle.height >= rectangle2.y + rectangle2.height) {
            rectangle.y = rectangle2.y + rectangle2.height - rectangle.height - 1;
        }
        return rectangle;
    }

    private void initCloser() {
        this.fFunctionBrowserCloser = new FunctionBrowserCloser();
        this.setCloser(this.fFunctionBrowserCloser);
    }

    private void initKeyBindings() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(70, 2), "doFloat");
        this.getRootPane().getActionMap().put("doFloat", (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionBrowser.this.makeFloating();
            }
        });
    }

    void insertFunction(String string) {
        if ((this.fHostTextComponent == null || this.isFloating()) && TargetDialog.isTargetAmbiguous()) {
            if (this.fTargetDialog == null) {
                this.fTargetDialog = new TargetDialog((Dialog)((Object)this), string);
            } else {
                this.fTargetDialog.build(string);
            }
            Point point = this.getMousePosition();
            if (point == null) {
                point = new Point(0, 0);
            }
            point = new Point(this.getWidth(), point.y - this.fTargetDialog.getSize().height / 2);
            SwingUtilities.convertPointToScreen(point, (Component)((Object)this));
            if (point.x + this.fTargetDialog.getSize().width >= WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)point).width) {
                point.x = point.x - this.fTargetDialog.getSize().width - this.getWidth();
            }
            this.fTargetDialog.setLocation(point);
            this.fTargetDialog.setVisible(true);
        } else if (this.fHostTextComponent != null && !this.isFloating()) {
            this.fHostTextComponent.replaceSelection(string);
        } else {
            TargetDialog.insertToCommandWindow(string);
        }
        if (!this.isFloating()) {
            this.setVisible(false);
        }
    }

    static boolean isDocAvailable() {
        return sDocRoot != null;
    }

    private void cleanup() {
        this.removeWindowFocusListener(this.fTooltipListener);
        this.removeWindowListener(this.fAntiClosingWindowListener);
        this.fFunctionBrowserCloser.cleanup();
        this.fProductScopePanel.cleanup();
        this.fPanel = null;
        this.fHostTextComponent = null;
        this.fTooltipListener = null;
        this.fAntiClosingWindowListener = null;
        this.fProductScopePanel = null;
    }

    private void addTooltipDismissListener() {
        if (this.fTooltipListener != null) {
            return;
        }
        this.fTooltipListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                TransparentDialog transparentDialog = FunctionBrowser.this.fPanel.getFunctionTable().getToolTipWindow();
                Window window = windowEvent.getOppositeWindow();
                if (window == null && PlatformInfo.isLinux()) {
                    return;
                }
                if (transparentDialog != null && transparentDialog.isVisible() && windowEvent.getOppositeWindow() != transparentDialog) {
                    FunctionBrowser.this.fPanel.getFunctionTable().hideActionToolTip();
                }
            }
        };
        this.addWindowFocusListener(this.fTooltipListener);
    }

    public void floatingComplete() {
        super.floatingComplete();
        this.fHostTextComponent = null;
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            if (this.isVisible()) {
                this.fPanel.getFunctionTable().hideActionToolTip();
            }
            this.fHostTextComponent = null;
        } else if (!this.isVisible()) {
            this.addTooltipDismissListener();
        }
        super.setVisible(bl);
    }

    public void dispose() {
        if (this.fPanel != null && this.fPanel.getFunctionTable() != null) {
            this.fPanel.getFunctionTable().hideActionToolTip();
        }
        super.dispose();
    }

    private static FunctionBrowserPanel getFunctionPanel() {
        if (sInstance == null) {
            return null;
        }
        if (FunctionBrowser.sInstance.fPanel == null) {
            return null;
        }
        return FunctionBrowser.sInstance.fPanel;
    }

    static {
        sProductFilterDirty = false;
        DEFAULT_BACKGROUND_COLOR = new Color(240, 240, 240);
    }

    private static class ColorListener
    implements PrefListener {
        private ColorListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            FunctionBrowserPanel functionBrowserPanel = FunctionBrowser.getFunctionPanel();
            if (functionBrowserPanel == null) {
                return;
            }
            if (prefEvent.getPrefKey().equals("ColorsText") || prefEvent.getPrefKey().equals("ColorsUseSystem")) {
                functionBrowserPanel.initColors();
            }
        }
    }

    private static class FontPrefListener
    implements FontListener {
        private FontPrefListener() {
        }

        public void fontChanged(Font font) {
            FunctionBrowserPanel functionBrowserPanel = FunctionBrowser.getFunctionPanel();
            if (functionBrowserPanel == null) {
                return;
            }
            FunctionTable functionTable = functionBrowserPanel.getFunctionTable();
            if (functionTable != null) {
                FunctionCellRenderer.setDefaultFont(font);
                functionTable.repaint();
                functionTable.calculateRowHeights();
                functionTable.repaint();
            }
        }
    }
}

