/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.find;

import com.mathworks.mde.find.FindFilesPrefs;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.table.SortedTableHeaderRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class FileExtensionFilter
extends MJDialog {
    static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.find.resources.RES_FindFilesExtFilter");
    private static FileExtensionFilter sThis;
    private MyTableSorter fSorter;
    private Vector sExtItems = new Vector();
    private static final Boolean OFF;
    private static final Boolean ON;
    private static MyTable sTable;
    private MJTextField fAddText;

    public FileExtensionFilter(Frame frame) {
        super(frame, false);
        this.setTitle(sRes.getString("title.FindFilesFilter"));
        this.getAccessibleContext().setAccessibleName(sRes.getString("title.FindFilesFilter"));
        sThis = this;
        this.setName("FileExclusionDialog");
        this.getContentPane().setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        MJPanel mJPanel = new MJPanel((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(sRes.getString("text.helpfulAdd"), true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints((Component)mJMultilineLabel, gridBagConstraints);
        mJPanel.add((Component)mJMultilineLabel);
        AddAction addAction = new AddAction();
        this.fAddText = new MJTextField(5);
        this.fAddText.setName("AddExtensionField");
        this.fAddText.addActionListener((ActionListener)addAction);
        this.fAddText.getAccessibleContext().setAccessibleName(sRes.getString("text.helpfulAdd"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints((Component)this.fAddText, gridBagConstraints);
        mJPanel.add((Component)this.fAddText);
        MJButton mJButton = new MJButton((Action)addAction);
        mJButton.setName("AddExtButton");
        mJButton.getAccessibleContext().setAccessibleName(sRes.getString("button.Add"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints((Component)mJButton, gridBagConstraints);
        mJPanel.add((Component)mJButton);
        mJPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        String[] stringArray = new String[]{sRes.getString("table.column1"), sRes.getString("table.column2")};
        this.getItems();
        this.fSorter = new MyTableSorter(new MyTableModel(this.sExtItems, stringArray));
        sTable = new MyTable(this.fSorter);
        sTable.setRowSelectionAllowed(true);
        sTable.setColumnSelectionAllowed(false);
        sTable.setCellViewerEnabled(true);
        sTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        sTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        sTable.setAutoResizeMode(0);
        sTable.setShowGrid(false);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)sTable));
        mJScrollPane.setHorizontalScrollBarPolicy(31);
        mJScrollPane.setPreferredSize(new Dimension(250, 200));
        mJScrollPane.getViewport().setBackground(Color.white);
        this.fSorter.setTableHeader(sTable.getTableHeader());
        this.fSorter.setSortingStatus(1, 1);
        sTable.setName("ExtensionsTable");
        sTable.getAccessibleContext().setAccessibleName(sRes.getString("table.acc.desc"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints((Component)mJScrollPane, gridBagConstraints);
        mJPanel.add((Component)mJScrollPane);
        gridBagConstraints.gridheight = 1;
        mJScrollPane.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), mJScrollPane.getBorder()));
        MJPanel mJPanel2 = new MJPanel();
        MJButton mJButton2 = new MJButton((Action)new RemoveAction());
        mJButton2.setName("RemoveExtButton");
        mJButton2.getAccessibleContext().setAccessibleName(sRes.getString("button.Remove"));
        MJButton mJButton3 = new MJButton((Action)new RestoreAction());
        mJButton3.getAccessibleContext().setAccessibleName(sRes.getString("button.Restore"));
        mJButton3.setName("RestoreButton");
        mJPanel2.add((Component)mJButton2);
        mJPanel2.add((Component)mJButton3);
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints((Component)mJPanel2, gridBagConstraints);
        mJPanel.add((Component)mJPanel2);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        MJPanel mJPanel3 = new MJPanel((LayoutManager)gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 5, 3, 5);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 10;
        MJMultilineLabel mJMultilineLabel2 = new MJMultilineLabel(sRes.getString("text.helpful"), true);
        gridBagLayout2.setConstraints((Component)mJMultilineLabel2, gridBagConstraints2);
        mJPanel3.add((Component)mJMultilineLabel2);
        MJPanel mJPanel4 = new MJPanel();
        MJButton mJButton4 = new MJButton((Action)new OkAction());
        mJButton4.setName("OKButton");
        mJButton4.getAccessibleContext().setAccessibleName(sRes.getString("button.OK"));
        MJButton mJButton5 = new MJButton((Action)new HelpAction());
        mJButton5.setName("HelpButton");
        mJButton5.getAccessibleContext().setAccessibleName(sRes.getString("button.Help"));
        mJPanel4.add((Component)mJButton4);
        mJPanel4.add((Component)mJButton5);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagLayout2.setConstraints((Component)mJPanel4, gridBagConstraints2);
        mJPanel3.add((Component)mJPanel4);
        this.getContentPane().add((Component)mJPanel, "Center");
        this.getContentPane().add((Component)mJPanel3, "South");
        this.pack();
        int n = this.getPreferredSize().height;
        int n2 = this.getPreferredSize().width;
        Rectangle rectangle = frame.getBounds();
        int n3 = (frame.getSize().width - n2) / 2 + rectangle.x;
        int n4 = (frame.getSize().height - n) / 2 + rectangle.y;
        this.setBounds(n3, n4, n2 + 25, n);
    }

    private void getItems() {
        String string = FindFilesPrefs.getExclusionFilter();
        String string2 = FindFilesPrefs.getExclusionSelections();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            this.sExtItems.addElement(new ExtItem(string3, string2.indexOf(string3 = stringTokenizer.nextToken()) != -1));
        }
    }

    private void restoreDefaults() {
        FindFilesPrefs.setExclusionFilter(FindFilesPrefs.getDefaultFilterList());
        FindFilesPrefs.setExclusionSelections(FindFilesPrefs.getDefaultFilterList());
        this.sExtItems.removeAllElements();
        this.getItems();
        this.fSorter.resetTableData(this.sExtItems);
        sTable.clearSelection();
    }

    private void removeSelectedRows() {
        int[] nArray = sTable.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.fSorter.removeRow(nArray[i]);
        }
        sTable.clearSelection();
    }

    private void addItemToTable() {
        String string = this.fAddText.getText();
        if (string.length() > 0) {
            int n;
            if (string.charAt(0) != '.') {
                string = ".".concat(string);
            }
            if ((n = this.getRowContainingExtName(string)) == -1) {
                this.fSorter.addRow(new ExtItem(string, true));
                n = this.getRowContainingExtName(string);
            }
            this.fAddText.setText(null);
            this.selectRow(n);
            this.scrollToExt(n);
        }
    }

    void selectRow(int n) {
        if (n != -1) {
            if (SwingUtilities.isEventDispatchThread()) {
                sTable.setRowSelectionInterval(n, n);
                sTable.setColumnSelectionInterval(0, 0);
            } else {
                SwingUtilities.invokeLater(new SelectRowsOnEventThread(n, n));
            }
        }
    }

    public int getRowContainingExtName(String string) {
        int n = sTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.fSorter.getValueAt(i, 1);
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void scrollToExt(int n) {
        Rectangle rectangle = sTable.getCellRect(n, 0, true);
        sTable.scrollRectToVisible(rectangle);
    }

    private void saveState() {
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        for (int i = 0; i < sTable.getRowCount(); ++i) {
            string = (String)sTable.getValueAt(i, 1);
            bl = (Boolean)sTable.getValueAt(i, 0);
            string2 = string2.concat(string + ";");
            if (!bl) continue;
            string3 = string3.concat(string + ";");
        }
        FindFilesPrefs.setExclusionFilter(string2);
        FindFilesPrefs.setExclusionSelections(string3);
    }

    public static void main(String[] stringArray) {
        MJFrame mJFrame = new MJFrame("Test");
        mJFrame.setSize(200, 100);
        mJFrame.setLocation(300, 300);
        mJFrame.setVisible(true);
        FileExtensionFilter fileExtensionFilter = new FileExtensionFilter((Frame)mJFrame);
        fileExtensionFilter.show();
    }

    static {
        OFF = new Boolean(false);
        ON = new Boolean(true);
    }

    private class SelectRowsOnEventThread
    implements Runnable {
        int fRowBegin;
        int fRowEnd;

        public SelectRowsOnEventThread(int n, int n2) {
            this.fRowBegin = n;
            this.fRowEnd = n2;
        }

        @Override
        public void run() {
            sTable.setRowSelectionInterval(this.fRowBegin, this.fRowEnd);
        }
    }

    class AddAction
    extends AbstractAction
    implements ActionListener {
        public AddAction() {
            super(sRes.getString("button.Add"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileExtensionFilter.this.addItemToTable();
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            super(sRes.getString("button.Help"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MLHelpServices.displayTopic((String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), (String)"matlab_env_findfiles_exlfilter");
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super(sRes.getString("button.OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileExtensionFilter.this.saveState();
            sThis.hide();
        }
    }

    class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(sRes.getString("button.Remove"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileExtensionFilter.this.removeSelectedRows();
        }
    }

    class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(sRes.getString("button.Restore"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileExtensionFilter.this.restoreDefaults();
        }
    }

    class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super(sRes.getString("button.SelectAll"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < FileExtensionFilter.this.fSorter.getRowCount(); ++i) {
                FileExtensionFilter.this.fSorter.setValueAt(ON, i, 0);
            }
        }
    }

    class ClearAllAction
    extends AbstractAction {
        public ClearAllAction() {
            super(sRes.getString("button.ClearAll"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < FileExtensionFilter.this.fSorter.getRowCount(); ++i) {
                FileExtensionFilter.this.fSorter.setValueAt(OFF, i, 0);
            }
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] icolumnNames;
        private Vector idata;

        public MyTableModel(Vector vector, String[] stringArray) {
            this.idata = vector;
            this.icolumnNames = stringArray;
        }

        @Override
        public int getColumnCount() {
            return this.icolumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.idata.size();
        }

        public void setData(Vector vector) {
            this.idata = vector;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return this.icolumnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((ExtItem)this.idata.elementAt(n)).getBooleanState();
            }
            return ((ExtItem)this.idata.elementAt(n)).getExtension();
        }

        public int addRow(ExtItem extItem) {
            this.idata.insertElementAt(extItem, this.getRowCount());
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
            return this.getRowCount();
        }

        public void removeRow(int n) {
            this.fireTableRowsDeleted(n, n);
            this.idata.removeElementAt(n);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ((ExtItem)this.idata.elementAt(n)).setState((Boolean)object);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }

    public static class ExtItem {
        private String iExt;
        private boolean iState;

        public ExtItem(String string, boolean bl) {
            this.iExt = string;
            this.iState = bl;
        }

        public String getExtension() {
            return this.iExt;
        }

        public boolean getState() {
            return this.iState;
        }

        void setState(boolean bl) {
            this.iState = bl;
        }

        public Boolean getBooleanState() {
            if (this.iState) {
                return ON;
            }
            return OFF;
        }
    }

    private static class MyTableSorter
    extends DefaultTableModel {
        protected MyTableModel tableModel;
        public static final int DESCENDING = -1;
        public static final int NOT_SORTED = 0;
        public static final int ASCENDING = 1;
        private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
        private int fSortCol = 0;
        private int fSortDir = 1;
        public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Comparable)object).compareTo(object2);
            }
        };
        public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        };
        private Row[] viewToModel;
        private int[] modelToView;
        private JTableHeader tableHeader;
        private TableModelListener tableModelListener;
        private Map columnComparators = new HashMap();
        private List sortingColumns = new ArrayList();

        public MyTableSorter() {
            this.tableModelListener = new TableModelHandler();
        }

        public MyTableSorter(MyTableModel myTableModel) {
            this();
            this.setTableModel(myTableModel);
        }

        public MyTableSorter(MyTableModel myTableModel, JTableHeader jTableHeader) {
            this();
            this.setTableHeader(jTableHeader);
            this.setTableModel(myTableModel);
        }

        private void clearSortingState() {
            this.viewToModel = null;
            this.modelToView = null;
        }

        public TableModel getTableModel() {
            return this.tableModel;
        }

        public void setTableModel(MyTableModel myTableModel) {
            if (this.tableModel != null) {
                this.tableModel.removeTableModelListener(this.tableModelListener);
            }
            this.tableModel = myTableModel;
            if (this.tableModel != null) {
                this.tableModel.addTableModelListener(this.tableModelListener);
            }
            this.clearSortingState();
            this.fireTableStructureChanged();
        }

        public JTableHeader getTableHeader() {
            return this.tableHeader;
        }

        public void setTableHeader(JTableHeader jTableHeader) {
            jTableHeader.addMouseListener(new MouseHandler());
            if (this.tableHeader != null) {
                this.tableHeader.setDefaultRenderer((TableCellRenderer)new SortedTableHeaderRenderer());
            }
            this.tableHeader = jTableHeader;
            if (this.tableHeader != null) {
                this.tableHeader.setDefaultRenderer((TableCellRenderer)new SortedTableHeaderRenderer());
            }
        }

        public boolean isSorting() {
            return this.sortingColumns.size() != 0;
        }

        private Directive getDirective(int n) {
            for (int i = 0; i < this.sortingColumns.size(); ++i) {
                Directive directive = (Directive)this.sortingColumns.get(i);
                if (directive.column != n) continue;
                return directive;
            }
            return EMPTY_DIRECTIVE;
        }

        public int getSortingStatus(int n) {
            return this.getDirective(n).direction;
        }

        private void sortingStatusChanged() {
            this.clearSortingState();
            this.fireTableDataChanged();
            if (this.tableHeader != null) {
                this.tableHeader.repaint();
            }
        }

        public void setSortingStatus(int n, int n2) {
            this.fSortCol = n;
            this.fSortDir = n2;
            Directive directive = this.getDirective(n);
            if (directive != EMPTY_DIRECTIVE) {
                this.sortingColumns.remove(directive);
            }
            if (n2 != 0) {
                this.sortingColumns.add(new Directive(n, n2));
            }
            this.sortingStatusChanged();
        }

        private void cancelSorting() {
            this.sortingColumns.clear();
            this.sortingStatusChanged();
        }

        public void setColumnComparator(Class clazz, Comparator comparator) {
            if (comparator == null) {
                this.columnComparators.remove(clazz);
            } else {
                this.columnComparators.put(clazz, comparator);
            }
        }

        protected Comparator getComparator(int n) {
            Class clazz = this.tableModel.getColumnClass(n);
            Comparator comparator = (Comparator)this.columnComparators.get(clazz);
            if (comparator != null) {
                return comparator;
            }
            if (Comparable.class.isAssignableFrom(clazz)) {
                return COMPARABLE_COMAPRATOR;
            }
            return LEXICAL_COMPARATOR;
        }

        private Row[] getViewToModel() {
            if (this.viewToModel == null || this.viewToModel.length > this.tableModel.getRowCount()) {
                int n = this.tableModel.getRowCount();
                this.viewToModel = new Row[n];
                for (int i = 0; i < n; ++i) {
                    this.viewToModel[i] = new Row(i);
                }
                if (this.isSorting()) {
                    Arrays.sort(this.viewToModel);
                }
            }
            return this.viewToModel;
        }

        public int modelIndex(int n) {
            return this.getViewToModel()[n].modelIndex;
        }

        private int[] getModelToView() {
            if (this.modelToView == null) {
                int n = this.getViewToModel().length;
                this.modelToView = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.modelToView[this.modelIndex((int)i)] = i;
                }
            }
            return this.modelToView;
        }

        @Override
        public int getRowCount() {
            return this.tableModel == null ? 0 : this.tableModel.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            return this.tableModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.tableModel.getColumnClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.tableModel.isCellEditable(this.modelIndex(n), n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.tableModel.getValueAt(this.modelIndex(n), n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.tableModel.setValueAt(object, this.modelIndex(n), n2);
        }

        public int addRow(ExtItem extItem) {
            this.clearSortingState();
            int n = this.tableModel.addRow(extItem);
            return n;
        }

        @Override
        public void removeRow(int n) {
            this.clearSortingState();
            if (n >= 0) {
                this.tableModel.removeRow(this.modelIndex(n));
            }
        }

        public void resetTableData(Vector vector) {
            this.clearSortingState();
            this.tableModel.setData(vector);
        }

        private static class Directive {
            private int column;
            private int direction;

            public Directive(int n, int n2) {
                this.column = n;
                this.direction = n2;
            }
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (n2 != -1 && (n = tableColumnModel.getColumn(n2).getModelIndex()) == 0) {
                    if (sTable.getCheckState() == 1 || sTable.getCheckState() == 0) {
                        sTable.uncheckAll();
                    } else {
                        sTable.checkAll();
                    }
                }
            }
        }

        private class TableModelHandler
        implements TableModelListener {
            private TableModelHandler() {
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (!MyTableSorter.this.isSorting()) {
                    MyTableSorter.this.clearSortingState();
                    MyTableSorter.this.fireTableChanged(tableModelEvent);
                    return;
                }
                if (tableModelEvent.getFirstRow() == -1) {
                    MyTableSorter.this.cancelSorting();
                    MyTableSorter.this.fireTableChanged(tableModelEvent);
                    return;
                }
                int n = tableModelEvent.getColumn();
                if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n != -1 && MyTableSorter.this.getSortingStatus(n) == 0 && MyTableSorter.this.modelToView != null) {
                    int n2 = MyTableSorter.this.getModelToView()[tableModelEvent.getFirstRow()];
                    MyTableSorter.this.fireTableChanged(new TableModelEvent(MyTableSorter.this, n2, n2, n, tableModelEvent.getType()));
                    return;
                }
                MyTableSorter.this.fireTableDataChanged();
            }
        }

        private class Row
        implements Comparable {
            private int modelIndex;

            public Row(int n) {
                this.modelIndex = n;
            }

            public int compareTo(Object object) {
                int n = this.modelIndex;
                int n2 = ((Row)object).modelIndex;
                for (Directive directive : MyTableSorter.this.sortingColumns) {
                    int n3 = directive.column;
                    Object object2 = MyTableSorter.this.tableModel.getValueAt(n, n3);
                    Object object3 = MyTableSorter.this.tableModel.getValueAt(n2, n3);
                    if (n3 != 0) {
                        object2 = object2.toString().toLowerCase();
                        object3 = object3.toString().toLowerCase();
                    }
                    int n4 = 0;
                    n4 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : MyTableSorter.this.getComparator(n3).compare(object2, object3)));
                    if (n4 == 0) continue;
                    return directive.direction == -1 ? -n4 : n4;
                }
                return 0;
            }
        }
    }

    private class MyTable
    extends MJTable {
        private int iCheckState;
        static final int MIXED = 0;
        static final int ALL = 1;
        static final int NONE = 2;

        MyTable(MyTableSorter myTableSorter) {
            super((TableModel)myTableSorter);
            this.iCheckState = 0;
        }

        public int getSortColumn() {
            for (int i = 0; i < FileExtensionFilter.this.fSorter.getColumnCount(); ++i) {
                if (FileExtensionFilter.this.fSorter.getSortingStatus(i) == 0) continue;
                return i;
            }
            return -1;
        }

        public int getSortDirection() {
            return FileExtensionFilter.this.fSorter.getSortingStatus(this.getSortColumn());
        }

        int getCheckState() {
            return this.iCheckState;
        }

        void setCheckState(int n) {
            this.iCheckState = n;
        }

        void checkAll() {
            for (int i = 0; i < FileExtensionFilter.this.fSorter.getRowCount(); ++i) {
                FileExtensionFilter.this.fSorter.setValueAt(ON, i, 0);
            }
            this.setCheckState(1);
        }

        void uncheckAll() {
            for (int i = 0; i < FileExtensionFilter.this.fSorter.getRowCount(); ++i) {
                FileExtensionFilter.this.fSorter.setValueAt(OFF, i, 0);
            }
            this.setCheckState(2);
        }
    }
}

