/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mde.explorer.Explorer;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.model.actions.TableActionInput;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarMode;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JComponent;

public final class NavigationActionProvider
implements ActionProvider {
    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        ActionConfiguration actionConfiguration = actionRegistry.getAction(CoreActionID.CD_TO_LOCATION);
        actionConfiguration.setEnabled(ActionPredicates.and((Predicate[])new Predicate[]{ActionPredicates.SINGLE_SELECTION, ActionPredicates.NO_DIRECTORIES, ActionPredicates.IN_SEARCH_MODE, ActionPredicates.NOT_ALL_IN_CURRENT_DIRECTORY, ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS}));
        actionConfiguration.setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileLocation fileLocation = ((FileSystemEntry)actionInput.getSelection().get(0)).getLocation().getParent();
                NavigationActionProvider.this.cancelSearch();
                MatlabPath.setCurrentDirectory((File)fileLocation.toFile());
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration2 = actionRegistry.getAction(CoreActionID.BACK);
        actionConfiguration2.setVisibleOnContextMenu(ActionConfiguration.ALWAYS);
        actionConfiguration2.setEnabled((Predicate)ActionPredicates.HAS_PREVIOUS_LOCATION);
        actionConfiguration2.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return NavigationActionProvider.this.runBack(actionInput);
            }
        });
        ActionConfiguration actionConfiguration3 = actionRegistry.getAction(CoreActionID.BACK_NO_TEXT);
        actionConfiguration3.setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionConfiguration3.setEnabled((Predicate)ActionPredicates.HAS_PREVIOUS_LOCATION);
        actionConfiguration3.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return NavigationActionProvider.this.runBack(actionInput);
            }
        });
        ActionConfiguration actionConfiguration4 = actionRegistry.getAction(CoreActionID.FORWARD);
        actionConfiguration4.setEnabled((Predicate)ActionPredicates.HAS_NEXT_LOCATION);
        actionConfiguration4.setVisibleOnContextMenu(ActionConfiguration.ALWAYS);
        actionConfiguration4.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return NavigationActionProvider.this.runForward(actionInput);
            }
        });
        ActionConfiguration actionConfiguration5 = actionRegistry.getAction(CoreActionID.FORWARD_NO_TEXT);
        actionConfiguration5.setEnabled((Predicate)ActionPredicates.HAS_NEXT_LOCATION);
        actionConfiguration5.setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionConfiguration5.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return NavigationActionProvider.this.runForward(actionInput);
            }
        });
        ActionConfiguration actionConfiguration6 = actionRegistry.getAction(CoreActionID.UP_ONE_LEVEL);
        actionConfiguration6.setEnabled((Predicate)ActionPredicates.HAS_PARENT_LOCATION);
        actionConfiguration6.setVisibleOnContextMenu(ActionConfiguration.ALWAYS);
        actionConfiguration6.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                NavigationActionProvider.this.cancelSearch();
                MatlabPath.setCurrentDirectory((File)actionInput.getLocation().getLocation().getParent().toFile());
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration7 = actionRegistry.getAction(CoreActionID.UP_ONE_LEVEL_NO_TEXT);
        actionConfiguration7.setEnabled((Predicate)ActionPredicates.HAS_PARENT_LOCATION);
        actionConfiguration7.setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionConfiguration7.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                NavigationActionProvider.this.cancelSearch();
                MatlabPath.setCurrentDirectory((File)actionInput.getLocation().getLocation().getParent().toFile());
                return Status.COMPLETED;
            }
        });
    }

    private Status runForward(ActionInput actionInput) {
        FileTable fileTable = ((TableActionInput)actionInput).getTable();
        FileLocation fileLocation = fileTable.getContext().getNextLocation();
        FileSystem fileSystem = fileTable.getContext().getSystem();
        this.cancelSearch();
        if (fileLocation != null) {
            boolean bl = false;
            if (fileSystem.exists(fileLocation)) {
                try {
                    fileTable.getContext().setLocation(fileTable.getContext().getNextLocation());
                    bl = true;
                }
                catch (InvalidLocationException invalidLocationException) {
                    // empty catch block
                }
            }
            if (!bl) {
                NavigationActionProvider.error((JComponent)fileTable, "backForward.error", "backForward.error.title", fileLocation.toString());
            }
        }
        return Status.COMPLETED;
    }

    private Status runBack(ActionInput actionInput) {
        FileTable fileTable = ((TableActionInput)actionInput).getTable();
        FileLocation fileLocation = fileTable.getContext().getLastLocation();
        FileSystem fileSystem = fileTable.getContext().getSystem();
        this.cancelSearch();
        if (fileLocation != null) {
            boolean bl = false;
            if (fileSystem.exists(fileLocation)) {
                try {
                    fileTable.getContext().goBack();
                    bl = true;
                }
                catch (InvalidLocationException invalidLocationException) {
                    // empty catch block
                }
            }
            if (!bl) {
                NavigationActionProvider.error(actionInput.getComponent(), "backForward.error", "backForward.error.title", fileLocation.toString());
            }
        }
        return Status.COMPLETED;
    }

    private void cancelSearch() {
        if (Explorer.getInstance().getAddressBar().getMode().equals((Object)AddressBarMode.SEARCH_MODE)) {
            Explorer.getInstance().getAddressBar().setMode(Explorer.getInstance().getAddressBar().getDefaultMode());
        }
    }

    private static void error(JComponent jComponent, String string, String string2, Object ... objectArray) {
        MJOptionPane.showMessageDialog((Component)jComponent, (Object)MessageFormat.format(ExplorerResources.getString((String)string), objectArray), (String)ExplorerResources.getString((String)string2), (int)0);
    }
}

