/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.embeddedoutputs.variables;

import com.mathworks.mde.embeddedoutputs.outputhandlers.VariableOutputData;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.util.Log;
import java.util.ArrayList;

public final class VariableManager {
    private static final String CLOSE_VARIABLES_FUNCTION = "matlab.internal.editor.VariableManager.closeVariablesForEditor";
    private static final String CLOSE_ALL_VARIABLES_FUNCTION = "matlab.internal.editor.VariableManager.closeAllVariables";
    private static final String OPEN_VARIABLE_FUNCTION = "matlab.internal.editor.VariableManager.openVariable";
    private final String fUniqueId;
    private final MVM fMvm;

    public VariableManager(String string, MVM mVM) {
        this.fMvm = mVM;
        this.fUniqueId = string;
    }

    public void closeVariables(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.fUniqueId, arrayList.toArray(new String[arrayList.size()])};
        FutureFevalResult<Object> futureFevalResult = this.callFunctionUsingMVM(objectArray, CLOSE_VARIABLES_FUNCTION, 0);
        try {
            futureFevalResult.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (MvmExecutionException mvmExecutionException) {
            Log.logException((Exception)((Object)mvmExecutionException));
        }
    }

    public VariableOutputData openVariable(String string, double[][] dArray, String string2) {
        if (string2 != null) {
            string2 = string2.split("\\*")[0];
        }
        Object[] objectArray = new Object[]{this.fUniqueId, string, dArray, string2};
        VariableOutputData variableOutputData = null;
        FutureFevalResult<Object> futureFevalResult = this.callFunctionUsingMVM(objectArray, OPEN_VARIABLE_FUNCTION, 3);
        try {
            Object[] objectArray2 = (Object[])futureFevalResult.get();
            variableOutputData = new VariableOutputData(string, objectArray2[1].toString(), (String)objectArray2[0], ((boolean[])objectArray2[2])[0]);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (MvmExecutionException mvmExecutionException) {
            Log.logException((Exception)((Object)mvmExecutionException));
        }
        return variableOutputData;
    }

    private void closeAllVariables() {
        Object[] objectArray = new Object[]{this.fUniqueId};
        FutureFevalResult<Object> futureFevalResult = this.callFunctionUsingMVM(objectArray, CLOSE_ALL_VARIABLES_FUNCTION, 0);
        try {
            futureFevalResult.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (MvmExecutionException mvmExecutionException) {
            Log.logException((Exception)((Object)mvmExecutionException));
        }
    }

    private FutureFevalResult<Object> callFunctionUsingMVM(Object[] objectArray, String string, int n) {
        MatlabExecutor matlabExecutor = this.fMvm.getExecutor();
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest(string, Integer.valueOf(n), objectArray);
        return matlabExecutor.submit(matlabFevalRequest);
    }

    public void dispose() {
        this.closeAllVariables();
    }
}

