/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.embeddedoutputs.figures;

import com.mathworks.mde.embeddedoutputs.OutputDataType;
import com.mathworks.mde.embeddedoutputs.figures.FigureData;
import com.mathworks.mde.embeddedoutputs.figures.ImageUtilities;
import com.mathworks.mde.embeddedoutputs.outputhandlers.FigureOutputData;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.util.Log;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public final class FigureManager {
    private static final String ENABLE_CAPTURE_FIGURES_FUNCTION = "matlab.internal.editor.FigureManager.enableCaptureFigures";
    private static final String DISABLE_CAPTURE_FIGURES_FUNCTION = "matlab.internal.editor.FigureManager.disableCaptureFigures";
    private static final String SNAPSHOT_FIGURES_FUNCTION = "matlab.internal.editor.FigureManager.snapshotFigures";
    private static final String COMPARE_FIGURES_FUNCTION = "matlab.internal.editor.FigureManager.compareFigures";
    private static final String CLOSE_FIGURES_FUNCTION = "matlab.internal.editor.FigureManager.closeAllEditorFigures";
    private static final String CLOSE_FIGURES_ENABLE_CAPTURE_FUNCTION = "matlab.internal.editor.FigureManager.closeAllFiguresAndEnableCapture";
    private static final String POST_EVALUATION_WORK_FUNCTION = "matlab.internal.editor.EvaluationManager.postEvalWork";
    private final String fUniqueId;
    private final MVM fMvm;

    public FigureManager(String string, MVM mVM) {
        this.fMvm = mVM;
        this.fUniqueId = string;
    }

    public void closeFiguresAndEnableCapture() {
        Object[] objectArray = new Object[]{this.fUniqueId};
        this.evalFunctionHelper(CLOSE_FIGURES_ENABLE_CAPTURE_FUNCTION, objectArray);
    }

    public void closeFigures() {
        Object[] objectArray = new Object[]{this.fUniqueId};
        this.evalFunctionHelper(CLOSE_FIGURES_FUNCTION, objectArray);
    }

    public void enableCaptureFigures() {
        Object[] objectArray = new Object[]{this.fUniqueId};
        this.evalFunctionHelper(ENABLE_CAPTURE_FIGURES_FUNCTION, objectArray);
    }

    public void disableCaptureFigures() {
        Object[] objectArray = new Object[]{this.fUniqueId};
        this.evalFunctionHelper(DISABLE_CAPTURE_FIGURES_FUNCTION, objectArray);
    }

    public void snapshotFigures() {
        this.evalFunctionHelper(SNAPSHOT_FIGURES_FUNCTION);
    }

    public List<OutputDataType> getFigureChangesAndSaveState(int n, boolean bl) {
        List<FigureData> list = this.getFigureChangesSinceSnapshotFromMatlab(n + 1, bl);
        return this.getFigureChangesMessages(list);
    }

    public List<OutputDataType> getFigureChangesMessages(List<FigureData> list) {
        ArrayList<OutputDataType> arrayList = new ArrayList<OutputDataType>();
        for (FigureData figureData : list) {
            BufferedImage bufferedImage = ImageUtilities.getBufferedImageFromFigureData(figureData);
            FigureOutputData figureOutputData = new FigureOutputData(figureData.getFigureId(), bufferedImage, figureData.getOriginalRegionNumber());
            arrayList.add(new OutputDataType("figure", figureOutputData));
        }
        return arrayList;
    }

    private List<FigureData> getFigureChangesSinceSnapshotFromMatlab(int n, boolean bl) {
        Object[] objectArray;
        Object[] objectArray2;
        MatlabExecutor matlabExecutor = this.fMvm.getExecutor();
        Object[] objectArray3 = new Object[]{this.fUniqueId, n, bl};
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest(POST_EVALUATION_WORK_FUNCTION, Integer.valueOf(1), objectArray3);
        FutureFevalResult futureFevalResult = matlabExecutor.submit(matlabFevalRequest);
        ArrayList<FigureData> arrayList = new ArrayList<FigureData>();
        try {
            objectArray2 = (Object[])futureFevalResult.get();
        }
        catch (InterruptedException interruptedException) {
            return arrayList;
        }
        catch (MvmExecutionException mvmExecutionException) {
            Log.logException((Exception)((Object)mvmExecutionException));
            return arrayList;
        }
        for (Object object : objectArray = (Object[])objectArray2[1]) {
            arrayList.add(new FigureData(object));
        }
        return arrayList;
    }

    private void evalFunctionHelper(String string) {
        Object[] objectArray = new Object[]{this.fUniqueId};
        this.evalFunctionHelper(string, objectArray);
    }

    private void evalFunctionHelper(String string, Object[] objectArray) {
        MatlabExecutor matlabExecutor = this.fMvm.getExecutor();
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest(string, Integer.valueOf(0), objectArray);
        FutureFevalResult futureFevalResult = matlabExecutor.submit(matlabFevalRequest);
        try {
            futureFevalResult.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (MvmExecutionException mvmExecutionException) {
            Log.logException((Exception)((Object)mvmExecutionException));
        }
    }
}

