/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.jmi.tabcompletion.TabCompletion;
import com.mathworks.jmi.tabcompletion.TabCompletionImpl;
import com.mathworks.jmi.tabcompletion.TabCompletionResults;
import com.mathworks.services.editordataservice.Document;
import com.mathworks.services.editordataservice.EditorFeature;
import com.mathworks.services.editordataservice.EditorNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TabCompletionFeature
extends EditorFeature {
    private Document fDocument;
    private final TabCompletion fTabCompletion = new TabCompletionImpl();
    private static final int TIMEOUT = 5;

    public TabCompletionFeature(EditorNode editorNode) {
        super(editorNode);
        this.registerResponseHandler();
    }

    public void documentChanged(Document document) {
        this.fDocument = document;
    }

    public String getFeatureId() {
        return "matlab.code.tabcompletion";
    }

    private void registerResponseHandler() {
        EditorFeature.FeatureResponse featureResponse = new EditorFeature.FeatureResponse(){

            public Map<String, Object> handle(Map<String, Object> map) {
                Map map2;
                try {
                    map2 = TabCompletionFeature.this.getTabCompletionResults(map);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
                return map2;
            }
        };
        this.registerFeatureResponseHandler(featureResponse);
    }

    private Map<String, Object> getTabCompletionResults(Map<String, Object> map) throws InterruptedException, ExecutionException, TimeoutException {
        TabCompletionResults tabCompletionResults = (TabCompletionResults)this.fTabCompletion.getCompletions(this.getCodeFromMessage(map), this.getCursorFromMessage(map)).get(5L, TimeUnit.MINUTES);
        Map<String, Object> map2 = this.createTabCompletionResults(map, tabCompletionResults);
        return map2;
    }

    private Map<String, Object> createTabCompletionResults(Map<String, Object> map, TabCompletionResults tabCompletionResults) {
        List list = tabCompletionResults.getStrings();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("results", list);
        hashMap.put("requestId", this.getRequestIdFromMessage(map));
        return hashMap;
    }

    private String getCodeFromMessage(Map<String, Object> map) {
        return (String)map.get("document");
    }

    private int getCursorFromMessage(Map<String, Object> map) {
        return ((Double)map.get("cursor")).intValue();
    }

    private String getRequestIdFromMessage(Map<String, Object> map) {
        return (String)map.get("requestId");
    }
}

