/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mde.editor.plugins.matlab.ConfigurationPopupMenuCustomizer;
import com.mathworks.mde.editor.plugins.matlab.EditorSaveRunAndPublishUtils;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationSelectionListener;
import com.mathworks.services.mlx.MlxFileUtils;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.FutureFileStorageLocation;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.io.File;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Nullable;
import org.netbeans.editor.BaseDocument;

public class MatlabPluginUtils {
    private static final String FUNCTION_KEYWORD = "function";

    private MatlabPluginUtils() {
    }

    public static void goToFunction(Editor editor, String string, String string2) {
        int n = MDocumentUtils.getFunctionLineNumber((BaseDocument)((BaseDocument)editor.getDocument()), (String)string);
        if (n >= 0) {
            editor.goToLine(n + 1, false);
        } else {
            String string3 = MatlabPluginUtils.getCommentPrefix(string2) + FUNCTION_KEYWORD + " " + string + "\n";
            editor.appendText(string3);
            editor.setCaretPosition(editor.getLength());
        }
    }

    private static String getCommentPrefix(String string) {
        return string == null ? "\n\n%------------------------------------------------------\n" : "\n\n" + string + "\n";
    }

    public static void executeDefaultConfiguration(Editor editor, AbstractFileConfiguration.Type<?> type) {
        MatlabPluginUtils.executeDefaultConfiguration(editor, type, null);
    }

    public static void executeDefaultConfiguration(Editor editor, AbstractFileConfiguration.Type<?> type, @Nullable MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        AbstractFileConfiguration abstractFileConfiguration = null;
        if (StorageLocationUtils.isBackedByFile((StorageLocation)editor.getStorageLocation())) {
            abstractFileConfiguration = ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(MatlabPluginUtils.getBackingFile(editor), type);
        }
        EditorSaveRunAndPublishUtils.saveFileAndDoConfigurationAction(editor, abstractFileConfiguration, type, matlabExecutionErrorHandler);
    }

    static void assertIsOrWillBeBackedByFile(Editor editor) {
        assert (StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)editor.getStorageLocation())) : "This method should only be called for file-based Editors.";
    }

    public static File getBackingFile(Editor editor) {
        assert (editor.getStorageLocation() instanceof FileStorageLocation) : "The given Editor is not using a FileStorageLocation: " + editor.getStorageLocation();
        return ((FileStorageLocation)editor.getStorageLocation()).getFile();
    }

    public static boolean isMatlabCodeFileOrBuffer(Editor editor) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        boolean bl = editor.getLanguage() instanceof MLanguage;
        boolean bl2 = editor.getStorageLocation() instanceof FutureFileStorageLocation;
        return bl && (bl2 || MatlabPluginUtils.isFileEndingWithMatlabExtension(editor));
    }

    public static boolean isMatlabCodeFile(Editor editor) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        return editor.getLanguage() instanceof MLanguage && MatlabPluginUtils.isFileEndingWithMatlabExtension(editor);
    }

    private static boolean isFileEndingWithMatlabExtension(Editor editor) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        boolean bl = false;
        if (editor.getStorageLocation() instanceof FileStorageLocation) {
            String string = ((FileStorageLocation)editor.getStorageLocation()).getFile().getName();
            bl = MLFileUtils.isMFile((String)string) || MlxFileUtils.isMlxFile((String)string);
        }
        return bl;
    }

    public static ConfigurationPopupMenuCustomizer createMenuCustomizer(final Editor editor, final AbstractFileConfiguration.Type<?> type) {
        return new ConfigurationPopupMenuCustomizer(editor, new ConfigurationSelectionListener(){

            public void configurationSelected(AbstractFileConfiguration abstractFileConfiguration) {
                EditorSaveRunAndPublishUtils.saveFileAndDoConfigurationAction(editor, abstractFileConfiguration, type, null);
            }
        }, type);
    }

    public static void runUntilCursor(Editor editor) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        MatlabPluginUtils.assertIsOrWillBeBackedByFile(editor);
        int n = DocumentUtils.getLineNumberFromPosition((BaseDocument)((BaseDocument)editor.getDocument()), (int)editor.getCaretPosition());
        MatlabBreakpointUtils.runUntil(n, MatlabPluginUtils.getBackingFile(editor), MatlabBreakpointUtils.getDebugger());
    }
}

