/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.debug.DebugListener;
import com.mathworks.mde.editor.breakpoints.DebugAdapter;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mde.editor.breakpoints.MatlabDebugger;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerModelManagers;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MatlabBreakpointMessageService {
    private static MatlabBreakpointMessageService sInstance;
    private final MatlabDebugger fDebugger;
    private final MessageService fMessageService;
    private final Subscriber fAddBreakpointRequestSubscriber = this.createAddBreakpointRequestSubscriber();
    private final Subscriber fRemoveBreakpointRequestSubscriber = this.createRemoveBreakpointRequestSubscriber();
    private final Subscriber fGetBreakpointsRequestSubscriber = this.createGetBreakpointsRequestSubscriber();
    private final DebugListener<MatlabBreakpoint> fMatlabBreakpointsListener = this.createMatlabBreakpointsListener();
    private final PeerModelManager fBreakpointsDataStore;
    public static final String BREAKPOINT_ADD_REQUEST = "/editor/breakpoints/addBreakpointsRequest";
    public static final String BREAKPOINT_REMOVE_REQUEST = "/editor/breakpoints/removeBreakpointsRequest";
    public static final String GET_BREAKPOINTS_REQUEST = "/editor/breakpoints/getBreakpoints";
    public static final String BREAKPOINT_ADDED = "/editor/breakpoint/breakpointsAdded";
    public static final String BREAKPOINT_REMOVED = "/editor/breakpoint/breakpointsRemoved";
    public static final String BREAKPOINTS_CLEARED = "/editor/breakpoint/breakpointsCleared";
    public static final String BREAKPOINTS_FILE_REFRESHED = "/editor/breakpoint/breakpointsFileRefreshed";
    public static final String BREAKPOINTS_ERRORED = "/editor/breakpoint/breakpointsErrored";

    public MatlabBreakpointMessageService(MatlabDebugger matlabDebugger, MessageService messageService) {
        this.fDebugger = matlabDebugger;
        this.fMessageService = messageService;
        this.fBreakpointsDataStore = PeerModelManagers.getInstance((String)"/matlabbreakpointsdatastore");
        this.initializeBreakpointDataStore();
        this.initializeListeners();
    }

    private void initializeBreakpointDataStore() {
        if (!this.fBreakpointsDataStore.hasRoot()) {
            this.fBreakpointsDataStore.setRoot("matlab_editor_breakpoint_store");
        }
        this.fBreakpointsDataStore.setSyncEnabled(true);
    }

    private MatlabBreakpointMessageService() {
        this(MatlabBreakpointUtils.getDebugger(), MessageServiceFactory.getMessageService());
    }

    public static MatlabBreakpointMessageService getInstance() {
        if (sInstance == null) {
            sInstance = new MatlabBreakpointMessageService();
        }
        return sInstance;
    }

    private void initializeListeners() {
        this.fMessageService.subscribe(BREAKPOINT_ADD_REQUEST, this.fAddBreakpointRequestSubscriber);
        this.fMessageService.subscribe(BREAKPOINT_REMOVE_REQUEST, this.fRemoveBreakpointRequestSubscriber);
        this.fMessageService.subscribe(GET_BREAKPOINTS_REQUEST, this.fGetBreakpointsRequestSubscriber);
        this.fDebugger.addDebugListener(this.fMatlabBreakpointsListener);
        this.fMessageService.publish(BREAKPOINTS_CLEARED, (Object)"");
    }

    public void dispose() {
        this.fMessageService.unsubscribe(BREAKPOINT_ADD_REQUEST, this.fAddBreakpointRequestSubscriber);
        this.fMessageService.unsubscribe(BREAKPOINT_REMOVE_REQUEST, this.fRemoveBreakpointRequestSubscriber);
        this.fMessageService.unsubscribe(GET_BREAKPOINTS_REQUEST, this.fGetBreakpointsRequestSubscriber);
        this.fDebugger.removeDebugListener(this.fMatlabBreakpointsListener);
    }

    public DebugListener<MatlabBreakpoint> getBreakpointListener() {
        return this.fMatlabBreakpointsListener;
    }

    private void clearAndSetBreakpoints(String string, Object[] objectArray) {
        ArrayList<MatlabBreakpoint> arrayList = new ArrayList<MatlabBreakpoint>();
        for (Object object : objectArray) {
            Map map = (Map)object;
            int n = ((Double)map.get("zeroBasedLineNumber")).intValue();
            arrayList.add(MatlabBreakpoint.create(n, new File(string)));
        }
        if (!arrayList.isEmpty()) {
            this.fDebugger.clearAndSet(arrayList, new File(string), this.errorHandlerCompletionObserver());
        }
    }

    private DebugAdapter<MatlabBreakpoint> createMatlabBreakpointsListener() {
        return new DebugAdapter<MatlabBreakpoint>(){

            @Override
            public void breakpointsAdded(Collection<MatlabBreakpoint> collection) {
                List<Map<String, Object>> list = this.convertBreakpointsToServerMessages(collection);
                MatlabBreakpointMessageService.this.fMessageService.publish(MatlabBreakpointMessageService.BREAKPOINT_ADDED, list);
            }

            private List<Map<String, Object>> convertBreakpointsToServerMessages(Collection<MatlabBreakpoint> collection) {
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (MatlabBreakpoint matlabBreakpoint : collection) {
                    arrayList.add(MatlabBreakpointMessageService.this.createMatlabBreakpointDO(matlabBreakpoint));
                }
                return arrayList;
            }

            @Override
            public void breakpointsRemoved(Collection<MatlabBreakpoint> collection) {
                List<Map<String, Object>> list = this.convertBreakpointsToServerMessages(collection);
                MatlabBreakpointMessageService.this.fMessageService.publish(MatlabBreakpointMessageService.BREAKPOINT_REMOVED, list);
            }

            @Override
            public void breakpointsCleared() {
                MatlabBreakpointMessageService.this.fMessageService.publish(MatlabBreakpointMessageService.BREAKPOINTS_CLEARED, new HashMap());
            }
        };
    }

    private Subscriber createGetBreakpointsRequestSubscriber() {
        return new Subscriber(){

            public void handle(Message message) {
                DisposableList<MatlabBreakpoint> disposableList = MatlabBreakpointMessageService.this.fDebugger.getBreakpoints(new File((String)message.getData()));
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (MatlabBreakpoint matlabBreakpoint : disposableList) {
                    arrayList.add(MatlabBreakpointMessageService.this.createMatlabBreakpointDO(matlabBreakpoint));
                }
                MatlabBreakpointMessageService.this.fMessageService.publish(MatlabBreakpointMessageService.BREAKPOINT_ADDED, arrayList);
            }
        };
    }

    public Map<String, Object> createMatlabBreakpointDO(MatlabBreakpoint matlabBreakpoint) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("zeroBasedLineNumber", matlabBreakpoint.getZeroBasedLineNumber());
        hashMap.put("fileName", matlabBreakpoint.getFile().getAbsolutePath());
        hashMap.put("expression", matlabBreakpoint.getExpression());
        hashMap.put("isEnabled", matlabBreakpoint.isEnabled());
        hashMap.put("anonymousIndex", matlabBreakpoint.getAnonymousIndex());
        return hashMap;
    }

    private Subscriber createRemoveBreakpointRequestSubscriber() {
        return new Subscriber(){

            public void handle(Message message) {
                String string = MatlabBreakpointMessageService.this.getFileNameFromClientMessage(message);
                int n = MatlabBreakpointMessageService.getLineNumberFromClientMessage(message);
                MatlabBreakpoint matlabBreakpoint = MatlabBreakpoint.create(n, new File(string));
                MatlabBreakpointMessageService.this.fDebugger.clearBreakpoint(matlabBreakpoint);
            }
        };
    }

    private static int getLineNumberFromClientMessage(Message message) {
        return ((Double)((Map)message.getData()).get("zeroBasedLineNumber")).intValue();
    }

    private String getFileNameFromClientMessage(Message message) {
        return (String)((Map)message.getData()).get("fileName");
    }

    private Subscriber createAddBreakpointRequestSubscriber() {
        return new Subscriber(){

            public void handle(Message message) {
                String string = MatlabBreakpointMessageService.this.getFileNameFromClientMessage(message);
                int n = MatlabBreakpointMessageService.getLineNumberFromClientMessage(message);
                MatlabBreakpoint matlabBreakpoint = MatlabBreakpoint.create(n, new File(string));
                MatlabBreakpointMessageService.this.fDebugger.setBreakpoint(matlabBreakpoint, MatlabBreakpointMessageService.this.errorHandlerCompletionObserver());
            }
        };
    }

    private CompletionObserver errorHandlerCompletionObserver() {
        return new CompletionObserver(){

            public void completed(int n, Object object) {
                if (!MatlabBreakpointMessageService.this.isExecutionStatusSuccess(n)) {
                    MatlabBreakpointMessageService.this.fMessageService.publish(MatlabBreakpointMessageService.BREAKPOINTS_ERRORED, object);
                }
            }
        };
    }

    private boolean isExecutionStatusSuccess(int n) {
        return Matlab.getExecutionStatus((int)n) == 0;
    }

    public void synchronizeBreakpoints(File file) {
        String string;
        PeerNode peerNode = this.fBreakpointsDataStore.getRoot();
        Map map = (Map)peerNode.getProperty(string = file.getAbsolutePath());
        if (map == null) {
            return;
        }
        Object[] objectArray = (Object[])map.get("breakpoints");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fileName", string);
        if (objectArray.length == 0) {
            this.fMessageService.publish(BREAKPOINTS_FILE_REFRESHED, hashMap);
            return;
        }
        this.refreshMatlabCacheForFile(file);
        this.fMessageService.publish(BREAKPOINTS_FILE_REFRESHED, hashMap);
        this.clearAndSetBreakpoints(string, objectArray);
    }

    private void refreshMatlabCacheForFile(File file) {
        MatlabPath.callFSChange((File)file);
        MatlabPath.clearFunction((File)file);
    }
}

