/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.event.ListEventListener;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.debug.BreakpointMarginPopUpMenu;
import com.mathworks.matlab.api.debug.BreakpointModel;
import com.mathworks.matlab.api.debug.BreakpointUiInfoProvider;
import com.mathworks.matlab.api.debug.ContextMenuListener;
import com.mathworks.matlab.api.debug.DebugListener;
import com.mathworks.matlab.api.debug.ViewProviderKey;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.actions.DebuggerActions;
import com.mathworks.mde.editor.breakpoints.BreakpointDialogs;
import com.mathworks.mde.editor.breakpoints.BreakpointInstallationResult;
import com.mathworks.mde.editor.breakpoints.DebugAdapter;
import com.mathworks.mde.editor.breakpoints.EditAllBreakpointsDialog;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointMargin;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUiInfoProvider;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointViewPopupBuilder;
import com.mathworks.mde.editor.breakpoints.MatlabDebugger;
import com.mathworks.mlwidgets.debug.DebugActions;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.SyntaxTextPaneMultiView;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.editor.breakpoints.BreakpointView;
import com.mathworks.widgets.glazedlists.DisposableList;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.mcode.AbstractMBreakpointMargin;
import com.mathworks.widgets.text.mcode.CmdManager;
import java.io.File;
import java.util.Collection;
import org.apache.commons.lang.Validate;

class MatlabBreakpointMarginImpl
extends AbstractMBreakpointMargin<MatlabBreakpoint>
implements MatlabBreakpointMargin {
    private final File fFile;
    private final DebugActions.ClearBkptListener fClearBreakpointsListener = this.createClearBreakpointListener();
    private final ListEventListener<MatlabBreakpoint> fLiveBreakpointsListener = this.createBreakpointsRepaintListener();
    private BreakpointInstallationResult fLastBreakpointInstallationResult;
    private final MatlabDebugger fDebugger;
    private final DisposableList<MatlabBreakpoint> fLiveBreakpoints;
    private final DebugListener<MatlabBreakpoint> fDebugListener = this.createDebugListener();
    private DebuggerManager.DebuggerManagerStateListener fDebuggerManagerStateListener = this.createDebuggerManagerStateListener();

    MatlabBreakpointMarginImpl(Editor editor, SyntaxTextPaneMultiView syntaxTextPaneMultiView) {
        super(editor, syntaxTextPaneMultiView, new CmdManager((STPInterface)syntaxTextPaneMultiView));
        Validate.isTrue((boolean)(editor.getStorageLocation() instanceof FileStorageLocation), (String)"The given editor should be backed by a file");
        this.fFile = ((FileStorageLocation)editor.getStorageLocation()).getFile();
        this.fDebugger = MatlabBreakpointUtils.getDebugger();
        this.fLiveBreakpoints = this.fDebugger.getBreakpoints(this.fFile);
        this.fLiveBreakpoints.addListEventListener(this.fLiveBreakpointsListener);
        this.setViewBreakpointList((EventList)this.fLiveBreakpoints);
        this.fLastBreakpointInstallationResult = BreakpointInstallationResult.createSuccessfulResult(this.fFile);
        DebugActions.addClearBkptsListener((DebugActions.ClearBkptListener)this.fClearBreakpointsListener);
        this.fDebugger.addDebugListener(this.fDebugListener);
        DebuggerManager.addDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
    }

    private DebuggerManager.DebuggerManagerStateListener createDebuggerManagerStateListener() {
        return new DebuggerManager.DebuggerManagerStateListener(){

            public void stateUpdated(DebuggerManager.DebuggerTransition debuggerTransition, Class<? extends DebuggerActions> clazz) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MatlabBreakpointMarginImpl.this.repaintAll();
                    }
                });
            }
        };
    }

    private DebugActions.ClearBkptListener createClearBreakpointListener() {
        return new DebugActions.ClearBkptListener(){

            public void clearBkpts() {
                MatlabBreakpointMarginImpl.this.clearViewBreakpointsIfNotLive();
            }
        };
    }

    protected BreakpointView<MatlabBreakpoint> createBreakpointView(ViewProviderKey viewProviderKey) {
        return new BreakpointView(this.getBreakpointModel(), this.getContextMenuListener(), this.getSyntaxPane(), this.getCmdManager(), viewProviderKey, (BreakpointUiInfoProvider)new MatlabBreakpointUiInfoProvider(), this.createBreakpointMarginPopUpMenu());
    }

    private BreakpointMarginPopUpMenu<MatlabBreakpoint> createBreakpointMarginPopUpMenu() {
        return new MatlabBreakpointViewPopupBuilder(this);
    }

    private DebugListener<MatlabBreakpoint> createDebugListener() {
        return new DebugAdapter<MatlabBreakpoint>(){

            @Override
            public void breakpointsCleared() {
                MatlabBreakpointMarginImpl.this.clearViewBreakpointsIfNotLive();
            }
        };
    }

    protected BreakpointModel<MatlabBreakpoint> createBreakpointModel() {
        return new BreakpointModel<MatlabBreakpoint>(){

            public boolean wasThereAnError() {
                return MatlabBreakpointMarginImpl.this.wasThereAnError();
            }

            public boolean areBreakpointsLive() {
                return MatlabBreakpointMarginImpl.this.areBreakpointsLive();
            }

            public int getNumberOfPossibleInLineBreakpoints(int n) {
                return MatlabBreakpointMarginImpl.this.getNumberOfPossibleAnonymousFunctions(n);
            }

            public Collection<MatlabBreakpoint> getBreakpointsAt(int n) {
                return MatlabBreakpointMarginImpl.this.getMatlabOrViewBreakpointsOnLine(n);
            }
        };
    }

    protected ContextMenuListener createContextMenuListener() {
        return new ContextMenuListener(){

            public void respondToClick(int n) {
                Collection collection = MatlabBreakpointMarginImpl.this.getBreakpointModel().getBreakpointsAt(n);
                int n2 = MatlabBreakpointMarginImpl.this.getBreakpointModel().getNumberOfPossibleInLineBreakpoints(n);
                if (collection.isEmpty()) {
                    MatlabBreakpointMarginImpl.this.setBreakpoint(n);
                } else if (n2 > 0) {
                    MatlabBreakpointMarginImpl.this.editAllBreakpointsOnLine(n);
                } else if (((MatlabBreakpoint)collection.iterator().next()).hasExpression() && ((MatlabBreakpoint)collection.iterator().next()).isEnabled()) {
                    MatlabBreakpointMarginImpl.this.toggleEnablement((MatlabBreakpoint)collection.iterator().next());
                } else {
                    MatlabBreakpointMarginImpl.this.clearBreakpoint((MatlabBreakpoint)collection.iterator().next());
                }
            }
        };
    }

    public void dispose() {
        super.dispose();
        this.fLiveBreakpoints.dispose();
        this.fLiveBreakpoints.removeListEventListener(this.fLiveBreakpointsListener);
        DebugActions.removeClearBkptsListener((DebugActions.ClearBkptListener)this.fClearBreakpointsListener);
        this.fDebugger.removeDebugListener(this.fDebugListener);
        DebuggerManager.removeDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
    }

    private void clearViewBreakpointsIfNotLive() {
        if (!this.areBreakpointsLive()) {
            this.getViewBreakpointList().clear();
        }
    }

    public void setLive(boolean bl) {
        this.fLastBreakpointInstallationResult.markAsInvalid();
        if (bl && this.shouldClearAndSetBreakpoints()) {
            this.useLiveBreakpoints(false);
            this.fDebugger.clearAndSet((Collection<MatlabBreakpoint>)this.getViewBreakpointList(), this.fFile, this.createClearAndSetBreakpointsCompletionObserver());
        } else {
            this.useLiveBreakpoints(bl);
        }
        this.repaintAll();
    }

    private void useLiveBreakpoints(boolean bl) {
        if (bl) {
            this.setViewBreakpointList((EventList)this.fLiveBreakpoints);
        } else if (this.areBreakpointsLive()) {
            this.setViewBreakpointList(GlazedLists.eventList(this.fLiveBreakpoints));
        }
        this.repaintAll();
    }

    private boolean areBreakpointsLive() {
        return this.getViewBreakpointList() == this.fLiveBreakpoints;
    }

    public void clearBreakpointInMatlabOrInView(MatlabBreakpoint matlabBreakpoint) {
        if (this.areBreakpointsLive()) {
            this.fDebugger.clearBreakpoint(matlabBreakpoint);
        } else {
            this.getViewBreakpointList().remove((Object)matlabBreakpoint);
            this.repaintAll();
        }
    }

    public void setBreakpointInMatlabOrInView(int n) {
        if (this.getNumberOfPossibleAnonymousFunctions(n) == 0) {
            this.setBreakpointSingleBreakpointPossible(n);
        } else {
            this.setBreakpointMultipleBreakpointsPossible(n);
        }
    }

    private void setBreakpointSingleBreakpointPossible(int n) {
        this.setBreakpointInMatlabOrInView(MatlabBreakpoint.create(n, this.fFile));
    }

    private void setBreakpointMultipleBreakpointsPossible(int n) {
        int n2 = this.validateThatInLineHasAnonymousFunctions(n);
        MatlabBreakpoint matlabBreakpoint = BreakpointDialogs.showSetBreakpointDialog(n, this.getMatlabOrViewBreakpointsOnLine(n), n2, this.fFile);
        if (matlabBreakpoint != null) {
            this.setBreakpointInMatlabOrInView(matlabBreakpoint);
        }
    }

    private void setBreakpointInMatlabOrInView(MatlabBreakpoint matlabBreakpoint) {
        if (this.areBreakpointsLive()) {
            this.fDebugger.setBreakpoint(matlabBreakpoint, this.createSetBreakpointInMatlabCompletionObserver());
        } else {
            this.addOrUpdateBreakpointInView(matlabBreakpoint);
        }
    }

    @Override
    public void editAllBreakpointsOnLine(int n) {
        int n2 = this.validateThatInLineHasAnonymousFunctions(n);
        Collection<MatlabBreakpoint> collection = this.getMatlabOrViewBreakpointsOnLine(n);
        EditAllBreakpointsDialog editAllBreakpointsDialog = new EditAllBreakpointsDialog(collection, n, this.fFile, n2);
        Collection<MatlabBreakpoint> collection2 = editAllBreakpointsDialog.show();
        if (collection2 != null) {
            this.clearBreakpointsInMatlabOrInView(collection);
            this.setBreakpointsInMatlabOrInView(collection2);
        }
    }

    private void addOrUpdateBreakpointInView(MatlabBreakpoint matlabBreakpoint) {
        assert (!this.areBreakpointsLive()) : "Breakpoints should not be live.";
        if (this.fLastBreakpointInstallationResult.isValid() && this.fLastBreakpointInstallationResult.errorOccurred()) {
            this.fLastBreakpointInstallationResult.showErrorDialog();
            return;
        }
        MatlabBreakpoint matlabBreakpoint2 = this.getBreakpointOnLineAtAnonymousIndex(matlabBreakpoint.getZeroBasedLineNumber(), matlabBreakpoint.getAnonymousIndex());
        if (matlabBreakpoint2 == null) {
            this.getViewBreakpointList().add((Object)matlabBreakpoint);
        } else {
            int n = this.getViewBreakpointList().indexOf((Object)matlabBreakpoint2);
            this.getViewBreakpointList().set(n, (Object)matlabBreakpoint);
        }
        this.repaintAll();
    }

    private boolean wasThereAnError() {
        return this.fLastBreakpointInstallationResult.isValid() && this.fLastBreakpointInstallationResult.errorOccurred();
    }

    public void setBreakpoint(int n) {
        this.setBreakpointInMatlabOrInView(n);
    }

    @Override
    public void setConditionalBreakpoint(int n) {
        this.modifyBreakpointsExpression(MatlabBreakpoint.create(n, this.fFile));
    }

    public void clearBreakpoint(MatlabBreakpoint matlabBreakpoint) {
        this.clearBreakpointInMatlabOrInView(matlabBreakpoint);
    }

    @Override
    public void modifyBreakpointsExpression(MatlabBreakpoint matlabBreakpoint) {
        int n = this.getNumberOfPossibleAnonymousFunctions(matlabBreakpoint.getZeroBasedLineNumber());
        String string = BreakpointDialogs.promptUserForExpression(matlabBreakpoint, n);
        if (string != null) {
            this.setBreakpointInMatlabOrInView(matlabBreakpoint.deriveBreakpoint(string));
        }
    }

    public void toggle(int n) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)("The line number can not be negative: " + n));
        if (this.areMultipleBreakpointsSetOnLine(n)) {
            this.editAllBreakpointsOnLine(n);
        } else if (this.isSingleBreakpointSetOnLine(n)) {
            this.clearBreakpointInMatlabOrInView(this.getBreakpointOnLine(n));
        } else {
            this.setBreakpointInMatlabOrInView(n);
        }
    }

    @Override
    public void toggleEnablement(int n) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)("The line number can not be negative: " + n));
        if (this.areMultipleBreakpointsSetOnLine(n)) {
            this.editAllBreakpointsOnLine(n);
        } else if (this.isSingleBreakpointSetOnLine(n)) {
            this.toggleEnablement(this.getBreakpointOnLine(n));
        } else {
            this.setBreakpointInMatlabOrInView(n);
        }
    }

    @Override
    public void modifyCondition(int n) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)("The line number can not be negative: " + n));
        if (this.areMultipleBreakpointsSetOnLine(n)) {
            this.editAllBreakpointsOnLine(n);
        } else {
            MatlabBreakpoint matlabBreakpoint = this.isSingleBreakpointSetOnLine(n) ? this.getBreakpointOnLine(n) : MatlabBreakpoint.create(n, this.fFile);
            this.modifyBreakpointsExpression(matlabBreakpoint);
        }
    }

    @Override
    public void toggleEnablement(MatlabBreakpoint matlabBreakpoint) {
        Validate.notNull((Object)matlabBreakpoint, (String)"The given breakpoint cannot be null.");
        MatlabBreakpoint matlabBreakpoint2 = matlabBreakpoint.deriveBreakpoint(!matlabBreakpoint.isEnabled());
        this.setBreakpointInMatlabOrInView(matlabBreakpoint2);
    }

    private boolean isSingleBreakpointSetOnLine(int n) {
        return this.getMatlabOrViewBreakpointsOnLine(n).size() == 1;
    }

    public boolean areMultipleBreakpointsSetOnLine(int n) {
        return this.getMatlabOrViewBreakpointsOnLine(n).size() > 1;
    }

    public MatlabBreakpoint getBreakpointOnLine(int n) {
        Validate.isTrue((boolean)this.isSingleBreakpointSetOnLine(n), (String)"Only one breakpoint should exist on the given line.");
        Collection<MatlabBreakpoint> collection = this.getMatlabOrViewBreakpointsOnLine(n);
        return collection.iterator().next();
    }

    private CompletionObserver createSetBreakpointInMatlabCompletionObserver() {
        return new CompletionObserver(){

            public void completed(int n, Object object) {
                MatlabBreakpointMarginImpl.this.assertSuccessCaptureResult(n, object, true);
            }
        };
    }

    private void assertSuccessCaptureResult(int n, Object object, boolean bl) {
        MatlabBreakpointMarginImpl.assertMatlabStatusWasSuccessful(n);
        this.fLastBreakpointInstallationResult = MatlabBreakpointMarginImpl.validateResultAndNarrow(object);
        if (this.fLastBreakpointInstallationResult.errorOccurred() && bl) {
            this.fLastBreakpointInstallationResult.showErrorDialog();
        }
    }

    private CompletionObserver createClearAndSetBreakpointsCompletionObserver() {
        return new CompletionObserver(){

            public void completed(int n, Object object) {
                MatlabBreakpointMarginImpl.this.assertSuccessCaptureResult(n, object, false);
                MatlabBreakpointMarginImpl.this.useLiveBreakpoints(MatlabBreakpointMarginImpl.this.fLastBreakpointInstallationResult.wasSuccessful());
            }
        };
    }

    private boolean shouldClearAndSetBreakpoints() {
        return !this.areBreakpointsLive() && (!this.getViewBreakpointList().isEmpty() || !this.fLiveBreakpoints.isEmpty());
    }

    private MatlabBreakpoint getBreakpointOnLineAtAnonymousIndex(int n, int n2) {
        return MatlabBreakpointUtils.findBreakpointOnLineAtAnonymousIndex(n, n2, (Collection<MatlabBreakpoint>)this.getViewBreakpointList());
    }

    private Collection<MatlabBreakpoint> getMatlabOrViewBreakpointsOnLine(int n) {
        return MatlabBreakpointUtils.getBreakpointsOnLine(n, (Collection<MatlabBreakpoint>)this.getViewBreakpointList());
    }

    private void clearBreakpointsInMatlabOrInView(Collection<MatlabBreakpoint> collection) {
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            this.clearBreakpointInMatlabOrInView(matlabBreakpoint);
        }
    }

    private void setBreakpointsInMatlabOrInView(Collection<MatlabBreakpoint> collection) {
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            this.setBreakpointInMatlabOrInView(matlabBreakpoint);
        }
    }

    private int getNumberOfPossibleAnonymousFunctions(int n) {
        return this.getCmdManager().getNumAnonymousFunctions(n);
    }

    private int validateThatInLineHasAnonymousFunctions(int n) {
        int n2 = this.getNumberOfPossibleAnonymousFunctions(n);
        Validate.isTrue((n2 > 0 ? 1 : 0) != 0, (String)"In-line breakpoints should be possible.");
        return n2;
    }

    private static void assertMatlabStatusWasSuccessful(int n) {
        assert (Matlab.getExecutionStatus((int)n) == 0) : "The MATLAB operation should not have failed.";
    }

    private static BreakpointInstallationResult validateResultAndNarrow(Object object) {
        Validate.isTrue((boolean)(object instanceof BreakpointInstallationResult), (String)"The result should have been a BreakpointInstallationResult.");
        return (BreakpointInstallationResult)object;
    }
}

