/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.editordataservice;

import com.mathworks.services.editordataservice.Document;
import com.mathworks.services.editordataservice.EditorFeature;
import com.mathworks.services.editordataservice.EditorNode;
import com.mathworks.widgets.text.mcode.CodeAnalyzerUtilities;
import com.mathworks.widgets.text.mcode.MLint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;

public class CodeAnalyzerFeature
extends EditorFeature {
    public CodeAnalyzerFeature(EditorNode editorNode) {
        super(editorNode);
    }

    public void documentChanged(Document document) {
        Object object;
        String string = document.getText();
        if (string.isEmpty()) {
            return;
        }
        List<Map<String, Object>> list = Collections.EMPTY_LIST;
        try {
            object = CodeAnalyzerFeature.getCodeAnalyzerMessages(string, null);
            list = CodeAnalyzerFeature.createCodeAnalyzerMessages(object);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        object = new HashMap();
        object.put("messages", list);
        this.updateFeatureData((Map)object);
    }

    public static List<MLint.Message> getCodeAnalyzerMessages(String string, String string2) throws BadLocationException {
        List list = MLint.getMessages((String)string, (String)string2);
        CodeAnalyzerUtilities.modifyMessages((String)string, (List)list);
        return list;
    }

    private static List<Map<String, Object>> createCodeAnalyzerMessages(List<MLint.Message> list) throws BadLocationException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (MLint.Message message : list) {
            arrayList.add(CodeAnalyzerFeature.createCodeAnalyzerMessage(message.getMessage(), message.getSeverity(), message.getLineNumber() - 1, message.getStartColumn() - 1, message.getEndColumn()));
        }
        return arrayList;
    }

    private static Map<String, Object> createCodeAnalyzerMessage(String string, int n, int n2, int n3, int n4) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("message", string);
        hashMap.put("severity", n);
        hashMap.put("lineNumber", n2);
        hashMap.put("startColumn", n3);
        hashMap.put("endColumn", n4);
        return hashMap;
    }

    public String getFeatureId() {
        return "matlab.code.codeanalzyer";
    }
}

