/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.difftool;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.difftool.FileDiffToolInfo;
import com.mathworks.mde.difftool.UnsavedChangesDiffToolInfo;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.Component;
import java.io.File;

public class DiffToolInfoImpl
implements FileDiffToolInfo,
UnsavedChangesDiffToolInfo {
    private final Editor fEditor;

    public DiffToolInfoImpl(Editor editor) {
        this.fEditor = editor;
    }

    @Override
    public File getFile() {
        this.checkEditorPresent();
        StorageLocation storageLocation = this.fEditor.getStorageLocation();
        return storageLocation instanceof FileStorageLocation ? ((FileStorageLocation)storageLocation).getFile() : null;
    }

    @Override
    public File getAutoSaveFile() {
        assert (this.fEditor != null);
        Object object = this.fEditor.getProperty((Object)"autoSaveFile");
        assert (object == null || object instanceof File);
        return (File)object;
    }

    @Override
    public Component getComponentForDialog() {
        assert (this.fEditor != null);
        return this.fEditor.getComponent();
    }

    @Override
    public void executeDiffRunnable(Runnable runnable) {
        assert (this.fEditor != null);
        if (this.fEditor.negotiateSave()) {
            runnable.run();
        }
    }

    @Override
    public boolean isDirty() {
        this.checkEditorPresent();
        return this.fEditor.isDirty();
    }

    @Override
    public boolean isBuffer() {
        this.checkEditorPresent();
        return this.fEditor.isBuffer();
    }

    @Override
    public boolean isSingleFileActive() {
        return true;
    }

    @Override
    public String getText() {
        this.checkEditorPresent();
        return this.fEditor.getTextWithSystemLineEndings();
    }

    private void checkEditorPresent() {
        if (this.fEditor == null) {
            throw new RuntimeException(EditorUtils.lookup("msg.FileNoLongerOpen"));
        }
    }
}

