/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.util.ArrayUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.event.ChangeEvent;
import org.apache.commons.io.FileUtils;

public class StartupClassLoader {
    private volatile boolean fMatlabBusy;
    private volatile boolean fInitialized;
    private volatile boolean fStopLoading;
    private final MLExecutionListener fListener;
    private Thread fLoadThread;
    private static final String[] sClassesToInvoke = new String[]{"com.mathworks.mde.editor.EditorStartup", "com.mathworks.hg.util.HGUtils", "com.mathworks.mlwidgets.html.HtmlComponentFactory", "com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils", "com.mathworks.page.plottool.StartupClasses", "com.mathworks.mde.functionhints.FunctionHints", "com.mathworks.mlwidgets.help.InstalledProductUtils"};
    private static StartupClassLoader sInstance = null;
    private static final int IDLE_DURATION = 3000;
    private static final int POLL_INTERVAL = 250;
    private static final int IDLE_INTERVALS = 12;
    private final boolean fUnitTesting;
    private Exception fException;

    public static StartupClassLoader getInstance() {
        return sInstance;
    }

    public static Thread getThread() {
        if (sInstance == null) {
            return null;
        }
        return StartupClassLoader.sInstance.fLoadThread;
    }

    public static synchronized void loadAllClasses() {
        if (sInstance == null) {
            sInstance = new StartupClassLoader(false);
        }
    }

    public static StartupClassLoader loadAllClassesForTest() {
        return new StartupClassLoader(true);
    }

    private StartupClassLoader(boolean bl) {
        this.fUnitTesting = bl;
        if (this.fUnitTesting) {
            this.fListener = null;
            this.startLoadingThread();
        } else {
            this.fListener = new MLExecutionListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MLExecutionEvent mLExecutionEvent = (MLExecutionEvent)changeEvent;
                    StartupClassLoader.this.fMatlabBusy = mLExecutionEvent.isCommandInProgress();
                    if (!StartupClassLoader.this.fMatlabBusy && !StartupClassLoader.this.fInitialized) {
                        StartupClassLoader.this.fInitialized = true;
                        new Timer("StartupClassLoader Timer", true).schedule(new TimerTask(){

                            @Override
                            public void run() {
                                StartupClassLoader.this.startLoadingThread();
                            }
                        }, 1000L);
                    }
                }
            };
            MLExecuteServices.addMLExecutionListener((MLExecutionListener)this.fListener);
        }
    }

    public static synchronized void stopLoadingClasses() {
        if (sInstance == null) {
            return;
        }
        StartupClassLoader.sInstance.fStopLoading = true;
        if (StartupClassLoader.sInstance.fLoadThread != null) {
            try {
                StartupClassLoader.sInstance.fLoadThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private List<LoadInfo> createLoadInfos() {
        Object object;
        LinkedList<LoadInfo> linkedList = new LinkedList<LoadInfo>();
        List list = new LinkedList();
        if (!this.fUnitTesting && ((File)(object = new File(Matlab.matlabRoot() + File.separator + "toolbox" + File.separator + "local" + File.separator + "classloader.txt"))).exists()) {
            try {
                list = FileUtils.readLines((File)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (String string : sClassesToInvoke) {
            if (!this.fUnitTesting && !list.contains(string)) continue;
            linkedList.add(new LoadInfo(string));
        }
        if (linkedList.isEmpty()) {
            this.fException = new Exception("Found nothing to load");
        }
        return linkedList;
    }

    private void startLoadingThread() {
        this.fLoadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (LoadInfo loadInfo : StartupClassLoader.this.createLoadInfos()) {
                    if (StartupClassLoader.this.fUnitTesting) {
                        System.out.println("Loading group " + loadInfo.fDisplayName);
                    }
                    for (String string : loadInfo.fClassesToLoad) {
                        int n = 0;
                        while ((StartupClassLoader.this.fMatlabBusy || n > 0) && !StartupClassLoader.this.fStopLoading) {
                            n = StartupClassLoader.this.fMatlabBusy ? 12 : --n;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (StartupClassLoader.this.fStopLoading) break;
                        StartupClassLoader.this.loadClass(string);
                    }
                    if (!StartupClassLoader.this.fStopLoading) continue;
                    break;
                }
                MLExecuteServices.removeMLExecutionListener((MLExecutionListener)StartupClassLoader.this.fListener);
            }
        }, "Startup Class Loader");
        this.fLoadThread.setPriority(1);
        this.fLoadThread.start();
    }

    private void loadClass(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            clazz.getDeclaredClasses();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fException = classNotFoundException;
        }
    }

    public boolean isFinished() {
        assert (this.fLoadThread != null) : "isFinished() called before loadAllClasses() or loadAllClassesForTest()";
        return !this.fLoadThread.isAlive();
    }

    public Exception getError() {
        return this.fException;
    }

    private class LoadInfo {
        private String[] fClassesToLoad;
        private String fDisplayName;

        LoadInfo(String string) {
            this.fDisplayName = string;
            try {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getMethod("getClassNames", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                this.fClassesToLoad = (String[])object;
            }
            catch (Exception exception) {
                this.fClassesToLoad = ArrayUtils.EmptyObjects.STRING;
                StartupClassLoader.this.fException = exception;
            }
        }
    }
}

