/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeWindows;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.NativeJava;
import com.mathworks.widgets.desk.DTAsyncWindowCloser;
import com.mathworks.widgets.desk.DTCloseReplyListener;
import com.mathworks.widgets.desk.DTShutdownExcludedCloser;
import com.mathworks.widgets.desk.DTWindowActivator;
import com.mathworks.widgets.desk.DTWindowRegistry;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;

public class MLNativeWindow
implements DTWindowActivator,
DTAsyncWindowCloser,
DTShutdownExcludedCloser {
    private static Map<Long, MLNativeWindow> sNativeWindowTable = new Hashtable<Long, MLNativeWindow>();
    private long fHWND;
    private String fTitle;
    private boolean fIsFigure;
    private boolean fIsClosed;

    public MLNativeWindow(long l, boolean bl) {
        this.fHWND = l;
        this.fIsFigure = bl;
        if (l == 0L) {
            return;
        }
        MLNativeWindow.addToNativeWindowTable(this, l);
        DTWindowRegistry.getInstance().addActivator((DTWindowActivator)this);
    }

    public void destroyWindow() {
        if (this.fHWND == 0L) {
            return;
        }
        MLNativeWindow.removeFromNativeWindowTable(this.fHWND);
        if (SwingUtilities.isEventDispatchThread()) {
            DTWindowRegistry.getInstance().removeActivator((DTWindowActivator)this);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DTWindowRegistry.getInstance().removeActivator((DTWindowActivator)MLNativeWindow.this);
                }
            });
        }
        this.fIsClosed = true;
    }

    public void setTitle(String string) {
        if (this.fHWND == 0L) {
            return;
        }
        this.fTitle = string;
        DTWindowRegistry.getInstance().nameChange((DTWindowActivator)this);
    }

    public long getHWND() {
        return this.fHWND;
    }

    public void activate() {
        NativeJava.setMinimized((long)this.fHWND, (boolean)false);
        NativeJava.setfocus((long)this.fHWND);
    }

    public String getShortTitle() {
        if (this.fTitle == null) {
            this.fTitle = NativeJava.getWindowTitle((long)this.fHWND);
            if (null == this.fTitle || this.fTitle.equals("")) {
                this.fTitle = MJUtilities.intlString((String)"window.Untitled");
            }
        }
        return this.fTitle;
    }

    public String getGroupName() {
        return this.fIsFigure ? "Figure" : "Simulink";
    }

    public boolean canClose() {
        return this.canClose(null) != 0;
    }

    public int canClose(final DTCloseReplyListener dTCloseReplyListener) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                Boolean bl = null;
                try {
                    bl = NativeWindows.destroyWindow((long)MLNativeWindow.this.fHWND) == 0 || MLNativeWindow.this.fIsClosed;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (dTCloseReplyListener != null) {
                    dTCloseReplyListener.closeReply((DTAsyncWindowCloser)MLNativeWindow.this, ((Boolean)object).booleanValue());
                }
            }
        };
        matlabWorker.start();
        return 2;
    }

    public void close() {
    }

    private static synchronized void addToNativeWindowTable(MLNativeWindow mLNativeWindow, long l) {
        sNativeWindowTable.put(l, mLNativeWindow);
    }

    private static synchronized void removeFromNativeWindowTable(long l) {
        sNativeWindowTable.remove(l);
    }

    public static synchronized MLNativeWindow NativeWindowFromHWND(long l) {
        return sNativeWindowTable.get(l);
    }
}

