/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.mde.desk.MLMenuBar;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.desk.PlotGalleryManager;
import com.mathworks.mde.desk.PlotableClientBase;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMenuOmission;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class MLMultipleClientFrame
extends DTMultipleClientFrame {
    private DTMenu fDebugMenu;
    private List<PlotGalleryManager> fPlotGalleryManagers;
    private DTClient fLastPlotableClient;
    private static final String MENU_CONTAINER_LISTENER_KEY = "MLMultipleClientFrame - Menu ContainerListener";

    public MLMultipleClientFrame(Desktop desktop, String string, Icon icon, DTGroup dTGroup, boolean bl) {
        super(desktop, string, icon, dTGroup, bl);
    }

    void addPlotGalleryManager(PlotGalleryManager plotGalleryManager) {
        if (this.fPlotGalleryManagers == null) {
            this.fPlotGalleryManagers = new ArrayList<PlotGalleryManager>();
        }
        this.fPlotGalleryManagers.add(plotGalleryManager);
    }

    public void removeClient(DTClient dTClient) {
        if (dTClient == this.fLastPlotableClient) {
            this.fLastPlotableClient = null;
            this.updatePlots();
        }
        super.removeClient(dTClient);
    }

    public void addClient(DTClient dTClient, DTLocation dTLocation) {
        super.addClient(dTClient, dTLocation);
        if (dTClient.getComponent() instanceof PlotableClientBase && dTClient.isSelected()) {
            this.fLastPlotableClient = dTClient;
            this.updatePlots();
        }
    }

    public void addGroup(DTGroup dTGroup, DTLocation dTLocation) {
        super.addGroup(dTGroup, dTLocation);
        if (this.fMergedClient != null && this.fMergedClient.getComponent() instanceof PlotableClientBase && this.fMergedClient.getGroup() == dTGroup) {
            this.fLastPlotableClient = this.fMergedClient;
            this.updatePlots();
        }
    }

    public void removeGroup(DTGroup dTGroup) {
        if (this.fLastPlotableClient != null && dTGroup == this.fLastPlotableClient.getGroup()) {
            this.fLastPlotableClient = null;
            this.updatePlots();
        }
        super.removeGroup(dTGroup);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DTClient dTClient;
        super.propertyChange(propertyChangeEvent);
        Object object = propertyChangeEvent.getSource();
        if (object instanceof DTClient && (dTClient = (DTClient)object).getComponent() instanceof PlotableClientBase) {
            if ("Occupant Selected".equals(propertyChangeEvent.getPropertyName())) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && dTClient != this.fLastPlotableClient) {
                    this.fLastPlotableClient = dTClient;
                    this.updatePlots();
                }
            } else if (dTClient == this.fLastPlotableClient && PlotableClientBase.VARIABLES_TO_PLOT.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.updatePlots();
            }
        }
    }

    private void updatePlots() {
        if (this.fPlotGalleryManagers == null) {
            return;
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.fLastPlotableClient != null) {
            PlotableClientBase plotableClientBase = (PlotableClientBase)((Object)this.fLastPlotableClient.getComponent());
            stringArray = plotableClientBase.getVariablesToPlot();
            stringArray2 = plotableClientBase.getVariableClasses();
        }
        for (PlotGalleryManager plotGalleryManager : this.fPlotGalleryManagers) {
            plotGalleryManager.variableSelectionUpdated(stringArray, stringArray2);
            if (this.fLastPlotableClient == null) continue;
            plotGalleryManager.setVariableSelectionSource((PlotableClientBase)((Object)this.fLastPlotableClient.getComponent()));
        }
    }

    protected void augmentClientMenuBar(final JMenuBar jMenuBar) {
        Component component;
        int n;
        Object object;
        super.augmentClientMenuBar(jMenuBar);
        boolean bl = true;
        if (this.fGroup != null && (object = (JMenuBar)this.fGroup.getProperty(DTProperty.MENU_BAR)) != null) {
            for (n = 0; n < ((Container)object).getComponentCount(); ++n) {
                component = ((Container)object).getComponent(n);
                if (!(component instanceof DTMenuOmission) || ((DTMenuOmission)component).getTag() != MLMenuMergeTag.DEBUG) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            int n2 = -1;
            for (n = 0; n < jMenuBar.getMenuCount(); ++n) {
                component = jMenuBar.getMenu(n);
                if (DTMenuMergeTag.getTag((JMenuItem)component) != DTMenuMergeTag.DESKTOP) continue;
                n2 = n;
            }
            this.fDebugMenu = new MLMenuBar.DebugMenu();
            if (n2 >= 0) {
                jMenuBar.add((Component)this.fDebugMenu, n2);
            } else {
                jMenuBar.add((JMenu)this.fDebugMenu);
            }
        }
        if ((object = (ContainerListener)jMenuBar.getClientProperty(MENU_CONTAINER_LISTENER_KEY)) == null) {
            object = new ContainerAdapter(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    Component component = containerEvent.getChild();
                    if (component instanceof JMenu && ((MLMultipleClientFrame)MLMultipleClientFrame.this).fClientMenuInfo.fTrueDesktopMenu.getText().equalsIgnoreCase(((JMenu)component).getText())) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ContainerListener[] containerListenerArray;
                                for (ContainerListener containerListener : containerListenerArray = jMenuBar.getContainerListeners()) {
                                    jMenuBar.removeContainerListener(containerListener);
                                }
                                jMenuBar.remove((Component)((MLMultipleClientFrame)MLMultipleClientFrame.this).fClientMenuInfo.fTrueDesktopMenu);
                                jMenuBar.remove((Component)((MLMultipleClientFrame)MLMultipleClientFrame.this).fClientMenuInfo.fTrueWindowMenu);
                                if (MLMultipleClientFrame.this.fDebugMenu != null) {
                                    jMenuBar.remove((Component)MLMultipleClientFrame.this.fDebugMenu);
                                }
                                ((MLMultipleClientFrame)MLMultipleClientFrame.this).fClientMenuInfo.fClientDesktopMenu = null;
                                ((MLMultipleClientFrame)MLMultipleClientFrame.this).fClientMenuInfo.fClientWindowMenu = null;
                                MLMultipleClientFrame.this.augmentClientMenuBar(jMenuBar);
                                for (ContainerListener containerListener : containerListenerArray) {
                                    jMenuBar.addContainerListener(containerListener);
                                }
                            }
                        });
                    }
                }
            };
            jMenuBar.addContainerListener((ContainerListener)object);
            jMenuBar.putClientProperty(MENU_CONTAINER_LISTENER_KEY, object);
        }
    }

    protected void restoreClientMenuBar(JMenuBar jMenuBar) {
        ContainerListener containerListener = (ContainerListener)jMenuBar.getClientProperty(MENU_CONTAINER_LISTENER_KEY);
        if (containerListener != null) {
            jMenuBar.putClientProperty(MENU_CONTAINER_LISTENER_KEY, null);
            jMenuBar.removeContainerListener(containerListener);
        }
        super.restoreClientMenuBar(jMenuBar);
        if (this.fDebugMenu != null) {
            jMenuBar.remove((Component)this.fDebugMenu);
            this.fDebugMenu.dispose();
            this.fDebugMenu = null;
        }
    }
}

