/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.appmanagement.AppManagementApiBuilder;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mde.apps.UserAppGuide;
import com.mathworks.mlwidgets.toolstrip.MatlabToolSet;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.toolstrip.accessories.ToolTipContentProvider;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.RecentFiles;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class ContributedTools {
    private List<TSToolSetContents> fContentList = new ArrayList<TSToolSetContents>();
    private List<TSToolSet> fToolSetList = new ArrayList<TSToolSet>();
    private List<RecentFiles.Tool> fRecentFileTools = new ArrayList<RecentFiles.Tool>();
    private TSToolSet fUserAppsToolSet;
    private static final String TOOL_SET_FILE_NAME = "DesktopToolset.xml";
    private static final String NON_SHIPPING = "Non-Shipping";

    ContributedTools() {
        File file;
        Object object2;
        File file2 = new File(Matlab.matlabRoot(), "toolbox");
        String string = file2.getAbsolutePath();
        for (Object object2 : MatlabPath.getPathEntries()) {
            String string2;
            int n;
            file = object2.getCurrentlyResolvedPath();
            String string3 = file.getAbsolutePath();
            if (!string3.startsWith(string)) continue;
            File file3 = new File(file, TOOL_SET_FILE_NAME);
            if (file3.exists()) {
                this.addToolSet(file3, this.readToolBoxContents(file));
                continue;
            }
            File file4 = null;
            if (new File(file, "info.xml").exists()) {
                file4 = file;
            }
            if (new File(file.getParentFile(), "info.xml").exists()) {
                file4 = file.getParentFile();
            }
            if (file4 == null || (n = string3.lastIndexOf(string2 = System.getProperty("file.separator"))) <= 0) continue;
            String string4 = string3.substring(n + 1);
            try {
                InputStream inputStream = ContributedTools.class.getResourceAsStream("resources/toolbox/" + string4 + "_Toolset.xml");
                if (inputStream == null) continue;
                this.addToolSet(inputStream, this.readToolBoxContents(file4), null);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
        File file5 = new File(file2, "mwtools");
        object2 = new File(file5, TOOL_SET_FILE_NAME);
        if (((File)object2).exists()) {
            this.addToolSet((File)object2, NON_SHIPPING);
        }
        file = AppManagementApiBuilder.getAppManagementApi();
        this.fUserAppsToolSet = file.getToolSet();
        file.loadInstalledApps();
        UserAppGuide.configure();
        this.fContentList.add(this.fUserAppsToolSet.getContents());
        this.fToolSetList.add(this.fUserAppsToolSet);
    }

    private String readToolBoxContents(File file) {
        if (file == null) {
            return null;
        }
        String string = null;
        File file2 = new File(file, "Contents.m");
        if (file2.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                String string2 = this.trimComment(bufferedReader.readLine());
                StringTokenizer stringTokenizer = new StringTokenizer(this.trimComment(bufferedReader.readLine()));
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                return string2 + " " + string3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private String trimComment(String string) {
        int n = string.indexOf(37);
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1).trim();
        }
        return string;
    }

    private void addToolSet(File file, String string) {
        try {
            this.addToolSet(new FileInputStream(file), string, file.getParent());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.logException((Exception)fileNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToolSet(InputStream inputStream, String string, String string2) {
        try {
            SimpleElement simpleElement = SimpleDOMUtils.read((InputStream)inputStream);
            TSToolSetContents tSToolSetContents = new TSToolSetContents(simpleElement, string2);
            if (!this.hasToolSet(tSToolSetContents.getName())) {
                ToolBoxToolSet toolBoxToolSet = new ToolBoxToolSet(tSToolSetContents, string);
                this.fContentList.add(tSToolSetContents);
                this.fToolSetList.add((TSToolSet)toolBoxToolSet);
                this.fRecentFileTools.addAll(RecentFiles.getTools((SimpleElement)simpleElement));
            }
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
    }

    private boolean hasToolSet(String string) {
        for (TSToolSetContents tSToolSetContents : this.fContentList) {
            if (!string.equals(tSToolSetContents.getName())) continue;
            return true;
        }
        return false;
    }

    List<TSToolSetContents> getContentList() {
        return Collections.unmodifiableList(this.fContentList);
    }

    List<TSToolSet> getToolSetList() {
        return Collections.unmodifiableList(this.fToolSetList);
    }

    TSToolSet getUserAppsToolSet() {
        return this.fUserAppsToolSet;
    }

    List<RecentFiles.Tool> getRecentFileTools() {
        return this.fRecentFileTools;
    }

    private static class ToolBoxToolSet
    extends MatlabToolSet {
        private String fInfo;

        private ToolBoxToolSet(TSToolSetContents tSToolSetContents, String string) {
            super(tSToolSetContents);
            this.fInfo = string;
            this.init();
        }

        public Action getAction(final String string) {
            Action action = super.getAction(string);
            if (action != null) {
                action.putValue("tool-tip-content-provider", new ToolTipContentProvider(){

                    public JComponent getToolTipContent() {
                        TSToolSetContents.Tool tool = ToolBoxToolSet.this.getContents().getTool(string);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string2 = tool.getLabel();
                        stringBuilder.append(string2);
                        stringBuilder.append('\n');
                        stringBuilder.append(tool.getDescription());
                        if (ToolBoxToolSet.this.fInfo != null) {
                            stringBuilder.append('\n');
                            stringBuilder.append(ToolBoxToolSet.this.fInfo);
                        }
                        MJTextPane mJTextPane = new MJTextPane();
                        mJTextPane.setEditable(false);
                        mJTextPane.setBackground(UIManager.getColor("ToolTip.background"));
                        mJTextPane.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
                        mJTextPane.setText(stringBuilder.toString());
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        StyleConstants.setBold(simpleAttributeSet, true);
                        mJTextPane.getStyledDocument().setCharacterAttributes(0, string2.length(), simpleAttributeSet, false);
                        return mJTextPane;
                    }
                });
            }
            return action;
        }
    }
}

