/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.mde.dataimport.IVariableContentsOwner;
import com.mathworks.mde.dataimport.ImportProxy;
import com.mathworks.mde.dataimport.ImportUtils;
import com.mathworks.mde.dataimport.ValueSpecification;
import com.mathworks.mde.dataimport.VariableContentsViewer;
import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.widgets.spreadsheet.SpreadsheetScrollPane;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.MaskFormatter;

class DataInterpretationPanel
extends MJPanel
implements ActionListener,
IVariableContentsOwner {
    private static final String RADIO_COMMA = "COMMA";
    private static final String RADIO_SPACE = "SPACE";
    private static final String RADIO_SEMI = "SEMI";
    private static final String RADIO_TAB = "TAB";
    private static final String RADIO_OTHER = "OTHER";
    private static final String ESCD_BACK_SLASH = "\\\\";
    private static final String ESCD_PERCENT = "%%";
    private MJRadioButton fCommaButton;
    private MJRadioButton fSpaceButton;
    private MJRadioButton fSemiButton;
    private MJRadioButton fTabButton;
    private MJRadioButton fOtherButton;
    private MJFormattedTextField fOtherTextField;
    private String fLastOtherText = " ";
    private MJSpinner fTextHeaderLinesSpinner;
    private DataPreviewPanel fPreviewPanel;
    private File fFileToImport = null;
    private ImportProxy fImportProxy;
    private Map<String, VariableContentsViewer> fRequestorHashtable;
    private boolean fNextAvailable;
    private boolean fBackAvailable = true;
    private int fRefreshRequestCounter = 0;
    private HeaderControlListener fChangeListener;
    private HeaderControlListener fHeaderControlListener;

    DataInterpretationPanel(ImportProxy importProxy, File file, String string, int n, String string2, String[] stringArray) {
        this.fImportProxy = importProxy;
        this.setLayout(new BorderLayout());
        this.fRequestorHashtable = new Hashtable<String, VariableContentsViewer>();
        MJPanel mJPanel = this.createColumnSepSelectionPanel(string, n);
        this.fPreviewPanel = new DataPreviewPanel();
        this.refreshPreviewBorder();
        mJPanel.setOpaque(true);
        this.fPreviewPanel.setOpaque(true);
        this.add((Component)mJPanel, "North");
        this.add((Component)((Object)this.fPreviewPanel), "Center");
        this.setFileToImport(file);
        this.setPreviewTextContents(string2);
        this.setPreviewTabList(stringArray);
        this.resetColors();
    }

    void resetColors() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.resetColorsDispatch();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataInterpretationPanel.this.resetColorsDispatch();
                }
            });
        }
    }

    private void resetColorsDispatch() {
        Color color = ColorPrefs.getTextColor();
        Color color2 = ColorPrefs.getBackgroundColor();
        this.fPreviewPanel.setTextForeground(color);
        this.fPreviewPanel.setTextBackground(color2);
        this.fOtherTextField.setForeground(color);
        this.fOtherTextField.setBackground(color2);
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.fTextHeaderLinesSpinner.getEditor();
        JFormattedTextField jFormattedTextField = numberEditor.getTextField();
        jFormattedTextField.setForeground(color);
        jFormattedTextField.setBackground(color2);
    }

    private MJPanel createColumnSepSelectionPanel(String string, int n) {
        MJPanel mJPanel = new MJPanel();
        this.fCommaButton = new MJRadioButton(ImportUtils.getResource("dip.comma"));
        this.fCommaButton.setMnemonic(67);
        this.fCommaButton.setActionCommand(RADIO_COMMA);
        this.fCommaButton.addActionListener((ActionListener)this);
        this.fCommaButton.setName("Comma");
        this.fSpaceButton = new MJRadioButton(ImportUtils.getResource("dip.space"));
        this.fSpaceButton.setMnemonic(83);
        this.fSpaceButton.setActionCommand(RADIO_SPACE);
        this.fSpaceButton.addActionListener((ActionListener)this);
        this.fSpaceButton.setName("Space");
        this.fSemiButton = new MJRadioButton(ImportUtils.getResource("dip.semicolon"));
        this.fSemiButton.setMnemonic(77);
        this.fSemiButton.setActionCommand(RADIO_SEMI);
        this.fSemiButton.addActionListener((ActionListener)this);
        this.fSemiButton.setName("Semicolon");
        this.fTabButton = new MJRadioButton(ImportUtils.getResource("dip.tab"));
        this.fTabButton.setMnemonic(84);
        this.fTabButton.setActionCommand(RADIO_TAB);
        this.fTabButton.addActionListener((ActionListener)this);
        this.fTabButton.setName("Tab");
        this.fOtherButton = new MJRadioButton(ImportUtils.getResource("dip.other"));
        this.fOtherButton.setMnemonic(79);
        this.fOtherButton.setActionCommand(RADIO_OTHER);
        this.fOtherButton.addActionListener((ActionListener)this);
        this.fOtherButton.setName("Other");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fCommaButton);
        buttonGroup.add((AbstractButton)this.fSpaceButton);
        buttonGroup.add((AbstractButton)this.fSemiButton);
        buttonGroup.add((AbstractButton)this.fTabButton);
        buttonGroup.add((AbstractButton)this.fOtherButton);
        MaskFormatter maskFormatter = null;
        try {
            maskFormatter = new MaskFormatter("*");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (maskFormatter != null) {
            this.fOtherTextField = new MJFormattedTextField((JFormattedTextField.AbstractFormatter)maskFormatter);
        } else {
            this.fOtherTextField = new MJFormattedTextField();
            this.fOtherTextField.setText(" ");
        }
        this.fOtherTextField.setName("OtherText");
        Dimension dimension = this.fOtherTextField.getPreferredSize();
        dimension.setSize(38.0, dimension.getHeight());
        this.fOtherTextField.setPreferredSize(dimension);
        this.setDelimiterControls(string);
        this.setOtherControlsEnabled(this.fOtherButton.isSelected());
        this.fHeaderControlListener = new HeaderControlListener();
        this.fOtherTextField.getDocument().addDocumentListener(this.fHeaderControlListener);
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setLayout((LayoutManager)new BorderLayout());
        mJPanel2.add((Component)this.fOtherButton, (Object)"West");
        mJPanel2.add((Component)this.fOtherTextField, (Object)"Center");
        MJPanel mJPanel3 = new MJPanel();
        MJPanel mJPanel4 = new MJPanel();
        mJPanel3.setLayout((LayoutManager)new FlowLayout());
        mJPanel3.add((Component)this.fCommaButton);
        mJPanel3.add((Component)this.fSpaceButton);
        mJPanel3.add((Component)this.fSemiButton);
        mJPanel3.add((Component)this.fTabButton);
        mJPanel3.add((Component)mJPanel2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ImportUtils.getResource("dip.selectColumnSeparators"));
        mJPanel3.setBorder((Border)titledBorder);
        mJPanel4.setLayout((LayoutManager)new FlowLayout());
        MJLabel mJLabel = new MJLabel(ImportUtils.getResource("dip.headerLines"));
        mJLabel.setName("HeaderLinesLabel");
        mJPanel4.add((Component)mJLabel);
        Integer n2 = 0;
        Integer n3 = 0;
        Integer n4 = Integer.MAX_VALUE;
        Integer n5 = 1;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n2, n3, n4, n5);
        this.fTextHeaderLinesSpinner = new MJSpinner((SpinnerModel)spinnerNumberModel);
        this.fTextHeaderLinesSpinner.setName("HeaderLinesSpinner");
        ((JSpinner.DefaultEditor)this.fTextHeaderLinesSpinner.getEditor()).getTextField().getAccessibleContext().setAccessibleName(ImportUtils.getResource("dip.headerLines"));
        Dimension dimension2 = this.fTextHeaderLinesSpinner.getPreferredSize();
        dimension2.setSize(70.0, dimension2.getHeight());
        this.fTextHeaderLinesSpinner.setPreferredSize(dimension2);
        this.setHeaderLinesControls(n);
        this.fChangeListener = new HeaderControlListener();
        this.fTextHeaderLinesSpinner.addChangeListener((ChangeListener)this.fChangeListener);
        mJPanel4.add((Component)this.fTextHeaderLinesSpinner);
        Insets insets = titledBorder.getBorderInsets((Component)mJPanel3);
        mJPanel4.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        mJPanel.add((Component)mJPanel3, (Object)"West");
        mJPanel.add((Component)mJPanel4, (Object)"East");
        return mJPanel;
    }

    private void setDelimiterControls(String string) {
        int n = 4;
        if (string != null && string.length() == 1) {
            switch (string.charAt(0)) {
                case ',': {
                    n = 0;
                    break;
                }
                case ' ': {
                    n = 1;
                    break;
                }
                case ';': {
                    n = 2;
                    break;
                }
                case '\t': {
                    n = 3;
                }
            }
            if (n == 4) {
                this.fOtherTextField.setText(string);
            }
        }
        this.fCommaButton.setSelected(n == 0);
        this.fSpaceButton.setSelected(n == 1);
        this.fSemiButton.setSelected(n == 2);
        this.fTabButton.setSelected(n == 3);
        this.fOtherButton.setSelected(n == 4);
    }

    private void setHeaderLinesControls(int n) {
        int n2 = n == -1 ? 0 : n;
        this.fTextHeaderLinesSpinner.setValue((Object)n2);
    }

    void reinitialize(File file, String string, int n, String string2, String[] stringArray) {
        this.setFileToImport(file);
        this.setDelimiterControls(string);
        this.setHeaderLinesControls(n);
        this.setPreviewTextContents(string2);
        this.setPreviewTabList(stringArray);
    }

    private void refreshPreviewBorder() {
        String string = ImportUtils.getResource("dip.previewClipboard");
        if (this.fFileToImport != null) {
            string = ImportUtils.getResource("dip.previewArg", this.fFileToImport.getAbsolutePath());
        }
        this.fPreviewPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
    }

    public void setFileToImport(File file) {
        this.fFileToImport = file;
        this.refreshPreviewBorder();
    }

    public File getFileToImport() {
        return this.fFileToImport;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.requestUpdate();
    }

    private void requestUpdate() {
        this.fNextAvailable = false;
        this.putClientProperty("NAVIGATION_CHANGED", new Object());
        this.fOtherTextField.setEnabled(this.fOtherButton.isSelected());
        String string = this.getDelimiter();
        if (this.fRefreshRequestCounter == 0) {
            this.fPreviewPanel.cleanupTabbedPane();
            this.fPreviewPanel.addInterpretingTab();
        }
        ++this.fRefreshRequestCounter;
        this.fImportProxy.requestVariableListDelimiter(string, this.getHeaderLines());
    }

    int getHeaderLines() {
        return (Integer)this.fTextHeaderLinesSpinner.getValue();
    }

    String getDelimiter() {
        String string = ",";
        if (this.fCommaButton.isSelected()) {
            string = ",";
        }
        if (this.fSpaceButton.isSelected()) {
            string = " ";
        }
        if (this.fSemiButton.isSelected()) {
            string = ";";
        }
        if (this.fTabButton.isSelected()) {
            string = "\\t";
        }
        if (this.fOtherButton.isSelected() && (string = (this.fLastOtherText = this.fOtherTextField.getText())) != null) {
            if (string.charAt(0) == '\\') {
                return ESCD_BACK_SLASH;
            }
            if (string.charAt(0) == '%') {
                return ESCD_PERCENT;
            }
        }
        return string;
    }

    private void setOtherControlsEnabled(boolean bl) {
        this.fOtherTextField.setEnabled(bl);
    }

    void setPreviewTextContents(String string) {
        this.fPreviewPanel.setText(string);
    }

    void setPreviewTabList(String[] stringArray) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.fRefreshRequestCounter > 0) {
                --this.fRefreshRequestCounter;
            }
            this.fNextAvailable = false;
            if (this.fRefreshRequestCounter == 0) {
                this.fPreviewPanel.cleanupTabbedPane();
                if (stringArray == null || stringArray.length == 0) {
                    this.fPreviewPanel.addEmptyScrollPane();
                } else {
                    this.fNextAvailable = true;
                    for (String string : stringArray) {
                        VariableContentsViewer variableContentsViewer = new VariableContentsViewer(this, new ValueSpecification(string, -1, -1, null));
                        variableContentsViewer.setName("VariableContentsViewer");
                        this.fPreviewPanel.addTab(string, (Component)((Object)variableContentsViewer));
                    }
                }
            }
            this.putClientProperty("NAVIGATION_CHANGED", new Object());
        } else {
            PreviewTabListUpdater previewTabListUpdater = new PreviewTabListUpdater(stringArray);
            SwingUtilities.invokeLater(previewTabListUpdater);
        }
    }

    boolean isNextAvailable() {
        return this.fNextAvailable;
    }

    boolean isBackAvailable() {
        return this.fBackAvailable;
    }

    @Override
    public void getVariablePreviewData(VariableContentsViewer variableContentsViewer, ValueSpecification valueSpecification) {
        variableContentsViewer.setContents(ImportUtils.getResource("dip.generatingPreview"));
        this.fRequestorHashtable.put(valueSpecification.getHashtableKey(), variableContentsViewer);
        this.fImportProxy.requestVariablePreviewData(this, valueSpecification);
    }

    @Override
    public void addVariablePreviewData(ValueSpecification valueSpecification, String string) {
        String string2 = valueSpecification.getHashtableKey();
        if (this.fRequestorHashtable.containsKey(string2)) {
            VariableContentsViewer variableContentsViewer = this.fRequestorHashtable.get(string2);
            variableContentsViewer.setContents(string);
        }
    }

    @Override
    public void addVariablePreviewData(ValueSpecification valueSpecification, double[][] dArray, double[][] dArray2) {
        String string = valueSpecification.getHashtableKey();
        if (this.fRequestorHashtable.containsKey(string)) {
            VariableContentsViewer variableContentsViewer = this.fRequestorHashtable.get(string);
            variableContentsViewer.setContents(dArray, dArray2);
        }
    }

    @Override
    public void addVariablePreviewData(ValueSpecification valueSpecification, int[][] nArray, int[][] nArray2) {
        String string = valueSpecification.getHashtableKey();
        if (this.fRequestorHashtable.containsKey(string)) {
            VariableContentsViewer variableContentsViewer = this.fRequestorHashtable.get(string);
            variableContentsViewer.setContents(nArray, nArray2);
        }
    }

    public void cleanup() {
        this.fOtherTextField.getDocument().removeDocumentListener(this.fHeaderControlListener);
        this.fHeaderControlListener = null;
        this.fOtherTextField = null;
        this.fTextHeaderLinesSpinner.removeChangeListener((ChangeListener)this.fChangeListener);
        this.fChangeListener = null;
        this.removeAll();
        this.fPreviewPanel.cleanup();
        this.fPreviewPanel = null;
        this.fRequestorHashtable = null;
    }

    private class HeaderControlListener
    implements DocumentListener,
    ChangeListener {
        private HeaderControlListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!DataInterpretationPanel.this.fLastOtherText.equals(DataInterpretationPanel.this.fOtherTextField.getText())) {
                DataInterpretationPanel.this.requestUpdate();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DataInterpretationPanel.this.requestUpdate();
        }
    }

    private class PreviewTabListUpdater
    implements Runnable {
        private String[] fTabs;

        PreviewTabListUpdater(String[] stringArray) {
            this.fTabs = stringArray;
        }

        @Override
        public void run() {
            DataInterpretationPanel.this.setPreviewTabList(this.fTabs);
        }
    }

    private class DataPreviewPanel
    extends MJPanel {
        private SpreadsheetTable fSpreadsheetTable;
        private MJScrollPane fPreviewScrollPane;
        private MJTextArea fFilePreviewText;
        private MJTabbedPane fFilePreviewTabbedPane;
        private SpreadsheetScrollPane fDummySSP;
        private MJScrollPane fInterpretingSP;
        private JComponent fInterpretingText;

        void cleanup() {
            this.fSpreadsheetTable.cleanup();
            this.fSpreadsheetTable = null;
            this.fPreviewScrollPane.setViewportView(null);
            this.fPreviewScrollPane = null;
            this.cleanupTabbedPane();
            this.fFilePreviewTabbedPane = null;
            if (this.fDummySSP != null) {
                this.fDummySSP.cleanup();
                this.fDummySSP = null;
            }
            this.removeAll();
        }

        private void cleanupTabbedPane() {
            MJTabbedPane mJTabbedPane = this.fFilePreviewTabbedPane;
            for (int i = 0; i < mJTabbedPane.getTabCount(); ++i) {
                Component component = mJTabbedPane.getComponentAt(i);
                if (component instanceof VariableContentsViewer) {
                    ((VariableContentsViewer)((Object)component)).cleanup();
                }
                mJTabbedPane.removeAll();
            }
        }

        private void addTab(String string, Component component) {
            this.fFilePreviewTabbedPane.addTab(string, component);
        }

        private void addInterpretingTab() {
            this.addTab(ImportUtils.getResource("all.interpretingTabHeader"), (Component)this.fInterpretingSP);
        }

        DataPreviewPanel() {
            this.setLayout(new BorderLayout());
            this.fFilePreviewText = new MJTextArea();
            this.fFilePreviewText.setName("FilePreviewText");
            this.fFilePreviewText.setFont(FontPrefs.getCodeFont());
            this.fFilePreviewText.setEditable(false);
            this.fFilePreviewText.setText(ImportUtils.getResource("dip.selectSourceType"));
            this.fSpreadsheetTable = new SpreadsheetTable(16, 16);
            this.fSpreadsheetTable.setName("InterpSpreadsheetTable");
            this.fSpreadsheetTable.setScheme(0);
            this.fSpreadsheetTable.setEditable(false);
            this.fDummySSP = new SpreadsheetScrollPane((JTable)this.fSpreadsheetTable);
            this.fDummySSP.setFont(FontPrefs.getTextFont());
            this.fDummySSP.setName("InterpSpreadsheetScrollPane");
            this.fSpreadsheetTable.setFont(FontPrefs.getTextFont());
            this.fPreviewScrollPane = new MJScrollPane((Component)this.fFilePreviewText);
            this.fPreviewScrollPane.setName("FilePreviewScrollPane");
            MJTextArea mJTextArea = new MJTextArea();
            mJTextArea.setName("InterpretingText");
            mJTextArea.setEditable(false);
            mJTextArea.setText(ImportUtils.getResource("dip.interpreting"));
            mJTextArea.setFont(FontPrefs.getTextFont());
            this.fInterpretingText = mJTextArea;
            this.fInterpretingSP = new MJScrollPane((Component)this.fInterpretingText);
            this.fInterpretingSP.setName("InterpretingScrollPane");
            this.fFilePreviewTabbedPane = new MJTabbedPane();
            this.fFilePreviewTabbedPane.setName("FilePreviewTabbedPane");
            this.fFilePreviewTabbedPane.addTab(ImportUtils.getResource("all.noDataTabHeader"), (Component)this.fDummySSP);
            MJSplitPane mJSplitPane = new MJSplitPane(1, (Component)this.fPreviewScrollPane, (Component)this.fFilePreviewTabbedPane);
            mJSplitPane.setName("FilePreviewSplitPane");
            this.add((Component)mJSplitPane, "Center");
            mJSplitPane.setDividerLocation(0.5);
            mJSplitPane.setResizeWeight(0.5);
        }

        private void setText(String string) {
            this.fFilePreviewText.setText(string);
        }

        private void setTextForeground(Color color) {
            this.fFilePreviewText.setForeground(color);
            this.fInterpretingText.setForeground(color);
            for (int i = 0; i < this.fFilePreviewTabbedPane.getTabCount(); ++i) {
                Component component = this.fFilePreviewTabbedPane.getComponentAt(i);
                if (component instanceof VariableContentsViewer) {
                    ((VariableContentsViewer)((Object)component)).resetColors();
                    continue;
                }
                component.setForeground(color);
            }
        }

        private void setTextBackground(Color color) {
            this.fFilePreviewText.setBackground(color);
            this.fInterpretingText.setBackground(color);
            for (int i = 0; i < this.fFilePreviewTabbedPane.getTabCount(); ++i) {
                Component component = this.fFilePreviewTabbedPane.getComponentAt(i);
                if (component instanceof VariableContentsViewer) {
                    ((VariableContentsViewer)((Object)component)).resetColors();
                    continue;
                }
                component.setBackground(color);
            }
        }

        private void addEmptyScrollPane() {
            DataInterpretationPanel.this.fPreviewPanel.addTab(ImportUtils.getResource("all.noDataTabHeader"), (Component)this.fDummySSP);
        }
    }
}

