/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mde.cmdwin.CmdWinEditorKit;
import com.mathworks.mde.cmdwin.CmdWinExecuteServices;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.cmdwin.CmdWinSinkRegistrar;
import com.mathworks.mde.cmdwin.CmdWinStatusBar;
import com.mathworks.mde.cmdwin.CommandWindowRegistrar;
import com.mathworks.mde.cmdwin.FunctionBrowserRowHeader;
import com.mathworks.mde.cmdwin.XCaret;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.util.LanguageUtils;
import com.mathworks.widgets.CloseableMessageBar;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindParentListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class CmdWin
extends DTClientBase
implements PrefListener {
    private static XCmdWndView sCWView;
    private static CmdWinEditorKit sKit;
    private static CmdWinStatusBar sStatusBar;
    private JComponent fMessageBarBox;
    private JComponent fStartingMessageBar;
    private JComponent fHandleGraphics2MessageBar;
    private final CmdWinSinkRegistrar cmdWinSinkRegistrar;
    private static final Color HG2_TITLE_COLOR;
    private static final Color HG2_BACKGROUND_COLOR;
    private WindowAdapter desktopWindowListener = null;
    private static ResourceBundle sRes;
    private static ResourceBundle sMLRes;
    private static final CmdWin sCmdWin;

    private CmdWin() {
        EventListener eventListener;
        sCWView = XCmdWndView.getInstance();
        MJScrollPane mJScrollPane = sCWView.getScrollPane();
        this.setLayout(new BorderLayout());
        mJScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)mJScrollPane, "Center");
        JScrollBar jScrollBar = mJScrollPane.getVerticalScrollBar();
        if (jScrollBar != null) {
            eventListener = sCWView.getFunctionBrowserRowHeader();
            this.add((Component)((Object)eventListener), "West");
            jScrollBar.addAdjustmentListener(new AdjustmentListener((FunctionBrowserRowHeader)eventListener){
                final /* synthetic */ FunctionBrowserRowHeader val$functionBrowserRowHeader;
                {
                    this.val$functionBrowserRowHeader = functionBrowserRowHeader;
                }

                @Override
                public final void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (sCWView.isVisible() && !adjustmentEvent.getValueIsAdjusting()) {
                        this.val$functionBrowserRowHeader.doLayout();
                    }
                }
            });
        }
        this.fMessageBarBox = new MJPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height -= this.getComponentCount() - 1;
                return dimension;
            }

            public void doLayout() {
                super.doLayout();
                if (this.getComponentCount() > 1) {
                    Component component = this.getComponent(1);
                    component.setLocation(component.getX(), component.getY() - 1);
                }
            }
        };
        this.fMessageBarBox.setLayout(new BoxLayout(this.fMessageBarBox, 1));
        this.add(this.fMessageBarBox, "North");
        if (CmdWinPrefs.shouldShowStartingMessage()) {
            this.addStartingMessageBar();
        }
        if (CmdWinPrefs.shouldShowHandleGraphics2Message()) {
            this.addHandleGraphics2MessageBar();
        }
        Prefs.addListener((PrefListener)this, (String)"CommandWindowShowStartupMessage");
        Prefs.addListener((PrefListener)this, (String)"CommandWindowShowHandleGraphics2Message");
        sKit = CmdWinEditorKit.getInstance();
        sCWView.setEditorKit(sKit);
        this.setHideTitleWhenSolo(true);
        eventListener = XCmdWndView.getCutAction();
        Action action = XCmdWndView.getCopyAction();
        Action action2 = XCmdWndView.getPasteAction();
        Action action3 = CmdWinEditorKit.getActionByName("undo");
        Action action4 = CmdWinEditorKit.getActionByName("redo");
        Action action5 = XCmdWndView.getSelectAllAction();
        Action action6 = XCmdWndView.getFindAction();
        Action action7 = CmdWinEditorKit.getActionByName("find-files");
        Action action8 = CmdWinEditorKit.getActionByName("print");
        Action action9 = CmdWinEditorKit.getActionByName("show-page-setup");
        XCmdWndView.getEvalSelAction();
        XCmdWndView.getOpenSelAction();
        XCmdWndView.getPrintSelAction();
        XCmdWndView.getShowFunctionBrowserButtonAction();
        ContextTargetingManager.setToolName((Action)eventListener, (String)DTMenuMergeTag.CUT.toString());
        ContextTargetingManager.setToolName((Action)action, (String)DTMenuMergeTag.COPY.toString());
        ContextTargetingManager.setToolName((Action)action2, (String)DTMenuMergeTag.PASTE.toString());
        ContextTargetingManager.setToolName((Action)action3, (String)DTMenuMergeTag.UNDO.toString());
        ContextTargetingManager.setToolName((Action)action4, (String)DTMenuMergeTag.REDO.toString());
        ContextTargetingManager.setToolName((Action)action5, (String)DTMenuMergeTag.SELECT_ALL.toString());
        ContextTargetingManager.setToolName((Action)action6, (String)DTMenuMergeTag.FIND.toString());
        ContextTargetingManager.setToolName((Action)action7, (String)MLMenuMergeTag.FIND_FILES.toString());
        ContextTargetingManager.setToolName((Action)action8, (String)DTMenuMergeTag.PRINT.toString());
        ContextTargetingManager.setToolName((Action)action9, (String)DTMenuMergeTag.PAGE_SETUP.toString());
        this.setContextActions(new Action[]{eventListener, action, action2, action3, action4, action5, action6, action7, action8, action9});
        MJMenu mJMenu = new MJMenu();
        mJMenu.add(CmdWinEditorKit.getActionByName("clear-command-window"));
        this.setContextMenu((JMenu)mJMenu);
        sStatusBar = new CmdWinStatusBar(sCWView);
        this.setStatusBar(sStatusBar);
        sCWView.setStatusBar(sStatusBar);
        this.setPermitUserClose(false);
        this.setOnTopWhenUndocked(false);
        CmdWinMLIF.getInstance();
        CmdWinExecuteServices.createServices();
        MLExecuteServices.addMLExecutionListener((MLExecutionListener)XCaret.getInstance());
        MLExecuteServices.addMLExecutionListener((MLExecutionListener)XCmdWndView.getInstance());
        CommandWindowRegistrar.initialize();
        this.setName("cw_DTClientBase");
        this.cmdWinSinkRegistrar = new CmdWinSinkRegistrar();
        this.cmdWinSinkRegistrar.register();
        if (Matlab.isMatlabAvailable()) {
            SwingUtilities.invokeLater(new CWDTClientListener());
        }
    }

    private void createStartingMessageBar() {
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(sRes.getString("infobar.message"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                if (string.startsWith("matlab:demo")) {
                    Window window = SwingUtilities.windowForComponent((Component)((Object)CmdWin.this));
                    GlobalCursor.setWait((Window)window);
                    MLHelpServices.showDemos((String)"matlab");
                    GlobalCursor.clear((Window)window);
                } else {
                    new MatlabMCR().evalConsoleOutput(string.replace("matlab:", ""));
                }
            }
        });
        this.fStartingMessageBar = new CloseableMessageBar(hyperlinkTextLabel.getComponent(), null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CmdWinPrefs.setShouldShowStartingMessage(false);
            }
        }).getComponent();
    }

    private void createHandleGraphics2MessageBar() {
        MJLabel mJLabel = new MJLabel(sRes.getString("title.hg2_notification"));
        mJLabel.setFont(FontUtils.getSystemUIFont().deriveFont(LanguageUtils.isCJK() ? 0 : 1, 14.0f));
        mJLabel.setForeground(HG2_TITLE_COLOR);
        String string = sRes.getString("message.hg2_notification");
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(string, true);
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel("<a href=\"\">" + sRes.getString("message.hg2_notification_link") + "</a>", new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLDesktop.getInstance().getVisitHG2DiscoveryAction().actionPerformed(new ActionEvent((Object)CmdWin.this, 1001, "LearnMoreAboutHG2"));
            }
        });
        mJMultilineLabel.setOpaque(false);
        final int n = mJMultilineLabel.getFontMetrics(mJMultilineLabel.getFont()).stringWidth(string);
        MJPanel mJPanel = new MJPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = n / 2 + 40;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 100;
                return dimension;
            }
        };
        mJPanel.add((Component)mJLabel, (Object)"North");
        mJPanel.add((Component)mJMultilineLabel, (Object)"Center");
        mJPanel.add((Component)hyperlinkTextLabel.getComponent(), (Object)"South");
        this.fHandleGraphics2MessageBar = new CloseableMessageBar((JComponent)mJPanel, (Icon)MiscellaneousIcon.HG2_EXAMPLE.getIcon(), HG2_BACKGROUND_COLOR, Color.black, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CmdWinPrefs.setShouldShowHandleGraphics2Message(false);
            }
        }).getComponent();
    }

    public void prefChanged(PrefEvent prefEvent) {
        if (prefEvent.getPrefKey().equals("CommandWindowShowStartupMessage")) {
            if (CmdWinPrefs.shouldShowStartingMessage()) {
                this.addStartingMessageBar();
            } else {
                this.removeStartingMessageBar();
            }
        } else if (prefEvent.getPrefKey().equals("CommandWindowShowHandleGraphics2Message")) {
            if (CmdWinPrefs.shouldShowHandleGraphics2Message()) {
                this.addHandleGraphics2MessageBar();
            } else {
                this.removeHandleGraphics2MessageBar();
            }
        }
    }

    public static CmdWin getInstance() {
        return sCmdWin;
    }

    static CmdWinStatusBar getStatusBar() {
        return sStatusBar;
    }

    public void requestFocus() {
        sCWView.requestFocus();
    }

    private void addStartingMessageBar() {
        if (this.fStartingMessageBar == null) {
            this.createStartingMessageBar();
        }
        this.fMessageBarBox.add((Component)this.fStartingMessageBar, 0);
        this.revalidate();
        this.repaint();
    }

    private void removeStartingMessageBar() {
        if (this.fStartingMessageBar != null) {
            this.fMessageBarBox.remove(this.fStartingMessageBar);
            this.fStartingMessageBar = null;
            this.revalidate();
            this.repaint();
        }
    }

    private void addHandleGraphics2MessageBar() {
        if (this.fHandleGraphics2MessageBar == null) {
            this.createHandleGraphics2MessageBar();
        }
        this.fMessageBarBox.add(this.fHandleGraphics2MessageBar);
        this.revalidate();
        this.repaint();
    }

    private void removeHandleGraphics2MessageBar() {
        if (this.fHandleGraphics2MessageBar != null) {
            this.fMessageBarBox.remove(this.fHandleGraphics2MessageBar);
            this.fHandleGraphics2MessageBar = null;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean hasFocus() {
        return sCWView.hasFocus();
    }

    public static void main(String[] stringArray) {
        CmdWin.getInstance();
    }

    static {
        HG2_TITLE_COLOR = new Color(6, 85, 149);
        HG2_BACKGROUND_COLOR = new Color(232, 245, 255);
        sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdwin.resources.RES_CmdWin");
        sMLRes = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop");
        sCmdWin = new CmdWin();
    }

    private class CWDTClientListener
    extends DTClientAdapter
    implements Runnable {
        private CWDTClientListener() {
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = sCWView.getFindParentListener();
            if (findParentListener == null) {
                FindDialog.registerComponent((FindClientInterface)sCWView.getFindClient(), (String[])new String[]{sMLRes.getString("title.CommandWindow")}, (int)2);
            }
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = sCWView.getFindParentListener();
            if (findParentListener != null) {
                findParentListener.docked(sCWView.getFindClient());
            }
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = sCWView.getFindParentListener();
            if (findParentListener != null) {
                findParentListener.undocked(sCWView.getFindClient());
            }
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = sCWView.getFindParentListener();
            if (findParentListener != null) {
                findParentListener.closing(sCWView.getFindClient());
            }
            FindDialog.unregister((FindClientInterface)sCWView.getFindClient());
            assert (MLDesktop.getInstance() != null);
            DTFrame dTFrame = MLDesktop.getInstance().getMainFrame();
            if (dTFrame != null) {
                if (CmdWin.this.desktopWindowListener == null) {
                    CmdWin.this.desktopWindowListener = new WindowAdapter((MJFrame)dTFrame){
                        final /* synthetic */ MJFrame val$dtFrame;
                        {
                            this.val$dtFrame = mJFrame;
                        }

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            CmdWin.this.cmdWinSinkRegistrar.unregister();
                            this.val$dtFrame.removeWindowListener((WindowListener)CmdWin.this.desktopWindowListener);
                            CmdWin.this.desktopWindowListener = null;
                        }
                    };
                    dTFrame.addWindowListener((WindowListener)CmdWin.this.desktopWindowListener);
                }
            } else {
                CmdWin.this.cmdWinSinkRegistrar.unregister();
            }
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            CmdWin.this.cmdWinSinkRegistrar.register();
            assert (MLDesktop.getInstance() != null);
            DTFrame dTFrame = MLDesktop.getInstance().getMainFrame();
            if (dTFrame != null) {
                dTFrame.removeWindowListener((WindowListener)CmdWin.this.desktopWindowListener);
                CmdWin.this.desktopWindowListener = null;
            }
        }

        @Override
        public void run() {
            CmdWin.this.getParentDesktop().addClientListener((Component)((Object)CmdWin.this), (DTClientListener)this);
        }
    }
}

