/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.jidesoft.swing.StyleRange;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class CommandStyleInfo {
    private final Tokenizer.TokenInfo[] fTokens;
    private static Map<Color, AttributeSet> sForegroundAttributeMap = new HashMap<Color, AttributeSet>();
    public static final Color HIGHLIGHT_FOREGROUND = new Color(0, 0, 32);
    public static final Color HIGHLIGHT_BACKGROUND = new Color(255, 255, 150);

    public CommandStyleInfo(String string) {
        this(string.toCharArray());
    }

    public CommandStyleInfo(char[] cArray) {
        this.fTokens = TokenizerFactory.getMTokenizer().tokenize(cArray);
    }

    public StyleRange[] getStyleRanges() {
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>(this.fTokens.length);
        for (Tokenizer.TokenInfo tokenInfo : this.fTokens) {
            Color color = this.getTokenColor(tokenInfo);
            if (color == null) continue;
            arrayList.add(new StyleRange(tokenInfo.getOffset(), tokenInfo.getLength(), color));
        }
        return arrayList.toArray(new StyleRange[arrayList.size()]);
    }

    public int getAttributesCount() {
        return this.fTokens.length;
    }

    public int getAttributesStart(int n) {
        return this.fTokens[n].getOffset();
    }

    public int getAttributesLength(int n) {
        return this.fTokens[n].getLength();
    }

    public AttributeSet getAttributes(int n) {
        Tokenizer.TokenInfo tokenInfo = this.fTokens[n];
        Color color = this.getTokenColor(tokenInfo);
        if (color != null) {
            AttributeSet attributeSet = sForegroundAttributeMap.get(color);
            if (attributeSet == null) {
                attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground((MutableAttributeSet)attributeSet, color);
                sForegroundAttributeMap.put(color, attributeSet);
            }
            return attributeSet;
        }
        return null;
    }

    private Color getTokenColor(Tokenizer.TokenInfo tokenInfo) {
        String string = tokenInfo.getColorPreferenceName();
        return string == null ? null : TokenizerFactory.getColorFromName((String)string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CommandStyleInfo)) {
            return false;
        }
        CommandStyleInfo commandStyleInfo = (CommandStyleInfo)object;
        if (this.fTokens.length != commandStyleInfo.fTokens.length) {
            return false;
        }
        for (int i = 0; i < this.fTokens.length; ++i) {
            if (this.fTokens[i].getOffset() == commandStyleInfo.fTokens[i].getOffset() && this.fTokens[i].getLength() == commandStyleInfo.fTokens[i].getLength() && this.fTokens[i].getColorPreferenceName() == commandStyleInfo.fTokens[i].getColorPreferenceName()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 11;
        for (Tokenizer.TokenInfo tokenInfo : this.fTokens) {
            n += 17 * tokenInfo.getOffset();
            n += 17 * tokenInfo.getLength();
            n += 17 * tokenInfo.getColorPreferenceName().hashCode();
        }
        return n;
    }

    public static StyleRange[] getHighlightRanges(String string, String string2, boolean bl, boolean bl2) {
        int n;
        int n2 = string2.length();
        if (bl2) {
            if (bl && string.startsWith(string2) || !bl && string.regionMatches(true, 0, string2, 0, string2.length())) {
                return new StyleRange[]{new StyleRange(0, n2, 0, HIGHLIGHT_FOREGROUND, HIGHLIGHT_BACKGROUND, 0)};
            }
            return null;
        }
        if (!bl) {
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
        }
        if ((n = string.indexOf(string2)) < 0) {
            return null;
        }
        StyleRange styleRange = new StyleRange(n, n2, 0, HIGHLIGHT_FOREGROUND, HIGHLIGHT_BACKGROUND, 0);
        int n3 = string.indexOf(string2, n + n2);
        if (n3 < 0) {
            return new StyleRange[]{styleRange};
        }
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
        arrayList.add(styleRange);
        while (n3 >= 0) {
            styleRange = new StyleRange(n3, n2, 0, HIGHLIGHT_FOREGROUND, HIGHLIGHT_BACKGROUND, 0);
            arrayList.add(styleRange);
            n3 = string.indexOf(string2, n3 + n2);
        }
        return arrayList.toArray(new StyleRange[arrayList.size()]);
    }

    public static StyleRange[] addHighlightRanges(StyleRange[] styleRangeArray, StyleRange[] styleRangeArray2) {
        if (styleRangeArray2 == null || styleRangeArray2.length == 0) {
            return styleRangeArray;
        }
        if (styleRangeArray == null || styleRangeArray.length == 0) {
            return styleRangeArray2;
        }
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
        styleRangeArray = Arrays.copyOf(styleRangeArray, styleRangeArray.length);
        int n = 0;
        for (StyleRange styleRange : styleRangeArray2) {
            int n2 = styleRange.getStart();
            int n3 = n2 + styleRange.getLength();
            while (n < styleRangeArray.length) {
                StyleRange styleRange2 = styleRangeArray[n];
                int n4 = styleRange2.getStart();
                int n5 = n4 + styleRange2.getLength();
                if (n5 < n2) {
                    arrayList.add(styleRange2);
                } else if (n4 < n2) {
                    arrayList.add(new StyleRange(n4, n2 - n4, styleRange2.getFontColor()));
                } else if (n4 > n3) break;
                if (n5 > n3) {
                    int n6 = n3 - n4;
                    styleRangeArray[n] = new StyleRange(n4 + n6, styleRange2.getLength() - n6, styleRange2.getFontColor());
                    break;
                }
                ++n;
            }
            arrayList.add(styleRange);
        }
        while (n < styleRangeArray.length) {
            arrayList.add(styleRangeArray[n]);
            ++n;
        }
        return arrayList.toArray(new StyleRange[arrayList.size()]);
    }
}

