/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.array;

import com.mathworks.common.icons.VariableIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.array.ArrayEditorResources;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.FormatToolsetSupplierFactory;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSComboBox;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.TSTextField;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ArrayEditorToolstripTabFactory {
    private static TSTabConfiguration sMainTabConfig = null;
    private static TSToolSetContents sToolSetContents = null;
    private static TSToolSet sToolSet = null;
    private static TSTabConfiguration sViewTabConfig = null;
    private static TSToolSetContents sViewTabContents = null;
    private static TSToolSet sViewToolSet = null;
    private static final int VARIABLE_LIST_LIMIT = 1000;
    private static final String MORE_VARIABLES_ITEM_NAME = "more variables";

    private ArrayEditorToolstripTabFactory() {
    }

    static TSToolSet createToolSet() {
        return new TSToolSet(sToolSet);
    }

    static TSToolSet createViewToolSet() {
        return new TSToolSet(sViewToolSet);
    }

    static List<ToolstripTab> createTabs(TSToolSet tSToolSet, TSToolSet tSToolSet2, WorkspaceVariable workspaceVariable, boolean bl, List<FormatToolsetSupplierFactory.FormatSupported> list) {
        return ArrayEditorToolstripTabFactory.createTabs(tSToolSet, tSToolSet2, workspaceVariable, workspaceVariable == null || MLDesktop.getInstance().isClientDocked(workspaceVariable.getVariableName()), bl, list);
    }

    private static List<ToolstripTab> createTabs(TSToolSet tSToolSet, TSToolSet tSToolSet2, WorkspaceVariable workspaceVariable, boolean bl, boolean bl2, List<FormatToolsetSupplierFactory.FormatSupported> list) {
        ArrayList<ToolstripTab> arrayList = new ArrayList<ToolstripTab>(2);
        arrayList.add(TSFactory.createTab((TSTabConfiguration)sMainTabConfig, (boolean)true, (TSToolSet[])new TSToolSet[]{tSToolSet}));
        try {
            sViewTabConfig = new TSTabConfiguration(SimpleDOMUtils.read((URL)ArrayEditorToolstripTabFactory.class.getResource("resources/ViewTab.xml")));
            if (!bl2) {
                sViewTabConfig.removeSection("codegen_section");
            }
            if (list != null && !list.contains(FormatToolsetSupplierFactory.FormatSupported.NUMERIC)) {
                sViewTabConfig.removeTool("format_section", "format", "variable_view_toolset");
                sViewTabConfig.removeTool("format_section", "format_label", "variable_view_toolset");
            }
            if (list == null || !list.contains(FormatToolsetSupplierFactory.FormatSupported.DATETIME)) {
                sViewTabConfig.removeTool("format_section", "datetimeFormat", "variable_view_toolset");
                sViewTabConfig.removeTool("format_section", "datetimeFormat_label", "variable_view_toolset");
            }
            if (workspaceVariable == null || bl) {
                arrayList.add(TSFactory.createTab((TSTabConfiguration)sViewTabConfig, (boolean)true, (TSToolSet[])new TSToolSet[]{tSToolSet2, MLDesktop.getInstance().getDefaultViewTabFactory().createToolSet("Array Editor")}));
            } else {
                sViewTabConfig.removeSection("tiles");
                sViewTabConfig.removeSection("document_bar");
                arrayList.add(TSFactory.createTab((TSTabConfiguration)sViewTabConfig, (boolean)true, (TSToolSet[])new TSToolSet[]{tSToolSet2}));
            }
        }
        catch (IOException | DataFormatException exception) {
            throw new RuntimeException(exception);
        }
        return arrayList;
    }

    static void disposeTabs(List<ToolstripTab> list) {
        if (list != null) {
            for (ToolstripTab toolstripTab : list) {
                TSFactory.disposeTab((ToolstripTab)toolstripTab);
            }
        }
    }

    private static TSToolSet createCommonVarEditToolSet() {
        TSToolSet tSToolSet = new TSToolSet(sToolSetContents);
        tSToolSet.configureAndAdd("open_variable", (Action)((Object)new OpenWorkspaceVariableAction()));
        TSToolSet.ToolSupplier toolSupplier = new TSToolSet.ToolSupplier(){

            public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                TSTextField tSTextField = new TSTextField(5);
                tSTextField.setEnabled(false);
                return tSTextField;
            }
        };
        tSToolSet.addSupplier("row_range", toolSupplier);
        tSToolSet.addSupplier("column_range", toolSupplier);
        tSToolSet.addSupplier("create", new TSToolSet.ToolSupplier(){

            public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                return new TSSplitButton(ArrayUtils.getResource((String)"variable.new.label"), (Icon)new ImageIcon(this.getClass().getResource(toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR ? "/com/mathworks/common/icons/resources/new_ts_16.png" : "/com/mathworks/common/icons/resources/new_ts_24.png")));
            }
        });
        return tSToolSet;
    }

    private static TSToolSet createCommonViewToolSet() {
        TSToolSet tSToolSet = new TSToolSet(sViewTabContents);
        tSToolSet.addSupplier("format", new TSToolSet.ToolSupplier(){

            public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                return new TSComboBox();
            }
        });
        tSToolSet.addSupplier("datetimeFormat", new TSToolSet.ToolSupplier(){

            public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                return new TSComboBox();
            }
        });
        return tSToolSet;
    }

    private static ListItem[] createVariableListItems(WhosInformation whosInformation) {
        ListItem[] listItemArray;
        int n = whosInformation.size();
        if (n > 1000) {
            n = 1000;
            listItemArray = new ListItem[n + 1];
        } else {
            listItemArray = new ListItem[n];
        }
        for (int i = 0; i < n; ++i) {
            String string = whosInformation.getName(i);
            listItemArray[i] = ListItem.newItem((String)string, (String)string, (Icon)WorkspaceIcon.getIcon((String)whosInformation.getClass(i)));
        }
        if (n < whosInformation.size()) {
            listItemArray[n] = ListItem.newItem((String)MORE_VARIABLES_ITEM_NAME, (String)ArrayEditorResources.getBundle().getString("message.MoreInWorkspace"), (Icon)VariableIcon.NONEXISTENT.getIcon());
        }
        return listItemArray;
    }

    static {
        try {
            sMainTabConfig = new TSTabConfiguration(SimpleDOMUtils.read((URL)ArrayEditorToolstripTabFactory.class.getResource("resources/ArrayEditorTab.xml")));
            sToolSetContents = new TSToolSetContents(SimpleDOMUtils.read((URL)ArrayEditorToolstripTabFactory.class.getResource("resources/ArrayEditorToolset.xml")));
            sToolSet = ArrayEditorToolstripTabFactory.createCommonVarEditToolSet();
            sViewTabConfig = new TSTabConfiguration(SimpleDOMUtils.read((URL)ArrayEditorToolstripTabFactory.class.getResource("resources/ViewTab.xml")));
            sViewTabContents = new TSToolSetContents(SimpleDOMUtils.read((URL)ArrayEditorToolstripTabFactory.class.getResource("resources/ViewToolset.xml")));
            sViewToolSet = ArrayEditorToolstripTabFactory.createCommonViewToolSet();
        }
        catch (IOException | DataFormatException exception) {
            Log.logException((Exception)exception);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class VariableSelectionListener
    implements ListActionListener {
        private VariableSelectionListener() {
        }

        public void listItemSelected(ListActionEvent listActionEvent) {
            String string = listActionEvent.getListItem().getName();
            if (ArrayEditorToolstripTabFactory.MORE_VARIABLES_ITEM_NAME.equals(string)) {
                MatlabDesktopServices.showWorkspaceBrowser();
            } else if (MLDesktop.getInstance().hasClient(string, "Array Editor")) {
                MLDesktop.getInstance().setClientSelected(string, "Array Editor", true);
            } else {
                WorkspaceCommands.openVariable((String)string);
            }
        }
    }

    private static class VariableListFetcher
    implements CompletionObserver {
        private final PopupListener.PopupCallback iCallback;

        private VariableListFetcher(PopupListener.PopupCallback popupCallback) {
            this.iCallback = popupCallback;
            new Matlab().feval("eval", (Object[])new String[]{"workspacefunc('getwhosinformation', builtin('whos'));"}, 1, (CompletionObserver)this);
        }

        public void completed(int n, Object object) {
            final WhosInformation whosInformation = (WhosInformation)object;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ListItem[] listItemArray = ArrayEditorToolstripTabFactory.createVariableListItems(whosInformation);
                    if (listItemArray.length > 0) {
                        PopupList popupList = ToolstripSections.createList((ListItem[])listItemArray, (ListActionListener)new VariableSelectionListener(), (ListStyle)ListStyle.ICON_TEXT);
                        popupList.setName("array_editor_toolset:openVarPopupList");
                        VariableListFetcher.this.iCallback.show((JComponent)popupList);
                    } else {
                        MJLabel mJLabel = new MJLabel("<html><i>" + ArrayEditorResources.getBundle().getString("message.NoVariables") + "</i></html>"){

                            public Dimension getPreferredSize() {
                                Dimension dimension = super.getPreferredSize();
                                dimension.width += 10;
                                return dimension;
                            }
                        };
                        mJLabel.setBorder(BorderFactory.createEmptyBorder(6, 10, 6, 10));
                        VariableListFetcher.this.iCallback.show((JComponent)mJLabel);
                    }
                }
            });
        }
    }

    public static class OpenWorkspaceVariableAction
    extends MJAbstractAction {
        public OpenWorkspaceVariableAction() {
            this.putValue("PopupListener", new PopupListener(){

                public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                    new VariableListFetcher(popupCallback);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class NewVariableAction
    extends MJAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.createAndOpenVariable();
        }
    }

    public static class Registrar
    implements ToolstripInfoRegistrar {
        public void registerToolstripInfo(TSRegistry tSRegistry) {
            tSRegistry.addTabConfiguration(sMainTabConfig);
            tSRegistry.addToolSetContents(sToolSetContents);
            tSRegistry.addToolSet(sToolSet);
        }
    }
}

