% Specialized math functions.
%
% Specialized math functions.
%   airy        - Airy functions.
%   besselj     - Bessel function of the first kind.
%   bessely     - Bessel function of the second kind.
%   besselh     - Bessel functions of the third kind (Hankel function).
%   besseli     - Modified Bessel function of the first kind.
%   besselk     - Modified Bessel function of the second kind.
%   beta        - Beta function.
%   betainc     - Incomplete beta function.
%   betaincinv  - Inverse incomplete beta function.
%   betaln      - Logarithm of beta function.
%   ellipj      - Jacobi elliptic functions.
%   ellipke     - Complete elliptic integral.
%   erf         - Error function.
%   erfc        - Complementary error function.
%   erfcx       - Scaled complementary error function.
%   erfinv      - Inverse error function.
%   expint      - Exponential integral function.
%   gamma       - Gamma function.
%   gammainc    - Incomplete gamma function.
%   gammaincinv - Inverse incomplete gamma function. 
%   gammaln     - Logarithm of gamma function.
%   psi         - Psi (polygamma) function.
%   legendre    - Associated Legendre function.
%   cross       - Vector cross product.
%   dot         - Vector dot product.
%
% Number theoretic functions.
%   factor      - Prime factors.
%   isprime     - True for prime numbers.
%   primes      - Generate list of prime numbers.
%   gcd         - Greatest common divisor.
%   lcm         - Least common multiple.
%   rat         - Rational approximation.
%   rats        - Rational output.
%   perms       - All possible permutations.
%   nchoosek    - All combinations of N elements taken K at a time.
%   factorial   - Factorial function.
%
% Coordinate transforms.
%   cart2sph    - Transform Cartesian to spherical coordinates.
%   cart2pol    - Transform Cartesian to polar coordinates.
%   pol2cart    - Transform polar to Cartesian coordinates.
%   sph2cart    - Transform spherical to Cartesian coordinates.
%   hsv2rgb     - Convert hue-saturation-value colors to red-green-blue.
%   rgb2hsv     - Convert red-green-blue colors to hue-saturation-value.

%   Copyright 1984-2012 The MathWorks, Inc.
%   $Revision: 5.19.4.5 $  $Date: 2012/04/14 04:16:16 $

