% Elementary math functions.
%
% Trigonometric.
%   sin         - Sine.
%   sind        - Sine of argument in degrees.
%   sinh        - Hyperbolic sine.
%   asin        - Inverse sine.
%   asind       - Inverse sine, result in degrees.
%   asinh       - Inverse hyperbolic sine.
%   cos         - Cosine.
%   cosd        - Cosine of argument in degrees.
%   cosh        - Hyperbolic cosine.
%   acos        - Inverse cosine.
%   acosd       - Inverse cosine, result in degrees.
%   acosh       - Inverse hyperbolic cosine.
%   tan         - Tangent.
%   tand        - Tangent of argument in degrees.
%   tanh        - Hyperbolic tangent.
%   atan        - Inverse tangent.
%   atand       - Inverse tangent, result in degrees.
%   atan2       - Four quadrant inverse tangent.
%   atan2d      - Four quadrant inverse tangent, result in degrees.
%   atanh       - Inverse hyperbolic tangent.
%   sec         - Secant.
%   secd        - Secant of argument in degrees.
%   sech        - Hyperbolic secant.
%   asec        - Inverse secant.
%   asecd       - Inverse secant, result in degrees.
%   asech       - Inverse hyperbolic secant.
%   csc         - Cosecant.
%   cscd        - Cosecant of argument in degrees.
%   csch        - Hyperbolic cosecant.
%   acsc        - Inverse cosecant.
%   acscd       - Inverse cosecant, result in degrees.
%   acsch       - Inverse hyperbolic cosecant.
%   cot         - Cotangent.
%   cotd        - Cotangent of argument in degrees.
%   coth        - Hyperbolic cotangent.
%   acot        - Inverse cotangent.
%   acotd       - Inverse cotangent, result in degrees.
%   acoth       - Inverse hyperbolic cotangent.
%   hypot       - Square root of sum of squares.
%
% Exponential.
%   exp         - Exponential.
%   expm1       - Compute exp(x)-1 accurately.
%   log         - Natural logarithm.
%   log1p       - Compute log(1+x) accurately.
%   log10       - Common (base 10) logarithm.
%   log2        - Base 2 logarithm and dissect floating point number.
%   pow2        - Base 2 power and scale floating point number.
%   realpow     - Power that will error out on complex result.
%   reallog     - Natural logarithm of real number.
%   realsqrt    - Square root of number greater than or equal to zero.
%   sqrt        - Square root.
%   nthroot     - Real n-th root of real numbers.
%   nextpow2    - Next higher power of 2.
%
% Complex.
%   abs         - Absolute value.
%   angle       - Phase angle.
%   complex     - Construct complex data from real and imaginary parts.
%   conj        - Complex conjugate.
%   imag        - Complex imaginary part.
%   real        - Complex real part.
%   unwrap      - Unwrap phase angle.
%   isreal      - True for real array.
%   cplxpair    - Sort numbers into complex conjugate pairs.
%
% Rounding and remainder.
%   fix         - Round towards zero.
%   floor       - Round towards minus infinity.
%   ceil        - Round towards plus infinity.
%   round       - Round towards nearest integer.
%   mod         - Modulus (signed remainder after division).
%   rem         - Remainder after division.
%   sign        - Signum.

%   Copyright 1984-2011 The MathWorks, Inc.
%   $Revision: 5.16.4.4 $  $Date: 2011/12/16 16:32:50 $
