/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class ExportClipboardHelper
implements Transferable {
    public static final String EMF_FORMAT = "emf";
    public static final DataFlavor EMF_FLAVOR = new DataFlavor("image/emf", "Enhanced Metafile");
    public static final String PDF_FORMAT = "pdf";
    public static final DataFlavor PDF_FLAVOR = new DataFlavor("application/pdf", "Portable Document Format");
    public static final String IMAGE_FORMAT = "image";
    public static final DataFlavor IMAGE_FLAVOR = DataFlavor.imageFlavor;
    private static HashMap sFlavorMap = null;
    private DataFlavor[] fSupportedFlavors = null;
    private ByteArrayOutputStream fStreamData;
    private Image fImageData;

    static void addToFlavorMap(String string, DataFlavor dataFlavor) {
        if (sFlavorMap == null) {
            sFlavorMap = new HashMap();
        }
        DataFlavor[] dataFlavorArray = new DataFlavor[]{dataFlavor};
        sFlavorMap.put(string, dataFlavorArray);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(EMF_FLAVOR) || dataFlavor.equals(PDF_FLAVOR)) {
            return new ByteArrayInputStream(this.fStreamData.toByteArray());
        }
        if (dataFlavor.equals(IMAGE_FLAVOR)) {
            return this.fImageData;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.fSupportedFlavors;
    }

    private void setTransferDataFlavors(DataFlavor[] dataFlavorArray) {
        this.fSupportedFlavors = dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : this.getTransferDataFlavors()) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(this, null);
    }

    public ExportClipboardHelper(String string, ByteArrayOutputStream byteArrayOutputStream) throws UnsupportedFlavorException {
        this.fStreamData = byteArrayOutputStream;
        if (sFlavorMap.get(string) == null) {
            throw new UnsupportedFlavorException(null);
        }
        this.setTransferDataFlavors((DataFlavor[])sFlavorMap.get(string));
    }

    public ExportClipboardHelper(String string, Image image) throws UnsupportedFlavorException {
        this.fImageData = image;
        if (sFlavorMap.get(string) == null) {
            throw new UnsupportedFlavorException(null);
        }
        this.setTransferDataFlavors((DataFlavor[])sFlavorMap.get(string));
    }

    static {
        SystemFlavorMap systemFlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        systemFlavorMap.addUnencodedNativeForFlavor(EMF_FLAVOR, "ENHMETAFILE");
        systemFlavorMap.addUnencodedNativeForFlavor(PDF_FLAVOR, "Portable Document Format");
        ExportClipboardHelper.addToFlavorMap(EMF_FORMAT, EMF_FLAVOR);
        ExportClipboardHelper.addToFlavorMap(PDF_FORMAT, PDF_FLAVOR);
        ExportClipboardHelper.addToFlavorMap(IMAGE_FORMAT, IMAGE_FLAVOR);
    }
}

