/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.jidesoft.combobox.ListComboBox;
import com.jidesoft.converter.EnumConverter;
import com.jidesoft.grid.AbstractMultiTableModel;
import com.jidesoft.grid.BooleanCheckBoxCellEditor;
import com.jidesoft.grid.BooleanCheckBoxCellRenderer;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EnumCellEditor;
import com.jidesoft.grid.EnumCellRenderer;
import com.jidesoft.grid.LongCellEditor;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.NumberCellRenderer;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TextFieldCellEditor;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.common.icons.ProjectIcon;
import com.mathworks.hg.types.table.ColumnDefinition;
import com.mathworks.hg.types.table.ColumnFormatEnum;
import com.mathworks.hg.types.table.TablePropertyModel;
import com.mathworks.hg.types.table.format.FormatEditor;
import com.mathworks.hg.types.table.format.FormatTypeEnum;
import com.mathworks.hg.types.table.format.MLFormatTypeEnum;
import com.mathworks.hg.types.table.panel.AbstractEditorPanel;
import com.mathworks.hg.types.table.panel.ChoiceListEditor;
import com.mathworks.hg.types.table.panel.EditableTableSupport;
import com.mathworks.hg.types.table.panel.EditableTableUtils;
import com.mathworks.hg.types.table.panel.MessagePanel;
import com.mathworks.hg.types.table.panel.PropertyPanelEnum;
import com.mathworks.hg.types.table.panel.RowHeaderMode;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ColumnDefinitionPanel
extends AbstractEditorPanel
implements EditableTableSupport {
    private static final int MULTICOL_HEADER = 0;
    private static final int MULTICOL_NAME = 1;
    private static final int MULTICOL_AUTO = 2;
    private static final int MULTICOL_WIDTH = 3;
    private static final int MULTICOL_EDITABLE = 4;
    private static final int MULTICOL_FORMAT = 5;
    private static final int COL_NAME = 0;
    private static final int COL_AUTO = 1;
    private static final int COL_WIDTH = 2;
    private static final int COL_EDITABLE = 3;
    private static final int COL_FORMAT = 4;
    private JTable fMainTable;
    private DefinitionsTableModel fTableModel;
    private MessagePanel fInfoPanel;
    private MJRadioButton fRadioNone;
    private MJRadioButton fRadioNumbered;
    private MJRadioButton fRadioNamed;
    private MJButton fButtonInsert;
    private MJButton fButtonCopy;
    private MJButton fButtonDelete;
    private MJButton fButtonMoveUp;
    private MJButton fButtonMoveDown;
    private MJButton fButtonFormat;
    private boolean fIsEnterInLastRowNameField = false;
    private ComponentAdapter fScrollComponentListener;
    private ColumnInfoMode fCurrentInfoMode;

    public ColumnDefinitionPanel(PropertyPanelEnum propertyPanelEnum, TablePropertyModel tablePropertyModel) {
        super(propertyPanelEnum, tablePropertyModel);
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    protected JPanel buildEditorPanel() {
        this.fInfoPanel = new MessagePanel(this.getResourceString("columns.info_default"));
        this.fInfoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("columns.info_default"));
        this.fCurrentInfoMode = ColumnInfoMode.DEFAULT;
        FormLayout formLayout = new FormLayout("fill:p:g(1.0)", "p, 8dlu, fill:p:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildHeaderPanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildColumnsPanel(), cellConstraints.xy(1, 3));
        panelBuilder.setBorder(Borders.createEmptyBorder((String)"6dlu, 0dlu, 0dlu, 0dlu"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)this.fInfoPanel), (Object)"North");
        mJPanel.add((Component)panelBuilder.getPanel(), (Object)"Center");
        mJPanel.setBorder(Borders.createEmptyBorder((String)"7dlu, 7dlu, 0dlu, 0dlu"));
        mJPanel.getAccessibleContext().setAccessibleName(this.getResourceString("acc.columns.name"));
        return mJPanel;
    }

    @Override
    protected void initializePanel() {
        this.setColumns();
    }

    private void setColumns() {
        Object object;
        Object object2;
        Object object3;
        Boolean bl;
        String string;
        Object object4 = this.propertyModel.getProperty("ColumnName");
        Object object5 = this.getMetadataValue("ColumnNameTyped");
        Object object6 = this.propertyModel.getProperty("ColumnEditable");
        Object object7 = this.propertyModel.getProperty("ColumnFormat");
        Object object8 = this.propertyModel.getProperty("ColumnWidth");
        Object object9 = this.getMetadataValue("DataPropertyDimension");
        int n = 0;
        ArrayList<Object> arrayList = null;
        do {
            string = null;
            if (object4 != null && object4 instanceof String[]) {
                if (((String[])object4).length > n) {
                    string = ((String[])object4)[n];
                }
            } else if (object5 != null && object5 instanceof String[] && ((String[])object5).length > n) {
                string = ((String[])object5)[n];
            }
            bl = null;
            if (object6 instanceof boolean[] && ((boolean[])object6).length > n) {
                bl = ((boolean[])object6)[n];
            }
            object3 = null;
            if (object7 instanceof Object[] && ((Object[])object7).length > n) {
                object3 = ((Object[])object7)[n];
            }
            object2 = null;
            if (object8 instanceof Object[] && ((Object[])object8).length > n) {
                object2 = ((Object[])object8)[n];
            }
            if (!(object9 != null && object9 instanceof double[] && (double)n < ((double[])object9)[1] || string != null && !string.equals("") || bl != null || object3 != null) && object2 == null) continue;
            object = new ColumnDefinition(string == null ? "" : string);
            object.setEditable(bl != null && bl != false);
            object.setAutoWidth(object2 == null || object2 instanceof double[] && ((double[])object2).length == 0 || object2.equals("auto"));
            if (object2 instanceof double[] && ((double[])object2).length == 1) {
                object.setFixedWidth((long)((double[])object2)[0]);
            }
            ColumnDefinitionPanel.setColumnFormat(object, object3);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            arrayList.add(object);
        } while (object9 != null && object9 instanceof double[] && (double)(++n) < ((double[])object9)[1] || string != null && !string.equals("") || bl != null || object3 != null || object2 != null);
        if (arrayList != null) {
            this.fTableModel.setDefinitions(arrayList);
        }
        if (this.fTableModel.getRowCount() == 0) {
            this.fTableModel.addDefinition();
        }
        object = object4 == null || "".equals(object4) || object4 instanceof String[] && ((String[])object4).length == 0 ? RowHeaderMode.NONE : ("numbered".equals(object4) ? RowHeaderMode.NUMBERED : RowHeaderMode.NAMED);
        MJRadioButton mJRadioButton = this.fRadioNumbered;
        switch (22.$SwitchMap$com$mathworks$hg$types$table$panel$RowHeaderMode[((Enum)object).ordinal()]) {
            case 1: {
                mJRadioButton = this.fRadioNamed;
                break;
            }
            case 2: {
                mJRadioButton = this.fRadioNone;
                break;
            }
            case 3: {
                mJRadioButton = this.fRadioNumbered;
            }
        }
        mJRadioButton.setSelected(true);
        ColumnDefinitionPanel.requestInitialFocus((JComponent)mJRadioButton);
    }

    private static void setColumnFormat(ColumnDefinition columnDefinition, Object object) {
        Object object2;
        if (object == null) {
            columnDefinition.setFormat(ColumnFormatEnum.DEFAULT);
        } else if ("numeric".equals(object)) {
            columnDefinition.setFormat(ColumnFormatEnum.NUMERIC);
        } else if ("char".equals(object)) {
            columnDefinition.setFormat(ColumnFormatEnum.TEXT);
        } else if ("logical".equals(object)) {
            columnDefinition.setFormat(ColumnFormatEnum.LOGICAL);
        } else if (object instanceof Object[]) {
            columnDefinition.setFormat(ColumnFormatEnum.CHOICE_LIST);
        } else if (MLFormatTypeEnum.parseString(object.toString()) != null) {
            columnDefinition.setFormat(ColumnFormatEnum.CUSTOM_FORMAT);
            object2 = MLFormatTypeEnum.parseString(object.toString());
            columnDefinition.setCustomFormatType(FormatTypeEnum.FORMAT);
            columnDefinition.setCustomFormatString(((MLFormatTypeEnum)((Object)object2)).getName());
        } else {
            columnDefinition.setFormat(ColumnFormatEnum.DEFAULT);
        }
        if (columnDefinition.getFormat() == ColumnFormatEnum.CHOICE_LIST) {
            object2 = new ArrayList<String>();
            if (object instanceof Object[]) {
                Object[] objectArray;
                for (Object object3 : objectArray = (Object[])object) {
                    object2.add(object3.toString());
                }
            }
            columnDefinition.setChoiceList((List<String>)object2);
        }
    }

    @Override
    public void commit() {
        this.putColumns();
    }

    private void putColumns() {
        String[] stringArray = null;
        boolean[] blArray = null;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        List<ColumnDefinition> list = this.fTableModel.getDefinitions();
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            stringArray = new String[n];
            blArray = new boolean[n];
            objectArray = new Object[n];
            objectArray2 = new Object[n];
            for (int i = 0; i < list.size(); ++i) {
                ColumnDefinition columnDefinition = list.get(i);
                stringArray[i] = columnDefinition.getTitle();
                blArray[i] = columnDefinition.isEditable();
                objectArray[i] = null;
                switch (columnDefinition.getFormat()) {
                    case DEFAULT: {
                        objectArray[i] = null;
                        break;
                    }
                    case NUMERIC: {
                        objectArray[i] = "numeric";
                        break;
                    }
                    case TEXT: {
                        objectArray[i] = "char";
                        break;
                    }
                    case LOGICAL: {
                        objectArray[i] = "logical";
                        break;
                    }
                    case CHOICE_LIST: {
                        objectArray[i] = columnDefinition.getChoiceList().toArray();
                        break;
                    }
                    case CUSTOM_FORMAT: {
                        objectArray[i] = columnDefinition.getCustomFormatString();
                    }
                }
                objectArray2[i] = columnDefinition.isAutoWidth() ? "auto" : columnDefinition.getFixedWidth();
            }
        }
        RowHeaderMode rowHeaderMode = this.fRadioNone.isSelected() ? RowHeaderMode.NONE : (this.fRadioNumbered.isSelected() ? RowHeaderMode.NUMBERED : RowHeaderMode.NAMED);
        Object object = null;
        if (rowHeaderMode.equals((Object)RowHeaderMode.NAMED)) {
            object = stringArray;
        } else if (rowHeaderMode.equals((Object)RowHeaderMode.NUMBERED)) {
            object = "numbered";
        }
        this.propertyModel.putProperty("ColumnName", object);
        if (objectArray != null) {
            this.propertyModel.putProperty("ColumnFormat", objectArray);
        }
        if (blArray != null) {
            this.propertyModel.putProperty("ColumnEditable", blArray);
        }
        if (objectArray2 != null) {
            this.propertyModel.putProperty("ColumnWidth", objectArray2);
        }
        this.setMetadataValue("ColumnNameTyped", stringArray);
    }

    private static void requestInitialFocus(final JComponent jComponent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.requestFocusInWindow();
            }
        });
    }

    private JPanel buildHeaderPanel() {
        this.fRadioNone = this.createRadioButton("columns.none", "columns.tip_none");
        this.fRadioNumbered = this.createRadioButton("columns.numbered", "columns.tip_numbered");
        this.fRadioNamed = this.createRadioButton("columns.named", "columns.tip_named");
        this.fRadioNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnDefinitionPanel.this.updateInfoPanel(ColumnInfoMode.DEFAULT);
            }
        });
        this.fRadioNumbered.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnDefinitionPanel.this.updateInfoPanel(ColumnInfoMode.DEFAULT);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadioNone);
        buttonGroup.add((AbstractButton)this.fRadioNumbered);
        buttonGroup.add((AbstractButton)this.fRadioNamed);
        FormLayout formLayout = new FormLayout("p, 0dlu:g(1.0)", "p, 4dlu, p, 2dlu, p, 2dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        String string = this.getResourceString("columns.header");
        panelBuilder.addSeparator(string, cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.fRadioNone, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.fRadioNumbered, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.fRadioNamed, cellConstraints.xy(1, 7));
        return panelBuilder.getPanel();
    }

    private MJRadioButton createRadioButton(String string, String string2) {
        MJRadioButton mJRadioButton = new MJRadioButton(this.getResourceString(string));
        if (string2 != null) {
            mJRadioButton.setToolTipText(this.getResourceString(string2));
        }
        return mJRadioButton;
    }

    private JPanel buildColumnsPanel() {
        FormLayout formLayout = new FormLayout("fill:p:g(1.0), 4dlu, p", "p, 4dlu, fill:0dlu:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        String string = this.getResourceString("columns.definitions");
        panelBuilder.addSeparator(string, cellConstraints.xyw(1, 1, 3));
        panelBuilder.add((Component)this.buildDefinitionsTable(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.buildButtonPanel(), cellConstraints.xy(3, 3));
        return panelBuilder.getPanel();
    }

    private TableScrollPane buildDefinitionsTable() {
        Object object;
        Object object2;
        ColumnFormatEnum columnFormatEnum2;
        CellEditorManager.initDefaultEditor();
        CellRendererManager.initDefaultRenderer();
        CellEditorFactory cellEditorFactory = new CellEditorFactory(){

            public CellEditor create() {
                return new BooleanCheckBoxCellEditor();
            }
        };
        String[] stringArray = new String[ColumnFormatEnum.values().length];
        int n = 0;
        for (ColumnFormatEnum columnFormatEnum2 : ColumnFormatEnum.values()) {
            stringArray[n++] = columnFormatEnum2.getDescription();
        }
        final EnumConverter enumConverter = new EnumConverter("ColumnFormat", ColumnFormatEnum.class, (Object[])ColumnFormatEnum.values(), stringArray, (Object)ColumnFormatEnum.DEFAULT);
        CellEditorFactory cellEditorFactory2 = new CellEditorFactory(){

            public CellEditor create() {
                return new EnumCellEditor(enumConverter);
            }
        };
        CellEditorFactory cellEditorFactory3 = new CellEditorFactory(){

            public CellEditor create() {
                return new LongCellEditor();
            }
        };
        CellEditorManager.registerEditor(Boolean.class, (CellEditorFactory)cellEditorFactory, (EditorContext)BooleanCheckBoxCellEditor.CONTEXT);
        CellEditorManager.registerEditor(Boolean.TYPE, (CellEditorFactory)cellEditorFactory, (EditorContext)BooleanCheckBoxCellEditor.CONTEXT);
        CellEditorManager.registerEditor(ColumnFormatEnum.class, (CellEditorFactory)cellEditorFactory2);
        CellEditorManager.registerEditor(Long.class, (CellEditorFactory)cellEditorFactory3);
        columnFormatEnum2 = new BooleanCheckBoxCellRenderer();
        CellRendererManager.registerRenderer(Boolean.class, (TableCellRenderer)((Object)columnFormatEnum2), (EditorContext)BooleanCheckBoxCellEditor.CONTEXT);
        CellRendererManager.registerRenderer(Boolean.TYPE, (TableCellRenderer)((Object)columnFormatEnum2), (EditorContext)BooleanCheckBoxCellEditor.CONTEXT);
        EnumCellRenderer enumCellRenderer = new EnumCellRenderer(enumConverter);
        CellRendererManager.registerRenderer(ColumnFormatEnum.class, (TableCellRenderer)enumCellRenderer);
        this.fTableModel = new DefinitionsTableModel();
        TableScrollPane tableScrollPane = new TableScrollPane((MultiTableModel)this.fTableModel, false){

            protected JTable createTable(TableModel tableModel, boolean bl) {
                return new CellStyleTable(tableModel);
            }
        };
        tableScrollPane.setPreferredSize(new Dimension(240, 240));
        this.fMainTable = tableScrollPane.getMainTable();
        JTable jTable = tableScrollPane.getRowHeaderTable();
        this.fMainTable.setSelectionMode(0);
        this.fMainTable.setCellSelectionEnabled(true);
        this.fMainTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.fMainTable.setAutoResizeMode(0);
        this.fMainTable.getAccessibleContext().setAccessibleName(this.getResourceString("acc.columns.table"));
        ((JLabel)((Object)this.fMainTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        ((JLabel)((Object)jTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.fMainTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        this.fMainTable.getColumnModel().getColumn(1).setCellRenderer(CellRendererManager.getRenderer(Boolean.class, (EditorContext)BooleanCheckBoxCellEditor.CONTEXT));
        this.fMainTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)CellEditorManager.getEditor(Boolean.class, (EditorContext)BooleanCheckBoxCellEditor.CONTEXT));
        this.fMainTable.getColumnModel().getColumn(2).setCellEditor((TableCellEditor)CellEditorManager.getEditor(Long.class));
        this.fMainTable.getColumnModel().getColumn(4).setCellEditor((TableCellEditor)CellEditorManager.getEditor(ColumnFormatEnum.class));
        this.fMainTable.getColumnModel().getColumn(3).setCellRenderer(CellRendererManager.getRenderer(Boolean.class, (EditorContext)BooleanCheckBoxCellEditor.CONTEXT));
        this.fMainTable.getColumnModel().getColumn(3).setCellEditor((TableCellEditor)CellEditorManager.getEditor(Boolean.class, (EditorContext)BooleanCheckBoxCellEditor.CONTEXT));
        TextFieldCellEditor textFieldCellEditor = new TextFieldCellEditor(String.class);
        JTextField jTextField = textFieldCellEditor.getTextField();
        this.fMainTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)textFieldCellEditor);
        this.fTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (ColumnDefinitionPanel.this.fIsEnterInLastRowNameField) {
                    if (!ColumnDefinitionPanel.this.fRadioNamed.isSelected()) {
                        ColumnDefinitionPanel.this.fRadioNamed.setSelected(true);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n = ColumnDefinitionPanel.this.fMainTable.getRowCount() - 1;
                            ColumnDefinitionPanel.this.fMainTable.setRowSelectionInterval(n, n);
                            ColumnDefinitionPanel.this.fMainTable.setColumnSelectionInterval(0, 0);
                            ColumnDefinitionPanel.this.fMainTable.requestFocusInWindow();
                        }
                    });
                } else if (tableModelEvent.getType() == 0) {
                    if (tableModelEvent.getColumn() == 1 && tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && tableModelEvent.getColumn() != -1 && !ColumnDefinitionPanel.this.fRadioNamed.isSelected()) {
                        ColumnDefinitionPanel.this.fRadioNamed.setSelected(true);
                    }
                    if (tableModelEvent.getColumn() == 5 && tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && tableModelEvent.getColumn() != -1) {
                        ColumnDefinitionPanel.this.fButtonFormat.setEnabled(true);
                        final int n = tableModelEvent.getFirstRow();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ColumnDefinition columnDefinition = ColumnDefinitionPanel.this.fTableModel.getDefinitions().get(n);
                                ColumnFormatEnum columnFormatEnum = columnDefinition.getFormat();
                                if (columnFormatEnum == ColumnFormatEnum.CHOICE_LIST) {
                                    ColumnDefinitionPanel.this.showChoiceListEditor();
                                } else if (columnFormatEnum == ColumnFormatEnum.CUSTOM_FORMAT) {
                                    ColumnDefinitionPanel.this.showCustomFormatEditor();
                                }
                            }
                        });
                    }
                }
                ColumnDefinitionPanel.this.fIsEnterInLastRowNameField = false;
            }
        });
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    int n;
                    int n2 = ColumnDefinitionPanel.this.fMainTable.getSelectedRow();
                    ColumnDefinitionPanel.this.fIsEnterInLastRowNameField = n2 == (n = ColumnDefinitionPanel.this.fMainTable.getRowCount() - 1);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.fMainTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.fMainTable.getColumnModel().getColumn(1).setPreferredWidth(65);
        this.fMainTable.getColumnModel().getColumn(2).setPreferredWidth(75);
        this.fMainTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.fMainTable.getColumnModel().getColumn(4).setPreferredWidth(110);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(40);
        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
        numberCellRenderer.setHorizontalAlignment(0);
        numberCellRenderer.setBackground(UIManager.getColor("TableHeader.background"));
        numberCellRenderer.setForeground(UIManager.getColor("TableHeader.foreground"));
        numberCellRenderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        tableColumn.setCellRenderer((TableCellRenderer)numberCellRenderer);
        this.fMainTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ColumnDefinitionPanel.this.processDefinitionSelectionChange();
                }
            }
        });
        ColumnHeaderToolTips columnHeaderToolTips = new ColumnHeaderToolTips();
        for (int i = 0; i < this.fMainTable.getColumnCount(); ++i) {
            object2 = this.fMainTable.getColumnModel().getColumn(i);
            object = this.getResourceString("columns.tip_title" + (i + 1));
            columnHeaderToolTips.setToolTip((TableColumn)object2, (String)object);
        }
        this.fMainTable.getTableHeader().addMouseMotionListener(columnHeaderToolTips);
        ColumnHeaderToolTips columnHeaderToolTips2 = new ColumnHeaderToolTips();
        object2 = this.getResourceString("columns.tip_title0");
        columnHeaderToolTips2.setToolTip(jTable.getColumnModel().getColumn(0), (String)object2);
        jTable.getTableHeader().addMouseMotionListener(columnHeaderToolTips2);
        this.attachScrollPaneResizeListener();
        this.attachColumnSelectionChangeListeners();
        EditableTableUtils.attachTableAccelerators(this.fMainTable, this);
        this.attachFormatButtonAccelerator();
        object = this.fMainTable.getColumnModel().getColumn(4).getCellEditor();
        if (object != null) {
            final ListComboBox listComboBox = (ListComboBox)object.getTableCellEditorComponent(this.fMainTable, null, false, 0, 0);
            listComboBox.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (listComboBox.isDisplayable() && !listComboBox.isPopupVisible()) {
                        listComboBox.showPopup();
                    }
                }
            });
        }
        return tableScrollPane;
    }

    private void attachScrollPaneResizeListener() {
        this.fScrollComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n;
                JComponent jComponent = (JComponent)componentEvent.getComponent();
                int n2 = jComponent.getWidth() - jComponent.getInsets().right - jComponent.getInsets().left;
                if (n2 > (n = ColumnDefinitionPanel.this.fMainTable.getColumnModel().getTotalColumnWidth())) {
                    int n3;
                    TableColumnModel tableColumnModel = ColumnDefinitionPanel.this.fMainTable.getColumnModel();
                    int n4 = n3 = n2 - n;
                    int n5 = ColumnDefinitionPanel.this.fMainTable.getColumnCount();
                    for (int i = 0; i < n5; ++i) {
                        int n6 = tableColumnModel.getColumn(i).getWidth();
                        int n7 = (int)((double)n3 * ((double)n6 * 1.0 / (double)n));
                        if (i == n5 - 1) {
                            n7 = n4;
                        }
                        n4 -= n7;
                        tableColumnModel.getColumn(i).setWidth(n6 + n7);
                        tableColumnModel.getColumn(i).setPreferredWidth(n6 + n7);
                    }
                }
                ColumnDefinitionPanel.this.fMainTable.getParent().removeComponentListener(ColumnDefinitionPanel.this.fScrollComponentListener);
                ColumnDefinitionPanel.this.fScrollComponentListener = null;
            }
        };
        this.fMainTable.getParent().addComponentListener(this.fScrollComponentListener);
    }

    private void attachColumnSelectionChangeListeners() {
        this.fMainTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ColumnDefinitionPanel.this.updateInfoPanel(ColumnDefinitionPanel.this.getInfoMode());
                }
            }
        });
        this.fMainTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ColumnDefinitionPanel.this.updateInfoPanel(ColumnDefinitionPanel.this.getInfoMode());
            }
        });
    }

    private void attachFormatButtonAccelerator() {
        this.fMainTable.getInputMap(1).put(KeyStroke.getKeyStroke(84, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), "Edit");
        this.fMainTable.getActionMap().put("Edit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ColumnDefinitionPanel.this.fMainTable.isEditing()) {
                    ColumnDefinitionPanel.this.fMainTable.getCellEditor().stopCellEditing();
                }
                ColumnDefinitionPanel.this.showFormatEditor();
            }
        });
    }

    private ColumnInfoMode getInfoMode() {
        int n = this.fMainTable.getSelectedColumn();
        switch (n) {
            case 0: {
                return ColumnInfoMode.NAMES;
            }
            case 4: {
                return ColumnInfoMode.FORMAT;
            }
        }
        return ColumnInfoMode.DEFAULT;
    }

    private void updateInfoPanel(ColumnInfoMode columnInfoMode) {
        if (columnInfoMode != this.fCurrentInfoMode) {
            switch (columnInfoMode) {
                case NAMES: {
                    this.fInfoPanel.setMessage(this.getResourceString("columns.info_names"));
                    this.fInfoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("columns.info_names"));
                    break;
                }
                case FORMAT: {
                    this.fInfoPanel.setMessage(this.getResourceString("columns.info_format"));
                    this.fInfoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("columns.info_format"));
                    break;
                }
                case DEFAULT: {
                    this.fInfoPanel.setMessage(this.getResourceString("columns.info_default"));
                    this.fInfoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("columns.info_default"));
                }
            }
            this.fCurrentInfoMode = columnInfoMode;
        }
    }

    private JPanel buildButtonPanel() {
        this.fButtonInsert = this.createButton("buttons.insert", "buttons.tip_insert", MiscellaneousIcon.ADD.getIcon());
        this.fButtonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnDefinitionPanel.this.addEntry();
            }
        });
        this.fButtonCopy = this.createButton("buttons.copy", "buttons.tip_copy", CommonIcon.COPY.getIcon());
        this.fButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnDefinitionPanel.this.copyEntry();
            }
        });
        this.fButtonDelete = this.createButton("buttons.delete", "buttons.tip_delete", MiscellaneousIcon.SUBTRACT.getIcon());
        this.fButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnDefinitionPanel.this.removeEntry();
            }
        });
        this.fButtonMoveUp = this.createButton("buttons.move_up", "buttons.tip_move_up", CommonIcon.UP.getIcon());
        this.fButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnDefinitionPanel.this.moveEntryUp();
            }
        });
        this.fButtonMoveDown = this.createButton("buttons.move_down", "buttons.tip_move_down", CommonIcon.DOWN.getIcon());
        this.fButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnDefinitionPanel.this.moveEntryDown();
            }
        });
        this.fButtonFormat = this.createButton("buttons.format", "buttons.tip_format", ProjectIcon.PROJECT_SETTINGS.getIcon());
        this.fButtonFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnDefinitionPanel.this.showFormatEditor();
            }
        });
        FormLayout formLayout = new FormLayout("fill:p", "p, p, p, p, p, p, p, p, p, p, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        ConstantSize constantSize = LayoutStyle.getCurrent().getUnrelatedComponentsPadY();
        int n = constantSize.getPixelSize((Component)panelBuilder.getPanel());
        ConstantSize constantSize2 = LayoutStyle.getCurrent().getRelatedComponentsPadY();
        int n2 = constantSize2.getPixelSize((Component)panelBuilder.getPanel());
        panelBuilder.add((Component)this.fButtonInsert, cellConstraints.xy(1, 1));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 2));
        panelBuilder.add((Component)this.fButtonCopy, cellConstraints.xy(1, 3));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 4));
        panelBuilder.add((Component)this.fButtonDelete, cellConstraints.xy(1, 5));
        panelBuilder.add(Box.createVerticalStrut(n), cellConstraints.xy(1, 6));
        panelBuilder.add((Component)this.fButtonMoveUp, cellConstraints.xy(1, 7));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 8));
        panelBuilder.add((Component)this.fButtonMoveDown, cellConstraints.xy(1, 9));
        panelBuilder.add(Box.createVerticalStrut(n), cellConstraints.xy(1, 10));
        panelBuilder.add((Component)this.fButtonFormat, cellConstraints.xy(1, 11));
        return panelBuilder.getPanel();
    }

    private MJButton createButton(String string, String string2, Icon icon) {
        MJButton mJButton = new MJButton();
        if (string != null) {
            mJButton.setText(this.getResourceString(string));
        }
        if (string2 != null) {
            mJButton.setToolTipText(this.getResourceString(string2));
        }
        if (!PlatformInfo.isMacintosh() && icon != null) {
            int n;
            mJButton.setIcon(icon);
            Insets insets = mJButton.getMargin();
            insets.left = n = (int)((double)insets.top * 2.0);
            insets.right = n;
            mJButton.setMargin(insets);
            mJButton.setHorizontalAlignment(10);
        }
        return mJButton;
    }

    @Override
    public void addEntry() {
        int n = this.fMainTable.getSelectedRow();
        if (n == -1) {
            n = this.fMainTable.getRowCount() - 1;
        }
        this.fTableModel.addDefinition(++n);
        this.fMainTable.getSelectionModel().setSelectionInterval(n, n);
        this.fMainTable.requestFocusInWindow();
    }

    @Override
    public void copyEntry() {
        int n = this.fMainTable.getSelectedRow();
        if (n != -1) {
            this.fTableModel.copyDefinition(n);
            this.fMainTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            this.fMainTable.requestFocusInWindow();
        }
    }

    @Override
    public void removeEntry() {
        int n = this.fMainTable.getSelectedRow();
        if (n != -1) {
            this.fTableModel.removeDefinition(n);
            int n2 = this.fMainTable.getRowCount() - 1;
            if (n2 >= 0) {
                n = n > n2 ? n2 : n;
                this.fMainTable.getSelectionModel().setSelectionInterval(n, n);
                this.fMainTable.requestFocusInWindow();
            }
        }
    }

    @Override
    public void moveEntryUp() {
        boolean bl = this.fButtonMoveUp.hasFocus();
        int n = this.fMainTable.getSelectedRow();
        if (n > 0) {
            this.fTableModel.moveDefinitionUp(n);
            this.fMainTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            if (bl) {
                this.fButtonMoveUp.requestFocusInWindow();
            }
        }
    }

    @Override
    public void moveEntryDown() {
        boolean bl = this.fButtonMoveDown.hasFocus();
        int n = this.fMainTable.getSelectedRow();
        int n2 = this.fMainTable.getRowCount() - 1;
        if (n >= 0 && n < n2) {
            this.fTableModel.moveDefinitionDown(n);
            this.fMainTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            if (bl) {
                this.fButtonMoveDown.requestFocusInWindow();
            }
        }
    }

    private void processDefinitionSelectionChange() {
        int n = this.fMainTable.getSelectedRow();
        int n2 = this.fMainTable.getRowCount() - 1;
        this.fButtonInsert.setSelected(true);
        this.fButtonCopy.setEnabled(n >= 0);
        this.fButtonDelete.setEnabled(n >= 0);
        this.fButtonMoveUp.setEnabled(n > 0);
        this.fButtonMoveDown.setEnabled(n >= 0 && n < n2);
        this.fButtonFormat.setEnabled(this.fTableModel.isUserSelectedDefinition(n));
    }

    private void showFormatEditor() {
        int n = this.fMainTable.getSelectedRow();
        ColumnDefinition columnDefinition = this.fTableModel.getDefinitions().get(n);
        ColumnFormatEnum columnFormatEnum = columnDefinition.getFormat();
        if (columnFormatEnum == ColumnFormatEnum.CHOICE_LIST) {
            this.showChoiceListEditor();
        } else if (columnFormatEnum == ColumnFormatEnum.CUSTOM_FORMAT) {
            this.showCustomFormatEditor();
        }
    }

    private void showChoiceListEditor() {
        int n = this.fMainTable.getSelectedRow();
        List<String> list = this.fTableModel.getChoiceListForDefinition(n);
        Window window = (Window)this.getTopLevelAncestor();
        List<String> list2 = ChoiceListEditor.showChoiceListEditorAsDialog(window, list, true);
        this.fTableModel.setChoiceListForDefinition(n, list2);
        this.fTableModel.fireTableRowsUpdated(n, n);
    }

    private void showCustomFormatEditor() {
        int n = this.fMainTable.getSelectedRow();
        ColumnDefinition columnDefinition = this.fTableModel.getDefinitions().get(n);
        Window window = (Window)this.getTopLevelAncestor();
        boolean bl = true;
        FormatEditor.showFormatEditorDialog(window, columnDefinition, true, bl);
    }

    public static class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        private TableColumn fCurCol;
        private Map<TableColumn, String> fTips = new HashMap<TableColumn, String>();

        public void setToolTip(TableColumn tableColumn, String string) {
            if (string == null) {
                this.fTips.remove(tableColumn);
            } else {
                this.fTips.put(tableColumn, string);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TableColumn tableColumn;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n >= 0 && (tableColumn = tableColumnModel.getColumn(n)) != null && !tableColumn.equals(this.fCurCol)) {
                jTableHeader.setToolTipText(this.fTips.get(tableColumn));
                this.fCurCol = tableColumn;
            }
        }
    }

    private class DefinitionsTableModel
    extends AbstractMultiTableModel {
        private final String[] fTITLES = new String[]{AbstractEditorPanel.EDITOR_RESOURCES.getString("columns.title0"), AbstractEditorPanel.EDITOR_RESOURCES.getString("columns.title1"), AbstractEditorPanel.EDITOR_RESOURCES.getString("columns.title2"), AbstractEditorPanel.EDITOR_RESOURCES.getString("columns.title3"), AbstractEditorPanel.EDITOR_RESOURCES.getString("columns.title4"), AbstractEditorPanel.EDITOR_RESOURCES.getString("columns.title5")};
        private LinkedList<ColumnDefinition> fDefinitions;

        DefinitionsTableModel() {
            this(new LinkedList<ColumnDefinition>());
        }

        DefinitionsTableModel(LinkedList<ColumnDefinition> linkedList) {
            this.fDefinitions = linkedList;
        }

        public String getColumnName(int n) {
            return n < this.fTITLES.length ? this.fTITLES[n] : "";
        }

        public int getColumnCount() {
            return this.fTITLES.length;
        }

        public int getRowCount() {
            return this.fDefinitions.size();
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Long.class;
                }
                case 5: {
                    return ColumnFormatEnum.class;
                }
                case 4: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public void setValueAt(Object object, int n, int n2) {
            boolean bl = false;
            boolean bl2 = false;
            ColumnDefinition columnDefinition = this.fDefinitions.get(n);
            switch (n2) {
                case 1: {
                    String string = columnDefinition.getTitle();
                    columnDefinition.setTitle((String)object);
                    bl = ColumnDefinitionPanel.this.fIsEnterInLastRowNameField;
                    bl2 = !string.equals(columnDefinition.getTitle());
                    break;
                }
                case 2: {
                    columnDefinition.setAutoWidth((Boolean)object);
                    if (columnDefinition.getFixedWidth() == null) break;
                    columnDefinition.setFixedWidth(null);
                    this.fireTableRowsUpdated(n, n);
                    break;
                }
                case 3: {
                    Long l = (Long)object;
                    columnDefinition.setFixedWidth(l);
                    if (l == null || !columnDefinition.isAutoWidth()) break;
                    columnDefinition.setAutoWidth(false);
                    this.fireTableRowsUpdated(n, n);
                    break;
                }
                case 5: {
                    ColumnFormatEnum columnFormatEnum = columnDefinition.getFormat();
                    columnDefinition.setFormat((ColumnFormatEnum)((Object)object));
                    if (columnDefinition.getFormat() == columnFormatEnum) break;
                    bl2 = ColumnFormatEnum.CHOICE_LIST == columnDefinition.getFormat() || ColumnFormatEnum.CUSTOM_FORMAT == columnDefinition.getFormat();
                    break;
                }
                case 4: {
                    columnDefinition.setEditable((Boolean)object);
                    break;
                }
            }
            if (bl) {
                this.addDefinition();
            } else if (bl2) {
                this.fireTableCellUpdated(n, n2);
            }
        }

        public Object getValueAt(int n, int n2) {
            ColumnDefinition columnDefinition = this.fDefinitions.get(n);
            switch (n2) {
                case 0: {
                    return String.valueOf(n + 1);
                }
                case 1: {
                    return columnDefinition.getTitle();
                }
                case 2: {
                    return columnDefinition.isAutoWidth();
                }
                case 3: {
                    return columnDefinition.isAutoWidth() ? null : columnDefinition.getFixedWidth();
                }
                case 5: {
                    return columnDefinition.getFormat();
                }
                case 4: {
                    return columnDefinition.isEditable();
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return false;
                }
            }
            return true;
        }

        public int getTableIndex(int n) {
            return 0;
        }

        public int getColumnType(int n) {
            return n <= 0 ? 1 : 0;
        }

        public void addDefinition() {
            int n = this.fDefinitions.size();
            this.addDefinition(n);
        }

        public void addDefinition(int n) {
            ColumnDefinition columnDefinition = new ColumnDefinition("");
            this.fDefinitions.add(n, columnDefinition);
            this.fireTableRowsInserted(n, n);
        }

        public void copyDefinition(int n) {
            ColumnDefinition columnDefinition = this.fDefinitions.get(n);
            ColumnDefinition columnDefinition2 = new ColumnDefinition(columnDefinition);
            this.fDefinitions.add(n + 1, columnDefinition2);
            this.fireTableRowsInserted(n + 1, n + 1);
        }

        public void removeDefinition(int n) {
            if (n >= 0 && n < this.fDefinitions.size()) {
                this.fDefinitions.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public boolean isUserSelectedDefinition(int n) {
            if (n >= 0 && n < this.fDefinitions.size()) {
                ColumnFormatEnum columnFormatEnum = this.fDefinitions.get(n).getFormat();
                return ColumnFormatEnum.CHOICE_LIST == columnFormatEnum || ColumnFormatEnum.CUSTOM_FORMAT == columnFormatEnum;
            }
            return false;
        }

        public void moveDefinitionUp(int n) {
            ColumnDefinition columnDefinition = this.fDefinitions.get(n);
            this.fDefinitions.remove(n);
            this.fDefinitions.add(n - 1, columnDefinition);
            this.fireTableRowsUpdated(n - 1, n);
        }

        public void moveDefinitionDown(int n) {
            ColumnDefinition columnDefinition = this.fDefinitions.get(n);
            this.fDefinitions.remove(n);
            this.fDefinitions.add(n + 1, columnDefinition);
            this.fireTableRowsUpdated(n, n + 1);
        }

        public List<String> getChoiceListForDefinition(int n) {
            if (n >= 0 && n < this.fDefinitions.size()) {
                return this.fDefinitions.get(n).getChoiceList();
            }
            return null;
        }

        public void setChoiceListForDefinition(int n, List<String> list) {
            if (n >= 0 && n < this.fDefinitions.size()) {
                this.fDefinitions.get(n).setChoiceList(list);
            }
        }

        public void setDefinitions(List<ColumnDefinition> list) {
            this.fDefinitions.clear();
            this.fDefinitions.addAll(list);
            this.fireTableDataChanged();
        }

        public List<ColumnDefinition> getDefinitions() {
            return this.fDefinitions;
        }
    }

    private static enum ColumnInfoMode {
        DEFAULT,
        NAMES,
        FORMAT;

    }
}

