/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AcceleratorEventNotification;
import com.mathworks.hg.peer.CDataGrabber;
import com.mathworks.hg.peer.CanvasPeerMouseListener;
import com.mathworks.hg.peer.CommandTarget;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FBOGrabber;
import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.FigureComponentNotification;
import com.mathworks.hg.peer.FigureComponentProxy;
import com.mathworks.hg.peer.FigureJavaEventNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.GLEventListenerHandler;
import com.mathworks.hg.peer.HGCanvasPeer;
import com.mathworks.hg.peer.JavaSceneServerCanvas;
import com.mathworks.hg.peer.JavaSceneServerGLCanvas;
import com.mathworks.hg.peer.JavaSceneServerGLJPanel;
import com.mathworks.hg.peer.JavaSceneServerOffScreenCanvas;
import com.mathworks.hg.peer.JavaSceneServerPanel;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import com.mathworks.util.GraphicsDeviceUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLException;
import javax.swing.SwingUtilities;

public class JavaSceneServerPeer
extends FigureComponentProxy
implements CommandTarget,
JavaSceneServerPeerInterface {
    private boolean fUseJogl = true;
    private int fGrabCDataWidth;
    private int fGrabCDataHeight;
    private BufferedImage fCDataImage = null;
    private static Image sOffscreenBuffer = null;
    private static boolean sLibraryInitialized = false;
    private Dimension fMaxViewportSize = null;
    private GLEventListenerHandler fGLEventListenerHandler = null;
    private long fServerProxyHandle = 0L;
    private long fCurrentlyOver = 0L;
    private boolean fEnterExitEnabled = false;
    private static final int RENDERING_HINT_GLOBAL_ANTIALIAS = 1;
    private static final int RENDERING_HINT_LIGHTWEIGHT = 2;
    private boolean fGlobalAntialias = true;
    private boolean fUseLightweight = FigurePeer.LightWeightManager.isUseLightWeightContainer();
    private int fOpenGLPrintResolution;
    private HGGLException fDisplayException;
    private GLAutoDrawable fDrawableComponent = null;
    private HGCanvasPeer fCanvas = null;
    public static final String sNOFBO = "JSSP_NOFBO: ";
    public static final String sFBOSIZE = "JSSP_FBOSIZE: ";
    public static final String sFBOCONFIGURATION = "JSSP_FBOCONFIGURATION: ";
    public static final String sFBOSETUP = "JSSP_FBOSETUP: ";
    private boolean fNonZeroSize = false;
    private final Object fSizeLock = new Object();

    @Override
    public GLEventListenerHandler getGLEventListenerHandler() {
        return this.fGLEventListenerHandler;
    }

    private boolean change_hint(int n, boolean bl) {
        boolean bl2 = false;
        if (n == 1) {
            if (this.fUseJogl && this.fGlobalAntialias != bl) {
                bl2 = true;
            }
            this.fGlobalAntialias = bl;
        } else if (n == 2) {
            if (this.fUseLightweight != bl) {
                bl2 = true;
            }
            this.fUseLightweight = bl;
        }
        return bl2;
    }

    private GLCapabilities getCaps() {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setHardwareAccelerated(true);
        if (this.fGlobalAntialias) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(8);
        }
        return gLCapabilities;
    }

    @Override
    public void setDisplayException(HGGLException hGGLException) {
        this.fDisplayException = hGGLException;
    }

    @Override
    public long getServerProxyHandle() {
        return this.fServerProxyHandle;
    }

    @Override
    public void setCDataImage(BufferedImage bufferedImage) {
        this.fCDataImage = bufferedImage;
    }

    @Override
    public void setGrabCDataWidth(int n) {
        this.fGrabCDataWidth = n;
    }

    @Override
    public void setGrabCDataHeight(int n) {
        this.fGrabCDataHeight = n;
    }

    private static void setHints(Graphics2D graphics2D) {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHints(renderingHints);
    }

    @Override
    public void callDoJavaPaint(Graphics graphics, boolean bl) {
        int n = this.getComponent().getWidth();
        int n2 = this.getComponent().getHeight();
        if (bl) {
            if (sOffscreenBuffer == null || sOffscreenBuffer.getWidth(null) != n || sOffscreenBuffer.getHeight(null) != n2) {
                sOffscreenBuffer = this.getComponent().createImage(n, n2);
            }
            Graphics graphics2 = sOffscreenBuffer.getGraphics();
            JavaSceneServerPeer.setHints((Graphics2D)graphics2);
            this.doJavaPaint(graphics2, this.fServerProxyHandle);
            graphics.drawImage(sOffscreenBuffer, 0, 0, null);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            JavaSceneServerPeer.setHints(graphics2D);
            this.doJavaPaint(graphics2D, this.fServerProxyHandle);
            graphics2D.dispose();
        }
    }

    @Override
    public void printOffscreen(Component component, Graphics graphics) {
        try {
            BufferedImage bufferedImage = this.generateAndGrabBufferedImage();
            if (bufferedImage == null) {
                throw new HGGLException("Null Buffered Image");
            }
            graphics.drawImage(bufferedImage, 0, 0, component.getWidth(), component.getHeight(), null);
        }
        catch (HGGLException hGGLException) {
            throw new HGGLRuntimeException(hGGLException);
        }
    }

    public JavaSceneServerPeer() {
        if (!sLibraryInitialized) {
            try {
                if (PlatformInfo.isWindows()) {
                    System.loadLibrary("jawt");
                }
                System.loadLibrary("nativehg");
                sLibraryInitialized = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.reportError("MATLAB:HG:Java:FailedLoadNativeHG", "Failed to load nativehg");
            }
        }
        try {
            this.createCanvas(this.fUseJogl);
        }
        catch (GLException gLException) {
            this.reportGLException(gLException);
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4, long l) {
        this.doReshape(n, n2, n3, n4, l);
    }

    @Override
    public native void doRestart(long var1, int var3);

    private native void doReshape(int var1, int var2, int var3, int var4, long var5);

    @Override
    public native void doDisplay(long var1, int var3);

    private native void doJavaPaint(Graphics var1, long var2);

    private native boolean doHitTest(int var1, int var2, MouseEvent var3, long var4);

    private native boolean doEnterExitTest(int var1, int var2, long var3);

    private native void doMouseEvent(MouseEvent var1, long var2);

    private native void doKeyEvent(KeyEvent var1, long var2);

    private native void doExecuteCommand(int var1, long var2, long var4);

    private native void doEnableWebOutput(long var1, int var3);

    public void replaceClient(int n) {
        this.doEnableWebOutput(this.fServerProxyHandle, n);
    }

    @Override
    public void reportError(String string, String string2) {
        this.reportError(false, string, string2);
    }

    @Override
    public void reportError(boolean bl, String string, String string2) {
        System.out.println("JavaSceneServerPeer problem: " + string2);
    }

    public void setSceneServerProxyHandle(long l) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.setSceneServerProxyHandle", this);
        this.fServerProxyHandle = l;
    }

    public void setOpenGLPrintResolution(int n) {
        if (n < 0) {
            n = 0;
        }
        this.fOpenGLPrintResolution = n;
    }

    @Override
    public int getOpenGLPrintResolution() {
        return this.fOpenGLPrintResolution;
    }

    @Override
    public void causeExpose() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call causeExpose from event dispatch thread";
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.causeExpose", this);
        if (this.fCanvas != null) {
            this.fCanvas.causeExpose();
        }
    }

    public boolean getUseJogl() {
        return this.fUseJogl;
    }

    public void setUseJogl(boolean bl) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.setUseJogl", this);
        assert (SwingUtilities.isEventDispatchThread()) : "Expected to call setUseJogl from EDT";
        if (bl != this.fUseJogl) {
            if (!bl) {
                this.fGLEventListenerHandler.resetListener();
            }
            this.doCreateCanvas(bl);
        }
    }

    @Override
    public void hide() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call hide from event dispatch thread";
        if (this.getComponent() != null) {
            this.getComponent().setVisible(false);
        }
    }

    @Override
    public void show() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call show from event dispatch thread";
        if (this.getComponent() != null) {
            this.getComponent().setVisible(true);
        }
    }

    public void setRenderingHint(int n, boolean bl) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.setRenderingHint", this);
        assert (SwingUtilities.isEventDispatchThread()) : "Expected to call setRenderingHint from EDT";
        if (this.change_hint(n, bl)) {
            if (this.fUseJogl) {
                this.fGLEventListenerHandler.resetListener();
            }
            this.doCreateCanvas(this.fUseJogl);
        }
    }

    private void setGrabCData(GLAutoDrawable gLAutoDrawable, boolean bl) {
        if (gLAutoDrawable instanceof CDataGrabber.CDataGrabberProvider) {
            CDataGrabber cDataGrabber = ((CDataGrabber.CDataGrabberProvider)gLAutoDrawable).getCDataGrabber();
            cDataGrabber.setGrabCData(bl, gLAutoDrawable.getGL());
        }
        this.fGLEventListenerHandler.setGrabCData(bl);
    }

    @Override
    public boolean setupForGrabbingCDataIfNeeded(GLAutoDrawable gLAutoDrawable) throws HGGLException {
        CDataGrabber cDataGrabber;
        if (gLAutoDrawable instanceof CDataGrabber.CDataGrabberProvider) {
            cDataGrabber = ((CDataGrabber.CDataGrabberProvider)gLAutoDrawable).getCDataGrabber();
            if (!cDataGrabber.getGrabCData()) {
                return false;
            }
        } else {
            return false;
        }
        double d = 1.0;
        if (this.fOpenGLPrintResolution > 0) {
            d = (double)this.fOpenGLPrintResolution / (double)GraphicsDeviceUtilities.getDefaultScreenResolution();
        }
        int n = (int)((double)this.fGrabCDataWidth * d);
        int n2 = (int)((double)this.fGrabCDataHeight * d);
        return cDataGrabber.setupCDataGrabber(gLAutoDrawable.getGL(), n, n2);
    }

    static void stopGrabbingCData(GLAutoDrawable gLAutoDrawable) {
        if (gLAutoDrawable instanceof CDataGrabber.CDataGrabberProvider) {
            CDataGrabber cDataGrabber = ((CDataGrabber.CDataGrabberProvider)gLAutoDrawable).getCDataGrabber();
            cDataGrabber.stopGrabbingCData(gLAutoDrawable.getGL());
        }
    }

    @Override
    public BufferedImage generateAndGrabBufferedImage() throws HGGLException {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.generateAndGrabBufferedImage", this);
        GLAutoDrawable gLAutoDrawable = this.fDrawableComponent;
        if (gLAutoDrawable == null) {
            DebugUtilities.logMessage(16, "in generateAmdGrabBufferedImage with a Drawable that isn't a GLCanvas or a GLJPanel", this);
            throw new HGGLException("Drawable isn't a GLCanvas or GLPanel");
        }
        if (!(gLAutoDrawable instanceof CDataGrabber.CDataGrabberProvider)) {
            DebugUtilities.logMessage(16, "in generateAndGrabBufferedImage with a Drawable that doesn't support getting image data", this);
            throw new HGGLException("Drawable doesn't support grabbing CData");
        }
        this.fGLEventListenerHandler.resetListener();
        this.fCDataImage = null;
        this.fDisplayException = null;
        this.setGrabCData(gLAutoDrawable, true);
        this.fGLEventListenerHandler.readyListener();
        gLAutoDrawable.display();
        BufferedImage bufferedImage = this.fCDataImage;
        this.fCDataImage = null;
        this.setGrabCData(gLAutoDrawable, false);
        this.fGLEventListenerHandler.readyListener();
        gLAutoDrawable.display();
        if (bufferedImage == null && this.fDisplayException != null) {
            throw this.fDisplayException;
        }
        return bufferedImage;
    }

    public BufferedImage grabBufferedImage() throws HGGLException {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.grabBufferedImage", this);
        boolean bl = false;
        if (!this.fUseJogl) {
            this.setUseJogl(true);
            bl = true;
        }
        if (!this.fUseJogl) {
            this.reportError("MATLAB:HG:Java:NoJOGLSwitch", "Couldn't switch to JOGL to grab image");
            return null;
        }
        if (!this.getComponent().isDisplayable()) {
            this.reportError("MATLAB:HG:Java:NoJOGLSwitch", "Getting CData from invisible figure is not supported.");
            return null;
        }
        BufferedImage bufferedImage = null;
        HGGLException hGGLException = null;
        try {
            bufferedImage = this.generateAndGrabBufferedImage();
        }
        catch (HGGLException hGGLException2) {
            hGGLException = hGGLException2;
        }
        if (bl) {
            this.setUseJogl(false);
        }
        if (hGGLException != null) {
            throw hGGLException;
        }
        return bufferedImage;
    }

    public static int getDefaultScreenWidth() {
        return GraphicsDeviceUtilities.getDefaultScreenWidth();
    }

    public static int getDefaultScreenHeight() {
        return GraphicsDeviceUtilities.getDefaultScreenHeight();
    }

    public static int getDefaultScreenResolution() {
        return GraphicsDeviceUtilities.getDefaultScreenResolution();
    }

    private GraphicsConfiguration getGraphicsConfiguration(Component component) {
        GraphicsConfiguration graphicsConfiguration = null;
        try {
            if (GraphicsEnvironment.isHeadless()) {
                this.reportError(true, "MATLAB:HG:Java:UnsupportedHeadlessGraphicsOperation", "Unable to perform graphics operations in headless mode");
            } else {
                if (component != null) {
                    graphicsConfiguration = component.getGraphicsConfiguration();
                }
                if (graphicsConfiguration == null) {
                    if (component != null) {
                        DebugUtilities.logMessage(16, "JavaSceneViewerPeer.getGraphicsConfiguration null graphics configuration for component", component);
                    }
                    graphicsConfiguration = GraphicsDeviceUtilities.getDefaultGraphicsConfiguration();
                }
            }
        }
        catch (HeadlessException headlessException) {
            this.reportError(true, "MATLAB:HG:Java:UnsupportedHeadlessGraphicsOperation", "Unable to perform graphics operations in headless mode");
        }
        if (graphicsConfiguration == null) {
            DebugUtilities.logMessage(16, "JavaSceneViewerPeer.getGraphicsConfiguration is null", this);
        }
        return graphicsConfiguration;
    }

    public int getScreenWidth() {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getScreenWidth", this);
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(this.getComponent());
        if (graphicsConfiguration == null) {
            return 0;
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return (int)rectangle.getWidth();
    }

    public int getScreenHeight() {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getScreenHeight", this);
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(this.getComponent());
        if (graphicsConfiguration == null) {
            return 0;
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return (int)rectangle.getHeight();
    }

    public int getScreenResolution() {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getScreenResolution", this);
        if (this.getComponent() != null) {
            Toolkit toolkit = this.getComponent().getToolkit();
            return toolkit.getScreenResolution();
        }
        return GraphicsDeviceUtilities.getDefaultScreenResolution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNonZeroSize() {
        boolean bl;
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Dimension dimension = JavaSceneServerPeer.this.getComponent().getSize();
                Object object = JavaSceneServerPeer.this.fSizeLock;
                synchronized (object) {
                    JavaSceneServerPeer.this.fNonZeroSize = dimension.height > 0 && dimension.width > 0;
                }
            }
        });
        Object object = this.fSizeLock;
        synchronized (object) {
            bl = this.fNonZeroSize;
        }
        return bl;
    }

    @Override
    public Dimension getMaxViewportSize() {
        return this.fMaxViewportSize;
    }

    @Override
    public void setMaxViewportSize(Dimension dimension) {
        this.fMaxViewportSize = dimension;
    }

    @Override
    public int getViewportWidth() {
        Rectangle rectangle;
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getViewportWidth", this);
        int n = 0;
        if (this.getComponent() != null && (rectangle = this.getComponent().getBounds()) != null) {
            n = rectangle.width;
        }
        return n;
    }

    @Override
    public int getViewportHeight() {
        Rectangle rectangle;
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getViewportHeight", this);
        int n = 0;
        if (this.getComponent() != null && (rectangle = this.getComponent().getBounds()) != null) {
            n = rectangle.height;
        }
        return n;
    }

    public void setEnterExitEnabled(boolean bl) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.setEnterExitEnabled", this);
        this.fEnterExitEnabled = bl;
    }

    public boolean getEnterExitEnabled() {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getEnterExitEnabled", this);
        return this.fEnterExitEnabled;
    }

    private void createCanvas(final boolean bl) {
        DebugUtilities.logMessage(32768, "createCanvas", this);
        assert (!SwingUtilities.isEventDispatchThread());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaSceneServerPeer.this.doCreateCanvas(bl);
            }
        });
    }

    private void doCreateCanvas(boolean bl) {
        Object object;
        DebugUtilities.logMessage(32768, "doCreateCanvas", this);
        assert (SwingUtilities.isEventDispatchThread()) : "Must call JavaSceneServerPeer.createCanvas from the EDT.";
        this.nullOutReferences();
        HGCanvasPeer hGCanvasPeer = null;
        if (bl) {
            object = this.getCaps();
            DebugUtilities.logMessage(32768, "caps = " + object, this);
            try {
                DebugUtilities.logMessage(32768, "try offscreen heavyweight with hardware", this);
                hGCanvasPeer = new JavaSceneServerOffScreenCanvas((GLCapabilities)object, this);
            }
            catch (GLException gLException) {
                DebugUtilities.logMessage(32784, "caught GLException", this);
                hGCanvasPeer = null;
            }
            if (hGCanvasPeer == null) {
                DebugUtilities.logMessage(16, "Couldn't create hardware accelerated JOGL canvas--trying software", this);
                this.reportError(true, "MATLAB:HG:Java:NoHardwareOpenGL", "Couldn't create hardware accelerated JOGL canvas--trying software");
                object.setHardwareAccelerated(false);
                try {
                    if (this.fUseLightweight) {
                        DebugUtilities.logMessage(32768, "try lightweight without hardware", this);
                        hGCanvasPeer = new JavaSceneServerGLJPanel((GLCapabilities)object, this);
                    } else {
                        DebugUtilities.logMessage(32768, "try heavyweight without hardware", this);
                        hGCanvasPeer = new JavaSceneServerGLCanvas((GLCapabilities)object, this);
                    }
                }
                catch (GLException gLException) {
                    DebugUtilities.logMessage(32784, "caught GLException", this);
                    hGCanvasPeer = null;
                }
            }
            if (hGCanvasPeer != null) {
                if (hGCanvasPeer instanceof CDataGrabber.CDataGrabberProvider) {
                    ((CDataGrabber.CDataGrabberProvider)((Object)hGCanvasPeer)).setCDataGrabber(new FBOGrabber(this));
                }
                this.fDrawableComponent = hGCanvasPeer.getGLAutoDrawable();
                assert (this.fDrawableComponent != null);
                if (this.fDrawableComponent != null) {
                    this.fGLEventListenerHandler = new GLEventListenerHandler(this.fDrawableComponent, this);
                } else {
                    DebugUtilities.logMessage(32784, "trying to set a listener when we don't have a drawable", this);
                }
            } else {
                DebugUtilities.logMessage(32784, "Couldn't create JOGL canvas--using painters", this);
                this.reportError("MATLAB:HG:Java:FailedOpenGL", "Couldn't create JOGL canvas--using painters");
                bl = false;
            }
        }
        if (!bl) {
            if (this.fUseLightweight) {
                DebugUtilities.logMessage(32768, "try lightweight painters", this);
                hGCanvasPeer = new JavaSceneServerPanel(this);
            } else {
                DebugUtilities.logMessage(32768, "try heavyweight painters", this);
                hGCanvasPeer = new JavaSceneServerCanvas(this);
            }
        }
        hGCanvasPeer.getComponent().addComponentListener(new CanvasPeerComponentListener());
        object = new CanvasPeerMouseListener(this);
        hGCanvasPeer.addMouseListener((MouseListener)object);
        hGCanvasPeer.addMouseMotionListener((MouseMotionListener)object);
        this.setFigureComponent((FigureComponent)((Object)hGCanvasPeer));
        this.fNotificationHandler.handleNotification(new FigureComponentNotification(1, this.getComponent(), this.fUseLightweight));
        this.fCanvas = hGCanvasPeer;
        this.fUseJogl = bl;
    }

    void doFireMousePressed(MouseEvent mouseEvent) {
        if (!this.doHitTest(mouseEvent.getX(), mouseEvent.getY(), mouseEvent, this.fServerProxyHandle)) {
            this.doMouseEvent(mouseEvent, this.fServerProxyHandle);
        }
    }

    void doFireMouseReleased(MouseEvent mouseEvent) {
        this.doMouseEvent(mouseEvent, this.fServerProxyHandle);
    }

    void doFireMouseDragged(MouseEvent mouseEvent) {
        if (this.fEnterExitEnabled) {
            this.doEnterExitTest(mouseEvent.getX(), mouseEvent.getY(), this.fServerProxyHandle);
        }
        this.doMouseEvent(mouseEvent, this.fServerProxyHandle);
    }

    void doFireMouseMoved(MouseEvent mouseEvent) {
        if (this.fEnterExitEnabled) {
            this.doEnterExitTest(mouseEvent.getX(), mouseEvent.getY(), this.fServerProxyHandle);
        }
        this.doMouseEvent(mouseEvent, this.fServerProxyHandle);
    }

    @Override
    public void executeCommand(int n, long l) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.executeCommand", this);
        this.doExecuteCommand(n, l, this.fServerProxyHandle);
    }

    @Override
    public void reportGLException(GLException gLException) {
        this.reportError("MATLAB:HG:GLException", "An OpenGL exception occurred: " + gLException.getMessage());
    }

    @Override
    public void dispose() {
        DebugUtilities.logMessage(32768, "dispose", this);
        assert (!SwingUtilities.isEventDispatchThread());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JavaSceneServerPeer.this.getComponent().getParent() != null) {
                    JavaSceneServerPeer.this.fNotificationHandler.handleNotification(new FigureComponentNotification(2, JavaSceneServerPeer.this.getComponent(), JavaSceneServerPeer.this.fUseLightweight));
                }
                JavaSceneServerPeer.super.dispose();
                JavaSceneServerPeer.this.nullOutReferences();
            }
        });
    }

    private void nullOutReferences() {
        if (this.fCanvas != null) {
            this.fCanvas.dispose();
        }
        this.fDrawableComponent = null;
        this.fGLEventListenerHandler = null;
        this.fCanvas = null;
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        AWTEvent aWTEvent;
        if (figureNotification instanceof FigureJavaEventNotification && (aWTEvent = ((FigureJavaEventNotification)figureNotification).getEvent()) instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            this.doKeyEvent(keyEvent, this.fServerProxyHandle);
            super.handleNotification(new AcceleratorEventNotification(keyEvent.getSource(), keyEvent));
            return;
        }
        super.handleNotification(figureNotification);
    }

    public static class HGGLRuntimeException
    extends RuntimeException {
        private HGGLException fException = null;

        public HGGLRuntimeException(HGGLException hGGLException) {
            super(hGGLException.getMessage());
            this.setStackTrace(hGGLException.getStackTrace());
            this.fException = hGGLException;
        }

        public HGGLException getSource() {
            return this.fException;
        }
    }

    public static class HGGLException
    extends Exception {
        public HGGLException(String string) {
            super(string);
        }
    }

    private class CanvasPeerComponentListener
    extends ComponentAdapter {
        private CanvasPeerComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (!JavaSceneServerPeer.this.fUseJogl) {
                DebugUtilities.logMessage(512, "CanvasPeerComponentListener.componentResized", this);
                Component component = componentEvent.getComponent();
                Rectangle rectangle = component.getBounds();
                if (rectangle != null) {
                    JavaSceneServerPeer.this.doReshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height, JavaSceneServerPeer.this.fServerProxyHandle);
                }
            }
        }
    }
}

