/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.analyzer;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.matlab.api.editor.EditorTipDocHelper;
import com.mathworks.widgets.messagepanel.AbstractMessageModel;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.CodeAnalyzerUtilities;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import org.apache.commons.lang.StringEscapeUtils;

public class CodeAnalyzerMessageModel
extends AbstractMessageModel {
    private static EditorTipDocHelper sDocHelper;
    private final STPBaseInterface fSyntaxPane;
    private boolean fValid;

    CodeAnalyzerMessageModel(STPBaseInterface sTPBaseInterface) {
        this.fSyntaxPane = sTPBaseInterface;
    }

    MLint.Message getMLintMessageAt(int n) {
        return ((CodeAnalyzerMessage)super.getMessageAt(n)).getMLintMessage();
    }

    @Override
    public String getTextAt(int n) {
        return null;
    }

    @Override
    public int getLineNumberAt(int n) {
        return this.getMLintMessageAt(n).getLineNumber() - 1;
    }

    @Override
    public int getPriorityAt(int n) {
        return this.getMLintMessageAt(n).getSeverity();
    }

    @Override
    public MessageModel.Priority getModelPriority(int n) {
        return MessageModel.Priority.TRANSIENT_LAYER;
    }

    public void update(List<MLint.Message> list) {
        ArrayList<CodeAnalyzerMessage> arrayList = new ArrayList<CodeAnalyzerMessage>(list.size());
        for (MLint.Message message : list) {
            arrayList.add(new CodeAnalyzerMessage(message));
        }
        this.setValid(true);
        super.update(arrayList, this.fSyntaxPane.getNumLines());
    }

    void setValid(boolean bl) {
        this.fValid = bl;
    }

    boolean isValid() {
        return this.fValid;
    }

    void refreshMessageValidStatePainting() {
        this.notifyListeners();
    }

    EditorKit getSyntaxKit() {
        return this.fSyntaxPane.getEditorKit();
    }

    public static void setDocHelper(EditorTipDocHelper editorTipDocHelper) {
        sDocHelper = editorTipDocHelper;
    }

    private class MLintFixAction
    extends AbstractAction {
        private final MLint.Message iMessage;

        MLintFixAction(MLint.Message message) {
            this.iMessage = message;
            this.putValue("Name", CodeAnalyzerUtils.getBundle().getString("exmlint.fixButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeAnalyzerUtils.applyAutoFixes(CodeAnalyzerMessageModel.this.fSyntaxPane, this.iMessage.getAutoFixChanges());
        }
    }

    public class CodeAnalyzerMessage
    implements EditorMessage {
        private final MLint.Message iMessage;

        public CodeAnalyzerMessage(MLint.Message message) {
            this.iMessage = message;
        }

        public int getStartPosition() {
            try {
                return CodeAnalyzerUtilities.getStartPosition(CodeAnalyzerMessageModel.this.fSyntaxPane.getDocument(), this.iMessage);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
        }

        public Color getColor() {
            return CodeAnalyzerUtils.getColorForSeverity(this.iMessage.getSeverity());
        }

        public boolean dismissOnCaretUpdate() {
            return true;
        }

        public int getLineNumber() {
            return this.iMessage.getLineNumber() - 1;
        }

        public Icon getIcon(int n) {
            return CodeAnalyzerUtils.getSeverityIcon(this.iMessage, n);
        }

        public boolean isActionable() {
            return true;
        }

        public boolean hasTooltipAction() {
            return this.iMessage.hasAutoFix();
        }

        public Action getTooltipAction() {
            return new MLintFixAction(this.iMessage);
        }

        public boolean isTooltipActionVisible() {
            return this.hasTooltipAction();
        }

        public boolean hasExtendedInformation() {
            return sDocHelper != null && sDocHelper.hasExtendedHelp(this.getMLintMessage().getTag());
        }

        public boolean isExtendable() {
            return true;
        }

        public String getMessage() {
            return StringEscapeUtils.escapeHtml((String)this.iMessage.getMessage());
        }

        public int getEndPosition() {
            try {
                return CodeAnalyzerUtilities.getEndPosition(CodeAnalyzerMessageModel.this.fSyntaxPane.getDocument(), this.iMessage);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
        }

        public int getNumberOfLines() {
            return 1;
        }

        public String getExtendedInformation() {
            assert (sDocHelper != null) : "Expanded messages should not be available if there is no doc helper";
            String string = sDocHelper.getExtendedHelp(this.getMLintMessage().getTag());
            if (string == null) {
                string = CodeAnalyzerUtils.getBundle().getString("exmlint.noExpandedMessage");
            }
            return string;
        }

        public boolean isStatic() {
            return true;
        }

        public MLint.Message getMLintMessage() {
            return this.iMessage;
        }
    }
}

