/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.util.Range;
import com.mathworks.widgets.text.PrintableDocument;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.matlab.MatlabState;
import com.mathworks.widgets.text.mcode.MLexer;
import com.mathworks.widgets.text.mcode.MTokenContext;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;

public class CmdManager {
    private STPInterface fSyntaxPane;
    private List fLineHandles;
    private EventListenerList fEventListenerList = null;
    private CmdMgrTextEventHandler fTextEventHandler;
    private CmdMgrTextViewListener fTextViewListener;
    private CmdMgrMouseListener fMouseListener;
    private EventListenerList fSavedEventListenerList;
    private boolean bEnableJUnitTest = true;
    public JUnitExpose fJUnitHook;

    public CmdManager(STPInterface sTPInterface) {
        this.fSyntaxPane = sTPInterface;
        int n = Math.max(100, this.fSyntaxPane.getNumLines());
        this.fLineHandles = new ArrayList(n);
        this.initializeLines();
        this.fTextEventHandler = new CmdMgrTextEventHandler();
        ((PrintableDocument)this.fSyntaxPane.getDocument()).addFirstDocumentListener(this.fTextEventHandler);
        this.fMouseListener = new CmdMgrMouseListener();
        this.fSyntaxPane.addMouseListener(this.fMouseListener);
        this.fTextViewListener = new CmdMgrTextViewListener();
        this.fSyntaxPane.addCaretListener(this.fTextViewListener);
        if (this.bEnableJUnitTest) {
            this.fJUnitHook = new JUnitExpose();
        }
    }

    public boolean isExecutableLine(int n) {
        if (n < 0 || n >= this.fSyntaxPane.getNumLines()) {
            return false;
        }
        if (n >= this.fLineHandles.size()) {
            System.out.println("Warning: line number " + n + " is inconsistent with internal array");
            return false;
        }
        return this.isStatementStart(n);
    }

    public int getNumAnonymousFunctions(int n) {
        int n2;
        block7: {
            n2 = 0;
            try {
                SyntaxSupport syntaxSupport = ((BaseDocument)this.fSyntaxPane.getDocument()).getSyntaxSupport();
                int n3 = this.fSyntaxPane.getLineStart(n);
                int n4 = this.fSyntaxPane.getLineEnd(n);
                TokenID[] tokenIDArray = new TokenID[]{MTokenContext.AT};
                int[] nArray = syntaxSupport.getTokenBlocks(n3, n4, tokenIDArray);
                if (nArray.length > 0) {
                    TokenItem tokenItem = ((ExtSyntaxSupport)syntaxSupport).getTokenChain(n3, n4);
                    for (int i = 0; tokenItem != null && i < nArray.length - 1; i += 2) {
                        int n5 = nArray[i + 1];
                        int n6 = i + 2 < nArray.length ? nArray[i + 2] : n4;
                        boolean bl = false;
                        while (n5 < n6 && !bl) {
                            while (tokenItem.getNext() != null && tokenItem.getNext().getOffset() <= n5) {
                                tokenItem = tokenItem.getNext();
                            }
                            if (tokenItem.getOffset() > n5) break;
                            if (tokenItem.getTokenID().equals(MTokenContext.LPAREN) || tokenItem.getTokenID().equals(MTokenContext.DOTDOTDOT)) {
                                bl = true;
                                continue;
                            }
                            if (!tokenItem.getTokenID().equals(MTokenContext.WHITESPACE) || tokenItem.getNext() == null) break;
                            n5 = tokenItem.getNext().getOffset();
                        }
                        if (!bl) continue;
                        ++n2;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                if (System.getProperty("netbeans.debug.exceptions") == null) break block7;
                badLocationException.printStackTrace();
            }
        }
        return n2;
    }

    protected STPInterface getSyntaxPane() {
        return this.fSyntaxPane;
    }

    public void pause() {
        if (this.fTextEventHandler != null) {
            ((PrintableDocument)this.fSyntaxPane.getDocument()).removeFirstDocumentListener(this.fTextEventHandler);
        }
        if (this.fTextViewListener != null) {
            this.fSyntaxPane.removeCaretListener(this.fTextViewListener);
        }
        if (this.fMouseListener != null) {
            this.fSyntaxPane.removeMouseListener(this.fMouseListener);
        }
        this.fSavedEventListenerList = this.fEventListenerList;
        this.fEventListenerList = null;
    }

    public void restart() {
        this.initializeLines();
        if (this.fTextEventHandler != null) {
            ((PrintableDocument)this.fSyntaxPane.getDocument()).addFirstDocumentListener(this.fTextEventHandler);
        }
        if (this.fTextViewListener != null) {
            this.fSyntaxPane.addCaretListener(this.fTextViewListener);
        }
        if (this.fMouseListener != null) {
            this.fSyntaxPane.addMouseListener(this.fMouseListener);
        }
        if (this.fSavedEventListenerList != null) {
            this.fEventListenerList = this.fSavedEventListenerList;
        }
        this.fSavedEventListenerList = null;
    }

    public void dispose() {
        if (this.fTextEventHandler != null) {
            ((PrintableDocument)this.fSyntaxPane.getDocument()).removeFirstDocumentListener(this.fTextEventHandler);
        }
        if (this.fTextViewListener != null) {
            this.fSyntaxPane.removeCaretListener(this.fTextViewListener);
        }
        if (this.fMouseListener != null) {
            this.fSyntaxPane.removeMouseListener(this.fMouseListener);
        }
        if (this.fEventListenerList != null) {
            Object[] objectArray = this.fEventListenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != CmdLineListener.class) continue;
                this.fEventListenerList.remove(CmdLineListener.class, (CmdLineListener)objectArray[i + 1]);
            }
        }
        this.fTextEventHandler = null;
        this.fTextViewListener = null;
        this.fMouseListener = null;
        this.fEventListenerList = null;
    }

    public void addListener(CmdLineListener cmdLineListener) {
        if (this.fEventListenerList == null) {
            this.fEventListenerList = new EventListenerList();
        }
        this.fEventListenerList.add(CmdLineListener.class, cmdLineListener);
    }

    public void removeListener(CmdLineListener cmdLineListener) {
        if (this.fEventListenerList != null && cmdLineListener != null) {
            this.fEventListenerList.remove(CmdLineListener.class, cmdLineListener);
        }
        if (this.fEventListenerList != null && this.fEventListenerList.getListenerCount() == 0) {
            this.fEventListenerList = null;
        }
    }

    public void updateLinesAndFire(int n, int n2) {
        int[] nArray = new int[]{-1, -1};
        nArray = this.updateLines(n, n2);
        this.fireEvent(nArray[0], nArray[1], null, false);
    }

    private void fireEvent(int n, int n2, DocumentEvent documentEvent, boolean bl) {
        if (this.fEventListenerList == null) {
            return;
        }
        if (n == n2) {
            if (documentEvent == null) {
                return;
            }
            n = -1;
            n2 = -1;
        } else {
            --n2;
        }
        Object[] objectArray = this.fEventListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CmdLineListener.class) continue;
            ((CmdLineListener)objectArray[i + 1]).commandLineChanged(n, n2, documentEvent, bl);
        }
    }

    private void debug(boolean bl, String string) {
        if (bl) {
            if (string != null && string.length() != 0) {
                System.out.println(string);
            }
            for (int i = 0; i < this.fLineHandles.size() - 1; ++i) {
                if (!this.isStatementStart(i)) continue;
                System.out.println(i + 1);
            }
            System.out.println("\n");
        }
    }

    private void initializeLines() {
        int n = this.fSyntaxPane.getNumLines();
        MatlabState matlabState = MLexer.getInstance().getInitialTokenizerState();
        this.fLineHandles.clear();
        this.fLineHandles.add(matlabState);
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = this.fSyntaxPane.getLineStart(i);
                int n3 = this.fSyntaxPane.getLineEnd(i);
                matlabState = MLexer.getInstance().tokenizeLines(matlabState, this.fSyntaxPane.getChars(n2, n3 - n2), 0, n3 - n2).getNewState();
                this.fLineHandles.add(matlabState);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.debug(false, "from Initialize");
    }

    private int[] updateLines(int n, int n2) {
        int n3 = this.rippleThroughLines(n, n2);
        int[] nArray = new int[]{n, n3};
        this.debug(false, "from updateLines ");
        return nArray;
    }

    private int rippleThroughLines(int n, int n2) {
        int n3 = n;
        boolean bl = false;
        int n4 = -1;
        int n5 = this.fSyntaxPane.getNumLines();
        boolean bl2 = false;
        while (!bl) {
            MatlabState matlabState = this.createStateHandle(n3);
            bl2 = this.isStateEquivalent(n3, matlabState);
            if (!bl2) {
                n4 = n3;
                this.replaceLineHandle(n3, matlabState);
            }
            if (n3 > n2 && bl2) {
                bl = true;
            }
            if (++n3 != n5) continue;
            bl = true;
        }
        n4 = n4 != -1 ? ++n4 : n;
        return n4;
    }

    private int[] insertLines(int n, int n2) {
        int n3;
        MatlabState[] matlabStateArray = new MatlabState[n2 - n];
        MatlabState matlabState = this.createStateHandle(n);
        for (n3 = n; n3 < n2; ++n3) {
            matlabStateArray[n3 - n] = matlabState;
            matlabState = this.createStateHandle(n3 + 1, matlabState);
        }
        for (n3 = n; n3 < n2; ++n3) {
            this.insertLineHandle(n3, matlabStateArray[n3 - n]);
        }
        n3 = this.rippleThroughLines(n2 - 1, n2);
        int[] nArray = new int[]{n, n3};
        return nArray;
    }

    private int[] deleteLines(int n, int n2) {
        int n3;
        for (n3 = n2 - 1; n3 >= n; --n3) {
            this.removeLineHandle(n3);
        }
        n3 = n2;
        if (this.fLineHandles.size() > 1) {
            n3 = this.rippleThroughLines(n, n);
        }
        int[] nArray = new int[]{n, n3};
        this.debug(false, new String("deleting " + n + " to " + n2));
        return nArray;
    }

    private MatlabState createStateHandle(int n) {
        MatlabState matlabState = (MatlabState)this.fLineHandles.get(n);
        return this.createStateHandle(n, matlabState);
    }

    private MatlabState createStateHandle(int n, MatlabState matlabState) {
        MatlabState matlabState2 = null;
        try {
            int n2 = this.fSyntaxPane.getLineStart(n);
            int n3 = this.fSyntaxPane.getLineEnd(n);
            matlabState2 = MLexer.getInstance().tokenizeLines(matlabState, this.fSyntaxPane.getChars(n2, n3 - n2), 0, n3 - n2).getNewState();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return matlabState2;
    }

    private boolean isStateEquivalent(int n, MatlabState matlabState) {
        return MLexer.areStatesEqual(matlabState, (MatlabState)this.fLineHandles.get(n + 1));
    }

    private boolean isStatementStart(int n) {
        return ((MatlabState)this.fLineHandles.get(n + 1)).isExecutable();
    }

    private void replaceLineHandle(int n, MatlabState matlabState) {
        if (n + 1 < this.fLineHandles.size()) {
            this.fLineHandles.set(n + 1, matlabState);
        } else {
            this.fLineHandles.add(matlabState);
        }
    }

    private void insertLineHandle(int n, MatlabState matlabState) {
        if (n + 1 < this.fLineHandles.size()) {
            this.fLineHandles.add(n + 1, matlabState);
        } else {
            this.fLineHandles.add(matlabState);
        }
    }

    private void removeLineHandle(int n) {
        if (n + 1 < this.fLineHandles.size()) {
            this.fLineHandles.remove(n + 1);
        }
    }

    public class JUnitExpose {
        public List getHandles() {
            return CmdManager.this.fLineHandles;
        }

        public STPInterface getPane() {
            return CmdManager.this.fSyntaxPane;
        }

        public int ripple(int n, int n2) {
            return CmdManager.this.rippleThroughLines(n, n2);
        }
    }

    public static interface CmdLineListener
    extends EventListener {
        public void commandLineChanged(int var1, int var2, DocumentEvent var3, boolean var4);
    }

    private class CmdMgrMouseListener
    extends MouseAdapter {
        private CmdMgrMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            try {
                int n = CmdManager.this.fSyntaxPane.getSelectionStart();
                int n2 = CmdManager.this.fSyntaxPane.getSelectionEnd();
                CmdManager.this.updateLinesAndFire(CmdManager.this.fSyntaxPane.getLineFromPos(n), CmdManager.this.fSyntaxPane.getLineFromPos(n2));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private class CmdMgrTextViewListener
    implements CaretListener {
        Range oldSel = null;

        private CmdMgrTextViewListener() {
        }

        private boolean selectionLineChanged(Range range, Range range2, Range range3) {
            if (range == null) {
                return true;
            }
            boolean bl = true;
            try {
                int n;
                int n2;
                if (range.getMin() >= CmdManager.this.fSyntaxPane.getLength() || range.getMax() >= CmdManager.this.fSyntaxPane.getLength()) {
                    n = n2 = CmdManager.this.fSyntaxPane.getNumLines() - 1;
                } else {
                    n = CmdManager.this.fSyntaxPane.getLineFromPos(range.getMin());
                    n2 = CmdManager.this.fSyntaxPane.getLineFromPos(range.getMax());
                }
                int n3 = CmdManager.this.fSyntaxPane.getLineFromPos(range2.getMin());
                int n4 = CmdManager.this.fSyntaxPane.getLineFromPos(range2.getMax());
                if (n == n2 && n3 == n4 && n == n3) {
                    return false;
                }
                range3.setStart(n);
                range3.setEnd(n2);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return bl;
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            Range range;
            Range range2 = new Range(CmdManager.this.fSyntaxPane.getCaret().getDot(), CmdManager.this.fSyntaxPane.getCaret().getMark());
            if (this.selectionLineChanged(this.oldSel, range2, range = new Range(-1, -1))) {
                int n = CmdManager.this.fSyntaxPane.getNumLines();
                int n2 = CmdManager.this.fLineHandles.size();
                boolean bl = false;
                if (n == n2 - 1) {
                    bl = true;
                }
                if (range.getMin() != -1 && bl) {
                    CmdManager.this.updateLinesAndFire(range.getMin(), range.getMax());
                }
                this.oldSel = range2;
            }
        }
    }

    private class CmdMgrTextEventHandler
    implements DocumentListener {
        private CmdMgrTextEventHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.lineChange(documentEvent, true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.lineChange(documentEvent, false);
        }

        private void lineChange(DocumentEvent documentEvent, boolean bl) {
            int n;
            int n2 = CmdManager.this.fSyntaxPane.getMinLineFromDocEvent(documentEvent);
            if (n2 == (n = CmdManager.this.fSyntaxPane.getMaxLineFromDocEvent(documentEvent))) {
                return;
            }
            int[] nArray = new int[]{-1, -1};
            nArray = bl ? CmdManager.this.insertLines(n2, n) : CmdManager.this.deleteLines(n2, n);
            CmdManager.this.fireEvent(nArray[0], nArray[1], documentEvent, bl);
        }
    }
}

