/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.mwswing.undo.FilterUndoableEdit;
import com.mathworks.widgets.text.ClearableMarkChain;
import com.mathworks.widgets.text.MWDocumentEvent;
import com.mathworks.widgets.text.MWDrawLayerFactory;
import com.mathworks.widgets.text.print.PrintableTextDocument;
import com.mathworks.widgets.text.print.TextPrintContainer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.EditorKit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Settings;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class PrintableDocument
extends BaseDocument
implements PrintableTextDocument {
    public static final String FILENAME_PROPERTY = "filename";
    private HashMap<Integer, Object> fEditMap = new HashMap();
    private boolean fBlocking = false;
    private int fLastIndex = -1;
    private static int sBlockEditSize = 50000;
    private PropertyChangeSupport fPropertyChangeSupport = new PropertyChangeSupport(this);
    private DefaultFilterBypass fFilterBypass = new DefaultFilterBypass();
    private int fPrintCurrentLine;
    private int fPrintEndLine;
    private int[] fPrevHighlightedLines;
    private ClearableMarkChain fHighlightedLines;
    private static final int HIGHLIGHT_LINES_LAYER = 2049;
    private int[] fPrevBoldLines;
    private int[] fPrevDrawAboveLines;
    private ClearableMarkChain fBoldLines;
    private ClearableMarkChain fDrawAboveLines;
    private static final int BOLD_LINES_LAYER = 1002;
    private static final int DRAW_ABOVE_LINES_LAYER = 1001;
    private static final int INPUT_MODE_LAYER = 1003;

    protected BaseDocumentEvent createDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
        return new MWDocumentEvent(this, n, n2, eventType);
    }

    public PrintableDocument(Class<? extends EditorKit> clazz, boolean bl) {
        super(clazz, bl);
        this.addLayer((DrawLayer)new MWDrawLayerFactory.HighlightLinesLayer(), 2049);
        this.fHighlightedLines = new ClearableMarkChain(this, "highlight-lines-layer");
        this.addLayer((DrawLayer)new MWDrawLayerFactory.BoldLinesLayer(), 1002);
        this.fBoldLines = new ClearableMarkChain(this, "bold-lines-layer");
        this.addLayer((DrawLayer)new MWDrawLayerFactory.AboveLinesLayer(), 1001);
        this.fDrawAboveLines = new ClearableMarkChain(this, "draw-above-lines-layer");
        this.addLayer((DrawLayer)new MWDrawLayerFactory.InputModeLayer(), 1003);
    }

    @Override
    public void startingPrinting(int n, int n2) {
        try {
            this.fPrintCurrentLine = Utilities.getLineOffset((BaseDocument)this, (int)n);
            this.fPrintEndLine = Utilities.getLineOffset((BaseDocument)this, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            this.fPrintCurrentLine = 0;
            this.fPrintEndLine = Utilities.getRowCount((BaseDocument)this) - 1;
        }
    }

    @Override
    public AttributedCharacterIterator[] createPrintIterators(int n) {
        if (this.fPrintCurrentLine > this.fPrintEndLine) {
            return null;
        }
        TextPrintContainer textPrintContainer = new TextPrintContainer();
        try {
            int n2 = Math.min(this.fPrintCurrentLine + n - 1, this.fPrintEndLine);
            int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)this, (int)this.fPrintCurrentLine);
            int n4 = Utilities.getRowEnd((BaseDocument)this, (int)Utilities.getRowStartFromLineOffset((BaseDocument)this, (int)n2));
            boolean bl = false;
            Boolean bl2 = (Boolean)Settings.getValue((Class)this.getKitClass(), (String)"print-line-number-visible");
            if (bl2 != null) {
                bl = bl2;
            }
            this.print(textPrintContainer, true, bl, n3, n4);
            this.fPrintCurrentLine = n2 + 1;
            return textPrintContainer.getIterators();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            this.fPrintCurrentLine = this.fPrintEndLine + 1;
            return null;
        }
    }

    private int[] updateLines(int[] nArray, int[] nArray2, ClearableMarkChain clearableMarkChain) {
        int n;
        int n2;
        int[] nArray3;
        int n3 = Utilities.getRowCount((BaseDocument)this);
        int n4 = n3 - 1;
        int n5 = 0;
        boolean bl = false;
        if (nArray != null) {
            assert (nArray.length == 2);
            n4 = Math.min(nArray[0], n3 - 1);
            n5 = Math.min(nArray[1], n3 - 1);
            bl = true;
        }
        clearableMarkChain.clearAll();
        if (nArray2 != null && nArray2.length > 0) {
            nArray3 = new int[2];
            for (n2 = 0; n2 != nArray2.length; ++n2) {
                n = Utilities.getRowStartFromLineOffset((BaseDocument)this, (int)nArray2[n2]);
                try {
                    if (n != -1) {
                        clearableMarkChain.addMark(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (n2 == 0) {
                    nArray3[0] = nArray2[n2];
                    n4 = Math.min(n4, nArray3[0]);
                }
                if (n2 != nArray2.length - 1) continue;
                nArray3[1] = nArray2[n2];
                n5 = Math.max(n5, nArray3[1]);
            }
            bl = true;
        } else {
            nArray3 = null;
        }
        if (bl) {
            n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this, (int)n4);
            n = n5 >= n3 - 1 ? this.getLength() : Utilities.getRowStartFromLineOffset((BaseDocument)this, (int)(n5 + 1));
            this.fireChangedUpdate((DocumentEvent)this.createDocumentEvent(n2, n - n2, DocumentEvent.EventType.CHANGE));
        }
        return nArray3;
    }

    protected void preInsertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        super.preInsertUpdate(defaultDocumentEvent, attributeSet);
        if (defaultDocumentEvent instanceof MWDocumentEvent) {
            ((MWDocumentEvent)((Object)defaultDocumentEvent)).setAttributeSet(attributeSet);
        }
    }

    public void setHighlightedLines(int[] nArray) {
        this.fPrevHighlightedLines = this.updateLines(this.fPrevHighlightedLines, nArray, this.fHighlightedLines);
    }

    public void setBoldLines(int[] nArray) {
        this.fPrevBoldLines = this.updateLines(this.fPrevBoldLines, nArray, this.fBoldLines);
    }

    public void setDrawAboveLines(int[] nArray) {
        this.fPrevDrawAboveLines = this.updateLines(this.fPrevDrawAboveLines, nArray, this.fDrawAboveLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        this.atomicLock();
        try {
            if (this.getDocumentFilter() != null && !this.fFilterBypass.isFilterBypassInProgress()) {
                this.getDocumentFilter().replace(this.fFilterBypass, n, n2, string, attributeSet);
            } else {
                super.replace(n, n2, string, attributeSet);
            }
        }
        finally {
            this.atomicUnlock();
        }
    }

    public void startEditGrouping() {
        this.atomicLock();
        this.fEditMap.clear();
        this.fBlocking = true;
        this.fLastIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endEditGrouping() throws BadLocationException {
        this.fBlocking = false;
        try {
            if (!this.fEditMap.isEmpty()) {
                TreeSet<Integer> treeSet = new TreeSet<Integer>(this.fEditMap.keySet());
                int n = 0;
                int n2 = treeSet.first();
                int n3 = Math.max(treeSet.last(), this.fLastIndex);
                if ((n3 = Math.min(n3, this.getLength())) - n2 <= sBlockEditSize) {
                    this.replaceSection(n2, n3, treeSet.iterator(), n);
                } else {
                    while (!treeSet.isEmpty()) {
                        Iterator<Integer> iterator = treeSet.iterator();
                        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
                        int n4 = n3;
                        while (iterator.hasNext()) {
                            Integer n5 = iterator.next();
                            if (n5 - n2 > sBlockEditSize) {
                                n4 = n5;
                                break;
                            }
                            treeSet2.add(n5);
                            iterator.remove();
                            if (iterator.hasNext()) continue;
                            n4 = Math.max(n5, this.fLastIndex);
                        }
                        n = this.replaceSection(n2 + n, n4 + n, treeSet2.iterator(), n);
                        n2 = n4;
                    }
                }
            }
        }
        finally {
            this.fEditMap.clear();
            this.atomicUnlock();
        }
    }

    private int replaceSection(int n, int n2, Iterator iterator, int n3) throws BadLocationException {
        StringBuffer stringBuffer = new StringBuffer(this.getText(n, n2 - n));
        while (iterator.hasNext()) {
            Integer n4 = (Integer)iterator.next();
            Object object = this.fEditMap.get(n4);
            if (object instanceof List) {
                Iterator iterator2 = ((List)object).iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!(e instanceof String)) continue;
                    n3 = this.processValue(e, n4 - n, n3, stringBuffer);
                    iterator2.remove();
                }
                iterator2 = ((List)object).iterator();
                while (iterator2.hasNext()) {
                    n3 = this.processValue(iterator2.next(), n4 - n, n3, stringBuffer);
                }
                continue;
            }
            n3 = this.processValue(object, n4 - n, n3, stringBuffer);
        }
        this.replace(n, n2 - n, new String(stringBuffer), null);
        return n3;
    }

    private int processValue(Object object, int n, int n2, StringBuffer stringBuffer) {
        n += n2;
        if (object instanceof Integer) {
            int n3 = (Integer)object;
            stringBuffer.delete(n, n + n3);
            n2 -= n3;
        } else {
            String string = (String)object;
            stringBuffer.insert(n, string);
            n2 += string.length();
        }
        return n2;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.fBlocking) {
            PrintableDocument.addElement(n, string, this.fEditMap);
        } else if (this.getDocumentFilter() != null && !this.fFilterBypass.isFilterBypassInProgress()) {
            this.getDocumentFilter().insertString(this.fFilterBypass, n, string, attributeSet);
        } else {
            super.insertString(n, string, attributeSet);
        }
    }

    private static void addElement(Integer n, Object object, HashMap<Integer, Object> hashMap) {
        if (hashMap.containsKey(n)) {
            Object object2 = hashMap.get(n);
            if (object2 instanceof List) {
                ((List)object2).add(object);
            } else {
                LinkedList<Object> linkedList = new LinkedList<Object>();
                linkedList.add(object2);
                linkedList.add(object);
                hashMap.put(n, linkedList);
            }
        } else {
            hashMap.put(n, object);
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.fBlocking) {
            PrintableDocument.addElement(n, n2, this.fEditMap);
            this.fLastIndex = Math.max(this.fLastIndex, n + n2);
        } else if (this.getDocumentFilter() != null && !this.fFilterBypass.isFilterBypassInProgress()) {
            this.getDocumentFilter().remove(this.fFilterBypass, n, n2);
        } else {
            super.remove(n, n2);
        }
    }

    public int processText(TextBatchProcessor textBatchProcessor, int n, int n2) throws BadLocationException {
        if (n2 == -1) {
            n2 = this.getLength();
        }
        int n3 = (Integer)this.getProperty("line-batch-size");
        int n4 = n;
        int n5 = -1;
        if (n < n2) {
            while (n5 < 0 && n4 < n2) {
                int n6 = Math.min(Utilities.getRowStart((BaseDocument)this, (int)n4, (int)n3), n2);
                if (n6 == -1) {
                    n6 = n2;
                }
                n5 = textBatchProcessor.processTextBatch((BaseDocument)this, n4, n6, n6 == n2);
                n4 = n6;
            }
        } else {
            while (n5 < 0 && n4 > n2) {
                int n7;
                n5 = textBatchProcessor.processTextBatch((BaseDocument)this, n4, n7, (n7 = Math.max(Utilities.getRowStart((BaseDocument)this, (int)n4, (int)(-n3)), n2)) == n2);
                n4 = n7;
            }
        }
        return n5;
    }

    private static void setBlockEditSize(int n) {
        sBlockEditSize = n;
    }

    protected UndoableEdit getEditDelegate(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof FilterUndoableEdit) {
            return ((FilterUndoableEdit)undoableEdit).getDelegate();
        }
        return super.getEditDelegate(undoableEdit);
    }

    public void addFirstDocumentListener(DocumentListener documentListener) {
        DocumentUtilities.addDocumentListener((Document)this, (DocumentListener)documentListener, (DocumentListenerPriority)DocumentListenerPriority.FOLD_UPDATE);
    }

    public void removeFirstDocumentListener(DocumentListener documentListener) {
        DocumentUtilities.removeDocumentListener((Document)this, (DocumentListener)documentListener, (DocumentListenerPriority)DocumentListenerPriority.FOLD_UPDATE);
    }

    public void setFilename(String string) {
        String string2 = this.getFilename();
        this.putProperty(FILENAME_PROPERTY, string);
        this.fPropertyChangeSupport.firePropertyChange(FILENAME_PROPERTY, string2, string);
    }

    public String getFilename() {
        return (String)this.getProperty(FILENAME_PROPERTY);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private class DefaultFilterBypass
    extends DocumentFilter.FilterBypass {
        private boolean fFilterBypassInProgress;

        private DefaultFilterBypass() {
        }

        @Override
        public Document getDocument() {
            return PrintableDocument.this;
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            this.setFilterBypassInProgress(true);
            PrintableDocument.this.remove(n, n2);
            this.setFilterBypassInProgress(false);
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            this.setFilterBypassInProgress(true);
            PrintableDocument.this.insertString(n, string, attributeSet);
            this.setFilterBypassInProgress(false);
        }

        @Override
        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            this.setFilterBypassInProgress(true);
            PrintableDocument.this.replace(n, n2, string, attributeSet);
            this.setFilterBypassInProgress(false);
        }

        private void setFilterBypassInProgress(boolean bl) {
            if (this.fFilterBypassInProgress && bl) {
                throw new IllegalStateException("Can't bypass the filter while already bypassing the filter.");
            }
            this.fFilterBypassInProgress = bl;
        }

        private boolean isFilterBypassInProgress() {
            return this.fFilterBypassInProgress;
        }
    }
}

